/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.v3_0_8.client.impl.schema;

import java.time.LocalDate;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.v3_0_8.client.impl.schema.AbstractSchema;
import org.apache.pulsar.v3_0_8.client.impl.schema.LongSchema;
import org.apache.pulsar.v3_0_8.client.impl.schema.SchemaInfoImpl;
import org.apache.pulsar.v3_0_8.shade.io.netty.buffer.ByteBuf;

public class LocalDateSchema
extends AbstractSchema<LocalDate> {
    private static final LocalDateSchema INSTANCE;
    private static final SchemaInfo SCHEMA_INFO;

    public static LocalDateSchema of() {
        return INSTANCE;
    }

    public byte[] encode(LocalDate message) {
        if (null == message) {
            return null;
        }
        Long epochDay = message.toEpochDay();
        return LongSchema.of().encode(epochDay);
    }

    public LocalDate decode(byte[] bytes) {
        if (null == bytes) {
            return null;
        }
        Long decode = LongSchema.of().decode(bytes);
        return LocalDate.ofEpochDay(decode);
    }

    @Override
    public LocalDate decode(ByteBuf byteBuf) {
        if (null == byteBuf) {
            return null;
        }
        Long decode = LongSchema.of().decode(byteBuf);
        return LocalDate.ofEpochDay(decode);
    }

    public SchemaInfo getSchemaInfo() {
        return SCHEMA_INFO;
    }

    static {
        SCHEMA_INFO = SchemaInfoImpl.builder().name("LocalDate").type(SchemaType.LOCAL_DATE).schema(new byte[0]).build();
        INSTANCE = new LocalDateSchema();
    }
}

