/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.v3_0_8.client.impl.schema;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.pulsar.client.api.schema.Field;
import org.apache.pulsar.client.api.schema.GenericRecord;
import org.apache.pulsar.common.classification.InterfaceAudience;
import org.apache.pulsar.common.classification.InterfaceStability;
import org.apache.pulsar.common.schema.SchemaType;

@InterfaceAudience.Private
@InterfaceStability.Evolving
class GenericObjectWrapper
implements GenericRecord {
    private final Object nativeObject;
    private final SchemaType schemaType;
    private final byte[] schemaVersion;

    static GenericObjectWrapper of(Object nativeObject, SchemaType schemaType, byte[] schemaVersion) {
        return new GenericObjectWrapper(nativeObject, schemaType, schemaVersion);
    }

    private GenericObjectWrapper(Object nativeObject, SchemaType schemaType, byte[] schemaVersion) {
        this.nativeObject = nativeObject;
        this.schemaType = Objects.requireNonNull(schemaType, "SchemaType is required");
        this.schemaVersion = schemaVersion;
    }

    public byte[] getSchemaVersion() {
        return this.schemaVersion;
    }

    public List<Field> getFields() {
        return Collections.emptyList();
    }

    public Object getField(String fieldName) {
        return null;
    }

    public SchemaType getSchemaType() {
        return this.schemaType;
    }

    public Object getNativeObject() {
        return this.nativeObject;
    }

    public String toString() {
        return Objects.toString(this.nativeObject);
    }

    public int hashCode() {
        return Objects.hashCode(this.nativeObject);
    }

    public boolean equals(Object other) {
        if (!(other instanceof GenericObjectWrapper)) {
            return false;
        }
        GenericObjectWrapper gw = (GenericObjectWrapper)other;
        return this.schemaType == gw.schemaType && Objects.equals(this.nativeObject, gw.nativeObject) && Arrays.equals(this.schemaVersion, gw.schemaVersion);
    }
}

