/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.v3_0_8.client.impl.schema;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.pulsar.client.api.schema.FieldSchemaBuilder;
import org.apache.pulsar.client.api.schema.GenericSchema;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.v3_0_8.client.impl.schema.AvroBaseStructSchema;
import org.apache.pulsar.v3_0_8.client.impl.schema.SchemaUtils;
import org.apache.pulsar.v3_0_8.client.impl.schema.generic.GenericAvroSchema;
import org.apache.pulsar.v3_0_8.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.v3_0_8.shade.org.apache.avro.JsonProperties;
import org.apache.pulsar.v3_0_8.shade.org.apache.avro.LogicalTypes;
import org.apache.pulsar.v3_0_8.shade.org.apache.avro.Schema;
import org.apache.pulsar.v3_0_8.shade.org.apache.avro.SchemaBuilder;

class FieldSchemaBuilderImpl
implements FieldSchemaBuilder<FieldSchemaBuilderImpl> {
    private final String fieldName;
    private SchemaType type;
    private boolean optional = false;
    private Object defaultVal = null;
    private final Map<String, String> properties = new HashMap<String, String>();
    private String doc;
    private String[] aliases;
    private GenericSchema genericSchema;

    FieldSchemaBuilderImpl(String fieldName) {
        this(fieldName, null);
    }

    FieldSchemaBuilderImpl(String fieldName, GenericSchema genericSchema) {
        this.fieldName = fieldName;
        this.genericSchema = genericSchema;
    }

    public FieldSchemaBuilderImpl property(String name, String val) {
        this.properties.put(name, val);
        return this;
    }

    public FieldSchemaBuilderImpl doc(String doc) {
        this.doc = doc;
        return this;
    }

    public FieldSchemaBuilderImpl aliases(String ... aliases) {
        this.aliases = aliases;
        return this;
    }

    public FieldSchemaBuilderImpl type(SchemaType type) {
        this.type = type;
        return this;
    }

    public FieldSchemaBuilderImpl optional() {
        this.optional = true;
        return this;
    }

    public FieldSchemaBuilderImpl required() {
        this.optional = false;
        return this;
    }

    public FieldSchemaBuilderImpl defaultValue(Object value) {
        this.defaultVal = value;
        return this;
    }

    Schema.Field build() {
        Schema baseSchema;
        Objects.requireNonNull(this.type, "Schema type is not provided");
        SchemaUtils.validateFieldSchema(this.fieldName, this.type, this.defaultVal);
        switch (this.type) {
            case INT32: {
                baseSchema = (Schema)SchemaBuilder.builder().intType();
                break;
            }
            case INT64: {
                baseSchema = (Schema)SchemaBuilder.builder().longType();
                break;
            }
            case STRING: {
                baseSchema = (Schema)SchemaBuilder.builder().stringType();
                break;
            }
            case FLOAT: {
                baseSchema = (Schema)SchemaBuilder.builder().floatType();
                break;
            }
            case DOUBLE: {
                baseSchema = (Schema)SchemaBuilder.builder().doubleType();
                break;
            }
            case BOOLEAN: {
                baseSchema = (Schema)SchemaBuilder.builder().booleanType();
                break;
            }
            case BYTES: {
                baseSchema = (Schema)SchemaBuilder.builder().bytesType();
                break;
            }
            case DATE: {
                baseSchema = LogicalTypes.date().addToSchema(Schema.create(Schema.Type.INT));
                break;
            }
            case TIME: {
                baseSchema = LogicalTypes.timeMillis().addToSchema(Schema.create(Schema.Type.INT));
                break;
            }
            case TIMESTAMP: {
                baseSchema = LogicalTypes.timestampMillis().addToSchema(Schema.create(Schema.Type.LONG));
                break;
            }
            case JSON: {
                Preconditions.checkArgument(this.genericSchema.getSchemaInfo().getType() == SchemaType.JSON, "The field is expected to be using JSON schema but " + this.genericSchema.getSchemaInfo().getType() + " schema is found");
                AvroBaseStructSchema genericJsonSchema = (AvroBaseStructSchema)this.genericSchema;
                baseSchema = genericJsonSchema.getAvroSchema();
                break;
            }
            case AVRO: {
                Preconditions.checkArgument(this.genericSchema.getSchemaInfo().getType() == SchemaType.AVRO, "The field is expected to be using AVRO schema but " + this.genericSchema.getSchemaInfo().getType() + " schema is found");
                GenericAvroSchema genericAvroSchema = (GenericAvroSchema)this.genericSchema;
                baseSchema = genericAvroSchema.getAvroSchema();
                break;
            }
            default: {
                throw new RuntimeException("Schema `" + this.type + "` is not supported to be used as a field for now");
            }
        }
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            baseSchema.addProp(entry.getKey(), entry.getValue());
        }
        if (null != this.aliases) {
            for (String alias : this.aliases) {
                baseSchema.addAlias(alias);
            }
        }
        Schema finalSchema = this.optional ? (this.defaultVal != null ? SchemaBuilder.builder().unionOf().type(baseSchema).and().nullType().endUnion() : SchemaBuilder.builder().unionOf().nullType().and().type(baseSchema).endUnion()) : baseSchema;
        Object finalDefaultValue = this.defaultVal != null ? SchemaUtils.toAvroObject(this.defaultVal) : (this.optional ? JsonProperties.NULL_VALUE : null);
        return new Schema.Field(this.fieldName, finalSchema, this.doc, finalDefaultValue);
    }
}

