/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.v3_0_8.client.impl.schema;

import org.apache.pulsar.client.api.SchemaSerializationException;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.v3_0_8.client.impl.schema.AbstractSchema;
import org.apache.pulsar.v3_0_8.client.impl.schema.SchemaInfoImpl;
import org.apache.pulsar.v3_0_8.shade.io.netty.buffer.ByteBuf;

public class ByteSchema
extends AbstractSchema<Byte> {
    private static final ByteSchema INSTANCE;
    private static final SchemaInfo SCHEMA_INFO;

    public static ByteSchema of() {
        return INSTANCE;
    }

    public void validate(byte[] message) {
        if (message.length != 1) {
            throw new SchemaSerializationException("Size of data received by ByteSchema is not 1");
        }
    }

    @Override
    public void validate(ByteBuf message) {
        if (message.readableBytes() != 1) {
            throw new SchemaSerializationException("Size of data received by ByteSchema is not 1");
        }
    }

    public byte[] encode(Byte message) {
        if (null == message) {
            return null;
        }
        return new byte[]{message};
    }

    public Byte decode(byte[] bytes) {
        if (null == bytes) {
            return null;
        }
        this.validate(bytes);
        return bytes[0];
    }

    @Override
    public Byte decode(ByteBuf byteBuf) {
        if (null == byteBuf) {
            return null;
        }
        this.validate(byteBuf);
        return byteBuf.getByte(0);
    }

    public SchemaInfo getSchemaInfo() {
        return SCHEMA_INFO;
    }

    static {
        SCHEMA_INFO = SchemaInfoImpl.builder().name("INT8").type(SchemaType.INT8).schema(new byte[0]).build();
        INSTANCE = new ByteSchema();
    }
}

