/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.v3_0_8.client.impl.schema;

import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.v3_0_8.client.impl.schema.AbstractSchema;
import org.apache.pulsar.v3_0_8.client.impl.schema.SchemaInfoImpl;
import org.apache.pulsar.v3_0_8.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.v3_0_8.shade.io.netty.buffer.ByteBufUtil;
import org.apache.pulsar.v3_0_8.shade.io.netty.buffer.Unpooled;

public class ByteBufSchema
extends AbstractSchema<ByteBuf> {
    private static final ByteBufSchema INSTANCE;
    private static final SchemaInfo SCHEMA_INFO;

    public static ByteBufSchema of() {
        return INSTANCE;
    }

    public byte[] encode(ByteBuf message) {
        if (message == null) {
            return null;
        }
        return ByteBufUtil.getBytes(message);
    }

    public ByteBuf decode(byte[] bytes) {
        if (null == bytes) {
            return null;
        }
        return Unpooled.wrappedBuffer(bytes);
    }

    @Override
    public ByteBuf decode(ByteBuf byteBuf) {
        return byteBuf;
    }

    public SchemaInfo getSchemaInfo() {
        return SCHEMA_INFO;
    }

    static {
        SCHEMA_INFO = SchemaInfoImpl.builder().name("ByteBuf").type(SchemaType.BYTES).schema(new byte[0]).build();
        INSTANCE = new ByteBufSchema();
    }
}

