/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.v3_0_8.client.impl;

import lombok.Generated;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.v3_0_8.shade.io.netty.util.Recycler;

public class UnackMessageIdWrapper {
    private static final Recycler<UnackMessageIdWrapper> RECYCLER = new Recycler<UnackMessageIdWrapper>(){

        @Override
        protected UnackMessageIdWrapper newObject(Recycler.Handle<UnackMessageIdWrapper> handle) {
            return new UnackMessageIdWrapper(handle);
        }
    };
    private final Recycler.Handle<UnackMessageIdWrapper> recyclerHandle;
    private MessageId messageId;
    private int redeliveryCount = 0;

    private UnackMessageIdWrapper(Recycler.Handle<UnackMessageIdWrapper> recyclerHandle) {
        this.recyclerHandle = recyclerHandle;
    }

    private static UnackMessageIdWrapper create(MessageId messageId, int redeliveryCount) {
        UnackMessageIdWrapper unackMessageIdWrapper = RECYCLER.get();
        unackMessageIdWrapper.messageId = messageId;
        unackMessageIdWrapper.redeliveryCount = redeliveryCount;
        return unackMessageIdWrapper;
    }

    public static UnackMessageIdWrapper valueOf(MessageId messageId) {
        return UnackMessageIdWrapper.create(messageId, 0);
    }

    public static UnackMessageIdWrapper valueOf(MessageId messageId, int redeliveryCount) {
        return UnackMessageIdWrapper.create(messageId, redeliveryCount);
    }

    public void recycle() {
        this.messageId = null;
        this.redeliveryCount = 0;
        this.recyclerHandle.recycle(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof UnackMessageIdWrapper) {
            UnackMessageIdWrapper other = (UnackMessageIdWrapper)obj;
            if (this.messageId.equals(other.messageId)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.messageId == null ? 0 : this.messageId.hashCode();
    }

    public String toString() {
        return "UnackMessageIdWrapper [messageId=" + this.messageId + ", redeliveryCount=" + this.redeliveryCount + "]";
    }

    @Generated
    public Recycler.Handle<UnackMessageIdWrapper> getRecyclerHandle() {
        return this.recyclerHandle;
    }

    @Generated
    public MessageId getMessageId() {
        return this.messageId;
    }

    @Generated
    public int getRedeliveryCount() {
        return this.redeliveryCount;
    }
}

