/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.v3_0_8.client.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.ConsumerInterceptor;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.Reader;
import org.apache.pulsar.client.api.ReaderInterceptor;
import org.apache.pulsar.v3_0_8.client.impl.ConsumerInterceptors;

public class ReaderInterceptorUtil {
    public static <T> ConsumerInterceptors<T> convertToConsumerInterceptors(Reader<T> reader, List<ReaderInterceptor<T>> interceptorList) {
        if (interceptorList == null || interceptorList.isEmpty()) {
            return null;
        }
        ArrayList consumerInterceptorList = new ArrayList(interceptorList.size());
        for (ReaderInterceptor<T> readerInterceptor : interceptorList) {
            consumerInterceptorList.add(ReaderInterceptorUtil.getInterceptor(reader, readerInterceptor));
        }
        return new ConsumerInterceptors(consumerInterceptorList);
    }

    private static <T> ConsumerInterceptor<T> getInterceptor(final Reader<T> reader, final ReaderInterceptor<T> readerInterceptor) {
        return new ConsumerInterceptor<T>(){

            public void close() {
                readerInterceptor.close();
            }

            public Message<T> beforeConsume(Consumer<T> consumer, Message<T> message) {
                return readerInterceptor.beforeRead(reader, message);
            }

            public void onAcknowledge(Consumer<T> consumer, MessageId messageId, Throwable exception) {
            }

            public void onAcknowledgeCumulative(Consumer<T> consumer, MessageId messageId, Throwable exception) {
            }

            public void onNegativeAcksSend(Consumer<T> consumer, Set<MessageId> set) {
            }

            public void onAckTimeoutSend(Consumer<T> consumer, Set<MessageId> set) {
            }

            public void onPartitionsChange(String topicName, int partitions) {
                readerInterceptor.onPartitionsChange(topicName, partitions);
            }
        };
    }
}

