/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.v3_0_8.client.impl;

import lombok.Generated;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.MessageIdAdv;
import org.apache.pulsar.v3_0_8.common.util.collections.BitSetRecyclable;
import org.apache.pulsar.v3_0_8.shade.io.netty.util.concurrent.FastThreadLocal;

class LastCumulativeAck {
    public static final FastThreadLocal<LastCumulativeAck> LOCAL_LAST_CUMULATIVE_ACK = new FastThreadLocal<LastCumulativeAck>(){

        @Override
        protected LastCumulativeAck initialValue() {
            return new LastCumulativeAck();
        }
    };
    public static final MessageIdAdv DEFAULT_MESSAGE_ID = (MessageIdAdv)MessageId.earliest;
    private volatile MessageIdAdv messageId = DEFAULT_MESSAGE_ID;
    private BitSetRecyclable bitSetRecyclable = null;
    private boolean flushRequired = false;

    LastCumulativeAck() {
    }

    public synchronized void update(MessageIdAdv messageId, BitSetRecyclable bitSetRecyclable) {
        if (this.compareTo(messageId) < 0) {
            if (this.bitSetRecyclable != null && this.bitSetRecyclable != bitSetRecyclable) {
                this.bitSetRecyclable.recycle();
            }
            this.set(messageId, bitSetRecyclable);
            this.flushRequired = true;
        }
    }

    public synchronized LastCumulativeAck flush() {
        if (this.flushRequired) {
            LastCumulativeAck localLastCumulativeAck = LOCAL_LAST_CUMULATIVE_ACK.get();
            if (this.bitSetRecyclable != null) {
                localLastCumulativeAck.set(this.messageId, BitSetRecyclable.valueOf(this.bitSetRecyclable.toLongArray()));
            } else {
                localLastCumulativeAck.set(this.messageId, null);
            }
            this.flushRequired = false;
            return localLastCumulativeAck;
        }
        return null;
    }

    public synchronized void reset() {
        if (this.bitSetRecyclable != null) {
            this.bitSetRecyclable.recycle();
        }
        this.messageId = DEFAULT_MESSAGE_ID;
        this.bitSetRecyclable = null;
        this.flushRequired = false;
    }

    public synchronized int compareTo(MessageIdAdv messageId) {
        int result = Long.compare(this.messageId.getLedgerId(), messageId.getLedgerId());
        if (result != 0) {
            return result;
        }
        result = Long.compare(this.messageId.getEntryId(), messageId.getEntryId());
        if (result != 0) {
            return result;
        }
        return Integer.compare(this.messageId.getBatchIndex() >= 0 ? this.messageId.getBatchIndex() : Integer.MAX_VALUE, messageId.getBatchIndex() >= 0 ? messageId.getBatchIndex() : Integer.MAX_VALUE);
    }

    private synchronized void set(MessageIdAdv messageId, BitSetRecyclable bitSetRecyclable) {
        this.messageId = messageId;
        this.bitSetRecyclable = bitSetRecyclable;
    }

    public String toString() {
        String s2 = this.messageId.toString();
        if (this.bitSetRecyclable != null) {
            s2 = s2 + " (bit set: " + this.bitSetRecyclable + ")";
        }
        return s2;
    }

    @Generated
    public MessageIdAdv getMessageId() {
        return this.messageId;
    }

    @Generated
    public BitSetRecyclable getBitSetRecyclable() {
        return this.bitSetRecyclable;
    }

    @Generated
    public boolean isFlushRequired() {
        return this.flushRequired;
    }
}

