/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.v3_0_8.client.impl;

import java.util.Map;
import org.apache.pulsar.v3_0_8.client.impl.DefaultCryptoKeyReader;
import org.apache.pulsar.v3_0_8.client.impl.conf.DefaultCryptoKeyReaderConfigurationData;

public class DefaultCryptoKeyReaderBuilder
implements Cloneable {
    private DefaultCryptoKeyReaderConfigurationData conf;

    DefaultCryptoKeyReaderBuilder() {
        this(new DefaultCryptoKeyReaderConfigurationData());
    }

    DefaultCryptoKeyReaderBuilder(DefaultCryptoKeyReaderConfigurationData conf) {
        this.conf = conf;
    }

    public DefaultCryptoKeyReaderBuilder defaultPublicKey(String defaultPublicKey) {
        this.conf.setDefaultPublicKey(defaultPublicKey);
        return this;
    }

    public DefaultCryptoKeyReaderBuilder defaultPrivateKey(String defaultPrivateKey) {
        this.conf.setDefaultPrivateKey(defaultPrivateKey);
        return this;
    }

    public DefaultCryptoKeyReaderBuilder publicKey(String keyName, String publicKey) {
        this.conf.setPublicKey(keyName, publicKey);
        return this;
    }

    public DefaultCryptoKeyReaderBuilder privateKey(String keyName, String privateKey) {
        this.conf.setPrivateKey(keyName, privateKey);
        return this;
    }

    public DefaultCryptoKeyReaderBuilder publicKeys(Map<String, String> publicKeys) {
        this.conf.getPublicKeys().putAll(publicKeys);
        return this;
    }

    public DefaultCryptoKeyReaderBuilder privateKeys(Map<String, String> privateKeys) {
        this.conf.getPrivateKeys().putAll(privateKeys);
        return this;
    }

    public DefaultCryptoKeyReader build() {
        return new DefaultCryptoKeyReader(this.conf);
    }

    public DefaultCryptoKeyReaderBuilder clone() {
        return new DefaultCryptoKeyReaderBuilder(this.conf.clone());
    }
}

