/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.v3_0_8.client.impl;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.pulsar.v3_0_8.client.impl.ClientCnx;

public class ClientCnxIdleState {
    private final ClientCnx clientCnx;
    private volatile State state;
    private final long createTime;
    private long idleMarkTime;
    private static final AtomicReferenceFieldUpdater<ClientCnxIdleState, State> STATE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(ClientCnxIdleState.class, State.class, "state");

    public ClientCnxIdleState(ClientCnx clientCnx) {
        this.clientCnx = clientCnx;
        this.createTime = System.currentTimeMillis();
        this.state = State.USING;
    }

    public State getIdleStat() {
        return STATE_UPDATER.get(this);
    }

    boolean compareAndSetIdleStat(State originalStat, State newStat) {
        return STATE_UPDATER.compareAndSet(this, originalStat, newStat);
    }

    public boolean isUsing() {
        return this.getIdleStat() == State.USING;
    }

    public boolean isIdle() {
        return this.getIdleStat() == State.IDLE;
    }

    public boolean isReleasing() {
        return this.getIdleStat() == State.RELEASING;
    }

    public boolean isReleased() {
        return this.getIdleStat() == State.RELEASED;
    }

    public void tryMarkIdleAndInitIdleTime() {
        if (this.compareAndSetIdleStat(State.USING, State.IDLE)) {
            this.idleMarkTime = System.currentTimeMillis();
        }
    }

    public boolean tryMarkUsingAndClearIdleTime() {
        do {
            if (this.isReleased()) {
                return false;
            }
            if (this.compareAndSetIdleStat(State.IDLE, State.USING)) {
                this.idleMarkTime = 0L;
                return true;
            }
            if (!this.compareAndSetIdleStat(State.RELEASING, State.USING)) continue;
            this.idleMarkTime = 0L;
            return true;
        } while (!this.isUsing());
        return true;
    }

    public boolean tryMarkReleasing() {
        return this.compareAndSetIdleStat(State.IDLE, State.RELEASING);
    }

    public boolean tryMarkReleasedAndCloseConnection() {
        if (!this.compareAndSetIdleStat(State.RELEASING, State.RELEASED)) {
            return false;
        }
        this.clientCnx.close();
        return true;
    }

    public void doIdleDetect(long maxIdleSeconds) {
        if (this.isReleasing()) {
            return;
        }
        if (this.isIdle()) {
            if (maxIdleSeconds * 1000L + this.idleMarkTime < System.currentTimeMillis()) {
                this.tryMarkReleasing();
            }
            return;
        }
        if (this.clientCnx.idleCheck()) {
            this.tryMarkIdleAndInitIdleTime();
        }
    }

    public static enum State {
        USING,
        IDLE,
        RELEASING,
        RELEASED;

    }
}

