/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.v3_0_8.client.admin;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarAdminException
extends Exception {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PulsarAdminException.class);
    private static final int DEFAULT_STATUS_CODE = 500;
    private final String httpError;
    private final int statusCode;

    public PulsarAdminException(Throwable t2, String httpError, int statusCode) {
        super(t2);
        this.httpError = httpError;
        this.statusCode = statusCode;
    }

    public PulsarAdminException(String message, Throwable t2, String httpError, int statusCode) {
        super(message, t2);
        this.httpError = httpError;
        this.statusCode = statusCode;
    }

    public PulsarAdminException(Throwable t2) {
        super(t2);
        this.httpError = null;
        this.statusCode = 500;
    }

    public PulsarAdminException(String message, Throwable t2) {
        super(message, t2);
        this.httpError = null;
        this.statusCode = 500;
    }

    public PulsarAdminException(String message) {
        super(message);
        this.httpError = null;
        this.statusCode = 500;
    }

    public String getHttpError() {
        return this.httpError;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    protected PulsarAdminException clone() {
        return new PulsarAdminException(this.getMessage(), this.getCause(), this.httpError, this.statusCode);
    }

    public static PulsarAdminException wrap(PulsarAdminException e) {
        PulsarAdminException cloned = e.clone();
        if (e.getClass() != cloned.getClass()) {
            throw new IllegalStateException("Cloning a " + e.getClass() + " generated a " + cloned.getClass() + ", this is a bug, original error is " + e, e);
        }
        cloned.addSuppressed(e);
        return (PulsarAdminException)cloned.fillInStackTrace();
    }

    public static class GettingAuthenticationDataException
    extends PulsarAdminException {
        public GettingAuthenticationDataException(Throwable t2) {
            super(t2);
        }

        @Deprecated
        public GettingAuthenticationDataException(String msg) {
            super(msg);
        }

        @Override
        protected PulsarAdminException clone() {
            return new GettingAuthenticationDataException(this.getCause());
        }
    }

    public static class ConnectException
    extends PulsarAdminException {
        public ConnectException(Throwable t2) {
            super(t2);
        }

        public ConnectException(String message, Throwable t2) {
            super(message, t2);
        }

        @Override
        protected PulsarAdminException clone() {
            return new ConnectException(this.getMessage(), this.getCause());
        }
    }

    public static class HttpErrorException
    extends PulsarAdminException {
        public HttpErrorException(Exception e) {
            super(e);
        }

        public HttpErrorException(Throwable t2) {
            super(t2);
        }

        @Override
        protected PulsarAdminException clone() {
            return new HttpErrorException(this.getCause());
        }
    }

    public static class ServerSideErrorException
    extends PulsarAdminException {
        public ServerSideErrorException(Throwable t2, String message, String httpError, int statusCode) {
            super(message, t2, httpError, statusCode);
        }

        @Deprecated
        public ServerSideErrorException(Throwable t2) {
            super("Some error occourred on the server", t2);
        }

        @Override
        protected PulsarAdminException clone() {
            return new ServerSideErrorException(this.getCause(), this.getMessage(), this.getHttpError(), this.getStatusCode());
        }
    }

    public static class TimeoutException
    extends PulsarAdminException {
        public TimeoutException(Throwable t2) {
            super(t2);
        }

        @Override
        protected PulsarAdminException clone() {
            return new TimeoutException(this.getCause());
        }
    }

    public static class PreconditionFailedException
    extends PulsarAdminException {
        public PreconditionFailedException(Throwable t2, String httpError, int statusCode) {
            super(httpError, t2, httpError, statusCode);
        }

        @Override
        protected PulsarAdminException clone() {
            return new PreconditionFailedException(this.getCause(), this.getHttpError(), this.getStatusCode());
        }
    }

    public static class ConflictException
    extends PulsarAdminException {
        public ConflictException(Throwable t2, String httpError, int statusCode) {
            super(httpError, t2, httpError, statusCode);
        }

        @Override
        protected PulsarAdminException clone() {
            return new ConflictException(this.getCause(), this.getHttpError(), this.getStatusCode());
        }
    }

    public static class NotAllowedException
    extends PulsarAdminException {
        public NotAllowedException(Throwable t2, String httpError, int statusCode) {
            super(httpError, t2, httpError, statusCode);
        }

        @Override
        protected PulsarAdminException clone() {
            return new NotAllowedException(this.getCause(), this.getHttpError(), this.getStatusCode());
        }
    }

    public static class NotFoundException
    extends PulsarAdminException {
        public NotFoundException(Throwable t2, String httpError, int statusCode) {
            super(httpError, t2, httpError, statusCode);
        }

        @Override
        protected PulsarAdminException clone() {
            return new NotFoundException(this.getCause(), this.getHttpError(), this.getStatusCode());
        }
    }

    public static class NotAuthorizedException
    extends PulsarAdminException {
        public NotAuthorizedException(Throwable t2, String httpError, int statusCode) {
            super(httpError, t2, httpError, statusCode);
        }

        @Override
        protected PulsarAdminException clone() {
            return new NotAuthorizedException(this.getCause(), this.getHttpError(), this.getStatusCode());
        }
    }
}

