/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.conf;

import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.URI;
import java.time.Clock;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.ProxyProtocol;
import org.apache.pulsar.client.api.ServiceUrlProvider;
import org.apache.pulsar.client.impl.auth.AuthenticationDisabled;
import org.apache.pulsar.client.util.Secret;
import org.apache.pulsar.shade.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.pulsar.shade.com.google.common.collect.Sets;
import org.apache.pulsar.shade.io.swagger.annotations.ApiModelProperty;

public class ClientConfigurationData
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(name="serviceUrl", value="Pulsar cluster HTTP URL to connect to a broker.")
    private String serviceUrl;
    @ApiModelProperty(name="serviceUrlProvider", value="The implementation class of ServiceUrlProvider used to generate ServiceUrl.")
    @JsonIgnore
    private transient ServiceUrlProvider serviceUrlProvider;
    @ApiModelProperty(name="authentication", value="Authentication settings of the client.")
    @JsonIgnore
    private Authentication authentication;
    @ApiModelProperty(name="authPluginClassName", value="Class name of authentication plugin of the client.")
    private String authPluginClassName;
    @ApiModelProperty(name="authParams", value="Authentication parameter of the client.")
    @Secret
    private String authParams;
    @ApiModelProperty(name="authParamMap", value="Authentication map of the client.")
    @Secret
    private Map<String, String> authParamMap;
    @ApiModelProperty(name="operationTimeoutMs", value="Client operation timeout (in millisecond).")
    private long operationTimeoutMs = 30000L;
    @ApiModelProperty(name="lookupTimeoutMs", value="Client lookup timeout (in millisecond).")
    private long lookupTimeoutMs = -1L;
    @ApiModelProperty(name="statsIntervalSeconds", value=" Interval to print client stats (in second).")
    private long statsIntervalSeconds = 60L;
    @ApiModelProperty(name="numIoThreads", value="Number of IO threads.")
    private int numIoThreads = 1;
    @ApiModelProperty(name="numListenerThreads", value="Number of consumer listener threads.")
    private int numListenerThreads = 1;
    @ApiModelProperty(name="connectionsPerBroker", value="Number of connections established between the client and each Broker.A value of 0 means to disable connection pooling.")
    private int connectionsPerBroker = 1;
    @ApiModelProperty(name="useTcpNoDelay", value="Whether to use TCP NoDelay option.")
    private boolean useTcpNoDelay = true;
    @ApiModelProperty(name="useTls", value="Whether to use TLS.")
    private boolean useTls = false;
    @ApiModelProperty(name="tlsTrustCertsFilePath", value="Path to the trusted TLS certificate file.")
    private String tlsTrustCertsFilePath = "";
    @ApiModelProperty(name="tlsAllowInsecureConnection", value="Whether the client accepts untrusted TLS certificates from the broker.")
    private boolean tlsAllowInsecureConnection = false;
    @ApiModelProperty(name="tlsHostnameVerificationEnable", value="Whether the hostname is validated when the proxy creates a TLS connection with brokers.")
    private boolean tlsHostnameVerificationEnable = false;
    @ApiModelProperty(name="concurrentLookupRequest", value="The number of concurrent lookup requests that can be sent on each broker connection. Setting a maximum prevents overloading a broker.")
    private int concurrentLookupRequest = 5000;
    @ApiModelProperty(name="maxLookupRequest", value="Maximum number of lookup requests allowed on each broker connection to prevent overloading a broker.")
    private int maxLookupRequest = 50000;
    @ApiModelProperty(name="maxLookupRedirects", value="Maximum times of redirected lookup requests.")
    private int maxLookupRedirects = 20;
    @ApiModelProperty(name="maxNumberOfRejectedRequestPerConnection", value="Maximum number of rejected requests of a broker in a certain time frame (30 seconds) after the current connection is closed and the client creating a new connection to connect to a different broker.")
    private int maxNumberOfRejectedRequestPerConnection = 50;
    @ApiModelProperty(name="keepAliveIntervalSeconds", value="Seconds of keeping alive interval for each client broker connection.")
    private int keepAliveIntervalSeconds = 30;
    @ApiModelProperty(name="connectionTimeoutMs", value="Duration of waiting for a connection to a broker to be established.If the duration passes without a response from a broker, the connection attempt is dropped.")
    private int connectionTimeoutMs = 10000;
    @ApiModelProperty(name="requestTimeoutMs", value="Maximum duration for completing a request.")
    private int requestTimeoutMs = 60000;
    @ApiModelProperty(name="initialBackoffIntervalNanos", value="Initial backoff interval (in nanosecond).")
    private long initialBackoffIntervalNanos = TimeUnit.MILLISECONDS.toNanos(100L);
    @ApiModelProperty(name="maxBackoffIntervalNanos", value="Max backoff interval (in nanosecond).")
    private long maxBackoffIntervalNanos = TimeUnit.SECONDS.toNanos(60L);
    @ApiModelProperty(name="enableBusyWait", value="Whether to enable BusyWait for EpollEventLoopGroup.")
    private boolean enableBusyWait = false;
    @ApiModelProperty(name="listenerName", value="Listener name for lookup. Clients can use listenerName to choose one of the listeners as the service URL to create a connection to the broker as long as the network is accessible.\"advertisedListeners\" must enabled in broker side.")
    private String listenerName;
    @ApiModelProperty(name="useKeyStoreTls", value="Set TLS using KeyStore way.")
    private boolean useKeyStoreTls = false;
    @ApiModelProperty(name="sslProvider", value="The TLS provider used by an internal client to authenticate with other Pulsar brokers.")
    private String sslProvider = null;
    @ApiModelProperty(name="tlsTrustStoreType", value="TLS TrustStore type configuration. You need to set this configuration when client authentication is required.")
    private String tlsTrustStoreType = "JKS";
    @ApiModelProperty(name="tlsTrustStorePath", value="Path of TLS TrustStore.")
    private String tlsTrustStorePath = null;
    @ApiModelProperty(name="tlsTrustStorePassword", value="Password of TLS TrustStore.")
    private String tlsTrustStorePassword = null;
    @ApiModelProperty(name="tlsCiphers", value="Set of TLS Ciphers.")
    private Set<String> tlsCiphers = Sets.newTreeSet();
    @ApiModelProperty(name="tlsProtocols", value="Protocols of TLS.")
    private Set<String> tlsProtocols = Sets.newTreeSet();
    @ApiModelProperty(name="memoryLimitBytes", value="Limit of client memory usage (in byte).")
    private long memoryLimitBytes = 0L;
    @ApiModelProperty(name="proxyServiceUrl", value="URL of proxy service. proxyServiceUrl and proxyProtocol must be mutually inclusive.")
    private String proxyServiceUrl;
    @ApiModelProperty(name="proxyProtocol", value="Protocol of proxy service. proxyServiceUrl and proxyProtocol must be mutually inclusive.")
    private ProxyProtocol proxyProtocol;
    @ApiModelProperty(name="enableTransaction", value="Whether to enable transaction.")
    private boolean enableTransaction = false;
    @JsonIgnore
    private Clock clock = Clock.systemDefaultZone();
    @ApiModelProperty(name="socks5ProxyAddress", value="Address of SOCKS5 proxy.")
    private InetSocketAddress socks5ProxyAddress;
    @ApiModelProperty(name="socks5ProxyUsername", value="User name of SOCKS5 proxy.")
    private String socks5ProxyUsername;
    @ApiModelProperty(name="socks5ProxyUsername", value="Password of SOCKS5 proxy.")
    private String socks5ProxyPassword;

    public Authentication getAuthentication() {
        if (this.authentication == null) {
            this.authentication = AuthenticationDisabled.INSTANCE;
        }
        return this.authentication;
    }

    public void setAuthentication(Authentication authentication) {
        this.authentication = authentication;
    }

    public boolean isUseTls() {
        if (this.useTls) {
            return true;
        }
        if (this.getServiceUrl() != null && (this.getServiceUrl().startsWith("pulsar+ssl") || this.getServiceUrl().startsWith("https"))) {
            this.useTls = true;
            return true;
        }
        return false;
    }

    public long getLookupTimeoutMs() {
        if (this.lookupTimeoutMs >= 0L) {
            return this.lookupTimeoutMs;
        }
        return this.operationTimeoutMs;
    }

    public ClientConfigurationData clone() {
        try {
            return (ClientConfigurationData)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Failed to clone ClientConfigurationData");
        }
    }

    public InetSocketAddress getSocks5ProxyAddress() {
        if (Objects.nonNull(this.socks5ProxyAddress)) {
            return this.socks5ProxyAddress;
        }
        String proxyAddress = System.getProperty("socks5Proxy.address");
        return Optional.ofNullable(proxyAddress).map(address -> {
            try {
                URI uri = URI.create(address);
                return new InetSocketAddress(uri.getHost(), uri.getPort());
            }
            catch (Exception e) {
                throw new RuntimeException("Invalid config [socks5Proxy.address]", e);
            }
        }).orElse(null);
    }

    public String getSocks5ProxyUsername() {
        return Objects.nonNull(this.socks5ProxyUsername) ? this.socks5ProxyUsername : System.getProperty("socks5Proxy.username");
    }

    public String getSocks5ProxyPassword() {
        return Objects.nonNull(this.socks5ProxyPassword) ? this.socks5ProxyPassword : System.getProperty("socks5Proxy.password");
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public ServiceUrlProvider getServiceUrlProvider() {
        return this.serviceUrlProvider;
    }

    public String getAuthPluginClassName() {
        return this.authPluginClassName;
    }

    public String getAuthParams() {
        return this.authParams;
    }

    public Map<String, String> getAuthParamMap() {
        return this.authParamMap;
    }

    public long getOperationTimeoutMs() {
        return this.operationTimeoutMs;
    }

    public long getStatsIntervalSeconds() {
        return this.statsIntervalSeconds;
    }

    public int getNumIoThreads() {
        return this.numIoThreads;
    }

    public int getNumListenerThreads() {
        return this.numListenerThreads;
    }

    public int getConnectionsPerBroker() {
        return this.connectionsPerBroker;
    }

    public boolean isUseTcpNoDelay() {
        return this.useTcpNoDelay;
    }

    public String getTlsTrustCertsFilePath() {
        return this.tlsTrustCertsFilePath;
    }

    public boolean isTlsAllowInsecureConnection() {
        return this.tlsAllowInsecureConnection;
    }

    public boolean isTlsHostnameVerificationEnable() {
        return this.tlsHostnameVerificationEnable;
    }

    public int getConcurrentLookupRequest() {
        return this.concurrentLookupRequest;
    }

    public int getMaxLookupRequest() {
        return this.maxLookupRequest;
    }

    public int getMaxLookupRedirects() {
        return this.maxLookupRedirects;
    }

    public int getMaxNumberOfRejectedRequestPerConnection() {
        return this.maxNumberOfRejectedRequestPerConnection;
    }

    public int getKeepAliveIntervalSeconds() {
        return this.keepAliveIntervalSeconds;
    }

    public int getConnectionTimeoutMs() {
        return this.connectionTimeoutMs;
    }

    public int getRequestTimeoutMs() {
        return this.requestTimeoutMs;
    }

    public long getInitialBackoffIntervalNanos() {
        return this.initialBackoffIntervalNanos;
    }

    public long getMaxBackoffIntervalNanos() {
        return this.maxBackoffIntervalNanos;
    }

    public boolean isEnableBusyWait() {
        return this.enableBusyWait;
    }

    public String getListenerName() {
        return this.listenerName;
    }

    public boolean isUseKeyStoreTls() {
        return this.useKeyStoreTls;
    }

    public String getSslProvider() {
        return this.sslProvider;
    }

    public String getTlsTrustStoreType() {
        return this.tlsTrustStoreType;
    }

    public String getTlsTrustStorePath() {
        return this.tlsTrustStorePath;
    }

    public String getTlsTrustStorePassword() {
        return this.tlsTrustStorePassword;
    }

    public Set<String> getTlsCiphers() {
        return this.tlsCiphers;
    }

    public Set<String> getTlsProtocols() {
        return this.tlsProtocols;
    }

    public long getMemoryLimitBytes() {
        return this.memoryLimitBytes;
    }

    public String getProxyServiceUrl() {
        return this.proxyServiceUrl;
    }

    public ProxyProtocol getProxyProtocol() {
        return this.proxyProtocol;
    }

    public boolean isEnableTransaction() {
        return this.enableTransaction;
    }

    public Clock getClock() {
        return this.clock;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    @JsonIgnore
    public void setServiceUrlProvider(ServiceUrlProvider serviceUrlProvider) {
        this.serviceUrlProvider = serviceUrlProvider;
    }

    public void setAuthPluginClassName(String authPluginClassName) {
        this.authPluginClassName = authPluginClassName;
    }

    public void setAuthParams(String authParams) {
        this.authParams = authParams;
    }

    public void setAuthParamMap(Map<String, String> authParamMap) {
        this.authParamMap = authParamMap;
    }

    public void setOperationTimeoutMs(long operationTimeoutMs) {
        this.operationTimeoutMs = operationTimeoutMs;
    }

    public void setLookupTimeoutMs(long lookupTimeoutMs) {
        this.lookupTimeoutMs = lookupTimeoutMs;
    }

    public void setStatsIntervalSeconds(long statsIntervalSeconds) {
        this.statsIntervalSeconds = statsIntervalSeconds;
    }

    public void setNumIoThreads(int numIoThreads) {
        this.numIoThreads = numIoThreads;
    }

    public void setNumListenerThreads(int numListenerThreads) {
        this.numListenerThreads = numListenerThreads;
    }

    public void setConnectionsPerBroker(int connectionsPerBroker) {
        this.connectionsPerBroker = connectionsPerBroker;
    }

    public void setUseTcpNoDelay(boolean useTcpNoDelay) {
        this.useTcpNoDelay = useTcpNoDelay;
    }

    public void setUseTls(boolean useTls) {
        this.useTls = useTls;
    }

    public void setTlsTrustCertsFilePath(String tlsTrustCertsFilePath) {
        this.tlsTrustCertsFilePath = tlsTrustCertsFilePath;
    }

    public void setTlsAllowInsecureConnection(boolean tlsAllowInsecureConnection) {
        this.tlsAllowInsecureConnection = tlsAllowInsecureConnection;
    }

    public void setTlsHostnameVerificationEnable(boolean tlsHostnameVerificationEnable) {
        this.tlsHostnameVerificationEnable = tlsHostnameVerificationEnable;
    }

    public void setConcurrentLookupRequest(int concurrentLookupRequest) {
        this.concurrentLookupRequest = concurrentLookupRequest;
    }

    public void setMaxLookupRequest(int maxLookupRequest) {
        this.maxLookupRequest = maxLookupRequest;
    }

    public void setMaxLookupRedirects(int maxLookupRedirects) {
        this.maxLookupRedirects = maxLookupRedirects;
    }

    public void setMaxNumberOfRejectedRequestPerConnection(int maxNumberOfRejectedRequestPerConnection) {
        this.maxNumberOfRejectedRequestPerConnection = maxNumberOfRejectedRequestPerConnection;
    }

    public void setKeepAliveIntervalSeconds(int keepAliveIntervalSeconds) {
        this.keepAliveIntervalSeconds = keepAliveIntervalSeconds;
    }

    public void setConnectionTimeoutMs(int connectionTimeoutMs) {
        this.connectionTimeoutMs = connectionTimeoutMs;
    }

    public void setRequestTimeoutMs(int requestTimeoutMs) {
        this.requestTimeoutMs = requestTimeoutMs;
    }

    public void setInitialBackoffIntervalNanos(long initialBackoffIntervalNanos) {
        this.initialBackoffIntervalNanos = initialBackoffIntervalNanos;
    }

    public void setMaxBackoffIntervalNanos(long maxBackoffIntervalNanos) {
        this.maxBackoffIntervalNanos = maxBackoffIntervalNanos;
    }

    public void setEnableBusyWait(boolean enableBusyWait) {
        this.enableBusyWait = enableBusyWait;
    }

    public void setListenerName(String listenerName) {
        this.listenerName = listenerName;
    }

    public void setUseKeyStoreTls(boolean useKeyStoreTls) {
        this.useKeyStoreTls = useKeyStoreTls;
    }

    public void setSslProvider(String sslProvider) {
        this.sslProvider = sslProvider;
    }

    public void setTlsTrustStoreType(String tlsTrustStoreType) {
        this.tlsTrustStoreType = tlsTrustStoreType;
    }

    public void setTlsTrustStorePath(String tlsTrustStorePath) {
        this.tlsTrustStorePath = tlsTrustStorePath;
    }

    public void setTlsTrustStorePassword(String tlsTrustStorePassword) {
        this.tlsTrustStorePassword = tlsTrustStorePassword;
    }

    public void setTlsCiphers(Set<String> tlsCiphers) {
        this.tlsCiphers = tlsCiphers;
    }

    public void setTlsProtocols(Set<String> tlsProtocols) {
        this.tlsProtocols = tlsProtocols;
    }

    public void setMemoryLimitBytes(long memoryLimitBytes) {
        this.memoryLimitBytes = memoryLimitBytes;
    }

    public void setProxyServiceUrl(String proxyServiceUrl) {
        this.proxyServiceUrl = proxyServiceUrl;
    }

    public void setProxyProtocol(ProxyProtocol proxyProtocol) {
        this.proxyProtocol = proxyProtocol;
    }

    public void setEnableTransaction(boolean enableTransaction) {
        this.enableTransaction = enableTransaction;
    }

    @JsonIgnore
    public void setClock(Clock clock) {
        this.clock = clock;
    }

    public void setSocks5ProxyAddress(InetSocketAddress socks5ProxyAddress) {
        this.socks5ProxyAddress = socks5ProxyAddress;
    }

    public void setSocks5ProxyUsername(String socks5ProxyUsername) {
        this.socks5ProxyUsername = socks5ProxyUsername;
    }

    public void setSocks5ProxyPassword(String socks5ProxyPassword) {
        this.socks5ProxyPassword = socks5ProxyPassword;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientConfigurationData)) {
            return false;
        }
        ClientConfigurationData other = (ClientConfigurationData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getOperationTimeoutMs() != other.getOperationTimeoutMs()) {
            return false;
        }
        if (this.getLookupTimeoutMs() != other.getLookupTimeoutMs()) {
            return false;
        }
        if (this.getStatsIntervalSeconds() != other.getStatsIntervalSeconds()) {
            return false;
        }
        if (this.getNumIoThreads() != other.getNumIoThreads()) {
            return false;
        }
        if (this.getNumListenerThreads() != other.getNumListenerThreads()) {
            return false;
        }
        if (this.getConnectionsPerBroker() != other.getConnectionsPerBroker()) {
            return false;
        }
        if (this.isUseTcpNoDelay() != other.isUseTcpNoDelay()) {
            return false;
        }
        if (this.isUseTls() != other.isUseTls()) {
            return false;
        }
        if (this.isTlsAllowInsecureConnection() != other.isTlsAllowInsecureConnection()) {
            return false;
        }
        if (this.isTlsHostnameVerificationEnable() != other.isTlsHostnameVerificationEnable()) {
            return false;
        }
        if (this.getConcurrentLookupRequest() != other.getConcurrentLookupRequest()) {
            return false;
        }
        if (this.getMaxLookupRequest() != other.getMaxLookupRequest()) {
            return false;
        }
        if (this.getMaxLookupRedirects() != other.getMaxLookupRedirects()) {
            return false;
        }
        if (this.getMaxNumberOfRejectedRequestPerConnection() != other.getMaxNumberOfRejectedRequestPerConnection()) {
            return false;
        }
        if (this.getKeepAliveIntervalSeconds() != other.getKeepAliveIntervalSeconds()) {
            return false;
        }
        if (this.getConnectionTimeoutMs() != other.getConnectionTimeoutMs()) {
            return false;
        }
        if (this.getRequestTimeoutMs() != other.getRequestTimeoutMs()) {
            return false;
        }
        if (this.getInitialBackoffIntervalNanos() != other.getInitialBackoffIntervalNanos()) {
            return false;
        }
        if (this.getMaxBackoffIntervalNanos() != other.getMaxBackoffIntervalNanos()) {
            return false;
        }
        if (this.isEnableBusyWait() != other.isEnableBusyWait()) {
            return false;
        }
        if (this.isUseKeyStoreTls() != other.isUseKeyStoreTls()) {
            return false;
        }
        if (this.getMemoryLimitBytes() != other.getMemoryLimitBytes()) {
            return false;
        }
        if (this.isEnableTransaction() != other.isEnableTransaction()) {
            return false;
        }
        String this$serviceUrl = this.getServiceUrl();
        String other$serviceUrl = other.getServiceUrl();
        if (this$serviceUrl == null ? other$serviceUrl != null : !this$serviceUrl.equals(other$serviceUrl)) {
            return false;
        }
        Authentication this$authentication = this.getAuthentication();
        Authentication other$authentication = other.getAuthentication();
        if (this$authentication == null ? other$authentication != null : !this$authentication.equals(other$authentication)) {
            return false;
        }
        String this$authPluginClassName = this.getAuthPluginClassName();
        String other$authPluginClassName = other.getAuthPluginClassName();
        if (this$authPluginClassName == null ? other$authPluginClassName != null : !this$authPluginClassName.equals(other$authPluginClassName)) {
            return false;
        }
        String this$authParams = this.getAuthParams();
        String other$authParams = other.getAuthParams();
        if (this$authParams == null ? other$authParams != null : !this$authParams.equals(other$authParams)) {
            return false;
        }
        Map<String, String> this$authParamMap = this.getAuthParamMap();
        Map<String, String> other$authParamMap = other.getAuthParamMap();
        if (this$authParamMap == null ? other$authParamMap != null : !((Object)this$authParamMap).equals(other$authParamMap)) {
            return false;
        }
        String this$tlsTrustCertsFilePath = this.getTlsTrustCertsFilePath();
        String other$tlsTrustCertsFilePath = other.getTlsTrustCertsFilePath();
        if (this$tlsTrustCertsFilePath == null ? other$tlsTrustCertsFilePath != null : !this$tlsTrustCertsFilePath.equals(other$tlsTrustCertsFilePath)) {
            return false;
        }
        String this$listenerName = this.getListenerName();
        String other$listenerName = other.getListenerName();
        if (this$listenerName == null ? other$listenerName != null : !this$listenerName.equals(other$listenerName)) {
            return false;
        }
        String this$sslProvider = this.getSslProvider();
        String other$sslProvider = other.getSslProvider();
        if (this$sslProvider == null ? other$sslProvider != null : !this$sslProvider.equals(other$sslProvider)) {
            return false;
        }
        String this$tlsTrustStoreType = this.getTlsTrustStoreType();
        String other$tlsTrustStoreType = other.getTlsTrustStoreType();
        if (this$tlsTrustStoreType == null ? other$tlsTrustStoreType != null : !this$tlsTrustStoreType.equals(other$tlsTrustStoreType)) {
            return false;
        }
        String this$tlsTrustStorePath = this.getTlsTrustStorePath();
        String other$tlsTrustStorePath = other.getTlsTrustStorePath();
        if (this$tlsTrustStorePath == null ? other$tlsTrustStorePath != null : !this$tlsTrustStorePath.equals(other$tlsTrustStorePath)) {
            return false;
        }
        String this$tlsTrustStorePassword = this.getTlsTrustStorePassword();
        String other$tlsTrustStorePassword = other.getTlsTrustStorePassword();
        if (this$tlsTrustStorePassword == null ? other$tlsTrustStorePassword != null : !this$tlsTrustStorePassword.equals(other$tlsTrustStorePassword)) {
            return false;
        }
        Set<String> this$tlsCiphers = this.getTlsCiphers();
        Set<String> other$tlsCiphers = other.getTlsCiphers();
        if (this$tlsCiphers == null ? other$tlsCiphers != null : !((Object)this$tlsCiphers).equals(other$tlsCiphers)) {
            return false;
        }
        Set<String> this$tlsProtocols = this.getTlsProtocols();
        Set<String> other$tlsProtocols = other.getTlsProtocols();
        if (this$tlsProtocols == null ? other$tlsProtocols != null : !((Object)this$tlsProtocols).equals(other$tlsProtocols)) {
            return false;
        }
        String this$proxyServiceUrl = this.getProxyServiceUrl();
        String other$proxyServiceUrl = other.getProxyServiceUrl();
        if (this$proxyServiceUrl == null ? other$proxyServiceUrl != null : !this$proxyServiceUrl.equals(other$proxyServiceUrl)) {
            return false;
        }
        ProxyProtocol this$proxyProtocol = this.getProxyProtocol();
        ProxyProtocol other$proxyProtocol = other.getProxyProtocol();
        if (this$proxyProtocol == null ? other$proxyProtocol != null : !this$proxyProtocol.equals(other$proxyProtocol)) {
            return false;
        }
        Clock this$clock = this.getClock();
        Clock other$clock = other.getClock();
        if (this$clock == null ? other$clock != null : !((Object)this$clock).equals(other$clock)) {
            return false;
        }
        InetSocketAddress this$socks5ProxyAddress = this.getSocks5ProxyAddress();
        InetSocketAddress other$socks5ProxyAddress = other.getSocks5ProxyAddress();
        if (this$socks5ProxyAddress == null ? other$socks5ProxyAddress != null : !((Object)this$socks5ProxyAddress).equals(other$socks5ProxyAddress)) {
            return false;
        }
        String this$socks5ProxyUsername = this.getSocks5ProxyUsername();
        String other$socks5ProxyUsername = other.getSocks5ProxyUsername();
        if (this$socks5ProxyUsername == null ? other$socks5ProxyUsername != null : !this$socks5ProxyUsername.equals(other$socks5ProxyUsername)) {
            return false;
        }
        String this$socks5ProxyPassword = this.getSocks5ProxyPassword();
        String other$socks5ProxyPassword = other.getSocks5ProxyPassword();
        return !(this$socks5ProxyPassword == null ? other$socks5ProxyPassword != null : !this$socks5ProxyPassword.equals(other$socks5ProxyPassword));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientConfigurationData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $operationTimeoutMs = this.getOperationTimeoutMs();
        result = result * 59 + (int)($operationTimeoutMs >>> 32 ^ $operationTimeoutMs);
        long $lookupTimeoutMs = this.getLookupTimeoutMs();
        result = result * 59 + (int)($lookupTimeoutMs >>> 32 ^ $lookupTimeoutMs);
        long $statsIntervalSeconds = this.getStatsIntervalSeconds();
        result = result * 59 + (int)($statsIntervalSeconds >>> 32 ^ $statsIntervalSeconds);
        result = result * 59 + this.getNumIoThreads();
        result = result * 59 + this.getNumListenerThreads();
        result = result * 59 + this.getConnectionsPerBroker();
        result = result * 59 + (this.isUseTcpNoDelay() ? 79 : 97);
        result = result * 59 + (this.isUseTls() ? 79 : 97);
        result = result * 59 + (this.isTlsAllowInsecureConnection() ? 79 : 97);
        result = result * 59 + (this.isTlsHostnameVerificationEnable() ? 79 : 97);
        result = result * 59 + this.getConcurrentLookupRequest();
        result = result * 59 + this.getMaxLookupRequest();
        result = result * 59 + this.getMaxLookupRedirects();
        result = result * 59 + this.getMaxNumberOfRejectedRequestPerConnection();
        result = result * 59 + this.getKeepAliveIntervalSeconds();
        result = result * 59 + this.getConnectionTimeoutMs();
        result = result * 59 + this.getRequestTimeoutMs();
        long $initialBackoffIntervalNanos = this.getInitialBackoffIntervalNanos();
        result = result * 59 + (int)($initialBackoffIntervalNanos >>> 32 ^ $initialBackoffIntervalNanos);
        long $maxBackoffIntervalNanos = this.getMaxBackoffIntervalNanos();
        result = result * 59 + (int)($maxBackoffIntervalNanos >>> 32 ^ $maxBackoffIntervalNanos);
        result = result * 59 + (this.isEnableBusyWait() ? 79 : 97);
        result = result * 59 + (this.isUseKeyStoreTls() ? 79 : 97);
        long $memoryLimitBytes = this.getMemoryLimitBytes();
        result = result * 59 + (int)($memoryLimitBytes >>> 32 ^ $memoryLimitBytes);
        result = result * 59 + (this.isEnableTransaction() ? 79 : 97);
        String $serviceUrl = this.getServiceUrl();
        result = result * 59 + ($serviceUrl == null ? 43 : $serviceUrl.hashCode());
        Authentication $authentication = this.getAuthentication();
        result = result * 59 + ($authentication == null ? 43 : $authentication.hashCode());
        String $authPluginClassName = this.getAuthPluginClassName();
        result = result * 59 + ($authPluginClassName == null ? 43 : $authPluginClassName.hashCode());
        String $authParams = this.getAuthParams();
        result = result * 59 + ($authParams == null ? 43 : $authParams.hashCode());
        Map<String, String> $authParamMap = this.getAuthParamMap();
        result = result * 59 + ($authParamMap == null ? 43 : ((Object)$authParamMap).hashCode());
        String $tlsTrustCertsFilePath = this.getTlsTrustCertsFilePath();
        result = result * 59 + ($tlsTrustCertsFilePath == null ? 43 : $tlsTrustCertsFilePath.hashCode());
        String $listenerName = this.getListenerName();
        result = result * 59 + ($listenerName == null ? 43 : $listenerName.hashCode());
        String $sslProvider = this.getSslProvider();
        result = result * 59 + ($sslProvider == null ? 43 : $sslProvider.hashCode());
        String $tlsTrustStoreType = this.getTlsTrustStoreType();
        result = result * 59 + ($tlsTrustStoreType == null ? 43 : $tlsTrustStoreType.hashCode());
        String $tlsTrustStorePath = this.getTlsTrustStorePath();
        result = result * 59 + ($tlsTrustStorePath == null ? 43 : $tlsTrustStorePath.hashCode());
        String $tlsTrustStorePassword = this.getTlsTrustStorePassword();
        result = result * 59 + ($tlsTrustStorePassword == null ? 43 : $tlsTrustStorePassword.hashCode());
        Set<String> $tlsCiphers = this.getTlsCiphers();
        result = result * 59 + ($tlsCiphers == null ? 43 : ((Object)$tlsCiphers).hashCode());
        Set<String> $tlsProtocols = this.getTlsProtocols();
        result = result * 59 + ($tlsProtocols == null ? 43 : ((Object)$tlsProtocols).hashCode());
        String $proxyServiceUrl = this.getProxyServiceUrl();
        result = result * 59 + ($proxyServiceUrl == null ? 43 : $proxyServiceUrl.hashCode());
        ProxyProtocol $proxyProtocol = this.getProxyProtocol();
        result = result * 59 + ($proxyProtocol == null ? 43 : $proxyProtocol.hashCode());
        Clock $clock = this.getClock();
        result = result * 59 + ($clock == null ? 43 : ((Object)$clock).hashCode());
        InetSocketAddress $socks5ProxyAddress = this.getSocks5ProxyAddress();
        result = result * 59 + ($socks5ProxyAddress == null ? 43 : ((Object)$socks5ProxyAddress).hashCode());
        String $socks5ProxyUsername = this.getSocks5ProxyUsername();
        result = result * 59 + ($socks5ProxyUsername == null ? 43 : $socks5ProxyUsername.hashCode());
        String $socks5ProxyPassword = this.getSocks5ProxyPassword();
        result = result * 59 + ($socks5ProxyPassword == null ? 43 : $socks5ProxyPassword.hashCode());
        return result;
    }

    public String toString() {
        return "ClientConfigurationData(serviceUrl=" + this.getServiceUrl() + ", serviceUrlProvider=" + this.getServiceUrlProvider() + ", authentication=" + this.getAuthentication() + ", authPluginClassName=" + this.getAuthPluginClassName() + ", authParams=" + this.getAuthParams() + ", authParamMap=" + this.getAuthParamMap() + ", operationTimeoutMs=" + this.getOperationTimeoutMs() + ", lookupTimeoutMs=" + this.getLookupTimeoutMs() + ", statsIntervalSeconds=" + this.getStatsIntervalSeconds() + ", numIoThreads=" + this.getNumIoThreads() + ", numListenerThreads=" + this.getNumListenerThreads() + ", connectionsPerBroker=" + this.getConnectionsPerBroker() + ", useTcpNoDelay=" + this.isUseTcpNoDelay() + ", useTls=" + this.isUseTls() + ", tlsTrustCertsFilePath=" + this.getTlsTrustCertsFilePath() + ", tlsAllowInsecureConnection=" + this.isTlsAllowInsecureConnection() + ", tlsHostnameVerificationEnable=" + this.isTlsHostnameVerificationEnable() + ", concurrentLookupRequest=" + this.getConcurrentLookupRequest() + ", maxLookupRequest=" + this.getMaxLookupRequest() + ", maxLookupRedirects=" + this.getMaxLookupRedirects() + ", maxNumberOfRejectedRequestPerConnection=" + this.getMaxNumberOfRejectedRequestPerConnection() + ", keepAliveIntervalSeconds=" + this.getKeepAliveIntervalSeconds() + ", connectionTimeoutMs=" + this.getConnectionTimeoutMs() + ", requestTimeoutMs=" + this.getRequestTimeoutMs() + ", initialBackoffIntervalNanos=" + this.getInitialBackoffIntervalNanos() + ", maxBackoffIntervalNanos=" + this.getMaxBackoffIntervalNanos() + ", enableBusyWait=" + this.isEnableBusyWait() + ", listenerName=" + this.getListenerName() + ", useKeyStoreTls=" + this.isUseKeyStoreTls() + ", sslProvider=" + this.getSslProvider() + ", tlsTrustStoreType=" + this.getTlsTrustStoreType() + ", tlsTrustStorePath=" + this.getTlsTrustStorePath() + ", tlsTrustStorePassword=" + this.getTlsTrustStorePassword() + ", tlsCiphers=" + this.getTlsCiphers() + ", tlsProtocols=" + this.getTlsProtocols() + ", memoryLimitBytes=" + this.getMemoryLimitBytes() + ", proxyServiceUrl=" + this.getProxyServiceUrl() + ", proxyProtocol=" + this.getProxyProtocol() + ", enableTransaction=" + this.isEnableTransaction() + ", clock=" + this.getClock() + ", socks5ProxyAddress=" + this.getSocks5ProxyAddress() + ", socks5ProxyUsername=" + this.getSocks5ProxyUsername() + ", socks5ProxyPassword=" + this.getSocks5ProxyPassword() + ")";
    }

    public ClientConfigurationData() {
    }

    public ClientConfigurationData(String serviceUrl, ServiceUrlProvider serviceUrlProvider, Authentication authentication, String authPluginClassName, String authParams, Map<String, String> authParamMap, long operationTimeoutMs, long lookupTimeoutMs, long statsIntervalSeconds, int numIoThreads, int numListenerThreads, int connectionsPerBroker, boolean useTcpNoDelay, boolean useTls, String tlsTrustCertsFilePath, boolean tlsAllowInsecureConnection, boolean tlsHostnameVerificationEnable, int concurrentLookupRequest, int maxLookupRequest, int maxLookupRedirects, int maxNumberOfRejectedRequestPerConnection, int keepAliveIntervalSeconds, int connectionTimeoutMs, int requestTimeoutMs, long initialBackoffIntervalNanos, long maxBackoffIntervalNanos, boolean enableBusyWait, String listenerName, boolean useKeyStoreTls, String sslProvider, String tlsTrustStoreType, String tlsTrustStorePath, String tlsTrustStorePassword, Set<String> tlsCiphers, Set<String> tlsProtocols, long memoryLimitBytes, String proxyServiceUrl, ProxyProtocol proxyProtocol, boolean enableTransaction, Clock clock, InetSocketAddress socks5ProxyAddress, String socks5ProxyUsername, String socks5ProxyPassword) {
        this.serviceUrl = serviceUrl;
        this.serviceUrlProvider = serviceUrlProvider;
        this.authentication = authentication;
        this.authPluginClassName = authPluginClassName;
        this.authParams = authParams;
        this.authParamMap = authParamMap;
        this.operationTimeoutMs = operationTimeoutMs;
        this.lookupTimeoutMs = lookupTimeoutMs;
        this.statsIntervalSeconds = statsIntervalSeconds;
        this.numIoThreads = numIoThreads;
        this.numListenerThreads = numListenerThreads;
        this.connectionsPerBroker = connectionsPerBroker;
        this.useTcpNoDelay = useTcpNoDelay;
        this.useTls = useTls;
        this.tlsTrustCertsFilePath = tlsTrustCertsFilePath;
        this.tlsAllowInsecureConnection = tlsAllowInsecureConnection;
        this.tlsHostnameVerificationEnable = tlsHostnameVerificationEnable;
        this.concurrentLookupRequest = concurrentLookupRequest;
        this.maxLookupRequest = maxLookupRequest;
        this.maxLookupRedirects = maxLookupRedirects;
        this.maxNumberOfRejectedRequestPerConnection = maxNumberOfRejectedRequestPerConnection;
        this.keepAliveIntervalSeconds = keepAliveIntervalSeconds;
        this.connectionTimeoutMs = connectionTimeoutMs;
        this.requestTimeoutMs = requestTimeoutMs;
        this.initialBackoffIntervalNanos = initialBackoffIntervalNanos;
        this.maxBackoffIntervalNanos = maxBackoffIntervalNanos;
        this.enableBusyWait = enableBusyWait;
        this.listenerName = listenerName;
        this.useKeyStoreTls = useKeyStoreTls;
        this.sslProvider = sslProvider;
        this.tlsTrustStoreType = tlsTrustStoreType;
        this.tlsTrustStorePath = tlsTrustStorePath;
        this.tlsTrustStorePassword = tlsTrustStorePassword;
        this.tlsCiphers = tlsCiphers;
        this.tlsProtocols = tlsProtocols;
        this.memoryLimitBytes = memoryLimitBytes;
        this.proxyServiceUrl = proxyServiceUrl;
        this.proxyProtocol = proxyProtocol;
        this.enableTransaction = enableTransaction;
        this.clock = clock;
        this.socks5ProxyAddress = socks5ProxyAddress;
        this.socks5ProxyUsername = socks5ProxyUsername;
        this.socks5ProxyPassword = socks5ProxyPassword;
    }
}

