/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.intercept;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.pulsar.common.api.proto.BrokerEntryMetadata;
import org.apache.pulsar.common.intercept.BrokerEntryMetadataInterceptor;

public class AppendIndexMetadataInterceptor
implements BrokerEntryMetadataInterceptor {
    private final AtomicLong indexGenerator = new AtomicLong(-1L);

    public void recoveryIndexGenerator(long index) {
        if (this.indexGenerator.get() < index) {
            this.indexGenerator.set(index);
        }
    }

    @Override
    public BrokerEntryMetadata intercept(BrokerEntryMetadata brokerMetadata) {
        return brokerMetadata;
    }

    @Override
    public BrokerEntryMetadata interceptWithNumberOfMessages(BrokerEntryMetadata brokerMetadata, int numberOfMessages) {
        return brokerMetadata.setIndex(this.indexGenerator.addAndGet(numberOfMessages));
    }

    public long getIndex() {
        return this.indexGenerator.get();
    }
}

