/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.impl.BatchMessageIdImpl;
import org.apache.pulsar.client.impl.ClientCnx;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.apache.pulsar.client.impl.schema.AbstractSchema;
import org.apache.pulsar.client.impl.schema.AutoConsumeSchema;
import org.apache.pulsar.client.impl.schema.KeyValueSchema;
import org.apache.pulsar.common.api.EncryptionContext;
import org.apache.pulsar.common.api.proto.BrokerEntryMetadata;
import org.apache.pulsar.common.api.proto.KeyValue;
import org.apache.pulsar.common.api.proto.MessageMetadata;
import org.apache.pulsar.common.api.proto.SingleMessageMetadata;
import org.apache.pulsar.common.protocol.Commands;
import org.apache.pulsar.common.schema.KeyValueEncodingType;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.pulsar.shade.com.google.common.collect.Maps;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.buffer.Unpooled;
import org.apache.pulsar.shade.io.netty.util.Recycler;
import org.apache.pulsar.shade.io.netty.util.ReferenceCountUtil;

public class MessageImpl<T>
implements Message<T> {
    protected MessageId messageId;
    private final MessageMetadata msgMetadata;
    private ClientCnx cnx;
    private ByteBuf payload;
    private Schema<T> schema;
    private SchemaState schemaState = SchemaState.None;
    private Optional<EncryptionContext> encryptionCtx = Optional.empty();
    private String topic;
    private transient Map<String, String> properties;
    private int redeliveryCount;
    private int uncompressedSize;
    private BrokerEntryMetadata brokerEntryMetadata;
    private boolean poolMessage;
    private Recycler.Handle<MessageImpl<?>> recyclerHandle;
    private static final Recycler<MessageImpl<?>> RECYCLER = new Recycler<MessageImpl<?>>(){

        @Override
        protected MessageImpl<?> newObject(Recycler.Handle<MessageImpl<?>> handle) {
            return new MessageImpl(handle);
        }
    };

    public static <T> MessageImpl<T> create(MessageMetadata msgMetadata, ByteBuffer payload, Schema<T> schema) {
        MessageImpl<?> msg = RECYCLER.get();
        msg.msgMetadata.clear();
        msg.msgMetadata.copyFrom(msgMetadata);
        msg.messageId = null;
        msg.topic = null;
        msg.cnx = null;
        msg.payload = Unpooled.wrappedBuffer(payload);
        msg.properties = null;
        msg.schema = schema;
        msg.uncompressedSize = payload.remaining();
        return msg;
    }

    MessageImpl(String topic, MessageIdImpl messageId, MessageMetadata msgMetadata, ByteBuf payload, ClientCnx cnx, Schema<T> schema) {
        this(topic, messageId, msgMetadata, payload, Optional.empty(), cnx, schema);
    }

    MessageImpl(String topic, MessageIdImpl messageId, MessageMetadata msgMetadata, ByteBuf payload, Optional<EncryptionContext> encryptionCtx, ClientCnx cnx, Schema<T> schema) {
        this(topic, messageId, msgMetadata, payload, encryptionCtx, cnx, schema, 0, false);
    }

    MessageImpl(String topic, MessageIdImpl messageId, MessageMetadata msgMetadata, ByteBuf payload, Optional<EncryptionContext> encryptionCtx, ClientCnx cnx, Schema<T> schema, int redeliveryCount, boolean pooledMessage) {
        this.msgMetadata = new MessageMetadata();
        MessageImpl.init(this, topic, messageId, msgMetadata, payload, encryptionCtx, cnx, schema, redeliveryCount, pooledMessage);
    }

    public static <T> MessageImpl<T> create(String topic, MessageIdImpl messageId, MessageMetadata msgMetadata, ByteBuf payload, Optional<EncryptionContext> encryptionCtx, ClientCnx cnx, Schema<T> schema, int redeliveryCount, boolean pooledMessage) {
        if (pooledMessage) {
            MessageImpl<?> msg = RECYCLER.get();
            MessageImpl.init(msg, topic, messageId, msgMetadata, payload, encryptionCtx, cnx, schema, redeliveryCount, pooledMessage);
            return msg;
        }
        return new MessageImpl<T>(topic, messageId, msgMetadata, payload, encryptionCtx, cnx, schema, redeliveryCount, pooledMessage);
    }

    MessageImpl(String topic, BatchMessageIdImpl batchMessageIdImpl, MessageMetadata msgMetadata, SingleMessageMetadata singleMessageMetadata, ByteBuf payload, Optional<EncryptionContext> encryptionCtx, ClientCnx cnx, Schema<T> schema) {
        this(topic, batchMessageIdImpl, msgMetadata, singleMessageMetadata, payload, encryptionCtx, cnx, schema, 0, false);
    }

    MessageImpl(String topic, BatchMessageIdImpl batchMessageIdImpl, MessageMetadata batchMetadata, SingleMessageMetadata singleMessageMetadata, ByteBuf payload, Optional<EncryptionContext> encryptionCtx, ClientCnx cnx, Schema<T> schema, int redeliveryCount, boolean keepMessageInDirectMemory) {
        this.msgMetadata = new MessageMetadata();
        MessageImpl.init(this, topic, batchMessageIdImpl, batchMetadata, singleMessageMetadata, payload, encryptionCtx, cnx, schema, redeliveryCount, keepMessageInDirectMemory);
    }

    public static <T> MessageImpl<T> create(String topic, BatchMessageIdImpl batchMessageIdImpl, MessageMetadata batchMetadata, SingleMessageMetadata singleMessageMetadata, ByteBuf payload, Optional<EncryptionContext> encryptionCtx, ClientCnx cnx, Schema<T> schema, int redeliveryCount, boolean pooledMessage) {
        if (pooledMessage) {
            MessageImpl<?> msg = RECYCLER.get();
            MessageImpl.init(msg, topic, batchMessageIdImpl, batchMetadata, singleMessageMetadata, payload, encryptionCtx, cnx, schema, redeliveryCount, pooledMessage);
            return msg;
        }
        return new MessageImpl<T>(topic, batchMessageIdImpl, batchMetadata, singleMessageMetadata, payload, encryptionCtx, cnx, schema, redeliveryCount, pooledMessage);
    }

    static <T> void init(MessageImpl<T> msg, String topic, MessageIdImpl messageId, MessageMetadata msgMetadata, ByteBuf payload, Optional<EncryptionContext> encryptionCtx, ClientCnx cnx, Schema<T> schema, int redeliveryCount, boolean poolMessage) {
        MessageImpl.init(msg, topic, null, msgMetadata, null, payload, encryptionCtx, cnx, schema, redeliveryCount, poolMessage);
        msg.messageId = messageId;
    }

    private static <T> void init(MessageImpl<T> msg, String topic, BatchMessageIdImpl batchMessageIdImpl, MessageMetadata msgMetadata, SingleMessageMetadata singleMessageMetadata, ByteBuf payload, Optional<EncryptionContext> encryptionCtx, ClientCnx cnx, Schema<T> schema, int redeliveryCount, boolean poolMessage) {
        msg.msgMetadata.clear();
        msg.msgMetadata.copyFrom(msgMetadata);
        msg.messageId = batchMessageIdImpl;
        msg.topic = topic;
        msg.cnx = cnx;
        msg.redeliveryCount = redeliveryCount;
        msg.encryptionCtx = encryptionCtx;
        msg.schema = schema;
        msg.poolMessage = poolMessage;
        ByteBuf byteBuf = msg.payload = poolMessage ? payload.retain() : Unpooled.copiedBuffer(payload);
        if (singleMessageMetadata != null) {
            if (singleMessageMetadata.getPropertiesCount() > 0) {
                TreeMap<String, String> properties = Maps.newTreeMap();
                for (KeyValue entry : singleMessageMetadata.getPropertiesList()) {
                    properties.put(entry.getKey(), entry.getValue());
                }
                msg.properties = Collections.unmodifiableMap(properties);
            } else {
                msg.properties = Collections.emptyMap();
            }
            if (singleMessageMetadata.hasPartitionKey()) {
                msg.msgMetadata.setPartitionKeyB64Encoded(singleMessageMetadata.isPartitionKeyB64Encoded()).setPartitionKey(singleMessageMetadata.getPartitionKey());
            } else if (msg.msgMetadata.hasPartitionKey()) {
                msg.msgMetadata.clearPartitionKey();
                msg.msgMetadata.clearPartitionKeyB64Encoded();
            }
            if (singleMessageMetadata.hasOrderingKey()) {
                msg.msgMetadata.setOrderingKey(singleMessageMetadata.getOrderingKey());
            } else if (msg.msgMetadata.hasOrderingKey()) {
                msg.msgMetadata.clearOrderingKey();
            }
            if (singleMessageMetadata.hasEventTime()) {
                msg.msgMetadata.setEventTime(singleMessageMetadata.getEventTime());
            }
            if (singleMessageMetadata.hasSequenceId()) {
                msg.msgMetadata.setSequenceId(singleMessageMetadata.getSequenceId());
            }
            if (singleMessageMetadata.hasNullValue()) {
                msg.msgMetadata.setNullValue(singleMessageMetadata.isNullValue());
            }
            if (singleMessageMetadata.hasNullPartitionKey()) {
                msg.msgMetadata.setNullPartitionKey(singleMessageMetadata.isNullPartitionKey());
            }
        } else {
            msg.properties = msgMetadata.getPropertiesCount() > 0 ? Collections.unmodifiableMap(msgMetadata.getPropertiesList().stream().collect(Collectors.toMap(KeyValue::getKey, KeyValue::getValue, (oldValue, newValue) -> newValue))) : Collections.emptyMap();
        }
    }

    public MessageImpl(String topic, String msgId, Map<String, String> properties, byte[] payload, Schema<T> schema, MessageMetadata msgMetadata) {
        this(topic, msgId, properties, Unpooled.wrappedBuffer(payload), schema, msgMetadata);
    }

    public MessageImpl(String topic, String msgId, Map<String, String> properties, ByteBuf payload, Schema<T> schema, MessageMetadata msgMetadata) {
        String[] data = msgId.split(":");
        long ledgerId = Long.parseLong(data[0]);
        long entryId = Long.parseLong(data[1]);
        this.messageId = data.length == 3 ? new BatchMessageIdImpl(ledgerId, entryId, -1, Integer.parseInt(data[2])) : new MessageIdImpl(ledgerId, entryId, -1);
        this.topic = topic;
        this.cnx = null;
        this.payload = payload;
        this.properties = Collections.unmodifiableMap(properties);
        this.schema = schema;
        this.redeliveryCount = 0;
        this.msgMetadata = new MessageMetadata().copyFrom(msgMetadata);
    }

    public static MessageImpl<byte[]> deserialize(ByteBuf headersAndPayload) throws IOException {
        MessageImpl<byte[]> msg = RECYCLER.get();
        Commands.parseMessageMetadata(headersAndPayload, msg.msgMetadata);
        msg.payload = headersAndPayload;
        msg.messageId = null;
        msg.topic = null;
        msg.cnx = null;
        msg.properties = Collections.emptyMap();
        msg.brokerEntryMetadata = null;
        return msg;
    }

    public static MessageImpl<byte[]> deserializeBrokerEntryMetaDataFirst(ByteBuf headersAndPayloadWithBrokerEntryMetadata) throws IOException {
        MessageImpl<byte[]> msg = RECYCLER.get();
        msg.brokerEntryMetadata = Commands.parseBrokerEntryMetadataIfExist(headersAndPayloadWithBrokerEntryMetadata);
        if (msg.brokerEntryMetadata != null) {
            msg.msgMetadata.clear();
            msg.payload = null;
            msg.messageId = null;
            msg.topic = null;
            msg.cnx = null;
            msg.properties = Collections.emptyMap();
            return msg;
        }
        Commands.parseMessageMetadata(headersAndPayloadWithBrokerEntryMetadata, msg.msgMetadata);
        msg.payload = headersAndPayloadWithBrokerEntryMetadata;
        msg.messageId = null;
        msg.topic = null;
        msg.cnx = null;
        msg.properties = Collections.emptyMap();
        return msg;
    }

    public static MessageImpl<byte[]> deserializeSkipBrokerEntryMetaData(ByteBuf headersAndPayloadWithBrokerEntryMetadata) throws IOException {
        MessageImpl<byte[]> msg = RECYCLER.get();
        Commands.skipBrokerEntryMetadataIfExist(headersAndPayloadWithBrokerEntryMetadata);
        Commands.parseMessageMetadata(headersAndPayloadWithBrokerEntryMetadata, msg.msgMetadata);
        msg.payload = headersAndPayloadWithBrokerEntryMetadata;
        msg.messageId = null;
        msg.topic = null;
        msg.cnx = null;
        msg.properties = Collections.emptyMap();
        msg.brokerEntryMetadata = null;
        return msg;
    }

    public void setReplicatedFrom(String cluster) {
        this.msgMetadata.setReplicatedFrom(cluster);
    }

    @Override
    public boolean isReplicated() {
        return this.msgMetadata.hasReplicatedFrom();
    }

    @Override
    public String getReplicatedFrom() {
        if (this.isReplicated()) {
            return this.msgMetadata.getReplicatedFrom();
        }
        return null;
    }

    @Override
    public long getPublishTime() {
        return this.msgMetadata.getPublishTime();
    }

    @Override
    public long getEventTime() {
        if (this.msgMetadata.hasEventTime()) {
            return this.msgMetadata.getEventTime();
        }
        return 0L;
    }

    public boolean isExpired(int messageTTLInSeconds) {
        return messageTTLInSeconds != 0 && (this.brokerEntryMetadata == null || !this.brokerEntryMetadata.hasBrokerTimestamp() ? System.currentTimeMillis() > this.getPublishTime() + TimeUnit.SECONDS.toMillis(messageTTLInSeconds) : System.currentTimeMillis() > this.brokerEntryMetadata.getBrokerTimestamp() + TimeUnit.SECONDS.toMillis(messageTTLInSeconds));
    }

    public boolean publishedEarlierThan(long timestamp) {
        return this.brokerEntryMetadata == null || !this.brokerEntryMetadata.hasBrokerTimestamp() ? this.getPublishTime() < timestamp : this.brokerEntryMetadata.getBrokerTimestamp() < timestamp;
    }

    @Override
    public byte[] getData() {
        if (this.msgMetadata.isNullValue()) {
            return null;
        }
        if (this.payload.isDirect()) {
            byte[] data = new byte[this.payload.readableBytes()];
            this.payload.getBytes(this.payload.readerIndex(), data);
            return data;
        }
        if (this.payload.arrayOffset() == 0 && this.payload.capacity() == this.payload.array().length) {
            return this.payload.array();
        }
        byte[] data = new byte[this.payload.readableBytes()];
        this.payload.readBytes(data);
        return data;
    }

    @Override
    public int size() {
        if (this.msgMetadata.isNullValue()) {
            return 0;
        }
        return this.payload.readableBytes();
    }

    public Schema<T> getSchemaInternal() {
        return this.schema;
    }

    @Override
    public Optional<Schema<?>> getReaderSchema() {
        this.ensureSchemaIsLoaded();
        if (this.schema == null) {
            return Optional.empty();
        }
        if (this.schema instanceof AutoConsumeSchema) {
            byte[] schemaVersion = this.getSchemaVersion();
            return Optional.of(((AutoConsumeSchema)this.schema).atSchemaVersion(schemaVersion));
        }
        if (this.schema instanceof AbstractSchema) {
            byte[] schemaVersion = this.getSchemaVersion();
            return Optional.of(((AbstractSchema)this.schema).atSchemaVersion(schemaVersion));
        }
        return Optional.of(this.schema);
    }

    @Override
    public byte[] getSchemaVersion() {
        if (this.msgMetadata.hasSchemaVersion()) {
            return this.msgMetadata.getSchemaVersion();
        }
        return null;
    }

    private void ensureSchemaIsLoaded() {
        if (this.schema instanceof AutoConsumeSchema) {
            ((AutoConsumeSchema)this.schema).fetchSchemaIfNeeded();
        }
    }

    private SchemaInfo getSchemaInfo() {
        this.ensureSchemaIsLoaded();
        return this.schema.getSchemaInfo();
    }

    @Override
    public T getValue() {
        SchemaInfo schemaInfo = this.getSchemaInfo();
        if (schemaInfo != null && SchemaType.KEY_VALUE == schemaInfo.getType()) {
            if (this.schema.supportSchemaVersioning()) {
                return this.getKeyValueBySchemaVersion();
            }
            return this.getKeyValue();
        }
        if (this.msgMetadata.isNullValue()) {
            return null;
        }
        return this.decode(this.schema.supportSchemaVersioning() ? this.getSchemaVersion() : null);
    }

    private KeyValueSchema getKeyValueSchema() {
        if (this.schema instanceof AutoConsumeSchema) {
            return (KeyValueSchema)((AutoConsumeSchema)this.schema).getInternalSchema();
        }
        return (KeyValueSchema)this.schema;
    }

    private T decode(byte[] schemaVersion) {
        T value;
        T t = value = this.poolMessage ? (T)this.schema.decode(this.payload.nioBuffer(), schemaVersion) : null;
        if (value != null) {
            return value;
        }
        if (null == schemaVersion) {
            return this.schema.decode(this.getData());
        }
        return this.schema.decode(this.getData(), schemaVersion);
    }

    private T getKeyValueBySchemaVersion() {
        KeyValueSchema kvSchema = this.getKeyValueSchema();
        byte[] schemaVersion = this.getSchemaVersion();
        if (kvSchema.getKeyValueEncodingType() == KeyValueEncodingType.SEPARATED) {
            org.apache.pulsar.common.schema.KeyValue keyValue = kvSchema.decode(this.getKeyBytes(), this.getData(), schemaVersion);
            if (this.schema instanceof AutoConsumeSchema) {
                return (T)AutoConsumeSchema.wrapPrimitiveObject(keyValue, this.schema.getSchemaInfo().getType(), schemaVersion);
            }
            return (T)keyValue;
        }
        return this.decode(schemaVersion);
    }

    private T getKeyValue() {
        KeyValueSchema kvSchema = this.getKeyValueSchema();
        if (kvSchema.getKeyValueEncodingType() == KeyValueEncodingType.SEPARATED) {
            org.apache.pulsar.common.schema.KeyValue keyValue = kvSchema.decode(this.getKeyBytes(), this.getData(), null);
            if (this.schema instanceof AutoConsumeSchema) {
                return (T)AutoConsumeSchema.wrapPrimitiveObject(keyValue, this.schema.getSchemaInfo().getType(), null);
            }
            return (T)keyValue;
        }
        return this.decode(null);
    }

    @Override
    public long getSequenceId() {
        if (this.msgMetadata.hasSequenceId()) {
            return this.msgMetadata.getSequenceId();
        }
        return -1L;
    }

    @Override
    public String getProducerName() {
        if (this.msgMetadata.hasProducerName()) {
            return this.msgMetadata.getProducerName();
        }
        return null;
    }

    public ByteBuf getDataBuffer() {
        return this.payload;
    }

    @Override
    public MessageId getMessageId() {
        return this.messageId;
    }

    @Override
    public synchronized Map<String, String> getProperties() {
        if (this.properties == null) {
            this.properties = this.msgMetadata.getPropertiesCount() > 0 ? Collections.unmodifiableMap(this.msgMetadata.getPropertiesList().stream().collect(Collectors.toMap(KeyValue::getKey, KeyValue::getValue, (oldValue, newValue) -> newValue))) : Collections.emptyMap();
        }
        return this.properties;
    }

    @Override
    public boolean hasProperty(String name) {
        return this.getProperties().containsKey(name);
    }

    @Override
    public String getProperty(String name) {
        return this.getProperties().get(name);
    }

    public MessageMetadata getMessageBuilder() {
        return this.msgMetadata;
    }

    @Override
    public boolean hasKey() {
        return this.msgMetadata.hasPartitionKey();
    }

    @Override
    public String getTopicName() {
        return this.topic;
    }

    @Override
    public String getKey() {
        if (this.msgMetadata.hasPartitionKey()) {
            return this.msgMetadata.getPartitionKey();
        }
        return null;
    }

    @Override
    public boolean hasBase64EncodedKey() {
        return this.msgMetadata.isPartitionKeyB64Encoded();
    }

    @Override
    public byte[] getKeyBytes() {
        if (!this.msgMetadata.hasPartitionKey() || this.msgMetadata.isNullPartitionKey()) {
            return null;
        }
        if (this.hasBase64EncodedKey()) {
            return Base64.getDecoder().decode(this.getKey());
        }
        return this.getKey().getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public boolean hasOrderingKey() {
        return this.msgMetadata.hasOrderingKey();
    }

    @Override
    public byte[] getOrderingKey() {
        if (this.msgMetadata.hasOrderingKey()) {
            return this.msgMetadata.getOrderingKey();
        }
        return null;
    }

    public BrokerEntryMetadata getBrokerEntryMetadata() {
        return this.brokerEntryMetadata;
    }

    public void setBrokerEntryMetadata(BrokerEntryMetadata brokerEntryMetadata) {
        this.brokerEntryMetadata = brokerEntryMetadata;
    }

    public ClientCnx getCnx() {
        return this.cnx;
    }

    public void recycle() {
        if (this.msgMetadata != null) {
            this.msgMetadata.clear();
        }
        if (this.brokerEntryMetadata != null) {
            this.brokerEntryMetadata.clear();
        }
        this.cnx = null;
        this.messageId = null;
        this.topic = null;
        this.payload = null;
        this.encryptionCtx = null;
        this.redeliveryCount = 0;
        this.uncompressedSize = 0;
        this.properties = null;
        this.schema = null;
        this.schemaState = SchemaState.None;
        this.poolMessage = false;
        if (this.recyclerHandle != null) {
            this.recyclerHandle.recycle(this);
        }
    }

    @Override
    public void release() {
        if (this.poolMessage) {
            ReferenceCountUtil.safeRelease(this.payload);
            this.recycle();
        }
    }

    private MessageImpl(Recycler.Handle<MessageImpl<?>> recyclerHandle) {
        this.recyclerHandle = recyclerHandle;
        this.redeliveryCount = 0;
        this.msgMetadata = new MessageMetadata();
        this.brokerEntryMetadata = new BrokerEntryMetadata();
    }

    public boolean hasReplicateTo() {
        return this.msgMetadata.getReplicateTosCount() > 0;
    }

    public List<String> getReplicateTo() {
        return this.msgMetadata.getReplicateTosList();
    }

    void setMessageId(MessageIdImpl messageId) {
        this.messageId = messageId;
    }

    @Override
    public Optional<EncryptionContext> getEncryptionCtx() {
        return this.encryptionCtx;
    }

    @Override
    public int getRedeliveryCount() {
        return this.redeliveryCount;
    }

    int getUncompressedSize() {
        return this.uncompressedSize;
    }

    SchemaState getSchemaState() {
        return this.schemaState;
    }

    void setSchemaState(SchemaState schemaState) {
        this.schemaState = schemaState;
    }

    @VisibleForTesting
    ByteBuf getPayload() {
        return this.payload;
    }

    static enum SchemaState {
        None,
        Ready,
        Broken;

    }
}

