/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.KeySharedPolicy;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.MessageListener;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Reader;
import org.apache.pulsar.client.api.ReaderListener;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SubscriptionMode;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.client.impl.ConsumerInterceptors;
import org.apache.pulsar.client.impl.MultiTopicsConsumerImpl;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.ReaderInterceptorUtil;
import org.apache.pulsar.client.impl.conf.ConsumerConfigurationData;
import org.apache.pulsar.client.impl.conf.ReaderConfigurationData;
import org.apache.pulsar.client.util.ExecutorProvider;
import org.apache.pulsar.shade.org.apache.commons.codec.digest.DigestUtils;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;

public class MultiTopicsReaderImpl<T>
implements Reader<T> {
    private final MultiTopicsConsumerImpl<T> multiTopicsConsumer;

    public MultiTopicsReaderImpl(PulsarClientImpl client, ReaderConfigurationData<T> readerConfiguration, ExecutorProvider executorProvider, CompletableFuture<Consumer<T>> consumerFuture, Schema<T> schema) {
        String subscription;
        if (StringUtils.isNotBlank(readerConfiguration.getSubscriptionName())) {
            subscription = readerConfiguration.getSubscriptionName();
        } else {
            subscription = "multiTopicsReader-" + DigestUtils.sha1Hex(UUID.randomUUID().toString()).substring(0, 10);
            if (StringUtils.isNotBlank(readerConfiguration.getSubscriptionRolePrefix())) {
                subscription = readerConfiguration.getSubscriptionRolePrefix() + "-" + subscription;
            }
        }
        ConsumerConfigurationData consumerConfiguration = new ConsumerConfigurationData();
        consumerConfiguration.getTopicNames().addAll(readerConfiguration.getTopicNames());
        consumerConfiguration.setSubscriptionName(subscription);
        consumerConfiguration.setSubscriptionType(SubscriptionType.Exclusive);
        consumerConfiguration.setSubscriptionMode(SubscriptionMode.NonDurable);
        consumerConfiguration.setReceiverQueueSize(readerConfiguration.getReceiverQueueSize());
        consumerConfiguration.setReadCompacted(readerConfiguration.isReadCompacted());
        consumerConfiguration.setPoolMessages(readerConfiguration.isPoolMessages());
        if (readerConfiguration.getReaderListener() != null) {
            final ReaderListener<T> readerListener = readerConfiguration.getReaderListener();
            consumerConfiguration.setMessageListener(new MessageListener<T>(){
                private static final long serialVersionUID = 1L;

                public void received(Consumer<T> consumer, Message<T> msg) {
                    readerListener.received((Reader)MultiTopicsReaderImpl.this, msg);
                    consumer.acknowledgeCumulativeAsync(msg);
                }

                public void reachedEndOfTopic(Consumer<T> consumer) {
                    readerListener.reachedEndOfTopic((Reader)MultiTopicsReaderImpl.this);
                }
            });
        }
        if (readerConfiguration.getReaderName() != null) {
            consumerConfiguration.setConsumerName(readerConfiguration.getReaderName());
        }
        if (readerConfiguration.isResetIncludeHead()) {
            consumerConfiguration.setResetIncludeHead(true);
        }
        consumerConfiguration.setCryptoFailureAction(readerConfiguration.getCryptoFailureAction());
        if (readerConfiguration.getCryptoKeyReader() != null) {
            consumerConfiguration.setCryptoKeyReader(readerConfiguration.getCryptoKeyReader());
        }
        if (readerConfiguration.getKeyHashRanges() != null) {
            consumerConfiguration.setKeySharedPolicy((KeySharedPolicy)KeySharedPolicy.stickyHashRange().ranges(readerConfiguration.getKeyHashRanges()));
        }
        if (readerConfiguration.isAutoUpdatePartitions()) {
            consumerConfiguration.setAutoUpdatePartitionsIntervalSeconds(readerConfiguration.getAutoUpdatePartitionsIntervalSeconds());
        }
        ConsumerInterceptors<T> consumerInterceptors = ReaderInterceptorUtil.convertToConsumerInterceptors(this, readerConfiguration.getReaderInterceptorList());
        this.multiTopicsConsumer = new MultiTopicsConsumerImpl(client, consumerConfiguration, executorProvider, consumerFuture, schema, consumerInterceptors, true, readerConfiguration.getStartMessageId(), readerConfiguration.getStartMessageFromRollbackDurationInSec());
    }

    public String getTopic() {
        return this.multiTopicsConsumer.getTopic();
    }

    public Message<T> readNext() throws PulsarClientException {
        Message msg = this.multiTopicsConsumer.receive();
        this.multiTopicsConsumer.tryAcknowledgeMessage(msg);
        return msg;
    }

    public Message<T> readNext(int timeout, TimeUnit unit) throws PulsarClientException {
        Message msg = this.multiTopicsConsumer.receive(timeout, unit);
        this.multiTopicsConsumer.tryAcknowledgeMessage(msg);
        return msg;
    }

    public CompletableFuture<Message<T>> readNextAsync() {
        return this.multiTopicsConsumer.receiveAsync().thenApply(msg -> {
            this.multiTopicsConsumer.acknowledgeCumulativeAsync((Message<?>)msg);
            return msg;
        });
    }

    public CompletableFuture<Void> closeAsync() {
        return this.multiTopicsConsumer.closeAsync();
    }

    public boolean hasReachedEndOfTopic() {
        return this.multiTopicsConsumer.hasReachedEndOfTopic();
    }

    public boolean hasMessageAvailable() throws PulsarClientException {
        return this.multiTopicsConsumer.hasMessageAvailable();
    }

    public CompletableFuture<Boolean> hasMessageAvailableAsync() {
        return this.multiTopicsConsumer.hasMessageAvailableAsync();
    }

    public boolean isConnected() {
        return this.multiTopicsConsumer.isConnected();
    }

    public void seek(MessageId messageId) throws PulsarClientException {
        this.multiTopicsConsumer.seek(messageId);
    }

    public void seek(long timestamp) throws PulsarClientException {
        this.multiTopicsConsumer.seek(timestamp);
    }

    public void seek(Function<String, Object> function) throws PulsarClientException {
        this.multiTopicsConsumer.seek(function);
    }

    public CompletableFuture<Void> seekAsync(MessageId messageId) {
        return this.multiTopicsConsumer.seekAsync(messageId);
    }

    public CompletableFuture<Void> seekAsync(long timestamp) {
        return this.multiTopicsConsumer.seekAsync(timestamp);
    }

    public CompletableFuture<Void> seekAsync(Function<String, Object> function) {
        return this.multiTopicsConsumer.seekAsync(function);
    }

    public void close() throws IOException {
        this.multiTopicsConsumer.close();
    }

    public MultiTopicsConsumerImpl<T> getMultiTopicsConsumer() {
        return this.multiTopicsConsumer;
    }
}

