/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.ConsumerStats;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.Messages;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.client.impl.BatchMessageIdImpl;
import org.apache.pulsar.client.impl.ConsumerBase;
import org.apache.pulsar.client.impl.ConsumerImpl;
import org.apache.pulsar.client.impl.ConsumerInterceptors;
import org.apache.pulsar.client.impl.ConsumerStatsRecorder;
import org.apache.pulsar.client.impl.ConsumerStatsRecorderImpl;
import org.apache.pulsar.client.impl.HandlerState;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.apache.pulsar.client.impl.MessageImpl;
import org.apache.pulsar.client.impl.MessagesImpl;
import org.apache.pulsar.client.impl.MultiMessageIdImpl;
import org.apache.pulsar.client.impl.PartitionsChangedListener;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.TopicMessageIdImpl;
import org.apache.pulsar.client.impl.TopicMessageImpl;
import org.apache.pulsar.client.impl.UnAckedMessageTracker;
import org.apache.pulsar.client.impl.UnAckedTopicMessageTracker;
import org.apache.pulsar.client.impl.conf.ConsumerConfigurationData;
import org.apache.pulsar.client.impl.transaction.TransactionImpl;
import org.apache.pulsar.client.util.ConsumerName;
import org.apache.pulsar.client.util.ExecutorProvider;
import org.apache.pulsar.common.api.proto.CommandAck;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.util.CompletableFutureCancellationHandler;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.com.google.common.collect.ImmutableMap;
import org.apache.pulsar.shade.com.google.common.collect.Lists;
import org.apache.pulsar.shade.io.netty.util.Timeout;
import org.apache.pulsar.shade.io.netty.util.TimerTask;
import org.apache.pulsar.shade.org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiTopicsConsumerImpl<T>
extends ConsumerBase<T> {
    public static final String DUMMY_TOPIC_NAME_PREFIX = "MultiTopicsConsumer-";
    private final ConcurrentHashMap<String, ConsumerImpl<T>> consumers;
    protected final ConcurrentHashMap<String, Integer> partitionedTopics;
    private final ConcurrentLinkedQueue<ConsumerImpl<T>> pausedConsumers;
    private final int sharedQueueResumeThreshold;
    AtomicInteger allTopicPartitionsNumber;
    private boolean paused = false;
    private final Object pauseMutex = new Object();
    private volatile Timeout partitionsAutoUpdateTimeout = null;
    TopicsPartitionChangedListener topicsPartitionChangedListener;
    CompletableFuture<Void> partitionsAutoUpdateFuture = null;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final ConsumerStatsRecorder stats;
    private UnAckedMessageTracker unAckedMessageTracker;
    private final ConsumerConfigurationData<T> internalConfig;
    private volatile BatchMessageIdImpl startMessageId = null;
    private final long startMessageRollbackDurationInSec;
    private TimerTask partitionsAutoUpdateTimerTask = new TimerTask(){

        @Override
        public void run(Timeout timeout) throws Exception {
            try {
                if (timeout.isCancelled() || MultiTopicsConsumerImpl.this.getState() != HandlerState.State.Ready) {
                    return;
                }
                if (log.isDebugEnabled()) {
                    log.debug("[{}] run partitionsAutoUpdateTimerTask", (Object)MultiTopicsConsumerImpl.this.topic);
                }
                if (MultiTopicsConsumerImpl.this.partitionsAutoUpdateFuture == null || MultiTopicsConsumerImpl.this.partitionsAutoUpdateFuture.isDone()) {
                    MultiTopicsConsumerImpl.this.partitionsAutoUpdateFuture = MultiTopicsConsumerImpl.this.topicsPartitionChangedListener.onTopicsExtended(MultiTopicsConsumerImpl.this.partitionedTopics.keySet());
                }
            }
            catch (Throwable th) {
                log.warn("Encountered error in partition auto update timer task for multi-topic consumer. Another task will be scheduled.", th);
            }
            finally {
                MultiTopicsConsumerImpl.this.partitionsAutoUpdateTimeout = MultiTopicsConsumerImpl.this.client.timer().newTimeout(MultiTopicsConsumerImpl.this.partitionsAutoUpdateTimerTask, MultiTopicsConsumerImpl.this.conf.getAutoUpdatePartitionsIntervalSeconds(), TimeUnit.SECONDS);
            }
        }
    };
    private static final Logger log = LoggerFactory.getLogger(MultiTopicsConsumerImpl.class);

    MultiTopicsConsumerImpl(PulsarClientImpl client, ConsumerConfigurationData<T> conf, ExecutorProvider executorProvider, CompletableFuture<Consumer<T>> subscribeFuture, Schema<T> schema, ConsumerInterceptors<T> interceptors, boolean createTopicIfDoesNotExist) {
        this(client, DUMMY_TOPIC_NAME_PREFIX + ConsumerName.generateRandomName(), conf, executorProvider, subscribeFuture, schema, interceptors, createTopicIfDoesNotExist);
    }

    MultiTopicsConsumerImpl(PulsarClientImpl client, ConsumerConfigurationData<T> conf, ExecutorProvider executorProvider, CompletableFuture<Consumer<T>> subscribeFuture, Schema<T> schema, ConsumerInterceptors<T> interceptors, boolean createTopicIfDoesNotExist, MessageId startMessageId, long startMessageRollbackDurationInSec) {
        this(client, DUMMY_TOPIC_NAME_PREFIX + ConsumerName.generateRandomName(), conf, executorProvider, subscribeFuture, schema, interceptors, createTopicIfDoesNotExist, startMessageId, startMessageRollbackDurationInSec);
    }

    MultiTopicsConsumerImpl(PulsarClientImpl client, String singleTopic, ConsumerConfigurationData<T> conf, ExecutorProvider executorProvider, CompletableFuture<Consumer<T>> subscribeFuture, Schema<T> schema, ConsumerInterceptors<T> interceptors, boolean createTopicIfDoesNotExist) {
        this(client, singleTopic, conf, executorProvider, subscribeFuture, schema, interceptors, createTopicIfDoesNotExist, null, 0L);
    }

    MultiTopicsConsumerImpl(PulsarClientImpl client, String singleTopic, ConsumerConfigurationData<T> conf, ExecutorProvider executorProvider, CompletableFuture<Consumer<T>> subscribeFuture, Schema<T> schema, ConsumerInterceptors<T> interceptors, boolean createTopicIfDoesNotExist, MessageId startMessageId, long startMessageRollbackDurationInSec) {
        super(client, singleTopic, conf, Math.max(2, conf.getReceiverQueueSize()), executorProvider, subscribeFuture, schema, interceptors);
        Preconditions.checkArgument(conf.getReceiverQueueSize() > 0, "Receiver queue size needs to be greater than 0 for Topics Consumer");
        this.partitionedTopics = new ConcurrentHashMap();
        this.consumers = new ConcurrentHashMap();
        this.pausedConsumers = new ConcurrentLinkedQueue();
        this.sharedQueueResumeThreshold = this.maxReceiverQueueSize / 2;
        this.allTopicPartitionsNumber = new AtomicInteger(0);
        this.startMessageId = startMessageId != null ? new BatchMessageIdImpl(MessageIdImpl.convertToMessageIdImpl(startMessageId)) : null;
        this.startMessageRollbackDurationInSec = startMessageRollbackDurationInSec;
        this.paused = conf.isStartPaused();
        this.unAckedMessageTracker = conf.getAckTimeoutMillis() != 0L ? (conf.getTickDurationMillis() > 0L ? new UnAckedTopicMessageTracker(client, this, conf.getAckTimeoutMillis(), conf.getTickDurationMillis()) : new UnAckedTopicMessageTracker(client, this, conf.getAckTimeoutMillis())) : UnAckedMessageTracker.UNACKED_MESSAGE_TRACKER_DISABLED;
        this.internalConfig = this.getInternalConsumerConfig();
        ConsumerStatsRecorder consumerStatsRecorder = this.stats = client.getConfiguration().getStatsIntervalSeconds() > 0L ? new ConsumerStatsRecorderImpl(this) : null;
        if (conf.isAutoUpdatePartitions()) {
            this.topicsPartitionChangedListener = new TopicsPartitionChangedListener();
            this.partitionsAutoUpdateTimeout = client.timer().newTimeout(this.partitionsAutoUpdateTimerTask, conf.getAutoUpdatePartitionsIntervalSeconds(), TimeUnit.SECONDS);
        }
        if (conf.getTopicNames().isEmpty()) {
            this.setState(HandlerState.State.Ready);
            this.subscribeFuture().complete(this);
            return;
        }
        Preconditions.checkArgument(conf.getTopicNames().isEmpty() || MultiTopicsConsumerImpl.topicNamesValid(conf.getTopicNames()), "Topics is empty or invalid.");
        List futures = conf.getTopicNames().stream().map(t -> this.subscribeAsync((String)t, createTopicIfDoesNotExist)).collect(Collectors.toList());
        ((CompletableFuture)FutureUtil.waitForAll(futures).thenAccept(finalFuture -> {
            if (this.allTopicPartitionsNumber.get() > this.maxReceiverQueueSize) {
                this.setMaxReceiverQueueSize(this.allTopicPartitionsNumber.get());
            }
            this.setState(HandlerState.State.Ready);
            this.startReceivingMessages(new ArrayList<ConsumerImpl<T>>(this.consumers.values()));
            log.info("[{}] [{}] Created topics consumer with {} sub-consumers", new Object[]{this.topic, this.subscription, this.allTopicPartitionsNumber.get()});
            this.subscribeFuture().complete(this);
        })).exceptionally(ex -> {
            log.warn("[{}] Failed to subscribe topics: {}, closing consumer", (Object)this.topic, (Object)ex.getMessage());
            this.closeAsync().whenComplete((res, closeEx) -> {
                if (closeEx != null) {
                    log.error("[{}] Failed to unsubscribe after failed consumer creation: {}", (Object)this.topic, (Object)closeEx.getMessage());
                }
                subscribeFuture.completeExceptionally((Throwable)ex);
            });
            return null;
        });
    }

    private static boolean topicNamesValid(Collection<String> topics) {
        Preconditions.checkState(topics != null && topics.size() >= 1, "topics should contain more than 1 topic");
        Optional<String> result = topics.stream().filter(topic -> !TopicName.isValid(topic)).findFirst();
        if (result.isPresent()) {
            log.warn("Received invalid topic name: {}", (Object)result.get());
            return false;
        }
        HashSet<String> set = new HashSet<String>(topics);
        if (set.size() == topics.size()) {
            return true;
        }
        log.warn("Topic names not unique. unique/all : {}/{}", (Object)set.size(), (Object)topics.size());
        return false;
    }

    private void startReceivingMessages(List<ConsumerImpl<T>> newConsumers) {
        if (log.isDebugEnabled()) {
            log.debug("[{}] startReceivingMessages for {} new consumers in topics consumer, state: {}", new Object[]{this.topic, newConsumers.size(), this.getState()});
        }
        if (this.getState() == HandlerState.State.Ready) {
            newConsumers.forEach(consumer -> {
                consumer.increaseAvailablePermits(consumer.getConnectionHandler().cnx(), this.conf.getReceiverQueueSize());
                this.internalPinnedExecutor.execute(() -> this.receiveMessageFromConsumer((ConsumerImpl<T>)consumer));
            });
        }
    }

    private void receiveMessageFromConsumer(ConsumerImpl<T> consumer) {
        ((CompletableFuture)consumer.receiveAsync().thenAcceptAsync(message -> {
            if (log.isDebugEnabled()) {
                log.debug("[{}] [{}] Receive message from sub consumer:{}", new Object[]{this.topic, this.subscription, consumer.getTopic()});
            }
            this.messageReceived(consumer, (Message<T>)message);
            int size = this.incomingMessages.size();
            if (size >= this.maxReceiverQueueSize || size > this.sharedQueueResumeThreshold && !this.pausedConsumers.isEmpty()) {
                this.pausedConsumers.add(consumer);
                this.resumeReceivingFromPausedConsumersIfNeeded();
            } else {
                this.receiveMessageFromConsumer(consumer);
            }
        }, (Executor)this.internalPinnedExecutor)).exceptionally(ex -> {
            if (ex instanceof PulsarClientException.AlreadyClosedException || ex.getCause() instanceof PulsarClientException.AlreadyClosedException) {
                return null;
            }
            log.error("Receive operation failed on consumer {} - Retrying later", (Object)consumer, ex);
            this.internalPinnedExecutor.schedule(() -> this.receiveMessageFromConsumer(consumer), 10L, TimeUnit.SECONDS);
            return null;
        });
    }

    private void messageReceived(ConsumerImpl<T> consumer, Message<T> message) {
        CompletableFuture receivedFuture;
        Preconditions.checkArgument(message instanceof MessageImpl);
        TopicMessageImpl<T> topicMessage = new TopicMessageImpl<T>(consumer.getTopic(), consumer.getTopicNameWithoutPartition(), message, consumer);
        if (log.isDebugEnabled()) {
            log.debug("[{}][{}] Received message from topics-consumer {}", new Object[]{this.topic, this.subscription, message.getMessageId()});
        }
        if ((receivedFuture = this.nextPendingReceive()) != null) {
            this.unAckedMessageTracker.add(topicMessage.getMessageId());
            this.completePendingReceive(receivedFuture, topicMessage);
        } else if (this.enqueueMessageAndCheckBatchReceive(topicMessage) && this.hasPendingBatchReceive()) {
            this.notifyPendingBatchReceivedCallBack();
        }
        if (this.listener != null) {
            this.triggerListener();
        }
    }

    @Override
    protected synchronized void messageProcessed(Message<?> msg) {
        this.unAckedMessageTracker.add(msg.getMessageId());
        this.decreaseIncomingMessageSize(msg);
    }

    private void resumeReceivingFromPausedConsumersIfNeeded() {
        if (this.incomingMessages.size() <= this.sharedQueueResumeThreshold && !this.pausedConsumers.isEmpty()) {
            ConsumerImpl<T> consumer;
            while ((consumer = this.pausedConsumers.poll()) != null) {
                this.internalPinnedExecutor.execute(() -> this.receiveMessageFromConsumer(consumer));
            }
        }
    }

    @Override
    protected Message<T> internalReceive() throws PulsarClientException {
        try {
            Message message = (Message)this.incomingMessages.take();
            this.decreaseIncomingMessageSize(message);
            Preconditions.checkState(message instanceof TopicMessageImpl);
            this.unAckedMessageTracker.add(message.getMessageId());
            this.resumeReceivingFromPausedConsumersIfNeeded();
            return message;
        }
        catch (Exception e) {
            throw PulsarClientException.unwrap((Throwable)e);
        }
    }

    @Override
    protected Message<T> internalReceive(int timeout, TimeUnit unit) throws PulsarClientException {
        try {
            Message message = (Message)this.incomingMessages.poll(timeout, unit);
            if (message != null) {
                this.decreaseIncomingMessageSize(message);
                Preconditions.checkArgument(message instanceof TopicMessageImpl);
                this.unAckedMessageTracker.add(message.getMessageId());
            }
            this.resumeReceivingFromPausedConsumersIfNeeded();
            return message;
        }
        catch (Exception e) {
            throw PulsarClientException.unwrap((Throwable)e);
        }
    }

    @Override
    protected Messages<T> internalBatchReceive() throws PulsarClientException {
        try {
            return this.internalBatchReceiveAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            HandlerState.State state = this.getState();
            if (state != HandlerState.State.Closing && state != HandlerState.State.Closed) {
                this.stats.incrementNumBatchReceiveFailed();
                throw PulsarClientException.unwrap((Throwable)e);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CompletableFuture<Messages<T>> internalBatchReceiveAsync() {
        CompletableFutureCancellationHandler cancellationHandler = new CompletableFutureCancellationHandler();
        CompletableFuture result = cancellationHandler.createFuture();
        try {
            this.lock.writeLock().lock();
            if (this.hasEnoughMessagesForBatchReceive()) {
                MessagesImpl messages = this.getNewMessagesImpl();
                Message msgPeeked = (Message)this.incomingMessages.peek();
                while (msgPeeked != null && messages.canAdd(msgPeeked)) {
                    Message msg = (Message)this.incomingMessages.poll();
                    if (msg != null) {
                        this.decreaseIncomingMessageSize(msg);
                        Message interceptMsg = this.beforeConsume(msg);
                        messages.add(interceptMsg);
                    }
                    msgPeeked = (Message)this.incomingMessages.peek();
                }
                result.complete(messages);
            } else {
                ConsumerBase.OpBatchReceive opBatchReceive = ConsumerBase.OpBatchReceive.of(result);
                this.pendingBatchReceives.add(opBatchReceive);
                cancellationHandler.setCancelAction(() -> this.pendingBatchReceives.remove(opBatchReceive));
            }
            this.resumeReceivingFromPausedConsumersIfNeeded();
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return result;
    }

    @Override
    protected CompletableFuture<Message<T>> internalReceiveAsync() {
        CompletableFutureCancellationHandler cancellationHandler = new CompletableFutureCancellationHandler();
        CompletableFuture<Message<T>> result = cancellationHandler.createFuture();
        this.internalPinnedExecutor.execute(() -> {
            Message message = (Message)this.incomingMessages.poll();
            if (message == null) {
                this.pendingReceives.add(result);
                cancellationHandler.setCancelAction(() -> this.pendingReceives.remove(result));
            } else {
                this.decreaseIncomingMessageSize(message);
                Preconditions.checkState(message instanceof TopicMessageImpl);
                this.unAckedMessageTracker.add(message.getMessageId());
                this.resumeReceivingFromPausedConsumersIfNeeded();
                result.complete(message);
            }
        });
        return result;
    }

    @Override
    protected CompletableFuture<Void> doAcknowledge(MessageId messageId, CommandAck.AckType ackType, Map<String, Long> properties, TransactionImpl txnImpl) {
        Preconditions.checkArgument(messageId instanceof TopicMessageIdImpl);
        TopicMessageIdImpl topicMessageId = (TopicMessageIdImpl)messageId;
        if (this.getState() != HandlerState.State.Ready) {
            return FutureUtil.failedFuture(new PulsarClientException("Consumer already closed"));
        }
        if (ackType == CommandAck.AckType.Cumulative) {
            Consumer individualConsumer = this.consumers.get(topicMessageId.getTopicPartitionName());
            if (individualConsumer != null) {
                MessageId innerId = topicMessageId.getInnerMessageId();
                return individualConsumer.acknowledgeCumulativeAsync(innerId);
            }
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.NotConnectedException());
        }
        ConsumerImpl<T> consumer = this.consumers.get(topicMessageId.getTopicPartitionName());
        MessageId innerId = topicMessageId.getInnerMessageId();
        return consumer.doAcknowledgeWithTxn(innerId, ackType, properties, txnImpl).thenRun(() -> this.unAckedMessageTracker.remove(topicMessageId));
    }

    @Override
    protected CompletableFuture<Void> doAcknowledge(List<MessageId> messageIdList, CommandAck.AckType ackType, Map<String, Long> properties, TransactionImpl txn) {
        ArrayList resultFutures = new ArrayList();
        if (ackType == CommandAck.AckType.Cumulative) {
            messageIdList.forEach(messageId -> resultFutures.add(this.doAcknowledge((MessageId)messageId, ackType, properties, txn)));
            return CompletableFuture.allOf(resultFutures.toArray(new CompletableFuture[0]));
        }
        if (this.getState() != HandlerState.State.Ready) {
            return FutureUtil.failedFuture(new PulsarClientException("Consumer already closed"));
        }
        HashMap<String, List> topicToMessageIdMap = new HashMap<String, List>();
        for (MessageId messageId2 : messageIdList) {
            if (!(messageId2 instanceof TopicMessageIdImpl)) {
                return FutureUtil.failedFuture(new IllegalArgumentException("messageId is not instance of TopicMessageIdImpl"));
            }
            TopicMessageIdImpl topicMessageId = (TopicMessageIdImpl)messageId2;
            topicToMessageIdMap.putIfAbsent(topicMessageId.getTopicPartitionName(), new ArrayList());
            ((List)topicToMessageIdMap.get(topicMessageId.getTopicPartitionName())).add(topicMessageId.getInnerMessageId());
        }
        topicToMessageIdMap.forEach((topicPartitionName, messageIds) -> {
            ConsumerImpl<T> consumer = this.consumers.get(topicPartitionName);
            resultFutures.add(consumer.doAcknowledgeWithTxn((List<MessageId>)messageIds, ackType, properties, txn).thenAccept(res -> messageIdList.forEach(this.unAckedMessageTracker::remove)));
        });
        return CompletableFuture.allOf(resultFutures.toArray(new CompletableFuture[0]));
    }

    @Override
    protected CompletableFuture<Void> doReconsumeLater(Message<?> message, CommandAck.AckType ackType, Map<String, String> customProperties, long delayTime, TimeUnit unit) {
        MessageId messageId = message.getMessageId();
        if (messageId == null) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.InvalidMessageException("Cannot handle message with null messageId"));
        }
        Preconditions.checkArgument(messageId instanceof TopicMessageIdImpl);
        TopicMessageIdImpl topicMessageId = (TopicMessageIdImpl)messageId;
        if (this.getState() != HandlerState.State.Ready) {
            return FutureUtil.failedFuture(new PulsarClientException("Consumer already closed"));
        }
        if (ackType == CommandAck.AckType.Cumulative) {
            Consumer individualConsumer = this.consumers.get(topicMessageId.getTopicPartitionName());
            if (individualConsumer != null) {
                return individualConsumer.reconsumeLaterCumulativeAsync(message, delayTime, unit);
            }
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.NotConnectedException());
        }
        ConsumerImpl<T> consumer = this.consumers.get(topicMessageId.getTopicPartitionName());
        return consumer.doReconsumeLater(message, ackType, customProperties, delayTime, unit).thenRun(() -> this.unAckedMessageTracker.remove(topicMessageId));
    }

    public void negativeAcknowledge(MessageId messageId) {
        Preconditions.checkArgument(messageId instanceof TopicMessageIdImpl);
        TopicMessageIdImpl topicMessageId = (TopicMessageIdImpl)messageId;
        ConsumerImpl<T> consumer = this.consumers.get(topicMessageId.getTopicPartitionName());
        consumer.negativeAcknowledge(topicMessageId.getInnerMessageId());
    }

    @Override
    public void negativeAcknowledge(Message<?> message) {
        MessageId messageId = message.getMessageId();
        Preconditions.checkArgument(messageId instanceof TopicMessageIdImpl);
        TopicMessageIdImpl topicMessageId = (TopicMessageIdImpl)messageId;
        ConsumerImpl<T> consumer = this.consumers.get(topicMessageId.getTopicPartitionName());
        consumer.negativeAcknowledge(message);
    }

    @Override
    public CompletableFuture<Void> unsubscribeAsync() {
        if (this.getState() == HandlerState.State.Closing || this.getState() == HandlerState.State.Closed) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.AlreadyClosedException("Topics Consumer was already closed"));
        }
        this.setState(HandlerState.State.Closing);
        CompletableFuture<Void> unsubscribeFuture = new CompletableFuture<Void>();
        List futureList = this.consumers.values().stream().map(ConsumerImpl::unsubscribeAsync).collect(Collectors.toList());
        ((CompletableFuture)FutureUtil.waitForAll(futureList).thenCompose(r -> {
            this.setState(HandlerState.State.Closed);
            this.cleanupMultiConsumer();
            log.info("[{}] [{}] [{}] Unsubscribed Topics Consumer", new Object[]{this.topic, this.subscription, this.consumerName});
            return this.failPendingReceive();
        })).whenComplete((r, ex) -> {
            if (ex == null) {
                unsubscribeFuture.complete(null);
            } else {
                this.setState(HandlerState.State.Failed);
                unsubscribeFuture.completeExceptionally((Throwable)ex);
                log.error("[{}] [{}] [{}] Could not unsubscribe Topics Consumer", new Object[]{this.topic, this.subscription, this.consumerName, ex.getCause()});
            }
        });
        return unsubscribeFuture;
    }

    @Override
    public CompletableFuture<Void> closeAsync() {
        if (this.getState() == HandlerState.State.Closing || this.getState() == HandlerState.State.Closed) {
            if (this.unAckedMessageTracker != null) {
                this.unAckedMessageTracker.close();
            }
            return CompletableFuture.completedFuture(null);
        }
        this.setState(HandlerState.State.Closing);
        if (this.partitionsAutoUpdateTimeout != null) {
            this.partitionsAutoUpdateTimeout.cancel();
            this.partitionsAutoUpdateTimeout = null;
        }
        CompletableFuture<Void> closeFuture = new CompletableFuture<Void>();
        List futureList = this.consumers.values().stream().map(ConsumerImpl::closeAsync).collect(Collectors.toList());
        ((CompletableFuture)FutureUtil.waitForAll(futureList).thenCompose(r -> {
            this.setState(HandlerState.State.Closed);
            this.cleanupMultiConsumer();
            log.info("[{}] [{}] Closed Topics Consumer", (Object)this.topic, (Object)this.subscription);
            return this.failPendingReceive();
        })).whenComplete((r, ex) -> {
            if (ex == null) {
                closeFuture.complete(null);
            } else {
                this.setState(HandlerState.State.Failed);
                closeFuture.completeExceptionally((Throwable)ex);
                log.error("[{}] [{}] Could not close Topics Consumer", new Object[]{this.topic, this.subscription, ex.getCause()});
            }
        });
        return closeFuture;
    }

    private void cleanupMultiConsumer() {
        if (this.unAckedMessageTracker != null) {
            this.unAckedMessageTracker.close();
            this.unAckedMessageTracker = null;
        }
        if (this.partitionsAutoUpdateTimeout != null) {
            this.partitionsAutoUpdateTimeout.cancel();
            this.partitionsAutoUpdateTimeout = null;
        }
        this.client.cleanupConsumer(this);
    }

    public boolean isConnected() {
        return this.consumers.values().stream().allMatch(consumer -> consumer.isConnected());
    }

    @Override
    String getHandlerName() {
        return this.subscription;
    }

    private ConsumerConfigurationData<T> getInternalConsumerConfig() {
        Object internalConsumerConfig = this.conf.clone();
        ((ConsumerConfigurationData)internalConsumerConfig).setSubscriptionName(this.subscription);
        ((ConsumerConfigurationData)internalConsumerConfig).setConsumerName(this.consumerName);
        ((ConsumerConfigurationData)internalConsumerConfig).setMessageListener(null);
        return internalConsumerConfig;
    }

    public void redeliverUnacknowledgedMessages() {
        this.lock.writeLock().lock();
        try {
            this.consumers.values().stream().forEach(consumer -> {
                consumer.redeliverUnacknowledgedMessages();
                consumer.unAckedChunkedMessageIdSequenceMap.clear();
            });
            this.clearIncomingMessages();
            this.unAckedMessageTracker.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.resumeReceivingFromPausedConsumersIfNeeded();
    }

    @Override
    public void redeliverUnacknowledgedMessages(Set<MessageId> messageIds) {
        if (messageIds.isEmpty()) {
            return;
        }
        Preconditions.checkArgument(messageIds.stream().findFirst().get() instanceof TopicMessageIdImpl);
        if (this.conf.getSubscriptionType() != SubscriptionType.Shared && this.conf.getSubscriptionType() != SubscriptionType.Key_Shared) {
            this.redeliverUnacknowledgedMessages();
            return;
        }
        this.removeExpiredMessagesFromQueue(messageIds);
        messageIds.stream().map(messageId -> (TopicMessageIdImpl)messageId).collect(Collectors.groupingBy(TopicMessageIdImpl::getTopicPartitionName, Collectors.toSet())).forEach((topicName, messageIds1) -> this.consumers.get(topicName).redeliverUnacknowledgedMessages(messageIds1.stream().map(mid -> mid.getInnerMessageId()).collect(Collectors.toSet())));
        this.resumeReceivingFromPausedConsumersIfNeeded();
    }

    @Override
    protected void completeOpBatchReceive(ConsumerBase.OpBatchReceive<T> op) {
        this.notifyPendingBatchReceivedCallBack(op);
        this.resumeReceivingFromPausedConsumersIfNeeded();
    }

    public void seek(MessageId messageId) throws PulsarClientException {
        try {
            this.seekAsync(messageId).get();
        }
        catch (Exception e) {
            throw PulsarClientException.unwrap((Throwable)e);
        }
    }

    public void seek(long timestamp) throws PulsarClientException {
        try {
            this.seekAsync(timestamp).get();
        }
        catch (Exception e) {
            throw PulsarClientException.unwrap((Throwable)e);
        }
    }

    public void seek(Function<String, Object> function) throws PulsarClientException {
        try {
            this.seekAsync(function).get();
        }
        catch (Exception e) {
            throw PulsarClientException.unwrap((Throwable)e);
        }
    }

    public CompletableFuture<Void> seekAsync(Function<String, Object> function) {
        ArrayList futures = new ArrayList(this.consumers.size());
        this.consumers.values().forEach(consumer -> futures.add(consumer.seekAsync(function)));
        this.unAckedMessageTracker.clear();
        this.incomingMessages.clear();
        this.resetIncomingMessageSize();
        return FutureUtil.waitForAll(futures);
    }

    public CompletableFuture<Void> seekAsync(MessageId messageId) {
        MessageIdImpl targetMessageId = MessageIdImpl.convertToMessageIdImpl(messageId);
        if (targetMessageId == null || MultiTopicsConsumerImpl.isIllegalMultiTopicsMessageId(messageId)) {
            return FutureUtil.failedFuture(new PulsarClientException("Illegal messageId, messageId can only be earliest/latest"));
        }
        ArrayList futures = new ArrayList(this.consumers.size());
        this.consumers.values().forEach(consumerImpl -> futures.add(consumerImpl.seekAsync(targetMessageId)));
        this.unAckedMessageTracker.clear();
        this.clearIncomingMessages();
        return FutureUtil.waitForAll(futures);
    }

    public CompletableFuture<Void> seekAsync(long timestamp) {
        ArrayList futures = new ArrayList(this.consumers.size());
        this.consumers.values().forEach(consumer -> futures.add(consumer.seekAsync(timestamp)));
        return FutureUtil.waitForAll(futures);
    }

    @Override
    public int getAvailablePermits() {
        return this.consumers.values().stream().mapToInt(ConsumerImpl::getAvailablePermits).sum();
    }

    public boolean hasReachedEndOfTopic() {
        return this.consumers.values().stream().allMatch(Consumer::hasReachedEndOfTopic);
    }

    public boolean hasMessageAvailable() throws PulsarClientException {
        try {
            return this.hasMessageAvailableAsync().get();
        }
        catch (Exception e) {
            throw PulsarClientException.unwrap((Throwable)e);
        }
    }

    public CompletableFuture<Boolean> hasMessageAvailableAsync() {
        if (this.numMessagesInQueue() > 0) {
            return CompletableFuture.completedFuture(true);
        }
        ArrayList<CompletionStage> futureList = new ArrayList<CompletionStage>();
        AtomicBoolean hasMessageAvailable = new AtomicBoolean(false);
        for (ConsumerImpl<T> consumer : this.consumers.values()) {
            futureList.add(consumer.hasMessageAvailableAsync().thenAccept(isAvailable -> {
                if (isAvailable.booleanValue()) {
                    hasMessageAvailable.compareAndSet(false, true);
                }
            }));
        }
        CompletableFuture<Boolean> completableFuture = new CompletableFuture<Boolean>();
        FutureUtil.waitForAll(futureList).whenComplete((result, exception) -> {
            if (exception != null) {
                completableFuture.completeExceptionally((Throwable)exception);
            } else {
                completableFuture.complete(hasMessageAvailable.get() || this.numMessagesInQueue() > 0);
            }
        });
        return completableFuture;
    }

    @Override
    public int numMessagesInQueue() {
        return this.incomingMessages.size() + this.consumers.values().stream().mapToInt(ConsumerImpl::numMessagesInQueue).sum();
    }

    public synchronized ConsumerStats getStats() {
        if (this.stats == null) {
            return null;
        }
        this.stats.reset();
        this.consumers.values().stream().forEach(consumer -> this.stats.updateCumulativeStats(consumer.getStats()));
        return this.stats;
    }

    public UnAckedMessageTracker getUnAckedMessageTracker() {
        return this.unAckedMessageTracker;
    }

    private void removeExpiredMessagesFromQueue(Set<MessageId> messageIds) {
        Message peek = (Message)this.incomingMessages.peek();
        if (peek != null) {
            if (!messageIds.contains(peek.getMessageId())) {
                return;
            }
            Message message = (Message)this.incomingMessages.poll();
            Preconditions.checkState(message instanceof TopicMessageImpl);
            while (message != null) {
                this.decreaseIncomingMessageSize(message);
                MessageId messageId = message.getMessageId();
                if (!messageIds.contains(messageId)) {
                    messageIds.add(messageId);
                    break;
                }
                message.release();
                message = (Message)this.incomingMessages.poll();
            }
        }
    }

    private TopicName getTopicName(String topic) {
        try {
            return TopicName.get(topic);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private String getFullTopicName(String topic) {
        TopicName topicName = this.getTopicName(topic);
        return topicName != null ? topicName.toString() : null;
    }

    private void removeTopic(String topic) {
        String fullTopicName = this.getFullTopicName(topic);
        if (fullTopicName != null) {
            this.partitionedTopics.remove(topic);
        }
    }

    public CompletableFuture<Void> subscribeAsync(String topicName, boolean createTopicIfDoesNotExist) {
        TopicName topicNameInstance = this.getTopicName(topicName);
        if (topicNameInstance == null) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.AlreadyClosedException("Topic name not valid"));
        }
        String fullTopicName = topicNameInstance.toString();
        if (this.consumers.containsKey(fullTopicName) || this.partitionedTopics.containsKey(topicNameInstance.getPartitionedTopicName())) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.AlreadyClosedException("Already subscribed to " + topicName));
        }
        if (this.getState() == HandlerState.State.Closing || this.getState() == HandlerState.State.Closed) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.AlreadyClosedException("Topics Consumer was already closed"));
        }
        CompletableFuture<Void> subscribeResult = new CompletableFuture<Void>();
        ((CompletableFuture)this.client.getPartitionedTopicMetadata(topicName).thenAccept(metadata -> this.subscribeTopicPartitions(subscribeResult, fullTopicName, metadata.partitions, createTopicIfDoesNotExist))).exceptionally(ex1 -> {
            log.warn("[{}] Failed to get partitioned topic metadata: {}", (Object)fullTopicName, (Object)ex1.getMessage());
            subscribeResult.completeExceptionally((Throwable)ex1);
            return null;
        });
        return subscribeResult;
    }

    public static <T> MultiTopicsConsumerImpl<T> createPartitionedConsumer(PulsarClientImpl client, ConsumerConfigurationData<T> conf, ExecutorProvider executorProvider, CompletableFuture<Consumer<T>> subscribeFuture, int numPartitions, Schema<T> schema, ConsumerInterceptors<T> interceptors) {
        Preconditions.checkArgument(conf.getTopicNames().size() == 1, "Should have only 1 topic for partitioned consumer");
        Object cloneConf = conf.clone();
        String topicName = ((ConsumerConfigurationData)cloneConf).getSingleTopic();
        ((ConsumerConfigurationData)cloneConf).getTopicNames().remove(topicName);
        CompletableFuture<Consumer<T>> future = new CompletableFuture<Consumer<T>>();
        MultiTopicsConsumerImpl consumer = new MultiTopicsConsumerImpl(client, topicName, cloneConf, executorProvider, future, schema, interceptors, true);
        ((CompletableFuture)((CompletableFuture)future.thenCompose(c -> ((MultiTopicsConsumerImpl)c).subscribeAsync(topicName, numPartitions))).thenRun(() -> subscribeFuture.complete(consumer))).exceptionally(e -> {
            log.warn("Failed subscription for createPartitionedConsumer: {} {}, e:{}", new Object[]{topicName, numPartitions, e});
            consumer.cleanupMultiConsumer();
            subscribeFuture.completeExceptionally(PulsarClientException.wrap((Throwable)((Throwable)e).getCause(), (String)String.format("Failed to subscribe %s with %d partitions", topicName, numPartitions)));
            return null;
        });
        return consumer;
    }

    CompletableFuture<Void> subscribeAsync(String topicName, int numberPartitions) {
        TopicName topicNameInstance = this.getTopicName(topicName);
        if (topicNameInstance == null) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.AlreadyClosedException("Topic name not valid"));
        }
        String fullTopicName = topicNameInstance.toString();
        if (this.consumers.containsKey(fullTopicName) || this.partitionedTopics.containsKey(topicNameInstance.getPartitionedTopicName())) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.AlreadyClosedException("Already subscribed to " + topicName));
        }
        if (this.getState() == HandlerState.State.Closing || this.getState() == HandlerState.State.Closed) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.AlreadyClosedException("Topics Consumer was already closed"));
        }
        CompletableFuture<Void> subscribeResult = new CompletableFuture<Void>();
        this.subscribeTopicPartitions(subscribeResult, fullTopicName, numberPartitions, true);
        return subscribeResult;
    }

    private void subscribeTopicPartitions(CompletableFuture<Void> subscribeResult, String topicName, int numPartitions, boolean createIfDoesNotExist) {
        this.client.preProcessSchemaBeforeSubscribe(this.client, this.schema, topicName).whenComplete((schema, cause) -> {
            if (null == cause) {
                this.doSubscribeTopicPartitions((Schema<T>)schema, subscribeResult, topicName, numPartitions, createIfDoesNotExist);
            } else {
                subscribeResult.completeExceptionally((Throwable)cause);
            }
        });
    }

    private void doSubscribeTopicPartitions(Schema<T> schema, CompletableFuture<Void> subscribeResult, String topicName, int numPartitions, boolean createIfDoesNotExist) {
        List futureList;
        if (log.isDebugEnabled()) {
            log.debug("Subscribe to topic {} metadata.partitions: {}", (Object)topicName, (Object)numPartitions);
        }
        if (numPartitions != 0) {
            boolean isTopicBeingSubscribedForInOtherThread;
            boolean bl = isTopicBeingSubscribedForInOtherThread = this.partitionedTopics.putIfAbsent(topicName, numPartitions) != null;
            if (isTopicBeingSubscribedForInOtherThread) {
                String errorMessage = String.format("[%s] Failed to subscribe for topic [%s] in topics consumer. Topic is already being subscribed for in other thread.", this.topic, topicName);
                log.warn(errorMessage);
                subscribeResult.completeExceptionally(new PulsarClientException(errorMessage));
                return;
            }
            this.allTopicPartitionsNumber.addAndGet(numPartitions);
            int receiverQueueSize = Math.min(this.conf.getReceiverQueueSize(), this.conf.getMaxTotalReceiverQueueSizeAcrossPartitions() / numPartitions);
            ConsumerConfigurationData<T> configurationData = this.getInternalConsumerConfig();
            configurationData.setReceiverQueueSize(receiverQueueSize);
            futureList = IntStream.range(0, numPartitions).mapToObj(partitionIndex -> {
                String partitionName = TopicName.get(topicName).getPartition(partitionIndex).toString();
                CompletableFuture subFuture = new CompletableFuture();
                ConsumerImpl newConsumer = ConsumerImpl.newConsumerImpl(this.client, partitionName, configurationData, this.client.externalExecutorProvider(), partitionIndex, true, subFuture, this.startMessageId, schema, this.interceptors, createIfDoesNotExist, this.startMessageRollbackDurationInSec);
                Object object = this.pauseMutex;
                synchronized (object) {
                    if (this.paused) {
                        newConsumer.pause();
                    }
                    this.consumers.putIfAbsent(newConsumer.getTopic(), newConsumer);
                }
                return subFuture;
            }).collect(Collectors.toList());
        } else {
            this.allTopicPartitionsNumber.incrementAndGet();
            CompletableFuture subFuture = new CompletableFuture();
            this.consumers.compute(topicName, (key, existingValue) -> {
                if (existingValue != null) {
                    String errorMessage = String.format("[%s] Failed to subscribe for topic [%s] in topics consumer. Topic is already being subscribed for in other thread.", this.topic, topicName);
                    log.warn(errorMessage);
                    subscribeResult.completeExceptionally(new PulsarClientException(errorMessage));
                    return existingValue;
                }
                ConsumerImpl<T> newConsumer = ConsumerImpl.newConsumerImpl(this.client, topicName, this.internalConfig, this.client.externalExecutorProvider(), -1, true, subFuture, this.startMessageId, schema, this.interceptors, createIfDoesNotExist, this.startMessageRollbackDurationInSec);
                Object object = this.pauseMutex;
                synchronized (object) {
                    if (this.paused) {
                        newConsumer.pause();
                    }
                }
                return newConsumer;
            });
            futureList = Collections.singletonList(subFuture);
        }
        ((CompletableFuture)FutureUtil.waitForAll(futureList).thenAccept(finalFuture -> {
            if (this.allTopicPartitionsNumber.get() > this.maxReceiverQueueSize) {
                this.setMaxReceiverQueueSize(this.allTopicPartitionsNumber.get());
            }
            this.startReceivingMessages(this.consumers.values().stream().filter(consumer1 -> {
                String consumerTopicName = consumer1.getTopic();
                return TopicName.get(consumerTopicName).getPartitionedTopicName().equals(TopicName.get(topicName).getPartitionedTopicName());
            }).collect(Collectors.toList()));
            subscribeResult.complete(null);
            log.info("[{}] [{}] Success subscribe new topic {} in topics consumer, partitions: {}, allTopicPartitionsNumber: {}", new Object[]{this.topic, this.subscription, topicName, numPartitions, this.allTopicPartitionsNumber.get()});
        })).exceptionally(ex -> {
            this.handleSubscribeOneTopicError(topicName, (Throwable)ex, subscribeResult);
            return null;
        });
    }

    private void handleSubscribeOneTopicError(String topicName, Throwable error, CompletableFuture<Void> subscribeFuture) {
        log.warn("[{}] Failed to subscribe for topic [{}] in topics consumer {}", new Object[]{this.topic, topicName, error.getMessage()});
        this.client.externalExecutorProvider().getExecutor().submit(() -> {
            AtomicInteger toCloseNum = new AtomicInteger(0);
            this.consumers.values().stream().filter(consumer1 -> {
                String consumerTopicName = consumer1.getTopic();
                if (TopicName.get(consumerTopicName).getPartitionedTopicName().equals(TopicName.get(topicName).getPartitionedTopicName())) {
                    toCloseNum.incrementAndGet();
                    return true;
                }
                return false;
            }).collect(Collectors.toList()).forEach(consumer2 -> consumer2.closeAsync().whenComplete((r, ex) -> {
                consumer2.subscribeFuture().completeExceptionally(error);
                this.allTopicPartitionsNumber.decrementAndGet();
                this.consumers.remove(consumer2.getTopic());
                if (toCloseNum.decrementAndGet() == 0) {
                    log.warn("[{}] Failed to subscribe for topic [{}] in topics consumer, subscribe error: {}", new Object[]{this.topic, topicName, error.getMessage()});
                    this.removeTopic(topicName);
                    subscribeFuture.completeExceptionally(error);
                }
            }));
        });
    }

    public CompletableFuture<Void> unsubscribeAsync(String topicName) {
        Preconditions.checkArgument(TopicName.isValid(topicName), "Invalid topic name:" + topicName);
        if (this.getState() == HandlerState.State.Closing || this.getState() == HandlerState.State.Closed) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.AlreadyClosedException("Topics Consumer was already closed"));
        }
        if (this.partitionsAutoUpdateTimeout != null) {
            this.partitionsAutoUpdateTimeout.cancel();
            this.partitionsAutoUpdateTimeout = null;
        }
        CompletableFuture<Void> unsubscribeFuture = new CompletableFuture<Void>();
        String topicPartName = TopicName.get(topicName).getPartitionedTopicName();
        List consumersToUnsub = this.consumers.values().stream().filter(consumer -> {
            String consumerTopicName = consumer.getTopic();
            return TopicName.get(consumerTopicName).getPartitionedTopicName().equals(topicPartName);
        }).collect(Collectors.toList());
        List futureList = consumersToUnsub.stream().map(ConsumerImpl::unsubscribeAsync).collect(Collectors.toList());
        FutureUtil.waitForAll(futureList).whenComplete((r, ex) -> {
            if (ex == null) {
                consumersToUnsub.forEach(consumer1 -> {
                    this.consumers.remove(consumer1.getTopic());
                    this.pausedConsumers.remove(consumer1);
                    this.allTopicPartitionsNumber.decrementAndGet();
                });
                this.removeTopic(topicName);
                ((UnAckedTopicMessageTracker)this.unAckedMessageTracker).removeTopicMessages(topicName);
                unsubscribeFuture.complete(null);
                log.info("[{}] [{}] [{}] Unsubscribed Topics Consumer, allTopicPartitionsNumber: {}", new Object[]{topicName, this.subscription, this.consumerName, this.allTopicPartitionsNumber});
            } else {
                unsubscribeFuture.completeExceptionally((Throwable)ex);
                this.setState(HandlerState.State.Failed);
                log.error("[{}] [{}] [{}] Could not unsubscribe Topics Consumer", new Object[]{topicName, this.subscription, this.consumerName, ex.getCause()});
            }
        });
        return unsubscribeFuture;
    }

    public CompletableFuture<Void> removeConsumerAsync(String topicName) {
        Preconditions.checkArgument(TopicName.isValid(topicName), "Invalid topic name:" + topicName);
        if (this.getState() == HandlerState.State.Closing || this.getState() == HandlerState.State.Closed) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.AlreadyClosedException("Topics Consumer was already closed"));
        }
        CompletableFuture<Void> unsubscribeFuture = new CompletableFuture<Void>();
        String topicPartName = TopicName.get(topicName).getPartitionedTopicName();
        List consumersToClose = this.consumers.values().stream().filter(consumer -> {
            String consumerTopicName = consumer.getTopic();
            return TopicName.get(consumerTopicName).getPartitionedTopicName().equals(topicPartName);
        }).collect(Collectors.toList());
        List futureList = consumersToClose.stream().map(ConsumerImpl::closeAsync).collect(Collectors.toList());
        FutureUtil.waitForAll(futureList).whenComplete((r, ex) -> {
            if (ex == null) {
                consumersToClose.forEach(consumer1 -> {
                    this.consumers.remove(consumer1.getTopic());
                    this.pausedConsumers.remove(consumer1);
                    this.allTopicPartitionsNumber.decrementAndGet();
                });
                this.removeTopic(topicName);
                ((UnAckedTopicMessageTracker)this.unAckedMessageTracker).removeTopicMessages(topicName);
                unsubscribeFuture.complete(null);
                log.info("[{}] [{}] [{}] Removed Topics Consumer, allTopicPartitionsNumber: {}", new Object[]{topicName, this.subscription, this.consumerName, this.allTopicPartitionsNumber});
            } else {
                unsubscribeFuture.completeExceptionally((Throwable)ex);
                this.setState(HandlerState.State.Failed);
                log.error("[{}] [{}] [{}] Could not remove Topics Consumer", new Object[]{topicName, this.subscription, this.consumerName, ex.getCause()});
            }
        });
        return unsubscribeFuture;
    }

    public List<String> getPartitionedTopics() {
        return this.partitionedTopics.keySet().stream().collect(Collectors.toList());
    }

    public List<String> getPartitions() {
        return this.consumers.keySet().stream().collect(Collectors.toList());
    }

    public List<ConsumerImpl<T>> getConsumers() {
        return this.consumers.values().stream().collect(Collectors.toList());
    }

    int getPartitionsOfTheTopicMap() {
        return this.partitionedTopics.values().stream().mapToInt(Integer::intValue).sum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        Object object = this.pauseMutex;
        synchronized (object) {
            this.paused = true;
            this.consumers.forEach((name, consumer) -> consumer.pause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Object object = this.pauseMutex;
        synchronized (object) {
            this.paused = false;
            this.consumers.forEach((name, consumer) -> consumer.resume());
        }
    }

    public long getLastDisconnectedTimestamp() {
        long lastDisconnectedTimestamp = 0L;
        Optional<ConsumerImpl> c = this.consumers.values().stream().max(Comparator.comparingLong(ConsumerImpl::getLastDisconnectedTimestamp));
        if (c.isPresent()) {
            lastDisconnectedTimestamp = c.get().getLastDisconnectedTimestamp();
        }
        return lastDisconnectedTimestamp;
    }

    private CompletableFuture<Void> subscribeIncreasedTopicPartitions(String topicName) {
        int oldPartitionNumber = this.partitionedTopics.get(topicName);
        return ((CompletableFuture)this.client.getPartitionsForTopic(topicName).thenCompose(list -> {
            int currentPartitionNumber = Long.valueOf(list.stream().filter(t -> TopicName.get(t).isPartitioned()).count()).intValue();
            if (log.isDebugEnabled()) {
                log.debug("[{}] partitions number. old: {}, new: {}", new Object[]{topicName, oldPartitionNumber, currentPartitionNumber});
            }
            if (oldPartitionNumber == currentPartitionNumber) {
                return CompletableFuture.completedFuture(null);
            }
            if (currentPartitionNumber == 0) {
                this.partitionedTopics.put(topicName, 0);
                this.allTopicPartitionsNumber.addAndGet(-oldPartitionNumber);
                ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
                for (Map.Entry<String, ConsumerImpl<T>> e : this.consumers.entrySet()) {
                    String partitionedTopicName = TopicName.get(e.getKey()).getPartitionedTopicName();
                    if (!partitionedTopicName.equals(topicName)) continue;
                    futures.add(e.getValue().closeAsync());
                    this.consumers.remove(e.getKey());
                }
                return FutureUtil.waitForAll(futures);
            }
            if (oldPartitionNumber < currentPartitionNumber) {
                this.allTopicPartitionsNumber.addAndGet(currentPartitionNumber - oldPartitionNumber);
                this.partitionedTopics.put(topicName, currentPartitionNumber);
                List newPartitions = list.subList(oldPartitionNumber, currentPartitionNumber);
                List futureList = newPartitions.stream().map(partitionName -> {
                    int partitionIndex = TopicName.getPartitionIndex(partitionName);
                    CompletableFuture subFuture = new CompletableFuture();
                    ConsumerConfigurationData<T> configurationData = this.getInternalConsumerConfig();
                    ConsumerImpl<T> newConsumer = ConsumerImpl.newConsumerImpl(this.client, partitionName, configurationData, this.client.externalExecutorProvider(), partitionIndex, true, subFuture, this.startMessageId, this.schema, this.interceptors, true, this.startMessageRollbackDurationInSec);
                    Object object = this.pauseMutex;
                    synchronized (object) {
                        if (this.paused) {
                            newConsumer.pause();
                        }
                        this.consumers.putIfAbsent(newConsumer.getTopic(), newConsumer);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] create consumer {} for partitionName: {}", new Object[]{topicName, newConsumer.getTopic(), partitionName});
                    }
                    return subFuture;
                }).collect(Collectors.toList());
                this.onPartitionsChange(topicName, currentPartitionNumber);
                return FutureUtil.waitForAll(futureList).thenAccept(finalFuture -> {
                    List<ConsumerImpl<T>> newConsumerList = newPartitions.stream().map(partitionTopic -> this.consumers.get(partitionTopic)).collect(Collectors.toList());
                    this.startReceivingMessages(newConsumerList);
                });
            }
            log.error("[{}] not support shrink topic partitions. old: {}, new: {}", new Object[]{topicName, oldPartitionNumber, currentPartitionNumber});
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.NotSupportedException("not support shrink topic partitions"));
        })).exceptionally(throwable -> {
            log.warn("Failed to get partitions for topic to determine if new partitions are added", throwable);
            return null;
        });
    }

    @VisibleForTesting
    public Timeout getPartitionsAutoUpdateTimeout() {
        return this.partitionsAutoUpdateTimeout;
    }

    @Override
    public CompletableFuture<MessageId> getLastMessageIdAsync() {
        CompletableFuture<MessageId> returnFuture = new CompletableFuture<MessageId>();
        Map<String, CompletableFuture> messageIdFutures = this.consumers.entrySet().stream().map(entry -> Pair.of(entry.getKey(), ((ConsumerImpl)entry.getValue()).getLastMessageIdAsync())).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
        CompletableFuture.allOf((CompletableFuture[])messageIdFutures.entrySet().stream().map(Map.Entry::getValue).toArray(CompletableFuture[]::new)).whenComplete((ignore, ex) -> {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            messageIdFutures.forEach((key, future) -> {
                MessageId messageId;
                try {
                    messageId = (MessageId)future.get();
                }
                catch (Exception e) {
                    log.warn("[{}] Exception when topic {} getLastMessageId.", key, (Object)e);
                    messageId = MessageId.earliest;
                }
                builder.put(key, messageId);
            });
            returnFuture.complete(new MultiMessageIdImpl(builder.build()));
        });
        return returnFuture;
    }

    public static boolean isIllegalMultiTopicsMessageId(MessageId messageId) {
        return !MessageId.earliest.equals(messageId) && !MessageId.latest.equals(messageId);
    }

    public void tryAcknowledgeMessage(Message<T> msg) {
        if (msg != null) {
            this.acknowledgeCumulativeAsync(msg);
        }
    }

    private class TopicsPartitionChangedListener
    implements PartitionsChangedListener {
        private TopicsPartitionChangedListener() {
        }

        @Override
        public CompletableFuture<Void> onTopicsExtended(Collection<String> topicsExtended) {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            if (topicsExtended.isEmpty()) {
                future.complete(null);
                return future;
            }
            if (log.isDebugEnabled()) {
                log.debug("[{}]  run onTopicsExtended: {}, size: {}", new Object[]{MultiTopicsConsumerImpl.this.topic, topicsExtended.toString(), topicsExtended.size()});
            }
            ArrayList futureList = Lists.newArrayListWithExpectedSize(topicsExtended.size());
            topicsExtended.forEach(topic -> futureList.add(MultiTopicsConsumerImpl.this.subscribeIncreasedTopicPartitions(topic)));
            ((CompletableFuture)FutureUtil.waitForAll(futureList).thenAccept(finalFuture -> future.complete(null))).exceptionally(ex -> {
                log.warn("[{}] Failed to subscribe increased topics partitions: {}", (Object)MultiTopicsConsumerImpl.this.topic, (Object)ex.getMessage());
                future.completeExceptionally((Throwable)ex);
                return null;
            });
            return future;
        }
    }
}

