/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.conf;

import java.io.Serializable;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.pulsar.client.api.BatchReceivePolicy;
import org.apache.pulsar.client.api.ConsumerCryptoFailureAction;
import org.apache.pulsar.client.api.ConsumerEventListener;
import org.apache.pulsar.client.api.CryptoKeyReader;
import org.apache.pulsar.client.api.DeadLetterPolicy;
import org.apache.pulsar.client.api.KeySharedPolicy;
import org.apache.pulsar.client.api.MessageCrypto;
import org.apache.pulsar.client.api.MessageListener;
import org.apache.pulsar.client.api.MessagePayloadProcessor;
import org.apache.pulsar.client.api.NegativeAckRedeliveryBackoff;
import org.apache.pulsar.client.api.RegexSubscriptionMode;
import org.apache.pulsar.client.api.SubscriptionInitialPosition;
import org.apache.pulsar.client.api.SubscriptionMode;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.shade.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.com.google.common.collect.Maps;
import org.apache.pulsar.shade.com.google.common.collect.Sets;

public class ConsumerConfigurationData<T>
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private Set<String> topicNames = Sets.newTreeSet();
    private Pattern topicsPattern;
    private String subscriptionName;
    private SubscriptionType subscriptionType = SubscriptionType.Exclusive;
    private SubscriptionMode subscriptionMode = SubscriptionMode.Durable;
    @JsonIgnore
    private MessageListener<T> messageListener;
    @JsonIgnore
    private ConsumerEventListener consumerEventListener;
    @JsonIgnore
    private NegativeAckRedeliveryBackoff negativeAckRedeliveryBackoff;
    private int receiverQueueSize = 1000;
    private long acknowledgementsGroupTimeMicros = TimeUnit.MILLISECONDS.toMicros(100L);
    private long negativeAckRedeliveryDelayMicros = TimeUnit.MINUTES.toMicros(1L);
    private int maxTotalReceiverQueueSizeAcrossPartitions = 50000;
    private String consumerName = null;
    private long ackTimeoutMillis = 0L;
    private long tickDurationMillis = 1000L;
    private int priorityLevel = 0;
    private int maxPendingChunkedMessage = 10;
    private boolean autoAckOldestChunkedMessageOnQueueFull = false;
    private long expireTimeOfIncompleteChunkedMessageMillis = 60000L;
    @JsonIgnore
    private CryptoKeyReader cryptoKeyReader = null;
    @JsonIgnore
    private transient MessageCrypto messageCrypto = null;
    private ConsumerCryptoFailureAction cryptoFailureAction = ConsumerCryptoFailureAction.FAIL;
    private SortedMap<String, String> properties = new TreeMap<String, String>();
    private boolean readCompacted = false;
    private SubscriptionInitialPosition subscriptionInitialPosition = SubscriptionInitialPosition.Latest;
    private int patternAutoDiscoveryPeriod = 60;
    private RegexSubscriptionMode regexSubscriptionMode = RegexSubscriptionMode.PersistentOnly;
    private transient DeadLetterPolicy deadLetterPolicy;
    private boolean retryEnable = false;
    @JsonIgnore
    private BatchReceivePolicy batchReceivePolicy;
    private boolean autoUpdatePartitions = true;
    private long autoUpdatePartitionsIntervalSeconds = 60L;
    private boolean replicateSubscriptionState = false;
    private boolean resetIncludeHead = false;
    private transient KeySharedPolicy keySharedPolicy;
    private boolean batchIndexAckEnabled = false;
    private boolean ackReceiptEnabled = false;
    private boolean poolMessages = false;
    @JsonIgnore
    private transient MessagePayloadProcessor payloadProcessor = null;

    @Deprecated
    public void setMaxPendingChuckedMessage(int maxPendingChuckedMessage) {
        this.maxPendingChunkedMessage = maxPendingChuckedMessage;
    }

    @Deprecated
    public int getMaxPendingChuckedMessage() {
        return this.maxPendingChunkedMessage;
    }

    public void setAutoUpdatePartitionsIntervalSeconds(int interval, TimeUnit timeUnit) {
        Preconditions.checkArgument(interval > 0, "interval needs to be > 0");
        this.autoUpdatePartitionsIntervalSeconds = timeUnit.toSeconds(interval);
    }

    @JsonIgnore
    public String getSingleTopic() {
        Preconditions.checkArgument(this.topicNames.size() == 1, "topicNames needs to be = 1");
        return this.topicNames.iterator().next();
    }

    public ConsumerConfigurationData<T> clone() {
        try {
            ConsumerConfigurationData c = (ConsumerConfigurationData)super.clone();
            c.topicNames = Sets.newTreeSet(this.topicNames);
            c.properties = Maps.newTreeMap(this.properties);
            return c;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Failed to clone ConsumerConfigurationData");
        }
    }

    public Set<String> getTopicNames() {
        return this.topicNames;
    }

    public Pattern getTopicsPattern() {
        return this.topicsPattern;
    }

    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    public SubscriptionType getSubscriptionType() {
        return this.subscriptionType;
    }

    public SubscriptionMode getSubscriptionMode() {
        return this.subscriptionMode;
    }

    public MessageListener<T> getMessageListener() {
        return this.messageListener;
    }

    public ConsumerEventListener getConsumerEventListener() {
        return this.consumerEventListener;
    }

    public NegativeAckRedeliveryBackoff getNegativeAckRedeliveryBackoff() {
        return this.negativeAckRedeliveryBackoff;
    }

    public int getReceiverQueueSize() {
        return this.receiverQueueSize;
    }

    public long getAcknowledgementsGroupTimeMicros() {
        return this.acknowledgementsGroupTimeMicros;
    }

    public long getNegativeAckRedeliveryDelayMicros() {
        return this.negativeAckRedeliveryDelayMicros;
    }

    public int getMaxTotalReceiverQueueSizeAcrossPartitions() {
        return this.maxTotalReceiverQueueSizeAcrossPartitions;
    }

    public String getConsumerName() {
        return this.consumerName;
    }

    public long getAckTimeoutMillis() {
        return this.ackTimeoutMillis;
    }

    public long getTickDurationMillis() {
        return this.tickDurationMillis;
    }

    public int getPriorityLevel() {
        return this.priorityLevel;
    }

    public int getMaxPendingChunkedMessage() {
        return this.maxPendingChunkedMessage;
    }

    public boolean isAutoAckOldestChunkedMessageOnQueueFull() {
        return this.autoAckOldestChunkedMessageOnQueueFull;
    }

    public long getExpireTimeOfIncompleteChunkedMessageMillis() {
        return this.expireTimeOfIncompleteChunkedMessageMillis;
    }

    public CryptoKeyReader getCryptoKeyReader() {
        return this.cryptoKeyReader;
    }

    public MessageCrypto getMessageCrypto() {
        return this.messageCrypto;
    }

    public ConsumerCryptoFailureAction getCryptoFailureAction() {
        return this.cryptoFailureAction;
    }

    public SortedMap<String, String> getProperties() {
        return this.properties;
    }

    public boolean isReadCompacted() {
        return this.readCompacted;
    }

    public SubscriptionInitialPosition getSubscriptionInitialPosition() {
        return this.subscriptionInitialPosition;
    }

    public int getPatternAutoDiscoveryPeriod() {
        return this.patternAutoDiscoveryPeriod;
    }

    public RegexSubscriptionMode getRegexSubscriptionMode() {
        return this.regexSubscriptionMode;
    }

    public DeadLetterPolicy getDeadLetterPolicy() {
        return this.deadLetterPolicy;
    }

    public boolean isRetryEnable() {
        return this.retryEnable;
    }

    public BatchReceivePolicy getBatchReceivePolicy() {
        return this.batchReceivePolicy;
    }

    public boolean isAutoUpdatePartitions() {
        return this.autoUpdatePartitions;
    }

    public long getAutoUpdatePartitionsIntervalSeconds() {
        return this.autoUpdatePartitionsIntervalSeconds;
    }

    public boolean isReplicateSubscriptionState() {
        return this.replicateSubscriptionState;
    }

    public boolean isResetIncludeHead() {
        return this.resetIncludeHead;
    }

    public KeySharedPolicy getKeySharedPolicy() {
        return this.keySharedPolicy;
    }

    public boolean isBatchIndexAckEnabled() {
        return this.batchIndexAckEnabled;
    }

    public boolean isAckReceiptEnabled() {
        return this.ackReceiptEnabled;
    }

    public boolean isPoolMessages() {
        return this.poolMessages;
    }

    public MessagePayloadProcessor getPayloadProcessor() {
        return this.payloadProcessor;
    }

    public void setTopicNames(Set<String> topicNames) {
        this.topicNames = topicNames;
    }

    public void setTopicsPattern(Pattern topicsPattern) {
        this.topicsPattern = topicsPattern;
    }

    public void setSubscriptionName(String subscriptionName) {
        this.subscriptionName = subscriptionName;
    }

    public void setSubscriptionType(SubscriptionType subscriptionType) {
        this.subscriptionType = subscriptionType;
    }

    public void setSubscriptionMode(SubscriptionMode subscriptionMode) {
        this.subscriptionMode = subscriptionMode;
    }

    @JsonIgnore
    public void setMessageListener(MessageListener<T> messageListener) {
        this.messageListener = messageListener;
    }

    @JsonIgnore
    public void setConsumerEventListener(ConsumerEventListener consumerEventListener) {
        this.consumerEventListener = consumerEventListener;
    }

    @JsonIgnore
    public void setNegativeAckRedeliveryBackoff(NegativeAckRedeliveryBackoff negativeAckRedeliveryBackoff) {
        this.negativeAckRedeliveryBackoff = negativeAckRedeliveryBackoff;
    }

    public void setReceiverQueueSize(int receiverQueueSize) {
        this.receiverQueueSize = receiverQueueSize;
    }

    public void setAcknowledgementsGroupTimeMicros(long acknowledgementsGroupTimeMicros) {
        this.acknowledgementsGroupTimeMicros = acknowledgementsGroupTimeMicros;
    }

    public void setNegativeAckRedeliveryDelayMicros(long negativeAckRedeliveryDelayMicros) {
        this.negativeAckRedeliveryDelayMicros = negativeAckRedeliveryDelayMicros;
    }

    public void setMaxTotalReceiverQueueSizeAcrossPartitions(int maxTotalReceiverQueueSizeAcrossPartitions) {
        this.maxTotalReceiverQueueSizeAcrossPartitions = maxTotalReceiverQueueSizeAcrossPartitions;
    }

    public void setConsumerName(String consumerName) {
        this.consumerName = consumerName;
    }

    public void setAckTimeoutMillis(long ackTimeoutMillis) {
        this.ackTimeoutMillis = ackTimeoutMillis;
    }

    public void setTickDurationMillis(long tickDurationMillis) {
        this.tickDurationMillis = tickDurationMillis;
    }

    public void setPriorityLevel(int priorityLevel) {
        this.priorityLevel = priorityLevel;
    }

    public void setMaxPendingChunkedMessage(int maxPendingChunkedMessage) {
        this.maxPendingChunkedMessage = maxPendingChunkedMessage;
    }

    public void setAutoAckOldestChunkedMessageOnQueueFull(boolean autoAckOldestChunkedMessageOnQueueFull) {
        this.autoAckOldestChunkedMessageOnQueueFull = autoAckOldestChunkedMessageOnQueueFull;
    }

    public void setExpireTimeOfIncompleteChunkedMessageMillis(long expireTimeOfIncompleteChunkedMessageMillis) {
        this.expireTimeOfIncompleteChunkedMessageMillis = expireTimeOfIncompleteChunkedMessageMillis;
    }

    @JsonIgnore
    public void setCryptoKeyReader(CryptoKeyReader cryptoKeyReader) {
        this.cryptoKeyReader = cryptoKeyReader;
    }

    @JsonIgnore
    public void setMessageCrypto(MessageCrypto messageCrypto) {
        this.messageCrypto = messageCrypto;
    }

    public void setCryptoFailureAction(ConsumerCryptoFailureAction cryptoFailureAction) {
        this.cryptoFailureAction = cryptoFailureAction;
    }

    public void setProperties(SortedMap<String, String> properties) {
        this.properties = properties;
    }

    public void setReadCompacted(boolean readCompacted) {
        this.readCompacted = readCompacted;
    }

    public void setSubscriptionInitialPosition(SubscriptionInitialPosition subscriptionInitialPosition) {
        this.subscriptionInitialPosition = subscriptionInitialPosition;
    }

    public void setPatternAutoDiscoveryPeriod(int patternAutoDiscoveryPeriod) {
        this.patternAutoDiscoveryPeriod = patternAutoDiscoveryPeriod;
    }

    public void setRegexSubscriptionMode(RegexSubscriptionMode regexSubscriptionMode) {
        this.regexSubscriptionMode = regexSubscriptionMode;
    }

    public void setDeadLetterPolicy(DeadLetterPolicy deadLetterPolicy) {
        this.deadLetterPolicy = deadLetterPolicy;
    }

    public void setRetryEnable(boolean retryEnable) {
        this.retryEnable = retryEnable;
    }

    @JsonIgnore
    public void setBatchReceivePolicy(BatchReceivePolicy batchReceivePolicy) {
        this.batchReceivePolicy = batchReceivePolicy;
    }

    public void setAutoUpdatePartitions(boolean autoUpdatePartitions) {
        this.autoUpdatePartitions = autoUpdatePartitions;
    }

    public void setAutoUpdatePartitionsIntervalSeconds(long autoUpdatePartitionsIntervalSeconds) {
        this.autoUpdatePartitionsIntervalSeconds = autoUpdatePartitionsIntervalSeconds;
    }

    public void setReplicateSubscriptionState(boolean replicateSubscriptionState) {
        this.replicateSubscriptionState = replicateSubscriptionState;
    }

    public void setResetIncludeHead(boolean resetIncludeHead) {
        this.resetIncludeHead = resetIncludeHead;
    }

    public void setKeySharedPolicy(KeySharedPolicy keySharedPolicy) {
        this.keySharedPolicy = keySharedPolicy;
    }

    public void setBatchIndexAckEnabled(boolean batchIndexAckEnabled) {
        this.batchIndexAckEnabled = batchIndexAckEnabled;
    }

    public void setAckReceiptEnabled(boolean ackReceiptEnabled) {
        this.ackReceiptEnabled = ackReceiptEnabled;
    }

    public void setPoolMessages(boolean poolMessages) {
        this.poolMessages = poolMessages;
    }

    @JsonIgnore
    public void setPayloadProcessor(MessagePayloadProcessor payloadProcessor) {
        this.payloadProcessor = payloadProcessor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConsumerConfigurationData)) {
            return false;
        }
        ConsumerConfigurationData other = (ConsumerConfigurationData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getReceiverQueueSize() != other.getReceiverQueueSize()) {
            return false;
        }
        if (this.getAcknowledgementsGroupTimeMicros() != other.getAcknowledgementsGroupTimeMicros()) {
            return false;
        }
        if (this.getNegativeAckRedeliveryDelayMicros() != other.getNegativeAckRedeliveryDelayMicros()) {
            return false;
        }
        if (this.getMaxTotalReceiverQueueSizeAcrossPartitions() != other.getMaxTotalReceiverQueueSizeAcrossPartitions()) {
            return false;
        }
        if (this.getAckTimeoutMillis() != other.getAckTimeoutMillis()) {
            return false;
        }
        if (this.getTickDurationMillis() != other.getTickDurationMillis()) {
            return false;
        }
        if (this.getPriorityLevel() != other.getPriorityLevel()) {
            return false;
        }
        if (this.getMaxPendingChunkedMessage() != other.getMaxPendingChunkedMessage()) {
            return false;
        }
        if (this.isAutoAckOldestChunkedMessageOnQueueFull() != other.isAutoAckOldestChunkedMessageOnQueueFull()) {
            return false;
        }
        if (this.getExpireTimeOfIncompleteChunkedMessageMillis() != other.getExpireTimeOfIncompleteChunkedMessageMillis()) {
            return false;
        }
        if (this.isReadCompacted() != other.isReadCompacted()) {
            return false;
        }
        if (this.getPatternAutoDiscoveryPeriod() != other.getPatternAutoDiscoveryPeriod()) {
            return false;
        }
        if (this.isRetryEnable() != other.isRetryEnable()) {
            return false;
        }
        if (this.isAutoUpdatePartitions() != other.isAutoUpdatePartitions()) {
            return false;
        }
        if (this.getAutoUpdatePartitionsIntervalSeconds() != other.getAutoUpdatePartitionsIntervalSeconds()) {
            return false;
        }
        if (this.isReplicateSubscriptionState() != other.isReplicateSubscriptionState()) {
            return false;
        }
        if (this.isResetIncludeHead() != other.isResetIncludeHead()) {
            return false;
        }
        if (this.isBatchIndexAckEnabled() != other.isBatchIndexAckEnabled()) {
            return false;
        }
        if (this.isAckReceiptEnabled() != other.isAckReceiptEnabled()) {
            return false;
        }
        if (this.isPoolMessages() != other.isPoolMessages()) {
            return false;
        }
        Set<String> this$topicNames = this.getTopicNames();
        Set<String> other$topicNames = other.getTopicNames();
        if (this$topicNames == null ? other$topicNames != null : !((Object)this$topicNames).equals(other$topicNames)) {
            return false;
        }
        Pattern this$topicsPattern = this.getTopicsPattern();
        Pattern other$topicsPattern = other.getTopicsPattern();
        if (this$topicsPattern == null ? other$topicsPattern != null : !this$topicsPattern.equals(other$topicsPattern)) {
            return false;
        }
        String this$subscriptionName = this.getSubscriptionName();
        String other$subscriptionName = other.getSubscriptionName();
        if (this$subscriptionName == null ? other$subscriptionName != null : !this$subscriptionName.equals(other$subscriptionName)) {
            return false;
        }
        SubscriptionType this$subscriptionType = this.getSubscriptionType();
        SubscriptionType other$subscriptionType = other.getSubscriptionType();
        if (this$subscriptionType == null ? other$subscriptionType != null : !this$subscriptionType.equals(other$subscriptionType)) {
            return false;
        }
        SubscriptionMode this$subscriptionMode = this.getSubscriptionMode();
        SubscriptionMode other$subscriptionMode = other.getSubscriptionMode();
        if (this$subscriptionMode == null ? other$subscriptionMode != null : !this$subscriptionMode.equals(other$subscriptionMode)) {
            return false;
        }
        MessageListener<T> this$messageListener = this.getMessageListener();
        MessageListener<T> other$messageListener = other.getMessageListener();
        if (this$messageListener == null ? other$messageListener != null : !this$messageListener.equals(other$messageListener)) {
            return false;
        }
        ConsumerEventListener this$consumerEventListener = this.getConsumerEventListener();
        ConsumerEventListener other$consumerEventListener = other.getConsumerEventListener();
        if (this$consumerEventListener == null ? other$consumerEventListener != null : !this$consumerEventListener.equals(other$consumerEventListener)) {
            return false;
        }
        NegativeAckRedeliveryBackoff this$negativeAckRedeliveryBackoff = this.getNegativeAckRedeliveryBackoff();
        NegativeAckRedeliveryBackoff other$negativeAckRedeliveryBackoff = other.getNegativeAckRedeliveryBackoff();
        if (this$negativeAckRedeliveryBackoff == null ? other$negativeAckRedeliveryBackoff != null : !this$negativeAckRedeliveryBackoff.equals(other$negativeAckRedeliveryBackoff)) {
            return false;
        }
        String this$consumerName = this.getConsumerName();
        String other$consumerName = other.getConsumerName();
        if (this$consumerName == null ? other$consumerName != null : !this$consumerName.equals(other$consumerName)) {
            return false;
        }
        CryptoKeyReader this$cryptoKeyReader = this.getCryptoKeyReader();
        CryptoKeyReader other$cryptoKeyReader = other.getCryptoKeyReader();
        if (this$cryptoKeyReader == null ? other$cryptoKeyReader != null : !this$cryptoKeyReader.equals(other$cryptoKeyReader)) {
            return false;
        }
        ConsumerCryptoFailureAction this$cryptoFailureAction = this.getCryptoFailureAction();
        ConsumerCryptoFailureAction other$cryptoFailureAction = other.getCryptoFailureAction();
        if (this$cryptoFailureAction == null ? other$cryptoFailureAction != null : !this$cryptoFailureAction.equals(other$cryptoFailureAction)) {
            return false;
        }
        SortedMap<String, String> this$properties = this.getProperties();
        SortedMap<String, String> other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !this$properties.equals(other$properties)) {
            return false;
        }
        SubscriptionInitialPosition this$subscriptionInitialPosition = this.getSubscriptionInitialPosition();
        SubscriptionInitialPosition other$subscriptionInitialPosition = other.getSubscriptionInitialPosition();
        if (this$subscriptionInitialPosition == null ? other$subscriptionInitialPosition != null : !this$subscriptionInitialPosition.equals(other$subscriptionInitialPosition)) {
            return false;
        }
        RegexSubscriptionMode this$regexSubscriptionMode = this.getRegexSubscriptionMode();
        RegexSubscriptionMode other$regexSubscriptionMode = other.getRegexSubscriptionMode();
        if (this$regexSubscriptionMode == null ? other$regexSubscriptionMode != null : !this$regexSubscriptionMode.equals(other$regexSubscriptionMode)) {
            return false;
        }
        BatchReceivePolicy this$batchReceivePolicy = this.getBatchReceivePolicy();
        BatchReceivePolicy other$batchReceivePolicy = other.getBatchReceivePolicy();
        return !(this$batchReceivePolicy == null ? other$batchReceivePolicy != null : !this$batchReceivePolicy.equals(other$batchReceivePolicy));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConsumerConfigurationData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getReceiverQueueSize();
        long $acknowledgementsGroupTimeMicros = this.getAcknowledgementsGroupTimeMicros();
        result = result * 59 + (int)($acknowledgementsGroupTimeMicros >>> 32 ^ $acknowledgementsGroupTimeMicros);
        long $negativeAckRedeliveryDelayMicros = this.getNegativeAckRedeliveryDelayMicros();
        result = result * 59 + (int)($negativeAckRedeliveryDelayMicros >>> 32 ^ $negativeAckRedeliveryDelayMicros);
        result = result * 59 + this.getMaxTotalReceiverQueueSizeAcrossPartitions();
        long $ackTimeoutMillis = this.getAckTimeoutMillis();
        result = result * 59 + (int)($ackTimeoutMillis >>> 32 ^ $ackTimeoutMillis);
        long $tickDurationMillis = this.getTickDurationMillis();
        result = result * 59 + (int)($tickDurationMillis >>> 32 ^ $tickDurationMillis);
        result = result * 59 + this.getPriorityLevel();
        result = result * 59 + this.getMaxPendingChunkedMessage();
        result = result * 59 + (this.isAutoAckOldestChunkedMessageOnQueueFull() ? 79 : 97);
        long $expireTimeOfIncompleteChunkedMessageMillis = this.getExpireTimeOfIncompleteChunkedMessageMillis();
        result = result * 59 + (int)($expireTimeOfIncompleteChunkedMessageMillis >>> 32 ^ $expireTimeOfIncompleteChunkedMessageMillis);
        result = result * 59 + (this.isReadCompacted() ? 79 : 97);
        result = result * 59 + this.getPatternAutoDiscoveryPeriod();
        result = result * 59 + (this.isRetryEnable() ? 79 : 97);
        result = result * 59 + (this.isAutoUpdatePartitions() ? 79 : 97);
        long $autoUpdatePartitionsIntervalSeconds = this.getAutoUpdatePartitionsIntervalSeconds();
        result = result * 59 + (int)($autoUpdatePartitionsIntervalSeconds >>> 32 ^ $autoUpdatePartitionsIntervalSeconds);
        result = result * 59 + (this.isReplicateSubscriptionState() ? 79 : 97);
        result = result * 59 + (this.isResetIncludeHead() ? 79 : 97);
        result = result * 59 + (this.isBatchIndexAckEnabled() ? 79 : 97);
        result = result * 59 + (this.isAckReceiptEnabled() ? 79 : 97);
        result = result * 59 + (this.isPoolMessages() ? 79 : 97);
        Set<String> $topicNames = this.getTopicNames();
        result = result * 59 + ($topicNames == null ? 43 : ((Object)$topicNames).hashCode());
        Pattern $topicsPattern = this.getTopicsPattern();
        result = result * 59 + ($topicsPattern == null ? 43 : $topicsPattern.hashCode());
        String $subscriptionName = this.getSubscriptionName();
        result = result * 59 + ($subscriptionName == null ? 43 : $subscriptionName.hashCode());
        SubscriptionType $subscriptionType = this.getSubscriptionType();
        result = result * 59 + ($subscriptionType == null ? 43 : $subscriptionType.hashCode());
        SubscriptionMode $subscriptionMode = this.getSubscriptionMode();
        result = result * 59 + ($subscriptionMode == null ? 43 : $subscriptionMode.hashCode());
        MessageListener<T> $messageListener = this.getMessageListener();
        result = result * 59 + ($messageListener == null ? 43 : $messageListener.hashCode());
        ConsumerEventListener $consumerEventListener = this.getConsumerEventListener();
        result = result * 59 + ($consumerEventListener == null ? 43 : $consumerEventListener.hashCode());
        NegativeAckRedeliveryBackoff $negativeAckRedeliveryBackoff = this.getNegativeAckRedeliveryBackoff();
        result = result * 59 + ($negativeAckRedeliveryBackoff == null ? 43 : $negativeAckRedeliveryBackoff.hashCode());
        String $consumerName = this.getConsumerName();
        result = result * 59 + ($consumerName == null ? 43 : $consumerName.hashCode());
        CryptoKeyReader $cryptoKeyReader = this.getCryptoKeyReader();
        result = result * 59 + ($cryptoKeyReader == null ? 43 : $cryptoKeyReader.hashCode());
        ConsumerCryptoFailureAction $cryptoFailureAction = this.getCryptoFailureAction();
        result = result * 59 + ($cryptoFailureAction == null ? 43 : $cryptoFailureAction.hashCode());
        SortedMap<String, String> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : $properties.hashCode());
        SubscriptionInitialPosition $subscriptionInitialPosition = this.getSubscriptionInitialPosition();
        result = result * 59 + ($subscriptionInitialPosition == null ? 43 : $subscriptionInitialPosition.hashCode());
        RegexSubscriptionMode $regexSubscriptionMode = this.getRegexSubscriptionMode();
        result = result * 59 + ($regexSubscriptionMode == null ? 43 : $regexSubscriptionMode.hashCode());
        BatchReceivePolicy $batchReceivePolicy = this.getBatchReceivePolicy();
        result = result * 59 + ($batchReceivePolicy == null ? 43 : $batchReceivePolicy.hashCode());
        return result;
    }

    public String toString() {
        return "ConsumerConfigurationData(topicNames=" + this.getTopicNames() + ", topicsPattern=" + this.getTopicsPattern() + ", subscriptionName=" + this.getSubscriptionName() + ", subscriptionType=" + this.getSubscriptionType() + ", subscriptionMode=" + this.getSubscriptionMode() + ", messageListener=" + this.getMessageListener() + ", consumerEventListener=" + this.getConsumerEventListener() + ", negativeAckRedeliveryBackoff=" + this.getNegativeAckRedeliveryBackoff() + ", receiverQueueSize=" + this.getReceiverQueueSize() + ", acknowledgementsGroupTimeMicros=" + this.getAcknowledgementsGroupTimeMicros() + ", negativeAckRedeliveryDelayMicros=" + this.getNegativeAckRedeliveryDelayMicros() + ", maxTotalReceiverQueueSizeAcrossPartitions=" + this.getMaxTotalReceiverQueueSizeAcrossPartitions() + ", consumerName=" + this.getConsumerName() + ", ackTimeoutMillis=" + this.getAckTimeoutMillis() + ", tickDurationMillis=" + this.getTickDurationMillis() + ", priorityLevel=" + this.getPriorityLevel() + ", maxPendingChunkedMessage=" + this.getMaxPendingChunkedMessage() + ", autoAckOldestChunkedMessageOnQueueFull=" + this.isAutoAckOldestChunkedMessageOnQueueFull() + ", expireTimeOfIncompleteChunkedMessageMillis=" + this.getExpireTimeOfIncompleteChunkedMessageMillis() + ", cryptoKeyReader=" + this.getCryptoKeyReader() + ", messageCrypto=" + this.getMessageCrypto() + ", cryptoFailureAction=" + this.getCryptoFailureAction() + ", properties=" + this.getProperties() + ", readCompacted=" + this.isReadCompacted() + ", subscriptionInitialPosition=" + this.getSubscriptionInitialPosition() + ", patternAutoDiscoveryPeriod=" + this.getPatternAutoDiscoveryPeriod() + ", regexSubscriptionMode=" + this.getRegexSubscriptionMode() + ", deadLetterPolicy=" + this.getDeadLetterPolicy() + ", retryEnable=" + this.isRetryEnable() + ", batchReceivePolicy=" + this.getBatchReceivePolicy() + ", autoUpdatePartitions=" + this.isAutoUpdatePartitions() + ", autoUpdatePartitionsIntervalSeconds=" + this.getAutoUpdatePartitionsIntervalSeconds() + ", replicateSubscriptionState=" + this.isReplicateSubscriptionState() + ", resetIncludeHead=" + this.isResetIncludeHead() + ", keySharedPolicy=" + this.getKeySharedPolicy() + ", batchIndexAckEnabled=" + this.isBatchIndexAckEnabled() + ", ackReceiptEnabled=" + this.isAckReceiptEnabled() + ", poolMessages=" + this.isPoolMessages() + ", payloadProcessor=" + this.getPayloadProcessor() + ")";
    }

    public ConsumerConfigurationData() {
    }

    public ConsumerConfigurationData(Set<String> topicNames, Pattern topicsPattern, String subscriptionName, SubscriptionType subscriptionType, SubscriptionMode subscriptionMode, MessageListener<T> messageListener, ConsumerEventListener consumerEventListener, NegativeAckRedeliveryBackoff negativeAckRedeliveryBackoff, int receiverQueueSize, long acknowledgementsGroupTimeMicros, long negativeAckRedeliveryDelayMicros, int maxTotalReceiverQueueSizeAcrossPartitions, String consumerName, long ackTimeoutMillis, long tickDurationMillis, int priorityLevel, int maxPendingChunkedMessage, boolean autoAckOldestChunkedMessageOnQueueFull, long expireTimeOfIncompleteChunkedMessageMillis, CryptoKeyReader cryptoKeyReader, MessageCrypto messageCrypto, ConsumerCryptoFailureAction cryptoFailureAction, SortedMap<String, String> properties, boolean readCompacted, SubscriptionInitialPosition subscriptionInitialPosition, int patternAutoDiscoveryPeriod, RegexSubscriptionMode regexSubscriptionMode, DeadLetterPolicy deadLetterPolicy, boolean retryEnable, BatchReceivePolicy batchReceivePolicy, boolean autoUpdatePartitions, long autoUpdatePartitionsIntervalSeconds, boolean replicateSubscriptionState, boolean resetIncludeHead, KeySharedPolicy keySharedPolicy, boolean batchIndexAckEnabled, boolean ackReceiptEnabled, boolean poolMessages, MessagePayloadProcessor payloadProcessor) {
        this.topicNames = topicNames;
        this.topicsPattern = topicsPattern;
        this.subscriptionName = subscriptionName;
        this.subscriptionType = subscriptionType;
        this.subscriptionMode = subscriptionMode;
        this.messageListener = messageListener;
        this.consumerEventListener = consumerEventListener;
        this.negativeAckRedeliveryBackoff = negativeAckRedeliveryBackoff;
        this.receiverQueueSize = receiverQueueSize;
        this.acknowledgementsGroupTimeMicros = acknowledgementsGroupTimeMicros;
        this.negativeAckRedeliveryDelayMicros = negativeAckRedeliveryDelayMicros;
        this.maxTotalReceiverQueueSizeAcrossPartitions = maxTotalReceiverQueueSizeAcrossPartitions;
        this.consumerName = consumerName;
        this.ackTimeoutMillis = ackTimeoutMillis;
        this.tickDurationMillis = tickDurationMillis;
        this.priorityLevel = priorityLevel;
        this.maxPendingChunkedMessage = maxPendingChunkedMessage;
        this.autoAckOldestChunkedMessageOnQueueFull = autoAckOldestChunkedMessageOnQueueFull;
        this.expireTimeOfIncompleteChunkedMessageMillis = expireTimeOfIncompleteChunkedMessageMillis;
        this.cryptoKeyReader = cryptoKeyReader;
        this.messageCrypto = messageCrypto;
        this.cryptoFailureAction = cryptoFailureAction;
        this.properties = properties;
        this.readCompacted = readCompacted;
        this.subscriptionInitialPosition = subscriptionInitialPosition;
        this.patternAutoDiscoveryPeriod = patternAutoDiscoveryPeriod;
        this.regexSubscriptionMode = regexSubscriptionMode;
        this.deadLetterPolicy = deadLetterPolicy;
        this.retryEnable = retryEnable;
        this.batchReceivePolicy = batchReceivePolicy;
        this.autoUpdatePartitions = autoUpdatePartitions;
        this.autoUpdatePartitionsIntervalSeconds = autoUpdatePartitionsIntervalSeconds;
        this.replicateSubscriptionState = replicateSubscriptionState;
        this.resetIncludeHead = resetIncludeHead;
        this.keySharedPolicy = keySharedPolicy;
        this.batchIndexAckEnabled = batchIndexAckEnabled;
        this.ackReceiptEnabled = ackReceiptEnabled;
        this.poolMessages = poolMessages;
        this.payloadProcessor = payloadProcessor;
    }
}

