/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.admin.cli;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import java.io.FileInputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.PulsarVersion;
import org.apache.pulsar.admin.cli.CmdBase;
import org.apache.pulsar.admin.cli.CmdBookies;
import org.apache.pulsar.admin.cli.CmdBrokerStats;
import org.apache.pulsar.admin.cli.CmdBrokers;
import org.apache.pulsar.admin.cli.CmdClusters;
import org.apache.pulsar.admin.cli.CmdFunctionWorker;
import org.apache.pulsar.admin.cli.CmdFunctions;
import org.apache.pulsar.admin.cli.CmdGenerateDocument;
import org.apache.pulsar.admin.cli.CmdNamespaceIsolationPolicy;
import org.apache.pulsar.admin.cli.CmdNamespaces;
import org.apache.pulsar.admin.cli.CmdNonPersistentTopics;
import org.apache.pulsar.admin.cli.CmdPackages;
import org.apache.pulsar.admin.cli.CmdPersistentTopics;
import org.apache.pulsar.admin.cli.CmdProxyStats;
import org.apache.pulsar.admin.cli.CmdResourceGroups;
import org.apache.pulsar.admin.cli.CmdResourceQuotas;
import org.apache.pulsar.admin.cli.CmdSchemas;
import org.apache.pulsar.admin.cli.CmdSinks;
import org.apache.pulsar.admin.cli.CmdSources;
import org.apache.pulsar.admin.cli.CmdTenants;
import org.apache.pulsar.admin.cli.CmdTopics;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminBuilder;

public class PulsarAdminTool {
    private static boolean allowSystemExit = true;
    private static int lastExitCode = Integer.MIN_VALUE;
    protected final Map<String, Class<?>> commandMap;
    private final JCommander jcommander;
    protected final PulsarAdminBuilder adminBuilder;
    @Parameter(names={"--admin-url"}, description="Admin Service URL to which to connect.")
    String serviceUrl = null;
    @Parameter(names={"--auth-plugin"}, description="Authentication plugin class name.")
    String authPluginClassName = null;
    @Parameter(names={"--request-timeout"}, description="Request time out in seconds for the pulsar admin client for any request")
    int requestTimeout = 300;
    @Parameter(names={"--auth-params"}, description="Authentication parameters, whose format is determined by the implementation of method `configure` in authentication plugin class, for example \"key1:val1,key2:val2\" or \"{\"key1\":\"val1\",\"key2\":\"val2\"}.")
    String authParams = null;
    @Parameter(names={"--tls-allow-insecure"}, description="Allow TLS insecure connection")
    Boolean tlsAllowInsecureConnection;
    @Parameter(names={"--tls-trust-cert-path"}, description="Allow TLS trust cert file path")
    String tlsTrustCertsFilePath;
    @Parameter(names={"--tls-enable-hostname-verification"}, description="Enable TLS common name verification")
    Boolean tlsEnableHostnameVerification;
    @Parameter(names={"-v", "--version"}, description="Get version of pulsar admin client")
    boolean version;
    @Parameter(names={"-h", "--help"}, help=true, description="Show this help.")
    boolean help;
    boolean useKeyStoreTls = false;
    String tlsTrustStoreType = "JKS";
    String tlsTrustStorePath = null;
    String tlsTrustStorePassword = null;

    PulsarAdminTool(Properties properties) throws Exception {
        this.serviceUrl = StringUtils.isNotBlank((CharSequence)properties.getProperty("webServiceUrl")) ? properties.getProperty("webServiceUrl") : properties.getProperty("serviceUrl");
        this.authPluginClassName = properties.getProperty("authPlugin");
        this.authParams = properties.getProperty("authParams");
        boolean tlsAllowInsecureConnection = this.tlsAllowInsecureConnection != null ? this.tlsAllowInsecureConnection : Boolean.parseBoolean(properties.getProperty("tlsAllowInsecureConnection", "false"));
        boolean tlsEnableHostnameVerification = this.tlsEnableHostnameVerification != null ? this.tlsEnableHostnameVerification : Boolean.parseBoolean(properties.getProperty("tlsEnableHostnameVerification", "false"));
        String tlsTrustCertsFilePath = StringUtils.isNotBlank((CharSequence)this.tlsTrustCertsFilePath) ? this.tlsTrustCertsFilePath : properties.getProperty("tlsTrustCertsFilePath");
        this.useKeyStoreTls = Boolean.parseBoolean(properties.getProperty("useKeyStoreTls", "false"));
        this.tlsTrustStoreType = properties.getProperty("tlsTrustStoreType", "JKS");
        this.tlsTrustStorePath = properties.getProperty("tlsTrustStorePath");
        this.tlsTrustStorePassword = properties.getProperty("tlsTrustStorePassword");
        this.adminBuilder = PulsarAdmin.builder().allowTlsInsecureConnection(tlsAllowInsecureConnection).enableTlsHostnameVerification(tlsEnableHostnameVerification).tlsTrustCertsFilePath(tlsTrustCertsFilePath).useKeyStoreTls(this.useKeyStoreTls).tlsTrustStoreType(this.tlsTrustStoreType).tlsTrustStorePath(this.tlsTrustStorePath).tlsTrustStorePassword(this.tlsTrustStorePassword);
        this.jcommander = new JCommander();
        this.jcommander.setProgramName("pulsar-admin");
        this.jcommander.addObject((Object)this);
        this.commandMap = new HashMap();
        this.commandMap.put("clusters", CmdClusters.class);
        this.commandMap.put("ns-isolation-policy", CmdNamespaceIsolationPolicy.class);
        this.commandMap.put("brokers", CmdBrokers.class);
        this.commandMap.put("broker-stats", CmdBrokerStats.class);
        this.commandMap.put("tenants", CmdTenants.class);
        this.commandMap.put("resourcegroups", CmdResourceGroups.class);
        this.commandMap.put("properties", CmdTenants.CmdProperties.class);
        this.commandMap.put("namespaces", CmdNamespaces.class);
        this.commandMap.put("topics", CmdTopics.class);
        this.commandMap.put("schemas", CmdSchemas.class);
        this.commandMap.put("bookies", CmdBookies.class);
        this.commandMap.put("persistent", CmdPersistentTopics.class);
        this.commandMap.put("non-persistent", CmdNonPersistentTopics.class);
        this.commandMap.put("resource-quotas", CmdResourceQuotas.class);
        this.commandMap.put("proxy-stats", CmdProxyStats.class);
        this.commandMap.put("functions", CmdFunctions.class);
        this.commandMap.put("functions-worker", CmdFunctionWorker.class);
        this.commandMap.put("sources", CmdSources.class);
        this.commandMap.put("sinks", CmdSinks.class);
        this.commandMap.put("documents", CmdGenerateDocument.class);
        this.commandMap.put("source", CmdSources.class);
        this.commandMap.put("sink", CmdSinks.class);
        this.commandMap.put("packages", CmdPackages.class);
    }

    private void setupCommands(Function<PulsarAdminBuilder, ? extends PulsarAdmin> adminFactory) {
        try {
            this.adminBuilder.serviceHttpUrl(this.serviceUrl);
            this.adminBuilder.authentication(this.authPluginClassName, this.authParams);
            this.adminBuilder.requestTimeout(this.requestTimeout, TimeUnit.SECONDS);
            PulsarAdminSupplier admin = new PulsarAdminSupplier(this.adminBuilder, adminFactory);
            for (Map.Entry<String, Class<?>> c : this.commandMap.entrySet()) {
                this.addCommand(c, admin);
            }
        }
        catch (Exception e) {
            Throwable cause = e instanceof InvocationTargetException && null != e.getCause() ? e.getCause() : e;
            System.err.println(cause.getClass() + ": " + cause.getMessage());
            System.exit(1);
        }
    }

    private void addCommand(Map.Entry<String, Class<?>> c, Supplier<PulsarAdmin> admin) throws Exception {
        if (c.getKey().equals("sources") || c.getKey().equals("source")) {
            this.jcommander.addCommand("sources", c.getValue().getConstructor(Supplier.class).newInstance(admin), new String[]{"source"});
        } else if (c.getKey().equals("sinks") || c.getKey().equals("sink")) {
            this.jcommander.addCommand("sinks", c.getValue().getConstructor(Supplier.class).newInstance(admin), new String[]{"sink"});
        } else if (c.getKey().equals("functions")) {
            this.jcommander.addCommand(c.getKey(), c.getValue().getConstructor(Supplier.class).newInstance(admin));
        } else {
            this.jcommander.addCommand(c.getKey(), c.getValue().getConstructor(Supplier.class).newInstance(admin));
        }
    }

    boolean run(String[] args) {
        return this.run(args, adminBuilder -> {
            try {
                return adminBuilder.build();
            }
            catch (Exception ex) {
                System.err.println(ex.getClass() + ": " + ex.getMessage());
                System.exit(1);
                return null;
            }
        });
    }

    boolean run(String[] args, Function<PulsarAdminBuilder, ? extends PulsarAdmin> adminFactory) {
        int cmdPos;
        if (args.length == 0) {
            this.setupCommands(adminFactory);
            this.jcommander.usage();
            return false;
        }
        for (cmdPos = 0; cmdPos < args.length && !this.commandMap.containsKey(args[cmdPos]); ++cmdPos) {
        }
        try {
            this.jcommander.parse(Arrays.copyOfRange(args, 0, Math.min(cmdPos, args.length)));
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.err.println();
            this.setupCommands(adminFactory);
            this.jcommander.usage();
            return false;
        }
        if (this.version) {
            System.out.println("Current version of pulsar admin client is: " + PulsarVersion.getVersion());
            return true;
        }
        if (this.help) {
            this.setupCommands(adminFactory);
            this.jcommander.usage();
            return true;
        }
        if (cmdPos == args.length) {
            this.setupCommands(adminFactory);
            this.jcommander.usage();
            return false;
        }
        this.setupCommands(adminFactory);
        String cmd = args[cmdPos];
        if (cmd.equals("source")) {
            cmd = "sources";
        } else if (cmd.equals("sink")) {
            cmd = "sinks";
        }
        JCommander obj = (JCommander)this.jcommander.getCommands().get(cmd);
        CmdBase cmdObj = (CmdBase)obj.getObjects().get(0);
        return cmdObj.run(Arrays.copyOfRange(args, cmdPos + 1, args.length));
    }

    public static void main(String[] args) throws Exception {
        int cmdPos;
        lastExitCode = 0;
        String configFile = null;
        if (args.length > 0) {
            configFile = args[0];
            args = Arrays.copyOfRange(args, 1, args.length);
        }
        Properties properties = new Properties();
        if (configFile != null) {
            try (FileInputStream fis = new FileInputStream(configFile);){
                properties.load(fis);
            }
        }
        PulsarAdminTool tool = new PulsarAdminTool(properties);
        for (cmdPos = 0; cmdPos < args.length && !tool.commandMap.containsKey(args[cmdPos]); ++cmdPos) {
        }
        boolean isLocalRun = ++cmdPos < args.length && "localrun".equals(args[cmdPos].toLowerCase());
        Function<PulsarAdminBuilder, PulsarAdmin> adminFactory = isLocalRun ? adminBuilder -> null : adminBuilder -> {
            try {
                return adminBuilder.build();
            }
            catch (Exception ex) {
                System.err.println(ex.getClass() + ": " + ex.getMessage());
                PulsarAdminTool.exit(1);
                return null;
            }
        };
        if (tool.run(args, adminFactory)) {
            PulsarAdminTool.exit(0);
        } else {
            PulsarAdminTool.exit(1);
        }
    }

    private static void exit(int code) {
        if (allowSystemExit) {
            Runtime.getRuntime().halt(code);
        } else {
            System.out.println("Exit code is " + code + " (System.exit not called, as we are in test mode)");
        }
    }

    static void setAllowSystemExit(boolean allowSystemExit) {
        PulsarAdminTool.allowSystemExit = allowSystemExit;
    }

    static int getLastExitCode() {
        return lastExitCode;
    }

    private static class PulsarAdminSupplier
    implements Supplier<PulsarAdmin> {
        private final PulsarAdminBuilder pulsarAdminBuilder;
        private final Function<PulsarAdminBuilder, ? extends PulsarAdmin> adminFactory;
        private PulsarAdmin admin;

        private PulsarAdminSupplier(PulsarAdminBuilder pulsarAdminBuilder, Function<PulsarAdminBuilder, ? extends PulsarAdmin> adminFactory) {
            this.pulsarAdminBuilder = pulsarAdminBuilder;
            this.adminFactory = adminFactory;
        }

        @Override
        public PulsarAdmin get() {
            if (this.admin == null) {
                this.admin = this.adminFactory.apply(this.pulsarAdminBuilder);
            }
            return this.admin;
        }
    }
}

