/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.cli;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterDescription;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.StringKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.cli.PulsarClientTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Parameters(commandDescription="Generate documentation automatically.")
public class CmdGenerateDocumentation {
    private static final Logger log = LoggerFactory.getLogger(CmdGenerateDocumentation.class);
    @Parameter(names={"-n", "--command-names"}, description="List of command names")
    private List<String> commandNames = new ArrayList<String>();

    public int run() throws PulsarClientException {
        PulsarClientTool pulsarClientTool = new PulsarClientTool(new Properties());
        JCommander commander = pulsarClientTool.commandParser;
        if (this.commandNames.size() == 0) {
            for (Map.Entry cmd : commander.getCommands().entrySet()) {
                this.generateDocument((String)cmd.getKey(), commander);
            }
        } else {
            for (String commandName : this.commandNames) {
                this.generateDocument(commandName, commander);
            }
        }
        return 0;
    }

    protected String generateDocument(String module, JCommander parentCmd) {
        StringBuilder sb = new StringBuilder();
        JCommander cmd = (JCommander)parentCmd.getCommands().get(module);
        sb.append("------------\n\n");
        sb.append("# ").append(module).append("\n\n");
        sb.append("### Usage\n\n");
        sb.append("`$").append(module).append("`\n\n");
        sb.append("------------\n\n");
        sb.append(parentCmd.getUsageFormatter().getCommandDescription(module)).append("\n");
        sb.append("\n\n```bdocs-tab:example_shell\n").append("$ pulsar-client ").append(module).append(" [options]").append("\n```");
        sb.append("\n\n");
        for (String s : cmd.getCommands().keySet()) {
            sb.append("* `").append(s).append("`\n");
        }
        sb.append("|Flag|Description|Default|\n");
        sb.append("|---|---|---|\n");
        Map descriptionMap = cmd.getDescriptions();
        descriptionMap.forEach((k, v) -> {
            StringKey key = (StringKey)k;
            ParameterDescription description = (ParameterDescription)v;
            sb.append("| `").append(key.getName()).append("` | ").append(description.getDescription().replace("\n", " ")).append("|").append(description.getDefault()).append("|\n");
        });
        System.out.println(sb.toString());
        return sb.toString();
    }

    public List<String> getCommandNames() {
        return this.commandNames;
    }
}

