/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.admin.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.function.Supplier;
import org.apache.pulsar.admin.cli.CliCommand;
import org.apache.pulsar.admin.cli.CmdBase;
import org.apache.pulsar.client.admin.PulsarAdmin;

@Parameters(commandDescription="Operations to collect Proxy statistics")
public class CmdProxyStats
extends CmdBase {
    public void printStats(JsonElement json, boolean indent) throws IOException {
        GsonBuilder builder = new GsonBuilder();
        Gson gson = indent ? builder.setPrettyPrinting().create() : builder.create();
        System.out.println(gson.toJson(json));
    }

    public CmdProxyStats(Supplier<PulsarAdmin> admin) {
        super("proxy-stats", admin);
        this.jcommander.addCommand("connections", (Object)new CmdConnectionMetrics());
        this.jcommander.addCommand("topics", (Object)new CmdTopicsMetrics());
    }

    @Parameters(commandDescription="dump topics metrics for Monitoring")
    private class CmdTopicsMetrics
    extends CliCommand {
        @Parameter(names={"-i", "--indent"}, description="Indent JSON output", required=false)
        private boolean indent = false;

        private CmdTopicsMetrics() {
        }

        @Override
        void run() throws Exception {
            JsonObject stats = CmdProxyStats.this.getAdmin().proxyStats().getTopics();
            CmdProxyStats.this.printStats((JsonElement)stats, this.indent);
        }
    }

    @Parameters(commandDescription="dump connections metrics for Monitoring")
    private class CmdConnectionMetrics
    extends CliCommand {
        @Parameter(names={"-i", "--indent"}, description="Indent JSON output", required=false)
        private boolean indent = false;

        private CmdConnectionMetrics() {
        }

        @Override
        void run() throws Exception {
            JsonArray stats = CmdProxyStats.this.getAdmin().proxyStats().getConnections();
            CmdProxyStats.this.printStats((JsonElement)stats, this.indent);
        }
    }
}

