/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.admin.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.converters.CommaParameterSplitter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.pulsar.admin.cli.CliCommand;
import org.apache.pulsar.admin.cli.CmdBase;
import org.apache.pulsar.admin.cli.utils.NameValueParameterSplitter;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.common.policies.data.AutoFailoverPolicyData;
import org.apache.pulsar.common.policies.data.AutoFailoverPolicyType;
import org.apache.pulsar.common.policies.data.BrokerNamespaceIsolationData;
import org.apache.pulsar.common.policies.data.NamespaceIsolationData;

@Parameters(commandDescription="Operations about namespace isolation policy")
public class CmdNamespaceIsolationPolicy
extends CmdBase {
    private List<String> validateList(List<String> list) {
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).isEmpty()) continue;
            list.remove(i);
        }
        return list;
    }

    private NamespaceIsolationData createNamespaceIsolationData(List<String> namespaces, List<String> primary, List<String> secondary, String autoFailoverPolicyTypeName, Map<String, String> autoFailoverPolicyParams) {
        if ((namespaces = this.validateList(namespaces)).isEmpty()) {
            throw new ParameterException("unable to parse namespaces parameter list: " + namespaces);
        }
        if ((primary = this.validateList(primary)).isEmpty()) {
            throw new ParameterException("unable to parse primary parameter list: " + namespaces);
        }
        secondary = this.validateList(secondary);
        NamespaceIsolationData nsIsolationData = new NamespaceIsolationData();
        if (namespaces != null) {
            nsIsolationData.namespaces = namespaces;
        }
        if (primary != null) {
            nsIsolationData.primary = primary;
        }
        if (secondary != null) {
            nsIsolationData.secondary = secondary;
        }
        nsIsolationData.auto_failover_policy = new AutoFailoverPolicyData();
        nsIsolationData.auto_failover_policy.policy_type = AutoFailoverPolicyType.fromString((String)autoFailoverPolicyTypeName);
        nsIsolationData.auto_failover_policy.parameters = autoFailoverPolicyParams;
        if (nsIsolationData.auto_failover_policy.policy_type == AutoFailoverPolicyType.min_available) {
            boolean error = true;
            String[] expectParamKeys = new String[]{"min_limit", "usage_threshold"};
            if (autoFailoverPolicyParams.size() == expectParamKeys.length) {
                for (String paramKey : expectParamKeys) {
                    if (!autoFailoverPolicyParams.containsKey(paramKey)) break;
                }
                error = false;
            }
            if (error) {
                throw new ParameterException("Unknown auto failover policy params specified : " + autoFailoverPolicyParams);
            }
        } else {
            throw new ParameterException("Unknown auto failover policy type specified : " + autoFailoverPolicyTypeName);
        }
        return nsIsolationData;
    }

    public CmdNamespaceIsolationPolicy(Supplier<PulsarAdmin> admin) {
        super("ns-isolation-policy", admin);
        this.jcommander.addCommand("set", (Object)new SetPolicy());
        this.jcommander.addCommand("get", (Object)new GetPolicy());
        this.jcommander.addCommand("list", (Object)new GetAllPolicies());
        this.jcommander.addCommand("delete", (Object)new DeletePolicy());
        this.jcommander.addCommand("brokers", (Object)new GetAllBrokersWithPolicies());
        this.jcommander.addCommand("broker", (Object)new GetBrokerWithPolicies());
    }

    @Parameters(commandDescription="Delete namespace isolation policy of a cluster. This operation requires Pulsar super-user privileges")
    private class DeletePolicy
    extends CliCommand {
        @Parameter(description="cluster-name policy-name", required=true)
        private List<String> params;

        private DeletePolicy() {
        }

        @Override
        void run() throws PulsarAdminException {
            String clusterName = DeletePolicy.getOneArgument(this.params, 0, 2);
            String policyName = DeletePolicy.getOneArgument(this.params, 1, 2);
            CmdNamespaceIsolationPolicy.this.getAdmin().clusters().deleteNamespaceIsolationPolicy(clusterName, policyName);
        }
    }

    @Parameters(commandDescription="Get namespace isolation policy of a cluster. This operation requires Pulsar super-user privileges")
    private class GetPolicy
    extends CliCommand {
        @Parameter(description="cluster-name policy-name", required=true)
        private List<String> params;

        private GetPolicy() {
        }

        @Override
        void run() throws PulsarAdminException {
            String clusterName = GetPolicy.getOneArgument(this.params, 0, 2);
            String policyName = GetPolicy.getOneArgument(this.params, 1, 2);
            NamespaceIsolationData nsIsolationData = CmdNamespaceIsolationPolicy.this.getAdmin().clusters().getNamespaceIsolationPolicy(clusterName, policyName);
            this.print(nsIsolationData);
        }
    }

    @Parameters(commandDescription="Get broker with namespace-isolation policies attached to it. This operation requires Pulsar super-user privileges")
    private class GetBrokerWithPolicies
    extends CliCommand {
        @Parameter(description="cluster-name", required=true)
        private List<String> params;
        @Parameter(names={"--broker"}, description="Broker-name to get namespace-isolation policies attached to it", required=true)
        private String broker;

        private GetBrokerWithPolicies() {
        }

        @Override
        void run() throws PulsarAdminException {
            String clusterName = GetBrokerWithPolicies.getOneArgument(this.params);
            BrokerNamespaceIsolationData brokerData = CmdNamespaceIsolationPolicy.this.getAdmin().clusters().getBrokerWithNamespaceIsolationPolicy(clusterName, this.broker);
            this.print(brokerData);
        }
    }

    @Parameters(commandDescription="List all brokers with namespace-isolation policies attached to it. This operation requires Pulsar super-user privileges")
    private class GetAllBrokersWithPolicies
    extends CliCommand {
        @Parameter(description="cluster-name", required=true)
        private List<String> params;

        private GetAllBrokersWithPolicies() {
        }

        @Override
        void run() throws PulsarAdminException {
            String clusterName = GetAllBrokersWithPolicies.getOneArgument(this.params);
            List brokers = CmdNamespaceIsolationPolicy.this.getAdmin().clusters().getBrokersWithNamespaceIsolationPolicy(clusterName);
            this.print(brokers);
        }
    }

    @Parameters(commandDescription="List all namespace isolation policies of a cluster. This operation requires Pulsar super-user privileges")
    private class GetAllPolicies
    extends CliCommand {
        @Parameter(description="cluster-name", required=true)
        private List<String> params;

        private GetAllPolicies() {
        }

        @Override
        void run() throws PulsarAdminException {
            String clusterName = GetAllPolicies.getOneArgument(this.params);
            Map policyMap = CmdNamespaceIsolationPolicy.this.getAdmin().clusters().getNamespaceIsolationPolicies(clusterName);
            this.print(policyMap);
        }
    }

    @Parameters(commandDescription="Create/Update a namespace isolation policy for a cluster. This operation requires Pulsar super-user privileges")
    private class SetPolicy
    extends CliCommand {
        @Parameter(description="cluster-name policy-name", required=true)
        private List<String> params;
        @Parameter(names={"--namespaces"}, description="comma separated namespaces-regex list", required=true, splitter=CommaParameterSplitter.class)
        private List<String> namespaces;
        @Parameter(names={"--primary"}, description="comma separated  primary-broker-regex list. In Pulsar, when namespaces (more specifically, namespace bundles) are assigned dynamically to brokers, the namespace isolation policy limits the set of brokers that can be used for assignment. Before topics are assigned to brokers, you can set the namespace isolation policy with a primary or a secondary regex to select desired brokers. If no broker matches the specified regex, you cannot create a topic. If there are not enough primary brokers, topics are assigned to secondary brokers. If there are not enough secondary brokers, topics are assigned to other brokers which do not have any isolation policies.", required=true, splitter=CommaParameterSplitter.class)
        private List<String> primary;
        @Parameter(names={"--secondary"}, description="comma separated secondary-broker-regex list", required=false, splitter=CommaParameterSplitter.class)
        private List<String> secondary = new ArrayList<String>();
        @Parameter(names={"--auto-failover-policy-type"}, description="auto failover policy type name ['min_available']", required=true)
        private String autoFailoverPolicyTypeName;
        @Parameter(names={"--auto-failover-policy-params"}, description="comma separated name=value auto failover policy parameters", required=true, converter=NameValueParameterSplitter.class)
        private Map<String, String> autoFailoverPolicyParams;

        private SetPolicy() {
        }

        @Override
        void run() throws PulsarAdminException {
            String clusterName = SetPolicy.getOneArgument(this.params, 0, 2);
            String policyName = SetPolicy.getOneArgument(this.params, 1, 2);
            NamespaceIsolationData namespaceIsolationData = CmdNamespaceIsolationPolicy.this.createNamespaceIsolationData(this.namespaces, this.primary, this.secondary, this.autoFailoverPolicyTypeName, this.autoFailoverPolicyParams);
            CmdNamespaceIsolationPolicy.this.getAdmin().clusters().createNamespaceIsolationPolicy(clusterName, policyName, namespaceIsolationData);
        }
    }
}

