/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.admin.cli;

import com.beust.jcommander.DefaultUsageFormatter;
import com.beust.jcommander.IUsageFormatter;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.util.function.Supplier;
import org.apache.pulsar.admin.cli.CliCommand;
import org.apache.pulsar.admin.cli.CmdUsageFormatter;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;

public abstract class CmdBase {
    protected final JCommander jcommander;
    private final Supplier<PulsarAdmin> adminSupplier;
    private PulsarAdmin admin;
    private IUsageFormatter usageFormatter;
    @Parameter(names={"-h", "--help"}, help=true, hidden=true)
    private boolean help;

    public CmdBase(String cmdName, Supplier<PulsarAdmin> adminSupplier) {
        this.adminSupplier = adminSupplier;
        this.jcommander = new JCommander();
        this.usageFormatter = new CmdUsageFormatter(this.jcommander);
        this.jcommander.setProgramName("pulsar-admin " + cmdName);
        this.jcommander.setUsageFormatter(this.usageFormatter);
    }

    protected IUsageFormatter getUsageFormatter() {
        if (this.usageFormatter == null) {
            this.usageFormatter = new DefaultUsageFormatter(this.jcommander);
        }
        return this.usageFormatter;
    }

    private void tryShowCommandUsage() {
        try {
            String chosenCommand = this.jcommander.getParsedCommand();
            this.getUsageFormatter().usage(chosenCommand);
        }
        catch (Exception e) {
            System.err.println("Invalid command, please use `pulsar-admin --help` to check out how to use");
        }
    }

    public boolean run(String[] args) {
        try {
            this.jcommander.parse(args);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.err.println();
            this.tryShowCommandUsage();
            return false;
        }
        String cmd = this.jcommander.getParsedCommand();
        if (cmd == null) {
            this.jcommander.usage();
            return false;
        }
        JCommander obj = (JCommander)this.jcommander.getCommands().get(cmd);
        CliCommand cmdObj = (CliCommand)obj.getObjects().get(0);
        try {
            cmdObj.run();
            return true;
        }
        catch (ParameterException e) {
            System.err.println(e.getMessage());
            System.err.println();
            return false;
        }
        catch (PulsarAdminException.ConnectException e) {
            System.err.println(e.getMessage());
            System.err.println();
            System.err.println("Error connecting to: " + this.getAdmin().getServiceUrl());
            return false;
        }
        catch (PulsarAdminException e) {
            System.err.println(e.getHttpError());
            System.err.println();
            System.err.println("Reason: " + e.getMessage());
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    protected PulsarAdmin getAdmin() {
        if (this.admin == null) {
            this.admin = this.adminSupplier.get();
        }
        return this.admin;
    }
}

