/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.admin.cli;

import com.beust.jcommander.Parameters;
import org.apache.pulsar.admin.cli.CliCommand;
import org.apache.pulsar.admin.cli.CmdBase;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.api.PulsarClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Parameters(commandDescription="Operations to collect function-worker statistics")
public class CmdFunctionWorker
extends CmdBase {
    private static final Logger log = LoggerFactory.getLogger(CmdFunctionWorker.class);

    public CmdFunctionWorker(PulsarAdmin admin) throws PulsarClientException {
        super("functions-worker", admin);
        this.jcommander.addCommand("function-stats", (Object)new FunctionsStats());
        this.jcommander.addCommand("monitoring-metrics", (Object)new CmdMonitoringMetrics());
        this.jcommander.addCommand("get-cluster", (Object)new GetCluster());
        this.jcommander.addCommand("get-cluster-leader", (Object)new GetClusterLeader());
        this.jcommander.addCommand("get-function-assignments", (Object)new GetFunctionAssignments());
    }

    @Parameters(commandDescription="Get the assignments of the functions accross the worker cluster")
    class GetFunctionAssignments
    extends BaseCommand {
        GetFunctionAssignments() {
        }

        @Override
        void runCmd() throws Exception {
            this.print(CmdFunctionWorker.this.admin.worker().getAssignments());
        }
    }

    @Parameters(commandDescription="Get the leader of the worker cluster")
    class GetClusterLeader
    extends BaseCommand {
        GetClusterLeader() {
        }

        @Override
        void runCmd() throws Exception {
            this.print(CmdFunctionWorker.this.admin.worker().getClusterLeader());
        }
    }

    @Parameters(commandDescription="Get all workers belonging to this cluster")
    class GetCluster
    extends BaseCommand {
        GetCluster() {
        }

        @Override
        void runCmd() throws Exception {
            this.print(CmdFunctionWorker.this.admin.worker().getCluster());
        }
    }

    @Parameters(commandDescription="Dump metrics for Monitoring")
    class CmdMonitoringMetrics
    extends BaseCommand {
        CmdMonitoringMetrics() {
        }

        @Override
        void runCmd() throws Exception {
            this.print(CmdFunctionWorker.this.admin.worker().getMetrics());
        }
    }

    @Parameters(commandDescription="Dump all functions stats running on this broker")
    class FunctionsStats
    extends BaseCommand {
        FunctionsStats() {
        }

        @Override
        void runCmd() throws Exception {
            this.print(CmdFunctionWorker.this.admin.worker().getFunctionsStats());
        }
    }

    abstract class BaseCommand
    extends CliCommand {
        BaseCommand() {
        }

        @Override
        void run() throws Exception {
            this.processArguments();
            this.runCmd();
        }

        void processArguments() throws Exception {
        }

        abstract void runCmd() throws Exception;
    }
}

