/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.admin.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.util.function.Supplier;
import org.apache.pulsar.admin.cli.CliCommand;
import org.apache.pulsar.admin.cli.CmdBase;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.common.policies.data.ResourceGroup;

@Parameters(commandDescription="Operations about ResourceGroups")
public class CmdResourceGroups
extends CmdBase {
    public CmdResourceGroups(Supplier<PulsarAdmin> admin) {
        super("resourcegroups", admin);
        this.jcommander.addCommand("list", (Object)new List());
        this.jcommander.addCommand("get", (Object)new Get());
        this.jcommander.addCommand("create", (Object)new Create());
        this.jcommander.addCommand("update", (Object)new Update());
        this.jcommander.addCommand("delete", (Object)new Delete());
    }

    @Parameters(commandDescription="Deletes an existing ResourceGroup")
    private class Delete
    extends CliCommand {
        @Parameter(description="resourcegroup-name", required=true)
        private java.util.List<String> params;

        private Delete() {
        }

        @Override
        void run() throws PulsarAdminException {
            String name = Delete.getOneArgument(this.params);
            CmdResourceGroups.this.getAdmin().resourcegroups().deleteResourceGroup(name);
        }
    }

    @Parameters(commandDescription="Updates a resourcegroup")
    private class Update
    extends CliCommand {
        @Parameter(description="resourcegroup-name", required=true)
        private java.util.List<String> params;
        @Parameter(names={"--msg-publish-rate", "-mp"}, description="message-publish-rate ", required=false)
        private Integer publishRateInMsgs;
        @Parameter(names={"--byte-publish-rate", "-bp"}, description="byte-publish-rate ", required=false)
        private Long publishRateInBytes;
        @Parameter(names={"--msg-dispatch-rate", "-md"}, description="message-dispatch-rate ", required=false)
        private Integer dispatchRateInMsgs;
        @Parameter(names={"--byte-dispatch-rate", "-bd"}, description="byte-dispatch-rate ", required=false)
        private Long dispatchRateInBytes;

        private Update() {
        }

        @Override
        void run() throws PulsarAdminException {
            String name = Update.getOneArgument(this.params);
            ResourceGroup resourcegroup = new ResourceGroup();
            resourcegroup.setDispatchRateInMsgs(this.dispatchRateInMsgs);
            resourcegroup.setDispatchRateInBytes(this.dispatchRateInBytes);
            resourcegroup.setPublishRateInMsgs(this.publishRateInMsgs);
            resourcegroup.setPublishRateInBytes(this.publishRateInBytes);
            CmdResourceGroups.this.getAdmin().resourcegroups().updateResourceGroup(name, resourcegroup);
        }
    }

    @Parameters(commandDescription="Creates a new resourcegroup")
    private class Create
    extends CliCommand {
        @Parameter(description="resourcegroup-name", required=true)
        private java.util.List<String> params;
        @Parameter(names={"--msg-publish-rate", "-mp"}, description="message-publish-rate (default -1 will be overwrite if not passed)", required=false)
        private Integer publishRateInMsgs;
        @Parameter(names={"--byte-publish-rate", "-bp"}, description="byte-publish-rate (default -1 will be overwrite if not passed)", required=false)
        private Long publishRateInBytes;
        @Parameter(names={"--msg-dispatch-rate", "-md"}, description="message-dispatch-rate (default -1 will be overwrite if not passed)", required=false)
        private Integer dispatchRateInMsgs;
        @Parameter(names={"--byte-dispatch-rate", "-bd"}, description="byte-dispatch-rate (default -1 will be overwrite if not passed)", required=false)
        private Long dispatchRateInBytes;

        private Create() {
        }

        @Override
        void run() throws PulsarAdminException {
            String name = Create.getOneArgument(this.params);
            ResourceGroup resourcegroup = new ResourceGroup();
            resourcegroup.setDispatchRateInMsgs(this.dispatchRateInMsgs);
            resourcegroup.setDispatchRateInBytes(this.dispatchRateInBytes);
            resourcegroup.setPublishRateInMsgs(this.publishRateInMsgs);
            resourcegroup.setPublishRateInBytes(this.publishRateInBytes);
            CmdResourceGroups.this.getAdmin().resourcegroups().createResourceGroup(name, resourcegroup);
        }
    }

    @Parameters(commandDescription="Gets the configuration of a resourcegroup")
    private class Get
    extends CliCommand {
        @Parameter(description="resourcegroup-name", required=true)
        private java.util.List<String> params;

        private Get() {
        }

        @Override
        void run() throws PulsarAdminException {
            String name = Get.getOneArgument(this.params);
            this.print(CmdResourceGroups.this.getAdmin().resourcegroups().getResourceGroup(name));
        }
    }

    @Parameters(commandDescription="List the existing resourcegroups")
    private class List
    extends CliCommand {
        private List() {
        }

        @Override
        void run() throws PulsarAdminException {
            this.print(CmdResourceGroups.this.getAdmin().resourcegroups().getResourceGroups());
        }
    }
}

