/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.admin.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.util.function.Supplier;
import org.apache.pulsar.admin.cli.CliCommand;
import org.apache.pulsar.admin.cli.CmdBase;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.common.naming.TopicVersion;

@Parameters(commandDescription="Operations about brokers")
public class CmdBrokers
extends CmdBase {
    public CmdBrokers(Supplier<PulsarAdmin> admin) {
        super("brokers", admin);
        this.jcommander.addCommand("list", (Object)new List());
        this.jcommander.addCommand("leader-broker", (Object)new LeaderBroker());
        this.jcommander.addCommand("namespaces", (Object)new Namespaces());
        this.jcommander.addCommand("update-dynamic-config", (Object)new UpdateConfigurationCmd());
        this.jcommander.addCommand("delete-dynamic-config", (Object)new DeleteConfigurationCmd());
        this.jcommander.addCommand("list-dynamic-config", (Object)new GetUpdatableConfigCmd());
        this.jcommander.addCommand("get-all-dynamic-config", (Object)new GetAllConfigurationsCmd());
        this.jcommander.addCommand("get-internal-config", (Object)new GetInternalConfigurationCmd());
        this.jcommander.addCommand("get-runtime-config", (Object)new GetRuntimeConfigCmd());
        this.jcommander.addCommand("healthcheck", (Object)new HealthcheckCmd());
        this.jcommander.addCommand("backlog-quota-check", (Object)new BacklogQuotaCheckCmd());
        this.jcommander.addCommand("version", (Object)new PulsarVersion());
        this.jcommander.addCommand("shutdown", (Object)new ShutDownBrokerGracefully());
    }

    @Parameters(commandDescription="Get the version of the currently connected broker")
    private class PulsarVersion
    extends CliCommand {
        private PulsarVersion() {
        }

        @Override
        void run() throws Exception {
            System.out.println(CmdBrokers.this.getAdmin().brokers().getVersion());
        }
    }

    @Parameters(commandDescription="Manually trigger backlogQuotaCheck")
    private class BacklogQuotaCheckCmd
    extends CliCommand {
        private BacklogQuotaCheckCmd() {
        }

        @Override
        void run() throws Exception {
            CmdBrokers.this.getAdmin().brokers().backlogQuotaCheckAsync();
            System.out.println("ok");
        }
    }

    @Parameters(commandDescription="Shutdown broker gracefully.")
    private class ShutDownBrokerGracefully
    extends CliCommand {
        @Parameter(names={"--max-concurrent-unload-per-sec", "-m"}, description="Max concurrent unload per second, if the value absent(value=0) means no concurrent limitation")
        private int maxConcurrentUnloadPerSec;
        @Parameter(names={"--forced-terminate-topic", "-f"}, description="Force terminate all topics on Broker")
        private boolean forcedTerminateTopic;

        private ShutDownBrokerGracefully() {
        }

        @Override
        void run() throws Exception {
            CmdBrokers.this.getAdmin().brokers().shutDownBrokerGracefully(this.maxConcurrentUnloadPerSec, this.forcedTerminateTopic);
            System.out.println("Successfully trigger broker shutdown gracefully");
        }
    }

    @Parameters(commandDescription="Run a health check against the broker")
    private class HealthcheckCmd
    extends CliCommand {
        @Parameter(names={"--topic-version"}, description="topic version V1 is default")
        private TopicVersion topicVersion;

        private HealthcheckCmd() {
        }

        @Override
        void run() throws Exception {
            CmdBrokers.this.getAdmin().brokers().healthcheck(this.topicVersion);
            System.out.println("ok");
        }
    }

    @Parameters(commandDescription="Get internal configuration information")
    private class GetInternalConfigurationCmd
    extends CliCommand {
        private GetInternalConfigurationCmd() {
        }

        @Override
        void run() throws Exception {
            this.print(CmdBrokers.this.getAdmin().brokers().getInternalConfigurationData());
        }
    }

    @Parameters(commandDescription="Get runtime configuration values")
    private class GetRuntimeConfigCmd
    extends CliCommand {
        private GetRuntimeConfigCmd() {
        }

        @Override
        void run() throws Exception {
            this.print(CmdBrokers.this.getAdmin().brokers().getRuntimeConfigurations());
        }
    }

    @Parameters(commandDescription="Get list of updatable configuration name")
    private class GetUpdatableConfigCmd
    extends CliCommand {
        private GetUpdatableConfigCmd() {
        }

        @Override
        void run() throws Exception {
            this.print(CmdBrokers.this.getAdmin().brokers().getDynamicConfigurationNames());
        }
    }

    @Parameters(commandDescription="Get all overridden dynamic-configuration values")
    private class GetAllConfigurationsCmd
    extends CliCommand {
        private GetAllConfigurationsCmd() {
        }

        @Override
        void run() throws Exception {
            this.print(CmdBrokers.this.getAdmin().brokers().getAllDynamicConfigurations());
        }
    }

    @Parameters(commandDescription="Delete dynamic-serviceConfiguration of broker")
    private class DeleteConfigurationCmd
    extends CliCommand {
        @Parameter(names={"--config"}, description="service-configuration name", required=true)
        private String configName;

        private DeleteConfigurationCmd() {
        }

        @Override
        void run() throws Exception {
            CmdBrokers.this.getAdmin().brokers().deleteDynamicConfiguration(this.configName);
        }
    }

    @Parameters(commandDescription="Update dynamic-serviceConfiguration of broker")
    private class UpdateConfigurationCmd
    extends CliCommand {
        @Parameter(names={"--config"}, description="service-configuration name", required=true)
        private String configName;
        @Parameter(names={"--value"}, description="service-configuration value", required=true)
        private String configValue;

        private UpdateConfigurationCmd() {
        }

        @Override
        void run() throws Exception {
            CmdBrokers.this.getAdmin().brokers().updateDynamicConfiguration(this.configName, this.configValue);
        }
    }

    @Parameters(commandDescription="List namespaces owned by the broker")
    private class Namespaces
    extends CliCommand {
        @Parameter(description="cluster-name", required=true)
        private java.util.List<String> params;
        @Parameter(names={"--url"}, description="broker-url", required=true)
        private String brokerUrl;

        private Namespaces() {
        }

        @Override
        void run() throws Exception {
            String cluster = Namespaces.getOneArgument(this.params);
            this.print(CmdBrokers.this.getAdmin().brokers().getOwnedNamespaces(cluster, this.brokerUrl));
        }
    }

    @Parameters(commandDescription="Get the information of the leader broker")
    private class LeaderBroker
    extends CliCommand {
        private LeaderBroker() {
        }

        @Override
        void run() throws Exception {
            this.print(CmdBrokers.this.getAdmin().brokers().getLeaderBroker());
        }
    }

    @Parameters(commandDescription="List active brokers of the cluster")
    private class List
    extends CliCommand {
        @Parameter(description="cluster-name", required=true)
        private java.util.List<String> params;

        private List() {
        }

        @Override
        void run() throws Exception {
            String cluster = List.getOneArgument(this.params);
            this.print(CmdBrokers.this.getAdmin().brokers().getActiveBrokers(cluster));
        }
    }
}

