/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.admin.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.converters.CommaParameterSplitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.swagger.util.Json;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.admin.cli.CliCommand;
import org.apache.pulsar.admin.cli.CmdBase;
import org.apache.pulsar.admin.cli.utils.IOUtils;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.policies.data.AutoSubscriptionCreationOverride;
import org.apache.pulsar.common.policies.data.AutoTopicCreationOverride;
import org.apache.pulsar.common.policies.data.BacklogQuota;
import org.apache.pulsar.common.policies.data.BookieAffinityGroupData;
import org.apache.pulsar.common.policies.data.BundlesData;
import org.apache.pulsar.common.policies.data.DelayedDeliveryPolicies;
import org.apache.pulsar.common.policies.data.DispatchRate;
import org.apache.pulsar.common.policies.data.InactiveTopicDeleteMode;
import org.apache.pulsar.common.policies.data.InactiveTopicPolicies;
import org.apache.pulsar.common.policies.data.OffloadPolicies;
import org.apache.pulsar.common.policies.data.OffloadPoliciesImpl;
import org.apache.pulsar.common.policies.data.OffloadedReadPriority;
import org.apache.pulsar.common.policies.data.PersistencePolicies;
import org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.common.policies.data.PublishRate;
import org.apache.pulsar.common.policies.data.RetentionPolicies;
import org.apache.pulsar.common.policies.data.SchemaAutoUpdateCompatibilityStrategy;
import org.apache.pulsar.common.policies.data.SchemaCompatibilityStrategy;
import org.apache.pulsar.common.policies.data.SubscribeRate;
import org.apache.pulsar.common.policies.data.SubscriptionAuthMode;
import org.apache.pulsar.common.policies.data.TopicType;
import org.apache.pulsar.common.util.RelativeTimeUtil;

@Parameters(commandDescription="Operations about namespaces")
public class CmdNamespaces
extends CmdBase {
    public CmdNamespaces(Supplier<PulsarAdmin> admin) {
        super("namespaces", admin);
        this.jcommander.addCommand("list", (Object)new GetNamespacesPerProperty());
        this.jcommander.addCommand("list-cluster", (Object)new GetNamespacesPerCluster());
        this.jcommander.addCommand("topics", (Object)new GetTopics());
        this.jcommander.addCommand("bundles", (Object)new GetBundles());
        this.jcommander.addCommand("destinations", (Object)new GetDestinations());
        this.jcommander.addCommand("policies", (Object)new GetPolicies());
        this.jcommander.addCommand("create", (Object)new Create());
        this.jcommander.addCommand("delete", (Object)new Delete());
        this.jcommander.addCommand("permissions", (Object)new Permissions());
        this.jcommander.addCommand("grant-permission", (Object)new GrantPermissions());
        this.jcommander.addCommand("revoke-permission", (Object)new RevokePermissions());
        this.jcommander.addCommand("subscription-permission", (Object)new SubscriptionPermissions());
        this.jcommander.addCommand("grant-subscription-permission", (Object)new GrantSubscriptionPermissions());
        this.jcommander.addCommand("revoke-subscription-permission", (Object)new RevokeSubscriptionPermissions());
        this.jcommander.addCommand("set-clusters", (Object)new SetReplicationClusters());
        this.jcommander.addCommand("get-clusters", (Object)new GetReplicationClusters());
        this.jcommander.addCommand("set-subscription-types-enabled", (Object)new SetSubscriptionTypesEnabled());
        this.jcommander.addCommand("get-subscription-types-enabled", (Object)new GetSubscriptionTypesEnabled());
        this.jcommander.addCommand("remove-subscription-types-enabled", (Object)new RemoveSubscriptionTypesEnabled());
        this.jcommander.addCommand("get-backlog-quotas", (Object)new GetBacklogQuotaMap());
        this.jcommander.addCommand("set-backlog-quota", (Object)new SetBacklogQuota());
        this.jcommander.addCommand("remove-backlog-quota", (Object)new RemoveBacklogQuota());
        this.jcommander.addCommand("get-persistence", (Object)new GetPersistence());
        this.jcommander.addCommand("set-persistence", (Object)new SetPersistence());
        this.jcommander.addCommand("remove-persistence", (Object)new RemovePersistence());
        this.jcommander.addCommand("get-message-ttl", (Object)new GetMessageTTL());
        this.jcommander.addCommand("set-message-ttl", (Object)new SetMessageTTL());
        this.jcommander.addCommand("remove-message-ttl", (Object)new RemoveMessageTTL());
        this.jcommander.addCommand("get-max-subscriptions-per-topic", (Object)new GetMaxSubscriptionsPerTopic());
        this.jcommander.addCommand("set-max-subscriptions-per-topic", (Object)new SetMaxSubscriptionsPerTopic());
        this.jcommander.addCommand("remove-max-subscriptions-per-topic", (Object)new RemoveMaxSubscriptionsPerTopic());
        this.jcommander.addCommand("get-subscription-expiration-time", (Object)new GetSubscriptionExpirationTime());
        this.jcommander.addCommand("set-subscription-expiration-time", (Object)new SetSubscriptionExpirationTime());
        this.jcommander.addCommand("remove-subscription-expiration-time", (Object)new RemoveSubscriptionExpirationTime());
        this.jcommander.addCommand("get-anti-affinity-group", (Object)new GetAntiAffinityGroup());
        this.jcommander.addCommand("set-anti-affinity-group", (Object)new SetAntiAffinityGroup());
        this.jcommander.addCommand("get-anti-affinity-namespaces", (Object)new GetAntiAffinityNamespaces());
        this.jcommander.addCommand("delete-anti-affinity-group", (Object)new DeleteAntiAffinityGroup());
        this.jcommander.addCommand("set-deduplication", (Object)new SetDeduplication());
        this.jcommander.addCommand("get-deduplication", (Object)new GetDeduplication());
        this.jcommander.addCommand("remove-deduplication", (Object)new RemoveDeduplication());
        this.jcommander.addCommand("set-auto-topic-creation", (Object)new SetAutoTopicCreation());
        this.jcommander.addCommand("get-auto-topic-creation", (Object)new GetAutoTopicCreation());
        this.jcommander.addCommand("remove-auto-topic-creation", (Object)new RemoveAutoTopicCreation());
        this.jcommander.addCommand("set-auto-subscription-creation", (Object)new SetAutoSubscriptionCreation());
        this.jcommander.addCommand("get-auto-subscription-creation", (Object)new GetAutoSubscriptionCreation());
        this.jcommander.addCommand("remove-auto-subscription-creation", (Object)new RemoveAutoSubscriptionCreation());
        this.jcommander.addCommand("get-retention", (Object)new GetRetention());
        this.jcommander.addCommand("set-retention", (Object)new SetRetention());
        this.jcommander.addCommand("remove-retention", (Object)new RemoveRetention());
        this.jcommander.addCommand("set-bookie-affinity-group", (Object)new SetBookieAffinityGroup());
        this.jcommander.addCommand("get-bookie-affinity-group", (Object)new GetBookieAffinityGroup());
        this.jcommander.addCommand("delete-bookie-affinity-group", (Object)new DeleteBookieAffinityGroup());
        this.jcommander.addCommand("unload", (Object)new Unload());
        this.jcommander.addCommand("split-bundle", (Object)new SplitBundle());
        this.jcommander.addCommand("set-dispatch-rate", (Object)new SetDispatchRate());
        this.jcommander.addCommand("remove-dispatch-rate", (Object)new RemoveDispatchRate());
        this.jcommander.addCommand("get-dispatch-rate", (Object)new GetDispatchRate());
        this.jcommander.addCommand("set-subscribe-rate", (Object)new SetSubscribeRate());
        this.jcommander.addCommand("get-subscribe-rate", (Object)new GetSubscribeRate());
        this.jcommander.addCommand("remove-subscribe-rate", (Object)new RemoveSubscribeRate());
        this.jcommander.addCommand("set-subscription-dispatch-rate", (Object)new SetSubscriptionDispatchRate());
        this.jcommander.addCommand("get-subscription-dispatch-rate", (Object)new GetSubscriptionDispatchRate());
        this.jcommander.addCommand("remove-subscription-dispatch-rate", (Object)new RemoveSubscriptionDispatchRate());
        this.jcommander.addCommand("set-publish-rate", (Object)new SetPublishRate());
        this.jcommander.addCommand("get-publish-rate", (Object)new GetPublishRate());
        this.jcommander.addCommand("remove-publish-rate", (Object)new RemovePublishRate());
        this.jcommander.addCommand("set-replicator-dispatch-rate", (Object)new SetReplicatorDispatchRate());
        this.jcommander.addCommand("get-replicator-dispatch-rate", (Object)new GetReplicatorDispatchRate());
        this.jcommander.addCommand("remove-replicator-dispatch-rate", (Object)new RemoveReplicatorDispatchRate());
        this.jcommander.addCommand("clear-backlog", (Object)new ClearBacklog());
        this.jcommander.addCommand("unsubscribe", (Object)new Unsubscribe());
        this.jcommander.addCommand("set-encryption-required", (Object)new SetEncryptionRequired());
        this.jcommander.addCommand("get-encryption-required", (Object)new GetEncryptionRequired());
        this.jcommander.addCommand("set-subscription-auth-mode", (Object)new SetSubscriptionAuthMode());
        this.jcommander.addCommand("get-subscription-auth-mode", (Object)new GetSubscriptionAuthMode());
        this.jcommander.addCommand("set-delayed-delivery", (Object)new SetDelayedDelivery());
        this.jcommander.addCommand("get-delayed-delivery", (Object)new GetDelayedDelivery());
        this.jcommander.addCommand("remove-delayed-delivery", (Object)new RemoveDelayedDelivery());
        this.jcommander.addCommand("get-inactive-topic-policies", (Object)new GetInactiveTopicPolicies());
        this.jcommander.addCommand("set-inactive-topic-policies", (Object)new SetInactiveTopicPolicies());
        this.jcommander.addCommand("remove-inactive-topic-policies", (Object)new RemoveInactiveTopicPolicies());
        this.jcommander.addCommand("get-max-producers-per-topic", (Object)new GetMaxProducersPerTopic());
        this.jcommander.addCommand("set-max-producers-per-topic", (Object)new SetMaxProducersPerTopic());
        this.jcommander.addCommand("remove-max-producers-per-topic", (Object)new RemoveMaxProducersPerTopic());
        this.jcommander.addCommand("get-max-consumers-per-topic", (Object)new GetMaxConsumersPerTopic());
        this.jcommander.addCommand("set-max-consumers-per-topic", (Object)new SetMaxConsumersPerTopic());
        this.jcommander.addCommand("remove-max-consumers-per-topic", (Object)new RemoveMaxConsumersPerTopic());
        this.jcommander.addCommand("get-max-consumers-per-subscription", (Object)new GetMaxConsumersPerSubscription());
        this.jcommander.addCommand("set-max-consumers-per-subscription", (Object)new SetMaxConsumersPerSubscription());
        this.jcommander.addCommand("remove-max-consumers-per-subscription", (Object)new RemoveMaxConsumersPerSubscription());
        this.jcommander.addCommand("get-max-unacked-messages-per-subscription", (Object)new GetMaxUnackedMessagesPerSubscription());
        this.jcommander.addCommand("set-max-unacked-messages-per-subscription", (Object)new SetMaxUnackedMessagesPerSubscription());
        this.jcommander.addCommand("remove-max-unacked-messages-per-subscription", (Object)new RemoveMaxUnackedMessagesPerSubscription());
        this.jcommander.addCommand("get-max-unacked-messages-per-consumer", (Object)new GetMaxUnackedMessagesPerConsumer());
        this.jcommander.addCommand("set-max-unacked-messages-per-consumer", (Object)new SetMaxUnackedMessagesPerConsumer());
        this.jcommander.addCommand("remove-max-unacked-messages-per-consumer", (Object)new RemoveMaxUnackedMessagesPerConsumer());
        this.jcommander.addCommand("get-compaction-threshold", (Object)new GetCompactionThreshold());
        this.jcommander.addCommand("set-compaction-threshold", (Object)new SetCompactionThreshold());
        this.jcommander.addCommand("remove-compaction-threshold", (Object)new RemoveCompactionThreshold());
        this.jcommander.addCommand("get-offload-threshold", (Object)new GetOffloadThreshold());
        this.jcommander.addCommand("set-offload-threshold", (Object)new SetOffloadThreshold());
        this.jcommander.addCommand("get-offload-deletion-lag", (Object)new GetOffloadDeletionLag());
        this.jcommander.addCommand("set-offload-deletion-lag", (Object)new SetOffloadDeletionLag());
        this.jcommander.addCommand("clear-offload-deletion-lag", (Object)new ClearOffloadDeletionLag());
        this.jcommander.addCommand("get-schema-autoupdate-strategy", (Object)new GetSchemaAutoUpdateStrategy());
        this.jcommander.addCommand("set-schema-autoupdate-strategy", (Object)new SetSchemaAutoUpdateStrategy());
        this.jcommander.addCommand("get-schema-compatibility-strategy", (Object)new GetSchemaCompatibilityStrategy());
        this.jcommander.addCommand("set-schema-compatibility-strategy", (Object)new SetSchemaCompatibilityStrategy());
        this.jcommander.addCommand("get-is-allow-auto-update-schema", (Object)new GetIsAllowAutoUpdateSchema());
        this.jcommander.addCommand("set-is-allow-auto-update-schema", (Object)new SetIsAllowAutoUpdateSchema());
        this.jcommander.addCommand("get-schema-validation-enforce", (Object)new GetSchemaValidationEnforced());
        this.jcommander.addCommand("set-schema-validation-enforce", (Object)new SetSchemaValidationEnforced());
        this.jcommander.addCommand("set-offload-policies", (Object)new SetOffloadPolicies());
        this.jcommander.addCommand("remove-offload-policies", (Object)new RemoveOffloadPolicies());
        this.jcommander.addCommand("get-offload-policies", (Object)new GetOffloadPolicies());
        this.jcommander.addCommand("set-deduplication-snapshot-interval", (Object)new SetDeduplicationSnapshotInterval());
        this.jcommander.addCommand("get-deduplication-snapshot-interval", (Object)new GetDeduplicationSnapshotInterval());
        this.jcommander.addCommand("remove-deduplication-snapshot-interval", (Object)new RemoveDeduplicationSnapshotInterval());
        this.jcommander.addCommand("set-max-topics-per-namespace", (Object)new SetMaxTopicsPerNamespace());
        this.jcommander.addCommand("get-max-topics-per-namespace", (Object)new GetMaxTopicsPerNamespace());
        this.jcommander.addCommand("remove-max-topics-per-namespace", (Object)new RemoveMaxTopicsPerNamespace());
        this.jcommander.addCommand("set-property", (Object)new SetPropertyForNamespace());
        this.jcommander.addCommand("get-property", (Object)new GetPropertyForNamespace());
        this.jcommander.addCommand("remove-property", (Object)new RemovePropertyForNamespace());
        this.jcommander.addCommand("set-properties", (Object)new SetPropertiesForNamespace());
        this.jcommander.addCommand("get-properties", (Object)new GetPropertiesForNamespace());
        this.jcommander.addCommand("clear-properties", (Object)new ClearPropertiesForNamespace());
        this.jcommander.addCommand("get-resource-group", (Object)new GetResourceGroup());
        this.jcommander.addCommand("set-resource-group", (Object)new SetResourceGroup());
        this.jcommander.addCommand("remove-resource-group", (Object)new RemoveResourceGroup());
    }

    @Parameters(commandDescription="Remove ResourceGroup from a namespace")
    private class RemoveResourceGroup
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private RemoveResourceGroup() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = RemoveResourceGroup.validateNamespace(this.params);
            CmdNamespaces.this.getAdmin().namespaces().removeNamespaceResourceGroup(namespace);
        }
    }

    @Parameters(commandDescription="Set ResourceGroup for a namespace")
    private class SetResourceGroup
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;
        @Parameter(names={"--resource-group-name", "-rgn"}, description="ResourceGroup name", required=true)
        private String rgName;

        private SetResourceGroup() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetResourceGroup.validateNamespace(this.params);
            CmdNamespaces.this.getAdmin().namespaces().setNamespaceResourceGroup(namespace, this.rgName);
        }
    }

    @Parameters(commandDescription="Get ResourceGroup for a namespace")
    private class GetResourceGroup
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private GetResourceGroup() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetResourceGroup.validateNamespace(this.params);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getNamespaceResourceGroup(namespace));
        }
    }

    @Parameters(commandDescription="Clear all properties for a namespace")
    private class ClearPropertiesForNamespace
    extends CliCommand {
        @Parameter(description="tenant/namespace\n", required=true)
        private List<String> params;

        private ClearPropertiesForNamespace() {
        }

        @Override
        void run() throws Exception {
            String namespace = ClearPropertiesForNamespace.validateNamespace(this.params);
            CmdNamespaces.this.getAdmin().namespaces().clearProperties(namespace);
        }
    }

    @Parameters(commandDescription="Remove property for a namespace")
    private class RemovePropertyForNamespace
    extends CliCommand {
        @Parameter(description="tenant/namespace\n", required=true)
        private List<String> params;
        @Parameter(names={"--key", "-k"}, description="Key of the property", required=true)
        private String key;

        private RemovePropertyForNamespace() {
        }

        @Override
        void run() throws Exception {
            String namespace = RemovePropertyForNamespace.validateNamespace(this.params);
            this.print(CmdNamespaces.this.getAdmin().namespaces().removeProperty(namespace, this.key));
        }
    }

    @Parameters(commandDescription="Get properties of a namespace")
    private class GetPropertiesForNamespace
    extends CliCommand {
        @Parameter(description="tenant/namespace\n", required=true)
        private List<String> params;

        private GetPropertiesForNamespace() {
        }

        @Override
        void run() throws Exception {
            String namespace = GetPropertiesForNamespace.validateNamespace(this.params);
            Json.prettyPrint((Object)CmdNamespaces.this.getAdmin().namespaces().getProperties(namespace));
        }
    }

    @Parameters(commandDescription="Get property for a namespace")
    private class GetPropertyForNamespace
    extends CliCommand {
        @Parameter(description="tenant/namespace\n", required=true)
        private List<String> params;
        @Parameter(names={"--key", "-k"}, description="Key of the property", required=true)
        private String key;

        private GetPropertyForNamespace() {
        }

        @Override
        void run() throws Exception {
            String namespace = GetPropertyForNamespace.validateNamespace(this.params);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getProperty(namespace, this.key));
        }
    }

    @Parameters(commandDescription="Set properties of a namespace")
    private class SetPropertiesForNamespace
    extends CliCommand {
        @Parameter(description="tenant/namespace\n", required=true)
        private List<String> params;
        @Parameter(names={"--properties", "-p"}, description="key value pair properties(a=a,b=b,c=c)", required=true)
        private List<String> properties;

        private SetPropertiesForNamespace() {
        }

        @Override
        void run() throws Exception {
            String namespace = SetPropertiesForNamespace.validateNamespace(this.params);
            HashMap<String, String> map = new HashMap<String, String>();
            if (this.properties.size() == 0) {
                throw new ParameterException(String.format("Required at least one property for the namespace, but found %d.", this.properties.size()));
            }
            for (String property : this.properties) {
                if (!property.contains("=")) {
                    throw new ParameterException(String.format("Invalid key value pair '%s', valid format like 'a=a,b=b,c=c'.", property));
                }
                String[] keyValue = property.split("=");
                if (keyValue.length != 2) {
                    throw new ParameterException(String.format("Invalid key value pair '%s', valid format like 'a=a,b=b,c=c'.", property));
                }
                map.put(keyValue[0], keyValue[1]);
            }
            CmdNamespaces.this.getAdmin().namespaces().setProperties(namespace, map);
        }
    }

    @Parameters(commandDescription="Set property for a namespace")
    private class SetPropertyForNamespace
    extends CliCommand {
        @Parameter(description="tenant/namespace\n", required=true)
        private List<String> params;
        @Parameter(names={"--key", "-k"}, description="Key of the property", required=true)
        private String key;
        @Parameter(names={"--value", "-v"}, description="Value of the property", required=true)
        private String value;

        private SetPropertyForNamespace() {
        }

        @Override
        void run() throws Exception {
            String namespace = SetPropertyForNamespace.validateNamespace(this.params);
            CmdNamespaces.this.getAdmin().namespaces().setProperty(namespace, this.key, this.value);
        }
    }

    @Parameters(commandDescription="Remove max topics per namespace")
    private class RemoveMaxTopicsPerNamespace
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private RemoveMaxTopicsPerNamespace() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = RemoveMaxTopicsPerNamespace.validateNamespace(this.params);
            CmdNamespaces.this.getAdmin().namespaces().removeMaxTopicsPerNamespace(namespace);
        }
    }

    @Parameters(commandDescription="Get max topics per namespace")
    private class GetMaxTopicsPerNamespace
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private GetMaxTopicsPerNamespace() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetMaxTopicsPerNamespace.validateNamespace(this.params);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getMaxTopicsPerNamespace(namespace));
        }
    }

    @Parameters(commandDescription="Set max topics per namespace")
    private class SetMaxTopicsPerNamespace
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;
        @Parameter(names={"--max-topics-per-namespace", "-t"}, description="max topics per namespace", required=true)
        private int maxTopicsPerNamespace;

        private SetMaxTopicsPerNamespace() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetMaxTopicsPerNamespace.validateNamespace(this.params);
            CmdNamespaces.this.getAdmin().namespaces().setMaxTopicsPerNamespace(namespace, this.maxTopicsPerNamespace);
        }
    }

    @Parameters(commandDescription="Get the offload policies for a namespace")
    private class GetOffloadPolicies
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private GetOffloadPolicies() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetOffloadPolicies.validateNamespace(this.params);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getOffloadPolicies(namespace));
        }
    }

    @Parameters(commandDescription="Remove the offload policies for a namespace")
    private class RemoveOffloadPolicies
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private RemoveOffloadPolicies() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = RemoveOffloadPolicies.validateNamespace(this.params);
            CmdNamespaces.this.getAdmin().namespaces().removeOffloadPolicies(namespace);
        }
    }

    @Parameters(commandDescription="Set the offload policies for a namespace")
    private class SetOffloadPolicies
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;
        @Parameter(names={"--driver", "-d"}, description="Driver to use to offload old data to long term storage, (Possible values: S3, aws-s3, google-cloud-storage, filesystem, azureblob)", required=true)
        private String driver;
        @Parameter(names={"--region", "-r"}, description="The long term storage region, default is s3ManagedLedgerOffloadRegion or gcsManagedLedgerOffloadRegion in broker.conf", required=false)
        private String region;
        @Parameter(names={"--bucket", "-b"}, description="Bucket to place offloaded ledger into", required=true)
        private String bucket;
        @Parameter(names={"--endpoint", "-e"}, description="Alternative endpoint to connect to, s3 default is s3ManagedLedgerOffloadServiceEndpoint in broker.conf", required=false)
        private String endpoint;
        @Parameter(names={"--aws-id", "-i"}, description="AWS Credential Id to use when using driver S3 or aws-s3", required=false)
        private String awsId;
        @Parameter(names={"--aws-secret", "-s"}, description="AWS Credential Secret to use when using driver S3 or aws-s3", required=false)
        private String awsSecret;
        @Parameter(names={"--s3-role", "-ro"}, description="S3 Role used for STSAssumeRoleSessionCredentialsProvider", required=false)
        private String s3Role;
        @Parameter(names={"--s3-role-session-name", "-rsn"}, description="S3 role session name used for STSAssumeRoleSessionCredentialsProvider", required=false)
        private String s3RoleSessionName;
        @Parameter(names={"--maxBlockSize", "-mbs"}, description="Max block size (eg: 32M, 64M), default is 64MB", required=false)
        private String maxBlockSizeStr;
        @Parameter(names={"--readBufferSize", "-rbs"}, description="Read buffer size (eg: 1M, 5M), default is 1MB", required=false)
        private String readBufferSizeStr;
        @Parameter(names={"--offloadAfterElapsed", "-oae"}, description="Offload after elapsed in minutes (or minutes, hours,days,weeks eg: 100m, 3h, 2d, 5w).", required=false)
        private String offloadAfterElapsedStr;
        @Parameter(names={"--offloadAfterThreshold", "-oat"}, description="Offload after threshold size (eg: 1M, 5M)", required=false)
        private String offloadAfterThresholdStr;
        @Parameter(names={"--offloadedReadPriority", "-orp"}, description="Read priority for offloaded messages. By default, once messages are offloaded to long-term storage, brokers read messages from long-term storage, but messages can still exist in BookKeeper for a period depends on your configuration. For messages that exist in both long-term storage and BookKeeper, you can set where to read messages from with the option `tiered-storage-first` or `bookkeeper-first`.", required=false)
        private String offloadReadPriorityStr;
        public final List<String> DRIVER_NAMES = OffloadPoliciesImpl.DRIVER_NAMES;

        private SetOffloadPolicies() {
        }

        public boolean driverSupported(String driver) {
            return this.DRIVER_NAMES.stream().anyMatch(d -> d.equalsIgnoreCase(driver));
        }

        public boolean isS3Driver(String driver) {
            if (StringUtils.isEmpty((CharSequence)driver)) {
                return false;
            }
            return driver.equalsIgnoreCase(this.DRIVER_NAMES.get(0)) || driver.equalsIgnoreCase(this.DRIVER_NAMES.get(1));
        }

        public boolean positiveCheck(String paramName, long value) {
            if (value <= 0L) {
                throw new ParameterException(paramName + " is not be negative or 0!");
            }
            return true;
        }

        public boolean maxValueCheck(String paramName, long value, long maxValue) {
            if (value > maxValue) {
                throw new ParameterException(paramName + " is not bigger than " + maxValue + "!");
            }
            return true;
        }

        @Override
        void run() throws PulsarAdminException {
            long offloadAfterThreshold;
            Long offloadAfterElapsed;
            long readBufferSize;
            long maxBlockSize;
            String namespace = SetOffloadPolicies.validateNamespace(this.params);
            if (!this.driverSupported(this.driver)) {
                throw new ParameterException("The driver " + this.driver + " is not supported, (Possible values: " + String.join((CharSequence)",", this.DRIVER_NAMES) + ").");
            }
            if (this.isS3Driver(this.driver) && Strings.isNullOrEmpty((String)this.region) && Strings.isNullOrEmpty((String)this.endpoint)) {
                throw new ParameterException("Either s3ManagedLedgerOffloadRegion or s3ManagedLedgerOffloadServiceEndpoint must be set if s3 offload enabled");
            }
            int maxBlockSizeInBytes = 0x4000000;
            if (StringUtils.isNotEmpty((CharSequence)this.maxBlockSizeStr) && this.positiveCheck("MaxBlockSize", maxBlockSize = SetOffloadPolicies.validateSizeString(this.maxBlockSizeStr)) && this.maxValueCheck("MaxBlockSize", maxBlockSize, Integer.MAX_VALUE)) {
                maxBlockSizeInBytes = new Long(maxBlockSize).intValue();
            }
            int readBufferSizeInBytes = 0x100000;
            if (StringUtils.isNotEmpty((CharSequence)this.readBufferSizeStr) && this.positiveCheck("ReadBufferSize", readBufferSize = SetOffloadPolicies.validateSizeString(this.readBufferSizeStr)) && this.maxValueCheck("ReadBufferSize", readBufferSize, Integer.MAX_VALUE)) {
                readBufferSizeInBytes = new Long(readBufferSize).intValue();
            }
            Long offloadAfterElapsedInMillis = OffloadPoliciesImpl.DEFAULT_OFFLOAD_DELETION_LAG_IN_MILLIS;
            if (StringUtils.isNotEmpty((CharSequence)this.offloadAfterElapsedStr) && this.positiveCheck("OffloadAfterElapsed", offloadAfterElapsed = Long.valueOf(TimeUnit.SECONDS.toMillis(RelativeTimeUtil.parseRelativeTimeInSeconds((String)this.offloadAfterElapsedStr)))) && this.maxValueCheck("OffloadAfterElapsed", offloadAfterElapsed, Long.MAX_VALUE)) {
                offloadAfterElapsedInMillis = offloadAfterElapsed;
            }
            Long offloadAfterThresholdInBytes = OffloadPoliciesImpl.DEFAULT_OFFLOAD_THRESHOLD_IN_BYTES;
            if (StringUtils.isNotEmpty((CharSequence)this.offloadAfterThresholdStr) && this.positiveCheck("OffloadAfterThreshold", offloadAfterThreshold = SetOffloadPolicies.validateSizeString(this.offloadAfterThresholdStr)) && this.maxValueCheck("OffloadAfterThreshold", offloadAfterThreshold, Long.MAX_VALUE)) {
                offloadAfterThresholdInBytes = offloadAfterThreshold;
            }
            OffloadedReadPriority offloadedReadPriority = OffloadPoliciesImpl.DEFAULT_OFFLOADED_READ_PRIORITY;
            if (this.offloadReadPriorityStr != null) {
                try {
                    offloadedReadPriority = OffloadedReadPriority.fromString((String)this.offloadReadPriorityStr);
                }
                catch (Exception e) {
                    throw new ParameterException("--offloadedReadPriority parameter must be one of " + Arrays.stream(OffloadedReadPriority.values()).map(OffloadedReadPriority::toString).collect(Collectors.joining(",")) + " but got: " + this.offloadReadPriorityStr, (Throwable)e);
                }
            }
            OffloadPoliciesImpl offloadPolicies = OffloadPoliciesImpl.create((String)this.driver, (String)this.region, (String)this.bucket, (String)this.endpoint, (String)this.s3Role, (String)this.s3RoleSessionName, (String)this.awsId, (String)this.awsSecret, (Integer)maxBlockSizeInBytes, (Integer)readBufferSizeInBytes, (Long)offloadAfterThresholdInBytes, (Long)offloadAfterElapsedInMillis, (OffloadedReadPriority)offloadedReadPriority);
            CmdNamespaces.this.getAdmin().namespaces().setOffloadPolicies(namespace, (OffloadPolicies)offloadPolicies);
        }
    }

    @Parameters(commandDescription="Set the schema whether open schema validation enforced")
    private class SetSchemaValidationEnforced
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;
        @Parameter(names={"--enable", "-e"}, description="Enable schema validation enforced")
        private boolean enable = false;
        @Parameter(names={"--disable", "-d"}, description="Disable schema validation enforced")
        private boolean disable = false;

        private SetSchemaValidationEnforced() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetSchemaValidationEnforced.validateNamespace(this.params);
            if (this.enable == this.disable) {
                throw new ParameterException("Need to specify either --enable or --disable");
            }
            CmdNamespaces.this.getAdmin().namespaces().setSchemaValidationEnforced(namespace, this.enable);
        }
    }

    @Parameters(commandDescription="Get the schema validation enforced")
    private class GetSchemaValidationEnforced
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;
        @Parameter(names={"-ap", "--applied"}, description="Get the applied policy of the namespace")
        private boolean applied = false;

        private GetSchemaValidationEnforced() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetSchemaValidationEnforced.validateNamespace(this.params);
            System.out.println(CmdNamespaces.this.getAdmin().namespaces().getSchemaValidationEnforced(namespace, this.applied));
        }
    }

    @Parameters(commandDescription="Set the namespace whether allow auto update schema")
    private class SetIsAllowAutoUpdateSchema
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;
        @Parameter(names={"--enable", "-e"}, description="Enable schema validation enforced")
        private boolean enable = false;
        @Parameter(names={"--disable", "-d"}, description="Disable schema validation enforced")
        private boolean disable = false;

        private SetIsAllowAutoUpdateSchema() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetIsAllowAutoUpdateSchema.validateNamespace(this.params);
            if (this.enable == this.disable) {
                throw new ParameterException("Need to specify either --enable or --disable");
            }
            CmdNamespaces.this.getAdmin().namespaces().setIsAllowAutoUpdateSchema(namespace, this.enable);
        }
    }

    @Parameters(commandDescription="Get the namespace whether allow auto update schema")
    private class GetIsAllowAutoUpdateSchema
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private GetIsAllowAutoUpdateSchema() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetIsAllowAutoUpdateSchema.validateNamespace(this.params);
            System.out.println(CmdNamespaces.this.getAdmin().namespaces().getIsAllowAutoUpdateSchema(namespace));
        }
    }

    @Parameters(commandDescription="Set the schema compatibility strategy for a namespace")
    private class SetSchemaCompatibilityStrategy
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;
        @Parameter(names={"--compatibility", "-c"}, description="Compatibility level required for new schemas created via a Producer. Possible values (FULL, BACKWARD, FORWARD, UNDEFINED, BACKWARD_TRANSITIVE, FORWARD_TRANSITIVE, FULL_TRANSITIVE, ALWAYS_INCOMPATIBLE,ALWAYS_COMPATIBLE).")
        private String strategyParam = null;

        private SetSchemaCompatibilityStrategy() {
        }

        @Override
        void run() throws PulsarAdminException {
            SchemaCompatibilityStrategy strategy;
            String namespace = SetSchemaCompatibilityStrategy.validateNamespace(this.params);
            String strategyStr = this.strategyParam != null ? this.strategyParam.toUpperCase() : "";
            try {
                strategy = SchemaCompatibilityStrategy.valueOf((String)strategyStr);
            }
            catch (IllegalArgumentException exception) {
                throw new ParameterException(String.format("Illegal schema compatibility strategy %s. Possible values: %s", strategyStr, Arrays.toString(SchemaCompatibilityStrategy.values())));
            }
            CmdNamespaces.this.getAdmin().namespaces().setSchemaCompatibilityStrategy(namespace, strategy);
        }
    }

    @Parameters(commandDescription="Get the schema compatibility strategy for a namespace")
    private class GetSchemaCompatibilityStrategy
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private GetSchemaCompatibilityStrategy() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetSchemaCompatibilityStrategy.validateNamespace(this.params);
            System.out.println(CmdNamespaces.this.getAdmin().namespaces().getSchemaCompatibilityStrategy(namespace).toString().toUpperCase());
        }
    }

    @Parameters(commandDescription="Set the schema auto-update strategy for a namespace", hidden=true)
    private class SetSchemaAutoUpdateStrategy
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;
        @Parameter(names={"--compatibility", "-c"}, description="Compatibility level required for new schemas created via a Producer. Possible values (Full, Backward, Forward).")
        private String strategyParam = null;
        @Parameter(names={"--disabled", "-d"}, description="Disable automatic schema updates")
        private boolean disabled = false;

        private SetSchemaAutoUpdateStrategy() {
        }

        @Override
        void run() throws PulsarAdminException {
            String strategyStr;
            String namespace = SetSchemaAutoUpdateStrategy.validateNamespace(this.params);
            SchemaAutoUpdateCompatibilityStrategy strategy = null;
            String string = strategyStr = this.strategyParam != null ? this.strategyParam.toUpperCase() : "";
            if (this.disabled) {
                strategy = SchemaAutoUpdateCompatibilityStrategy.AutoUpdateDisabled;
            } else if (strategyStr.equals("FULL")) {
                strategy = SchemaAutoUpdateCompatibilityStrategy.Full;
            } else if (strategyStr.equals("BACKWARD")) {
                strategy = SchemaAutoUpdateCompatibilityStrategy.Backward;
            } else if (strategyStr.equals("FORWARD")) {
                strategy = SchemaAutoUpdateCompatibilityStrategy.Forward;
            } else if (strategyStr.equals("NONE")) {
                strategy = SchemaAutoUpdateCompatibilityStrategy.AlwaysCompatible;
            } else {
                throw new PulsarAdminException("Either --compatibility or --disabled must be specified");
            }
            CmdNamespaces.this.getAdmin().namespaces().setSchemaAutoUpdateCompatibilityStrategy(namespace, strategy);
        }
    }

    @Parameters(commandDescription="Get the schema auto-update strategy for a namespace", hidden=true)
    private class GetSchemaAutoUpdateStrategy
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private GetSchemaAutoUpdateStrategy() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetSchemaAutoUpdateStrategy.validateNamespace(this.params);
            System.out.println(CmdNamespaces.this.getAdmin().namespaces().getSchemaAutoUpdateCompatibilityStrategy(namespace).toString().toUpperCase());
        }
    }

    @Parameters(commandDescription="Clear offloadDeletionLag for a namespace")
    private class ClearOffloadDeletionLag
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private ClearOffloadDeletionLag() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = ClearOffloadDeletionLag.validateNamespace(this.params);
            CmdNamespaces.this.getAdmin().namespaces().clearOffloadDeleteLag(namespace);
        }
    }

    @Parameters(commandDescription="Set offloadDeletionLag for a namespace")
    private class SetOffloadDeletionLag
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;
        @Parameter(names={"--lag", "-l"}, description="Duration to wait after offloading a ledger segment, before deleting the copy of that segment from cluster local storage. (eg: 10m, 5h, 3d, 2w).", required=true)
        private String lag = "-1";

        private SetOffloadDeletionLag() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetOffloadDeletionLag.validateNamespace(this.params);
            CmdNamespaces.this.getAdmin().namespaces().setOffloadDeleteLag(namespace, RelativeTimeUtil.parseRelativeTimeInSeconds((String)this.lag), TimeUnit.SECONDS);
        }
    }

    @Parameters(commandDescription="Get offloadDeletionLag, in minutes, for a namespace")
    private class GetOffloadDeletionLag
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private GetOffloadDeletionLag() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetOffloadDeletionLag.validateNamespace(this.params);
            Long lag = CmdNamespaces.this.getAdmin().namespaces().getOffloadDeleteLagMs(namespace);
            if (lag != null) {
                System.out.println(TimeUnit.MINUTES.convert(lag, TimeUnit.MILLISECONDS) + " minute(s)");
            } else {
                System.out.println("Unset for namespace. Defaulting to broker setting.");
            }
        }
    }

    @Parameters(commandDescription="Set offloadThreshold for a namespace")
    private class SetOffloadThreshold
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;
        @Parameter(names={"--size", "-s"}, description="Maximum number of bytes stored in the pulsar cluster for a topic before data will start being automatically offloaded to longterm storage (eg: 10M, 16G, 3T, 100). -1 falls back to the cluster's namespace default. Negative values disable automatic offload. 0 triggers offloading as soon as possible.", required=true)
        private String threshold = "-1";

        private SetOffloadThreshold() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetOffloadThreshold.validateNamespace(this.params);
            CmdNamespaces.this.getAdmin().namespaces().setOffloadThreshold(namespace, SetOffloadThreshold.validateSizeString(this.threshold));
        }
    }

    @Parameters(commandDescription="Get offloadThreshold for a namespace")
    private class GetOffloadThreshold
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private GetOffloadThreshold() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetOffloadThreshold.validateNamespace(this.params);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getOffloadThreshold(namespace));
        }
    }

    @Parameters(commandDescription="Set compactionThreshold for a namespace")
    private class SetCompactionThreshold
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;
        @Parameter(names={"--threshold", "-t"}, description="Maximum number of bytes in a topic backlog before compaction is triggered (eg: 10M, 16G, 3T). 0 disables automatic compaction", required=true)
        private String threshold = "0";

        private SetCompactionThreshold() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetCompactionThreshold.validateNamespace(this.params);
            CmdNamespaces.this.getAdmin().namespaces().setCompactionThreshold(namespace, SetCompactionThreshold.validateSizeString(this.threshold));
        }
    }

    @Parameters(commandDescription="Remove compactionThreshold for a namespace")
    private class RemoveCompactionThreshold
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private RemoveCompactionThreshold() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = RemoveCompactionThreshold.validateNamespace(this.params);
            CmdNamespaces.this.getAdmin().namespaces().removeCompactionThreshold(namespace);
        }
    }

    @Parameters(commandDescription="Get compactionThreshold for a namespace")
    private class GetCompactionThreshold
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private GetCompactionThreshold() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetCompactionThreshold.validateNamespace(this.params);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getCompactionThreshold(namespace));
        }
    }

    @Parameters(commandDescription="Remove maxUnackedMessagesPerSubscription for a namespace")
    private class RemoveMaxUnackedMessagesPerSubscription
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private RemoveMaxUnackedMessagesPerSubscription() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = RemoveMaxUnackedMessagesPerSubscription.validateNamespace(this.params);
            CmdNamespaces.this.getAdmin().namespaces().removeMaxUnackedMessagesPerSubscription(namespace);
        }
    }

    @Parameters(commandDescription="Set maxUnackedMessagesPerSubscription for a namespace")
    private class SetMaxUnackedMessagesPerSubscription
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;
        @Parameter(names={"--max-unacked-messages-per-subscription", "-c"}, description="maxUnackedMessagesPerSubscription for a namespace", required=true)
        private int maxUnackedMessagesPerSubscription;

        private SetMaxUnackedMessagesPerSubscription() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetMaxUnackedMessagesPerSubscription.validateNamespace(this.params);
            CmdNamespaces.this.getAdmin().namespaces().setMaxUnackedMessagesPerSubscription(namespace, this.maxUnackedMessagesPerSubscription);
        }
    }

    @Parameters(commandDescription="Get maxUnackedMessagesPerSubscription for a namespace")
    private class GetMaxUnackedMessagesPerSubscription
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private GetMaxUnackedMessagesPerSubscription() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetMaxUnackedMessagesPerSubscription.validateNamespace(this.params);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getMaxUnackedMessagesPerSubscription(namespace));
        }
    }

    @Parameters(commandDescription="Remove maxUnackedMessagesPerConsumer for a namespace")
    private class RemoveMaxUnackedMessagesPerConsumer
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private RemoveMaxUnackedMessagesPerConsumer() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = RemoveMaxUnackedMessagesPerConsumer.validateNamespace(this.params);
            CmdNamespaces.this.getAdmin().namespaces().removeMaxUnackedMessagesPerConsumer(namespace);
        }
    }

    @Parameters(commandDescription="Set maxUnackedMessagesPerConsumer for a namespace")
    private class SetMaxUnackedMessagesPerConsumer
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;
        @Parameter(names={"--max-unacked-messages-per-topic", "-c"}, description="maxUnackedMessagesPerConsumer for a namespace", required=true)
        private int maxUnackedMessagesPerConsumer;

        private SetMaxUnackedMessagesPerConsumer() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetMaxUnackedMessagesPerConsumer.validateNamespace(this.params);
            CmdNamespaces.this.getAdmin().namespaces().setMaxUnackedMessagesPerConsumer(namespace, this.maxUnackedMessagesPerConsumer);
        }
    }

    @Parameters(commandDescription="Get maxUnackedMessagesPerConsumer for a namespace")
    private class GetMaxUnackedMessagesPerConsumer
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private GetMaxUnackedMessagesPerConsumer() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetMaxUnackedMessagesPerConsumer.validateNamespace(this.params);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getMaxUnackedMessagesPerConsumer(namespace));
        }
    }

    @Parameters(commandDescription="Set maxConsumersPerSubscription for a namespace")
    private class SetMaxConsumersPerSubscription
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;
        @Parameter(names={"--max-consumers-per-subscription", "-c"}, description="maxConsumersPerSubscription for a namespace", required=true)
        private int maxConsumersPerSubscription;

        private SetMaxConsumersPerSubscription() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetMaxConsumersPerSubscription.validateNamespace(this.params);
            CmdNamespaces.this.getAdmin().namespaces().setMaxConsumersPerSubscription(namespace, this.maxConsumersPerSubscription);
        }
    }

    @Parameters(commandDescription="Remove maxConsumersPerSubscription for a namespace")
    private class RemoveMaxConsumersPerSubscription
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private RemoveMaxConsumersPerSubscription() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = RemoveMaxConsumersPerSubscription.validateNamespace(this.params);
            CmdNamespaces.this.getAdmin().namespaces().removeMaxConsumersPerSubscription(namespace);
        }
    }

    @Parameters(commandDescription="Get maxConsumersPerSubscription for a namespace")
    private class GetMaxConsumersPerSubscription
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private GetMaxConsumersPerSubscription() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetMaxConsumersPerSubscription.validateNamespace(this.params);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getMaxConsumersPerSubscription(namespace));
        }
    }

    @Parameters(commandDescription="Remove max consumers per topic for a namespace")
    private class RemoveMaxConsumersPerTopic
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private RemoveMaxConsumersPerTopic() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = RemoveMaxConsumersPerTopic.validateNamespace(this.params);
            CmdNamespaces.this.getAdmin().namespaces().removeMaxConsumersPerTopic(namespace);
        }
    }

    @Parameters(commandDescription="Set maxConsumersPerTopic for a namespace")
    private class SetMaxConsumersPerTopic
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;
        @Parameter(names={"--max-consumers-per-topic", "-c"}, description="maxConsumersPerTopic for a namespace", required=true)
        private int maxConsumersPerTopic;

        private SetMaxConsumersPerTopic() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetMaxConsumersPerTopic.validateNamespace(this.params);
            CmdNamespaces.this.getAdmin().namespaces().setMaxConsumersPerTopic(namespace, this.maxConsumersPerTopic);
        }
    }

    @Parameters(commandDescription="Get maxConsumersPerTopic for a namespace")
    private class GetMaxConsumersPerTopic
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private GetMaxConsumersPerTopic() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetMaxConsumersPerTopic.validateNamespace(this.params);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getMaxConsumersPerTopic(namespace));
        }
    }

    @Parameters(commandDescription="Set maxProducersPerTopic for a namespace")
    private class SetMaxProducersPerTopic
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;
        @Parameter(names={"--max-producers-per-topic", "-p"}, description="maxProducersPerTopic for a namespace", required=true)
        private int maxProducersPerTopic;

        private SetMaxProducersPerTopic() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetMaxProducersPerTopic.validateNamespace(this.params);
            CmdNamespaces.this.getAdmin().namespaces().setMaxProducersPerTopic(namespace, this.maxProducersPerTopic);
        }
    }

    @Parameters(commandDescription="Remove max producers per topic for a namespace")
    private class RemoveMaxProducersPerTopic
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private RemoveMaxProducersPerTopic() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = RemoveMaxProducersPerTopic.validateNamespace(this.params);
            CmdNamespaces.this.getAdmin().namespaces().removeMaxProducersPerTopic(namespace);
        }
    }

    @Parameters(commandDescription="Get maxProducersPerTopic for a namespace")
    private class GetMaxProducersPerTopic
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private GetMaxProducersPerTopic() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetMaxProducersPerTopic.validateNamespace(this.params);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getMaxProducersPerTopic(namespace));
        }
    }

    @Parameters(commandDescription="Set deduplicationSnapshotInterval for a namespace")
    private class SetDeduplicationSnapshotInterval
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;
        @Parameter(names={"--interval", "-i"}, description="deduplicationSnapshotInterval for a namespace", required=true)
        private int interval;

        private SetDeduplicationSnapshotInterval() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetDeduplicationSnapshotInterval.validateNamespace(this.params);
            CmdNamespaces.this.getAdmin().namespaces().setDeduplicationSnapshotInterval(namespace, Integer.valueOf(this.interval));
        }
    }

    @Parameters(commandDescription="Remove deduplicationSnapshotInterval for a namespace")
    private class RemoveDeduplicationSnapshotInterval
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private RemoveDeduplicationSnapshotInterval() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = RemoveDeduplicationSnapshotInterval.validateNamespace(this.params);
            CmdNamespaces.this.getAdmin().namespaces().removeDeduplicationSnapshotInterval(namespace);
        }
    }

    @Parameters(commandDescription="Get deduplicationSnapshotInterval for a namespace")
    private class GetDeduplicationSnapshotInterval
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private GetDeduplicationSnapshotInterval() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetDeduplicationSnapshotInterval.validateNamespace(this.params);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getDeduplicationSnapshotInterval(namespace));
        }
    }

    @Parameters(commandDescription="Get subscriptionAuthMod for a namespace")
    private class GetSubscriptionAuthMode
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private GetSubscriptionAuthMode() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetSubscriptionAuthMode.validateNamespace(this.params);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getSubscriptionAuthMode(namespace));
        }
    }

    @Parameters(commandDescription="Set subscription auth mode on a namespace")
    private class SetSubscriptionAuthMode
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;
        @Parameter(names={"-m", "--subscription-auth-mode"}, description="Subscription authorization mode for Pulsar policies. Valid options are: [None, Prefix]", required=true)
        private String mode;

        private SetSubscriptionAuthMode() {
        }

        @Override
        void run() throws Exception {
            String namespace = SetSubscriptionAuthMode.validateNamespace(this.params);
            CmdNamespaces.this.getAdmin().namespaces().setSubscriptionAuthMode(namespace, SubscriptionAuthMode.valueOf((String)this.mode));
        }
    }

    @Parameters(commandDescription="Set the delayed delivery policy on a namespace")
    private class SetDelayedDelivery
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;
        @Parameter(names={"--enable", "-e"}, description="Enable delayed delivery messages")
        private boolean enable = false;
        @Parameter(names={"--disable", "-d"}, description="Disable delayed delivery messages")
        private boolean disable = false;
        @Parameter(names={"--time", "-t"}, description="The tick time for when retrying on delayed delivery messages, affecting the accuracy of the delivery time compared to the scheduled time. (eg: 1s, 10s, 1m, 5h, 3d)")
        private String delayedDeliveryTimeStr = "1s";

        private SetDelayedDelivery() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetDelayedDelivery.validateNamespace(this.params);
            long delayedDeliveryTimeInMills = TimeUnit.SECONDS.toMillis(RelativeTimeUtil.parseRelativeTimeInSeconds((String)this.delayedDeliveryTimeStr));
            if (this.enable == this.disable) {
                throw new ParameterException("Need to specify either --enable or --disable");
            }
            CmdNamespaces.this.getAdmin().namespaces().setDelayedDeliveryMessages(namespace, DelayedDeliveryPolicies.builder().tickTime(delayedDeliveryTimeInMills).active(this.enable).build());
        }
    }

    @Parameters(commandDescription="Set the inactive topic policies on a namespace")
    private class SetInactiveTopicPolicies
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;
        @Parameter(names={"--enable-delete-while-inactive", "-e"}, description="Enable delete while inactive")
        private boolean enableDeleteWhileInactive = false;
        @Parameter(names={"--disable-delete-while-inactive", "-d"}, description="Disable delete while inactive")
        private boolean disableDeleteWhileInactive = false;
        @Parameter(names={"--max-inactive-duration", "-t"}, description="Max duration of topic inactivity in seconds,topics that are inactive for longer than this value will be deleted (eg: 1s, 10s, 1m, 5h, 3d)", required=true)
        private String deleteInactiveTopicsMaxInactiveDuration;
        @Parameter(names={"--delete-mode", "-m"}, description="Mode of delete inactive topic,Valid options are: [delete_when_no_subscriptions, delete_when_subscriptions_caught_up]", required=true)
        private String inactiveTopicDeleteMode;

        private SetInactiveTopicPolicies() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetInactiveTopicPolicies.validateNamespace(this.params);
            long maxInactiveDurationInSeconds = TimeUnit.SECONDS.toSeconds(RelativeTimeUtil.parseRelativeTimeInSeconds((String)this.deleteInactiveTopicsMaxInactiveDuration));
            if (this.enableDeleteWhileInactive == this.disableDeleteWhileInactive) {
                throw new ParameterException("Need to specify either enable-delete-while-inactive or disable-delete-while-inactive");
            }
            InactiveTopicDeleteMode deleteMode = null;
            try {
                deleteMode = InactiveTopicDeleteMode.valueOf((String)this.inactiveTopicDeleteMode);
            }
            catch (IllegalArgumentException e) {
                throw new ParameterException("delete mode can only be set to delete_when_no_subscriptions or delete_when_subscriptions_caught_up");
            }
            CmdNamespaces.this.getAdmin().namespaces().setInactiveTopicPolicies(namespace, new InactiveTopicPolicies(deleteMode, (int)maxInactiveDurationInSeconds, this.enableDeleteWhileInactive));
        }
    }

    @Parameters(commandDescription="Remove inactive topic policies from a namespace")
    private class RemoveInactiveTopicPolicies
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private RemoveInactiveTopicPolicies() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = RemoveInactiveTopicPolicies.validateNamespace(this.params);
            CmdNamespaces.this.getAdmin().namespaces().removeInactiveTopicPolicies(namespace);
        }
    }

    @Parameters(commandDescription="Get the inactive topic policy for a namespace")
    private class GetInactiveTopicPolicies
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private GetInactiveTopicPolicies() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetInactiveTopicPolicies.validateNamespace(this.params);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getInactiveTopicPolicies(namespace));
        }
    }

    @Parameters(commandDescription="Remove delayed delivery policies from a namespace")
    private class RemoveDelayedDelivery
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private RemoveDelayedDelivery() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = RemoveDelayedDelivery.validateNamespace(this.params);
            CmdNamespaces.this.getAdmin().namespaces().removeDelayedDeliveryMessages(namespace);
        }
    }

    @Parameters(commandDescription="Get the delayed delivery policy for a namespace")
    private class GetDelayedDelivery
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private GetDelayedDelivery() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetDelayedDelivery.validateNamespace(this.params);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getDelayedDelivery(namespace));
        }
    }

    @Parameters(commandDescription="Get encryption required for a namespace")
    private class GetEncryptionRequired
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private GetEncryptionRequired() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetEncryptionRequired.validateNamespace(this.params);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getEncryptionRequiredStatus(namespace));
        }
    }

    @Parameters(commandDescription="Enable or disable message encryption required for a namespace")
    private class SetEncryptionRequired
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;
        @Parameter(names={"--enable", "-e"}, description="Enable message encryption required")
        private boolean enable = false;
        @Parameter(names={"--disable", "-d"}, description="Disable message encryption required")
        private boolean disable = false;

        private SetEncryptionRequired() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetEncryptionRequired.validateNamespace(this.params);
            if (this.enable == this.disable) {
                throw new ParameterException("Need to specify either --enable or --disable");
            }
            CmdNamespaces.this.getAdmin().namespaces().setEncryptionRequiredStatus(namespace, this.enable);
        }
    }

    @Parameters(commandDescription="Unsubscribe the given subscription on all topics on a namespace")
    private class Unsubscribe
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;
        @Parameter(names={"--sub", "-s"}, description="subscription name", required=true)
        private String subscription;
        @Parameter(names={"--bundle", "-b"}, description="{start-boundary}_{end-boundary}")
        private String bundle;

        private Unsubscribe() {
        }

        @Override
        void run() throws Exception {
            String namespace = Unsubscribe.validateNamespace(this.params);
            if (this.bundle != null) {
                CmdNamespaces.this.getAdmin().namespaces().unsubscribeNamespaceBundle(namespace, this.bundle, this.subscription);
            } else {
                CmdNamespaces.this.getAdmin().namespaces().unsubscribeNamespace(namespace, this.subscription);
            }
        }
    }

    @Parameters(commandDescription="Clear backlog for a namespace")
    private class ClearBacklog
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;
        @Parameter(names={"--sub", "-s"}, description="subscription name")
        private String subscription;
        @Parameter(names={"--bundle", "-b"}, description="{start-boundary}_{end-boundary}")
        private String bundle;
        @Parameter(names={"--force", "-force"}, description="Whether to force clear backlog without prompt")
        private boolean force;

        private ClearBacklog() {
        }

        @Override
        void run() throws PulsarAdminException, IOException {
            String prompt;
            boolean confirm;
            if (!this.force && !(confirm = IOUtils.confirmPrompt(prompt = "Are you sure you want to clear the backlog?"))) {
                return;
            }
            String namespace = ClearBacklog.validateNamespace(this.params);
            if (this.subscription != null && this.bundle != null) {
                CmdNamespaces.this.getAdmin().namespaces().clearNamespaceBundleBacklogForSubscription(namespace, this.bundle, this.subscription);
            } else if (this.subscription != null) {
                CmdNamespaces.this.getAdmin().namespaces().clearNamespaceBacklogForSubscription(namespace, this.subscription);
            } else if (this.bundle != null) {
                CmdNamespaces.this.getAdmin().namespaces().clearNamespaceBundleBacklog(namespace, this.bundle);
            } else {
                CmdNamespaces.this.getAdmin().namespaces().clearNamespaceBacklog(namespace);
            }
        }
    }

    @Parameters(commandDescription="Set the persistence policies for a namespace")
    private class SetPersistence
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;
        @Parameter(names={"-e", "--bookkeeper-ensemble"}, description="Number of bookies to use for a topic", required=true)
        private int bookkeeperEnsemble;
        @Parameter(names={"-w", "--bookkeeper-write-quorum"}, description="How many writes to make of each entry", required=true)
        private int bookkeeperWriteQuorum;
        @Parameter(names={"-a", "--bookkeeper-ack-quorum"}, description="Number of acks (guaranteed copies) to wait for each entry", required=true)
        private int bookkeeperAckQuorum;
        @Parameter(names={"-r", "--ml-mark-delete-max-rate"}, description="Throttling rate of mark-delete operation (0 means no throttle)", required=true)
        private double managedLedgerMaxMarkDeleteRate;

        private SetPersistence() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetPersistence.validateNamespace(this.params);
            CmdNamespaces.this.getAdmin().namespaces().setPersistence(namespace, new PersistencePolicies(this.bookkeeperEnsemble, this.bookkeeperWriteQuorum, this.bookkeeperAckQuorum, this.managedLedgerMaxMarkDeleteRate));
        }
    }

    @Parameters(commandDescription="Remove the persistence policies for a namespace")
    private class RemovePersistence
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private RemovePersistence() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = RemovePersistence.validateNamespace(this.params);
            CmdNamespaces.this.getAdmin().namespaces().removePersistence(namespace);
        }
    }

    @Parameters(commandDescription="Get the persistence policies for a namespace")
    private class GetPersistence
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private GetPersistence() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetPersistence.validateNamespace(this.params);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getPersistence(namespace));
        }
    }

    @Parameters(commandDescription="Remove a backlog quota policy from a namespace")
    private class RemoveBacklogQuota
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;
        @Parameter(names={"-t", "--type"}, description="Backlog quota type to remove. Valid options are: destination_storage, message_age")
        private String backlogQuotaTypeStr = BacklogQuota.BacklogQuotaType.destination_storage.name();

        private RemoveBacklogQuota() {
        }

        @Override
        void run() throws PulsarAdminException {
            BacklogQuota.BacklogQuotaType backlogQuotaType;
            String namespace = RemoveBacklogQuota.validateNamespace(this.params);
            try {
                backlogQuotaType = BacklogQuota.BacklogQuotaType.valueOf((String)this.backlogQuotaTypeStr);
            }
            catch (IllegalArgumentException e) {
                throw new ParameterException(String.format("Invalid backlog quota type '%s'. Valid options are: %s", this.backlogQuotaTypeStr, Arrays.toString(BacklogQuota.BacklogQuotaType.values())));
            }
            CmdNamespaces.this.getAdmin().namespaces().removeBacklogQuota(namespace, backlogQuotaType);
        }
    }

    @Parameters(commandDescription="Set a backlog quota policy for a namespace")
    private class SetBacklogQuota
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;
        @Parameter(names={"-l", "--limit"}, description="Size limit (eg: 10M, 16G)", required=true)
        private String limitStr;
        @Parameter(names={"-lt", "--limitTime"}, description="Time limit in second, non-positive number for disabling time limit.")
        private int limitTime = -1;
        @Parameter(names={"-p", "--policy"}, description="Retention policy to enforce when the limit is reached. Valid options are: [producer_request_hold, producer_exception, consumer_backlog_eviction]", required=true)
        private String policyStr;
        @Parameter(names={"-t", "--type"}, description="Backlog quota type to set. Valid options are: destination_storage, message_age")
        private String backlogQuotaTypeStr = BacklogQuota.BacklogQuotaType.destination_storage.name();

        private SetBacklogQuota() {
        }

        @Override
        void run() throws PulsarAdminException {
            BacklogQuota.BacklogQuotaType backlogQuotaType;
            long limit;
            BacklogQuota.RetentionPolicy policy;
            try {
                policy = BacklogQuota.RetentionPolicy.valueOf((String)this.policyStr);
            }
            catch (IllegalArgumentException e) {
                throw new ParameterException(String.format("Invalid retention policy type '%s'. Valid options are: %s", this.policyStr, Arrays.toString(BacklogQuota.RetentionPolicy.values())));
            }
            try {
                limit = SetBacklogQuota.validateSizeString(this.limitStr);
            }
            catch (IllegalArgumentException e) {
                throw new ParameterException(String.format("Invalid retention policy type '%s'. Valid formats are: %s", this.limitStr, "(4096, 100K, 10M, 16G, 2T)"));
            }
            try {
                backlogQuotaType = BacklogQuota.BacklogQuotaType.valueOf((String)this.backlogQuotaTypeStr);
            }
            catch (IllegalArgumentException e) {
                throw new ParameterException(String.format("Invalid backlog quota type '%s'. Valid options are: %s", this.backlogQuotaTypeStr, Arrays.toString(BacklogQuota.BacklogQuotaType.values())));
            }
            String namespace = SetBacklogQuota.validateNamespace(this.params);
            CmdNamespaces.this.getAdmin().namespaces().setBacklogQuota(namespace, BacklogQuota.builder().limitSize(limit).limitTime(this.limitTime).retentionPolicy(policy).build(), backlogQuotaType);
        }
    }

    @Parameters(commandDescription="Get the backlog quota policies for a namespace")
    private class GetBacklogQuotaMap
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private GetBacklogQuotaMap() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetBacklogQuotaMap.validateNamespace(this.params);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getBacklogQuotaMap(namespace));
        }
    }

    @Parameters(commandDescription="Remove replicator configured message-dispatch-rate for all topics of the namespace")
    private class RemoveReplicatorDispatchRate
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private RemoveReplicatorDispatchRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = RemoveReplicatorDispatchRate.validateNamespace(this.params);
            CmdNamespaces.this.getAdmin().namespaces().removeReplicatorDispatchRate(namespace);
        }
    }

    @Parameters(commandDescription="Get replicator configured message-dispatch-rate for all topics of the namespace (Disabled if value < 0)")
    private class GetReplicatorDispatchRate
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private GetReplicatorDispatchRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetReplicatorDispatchRate.validateNamespace(this.params);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getReplicatorDispatchRate(namespace));
        }
    }

    @Parameters(commandDescription="Set replicator message-dispatch-rate for all topics of the namespace")
    private class SetReplicatorDispatchRate
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;
        @Parameter(names={"--msg-dispatch-rate", "-md"}, description="message-dispatch-rate (default -1 will be overwrite if not passed)", required=false)
        private int msgDispatchRate = -1;
        @Parameter(names={"--byte-dispatch-rate", "-bd"}, description="byte-dispatch-rate (default -1 will be overwrite if not passed)", required=false)
        private long byteDispatchRate = -1L;
        @Parameter(names={"--dispatch-rate-period", "-dt"}, description="dispatch-rate-period in second type (default 1 second will be overwrite if not passed)", required=false)
        private int dispatchRatePeriodSec = 1;

        private SetReplicatorDispatchRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetReplicatorDispatchRate.validateNamespace(this.params);
            CmdNamespaces.this.getAdmin().namespaces().setReplicatorDispatchRate(namespace, DispatchRate.builder().dispatchThrottlingRateInMsg(this.msgDispatchRate).dispatchThrottlingRateInByte(this.byteDispatchRate).ratePeriodInSecond(this.dispatchRatePeriodSec).build());
        }
    }

    @Parameters(commandDescription="Get configured message-publish-rate for all topics of the namespace (Disabled if value < 0)")
    private class GetPublishRate
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private GetPublishRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetPublishRate.validateNamespace(this.params);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getPublishRate(namespace));
        }
    }

    @Parameters(commandDescription="Remove publish-rate for all topics of the namespace")
    private class RemovePublishRate
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private RemovePublishRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = RemovePublishRate.validateNamespace(this.params);
            CmdNamespaces.this.getAdmin().namespaces().removePublishRate(namespace);
        }
    }

    @Parameters(commandDescription="Set publish-rate for all topics of the namespace")
    private class SetPublishRate
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;
        @Parameter(names={"--msg-publish-rate", "-m"}, description="message-publish-rate (default -1 will be overwrite if not passed)", required=false)
        private int msgPublishRate = -1;
        @Parameter(names={"--byte-publish-rate", "-b"}, description="byte-publish-rate (default -1 will be overwrite if not passed)", required=false)
        private long bytePublishRate = -1L;

        private SetPublishRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetPublishRate.validateNamespace(this.params);
            CmdNamespaces.this.getAdmin().namespaces().setPublishRate(namespace, new PublishRate(this.msgPublishRate, this.bytePublishRate));
        }
    }

    @Parameters(commandDescription="Get subscription configured message-dispatch-rate for all topics of the namespace (Disabled if value < 0)")
    private class GetSubscriptionDispatchRate
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private GetSubscriptionDispatchRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetSubscriptionDispatchRate.validateNamespace(this.params);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getSubscriptionDispatchRate(namespace));
        }
    }

    @Parameters(commandDescription="Remove subscription configured message-dispatch-rate for all topics of the namespace")
    private class RemoveSubscriptionDispatchRate
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private RemoveSubscriptionDispatchRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = RemoveSubscriptionDispatchRate.validateNamespace(this.params);
            CmdNamespaces.this.getAdmin().namespaces().removeSubscriptionDispatchRate(namespace);
        }
    }

    @Parameters(commandDescription="Set subscription message-dispatch-rate for all subscription of the namespace")
    private class SetSubscriptionDispatchRate
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;
        @Parameter(names={"--msg-dispatch-rate", "-md"}, description="message-dispatch-rate (default -1 will be overwrite if not passed)", required=false)
        private int msgDispatchRate = -1;
        @Parameter(names={"--byte-dispatch-rate", "-bd"}, description="byte-dispatch-rate (default -1 will be overwrite if not passed)", required=false)
        private long byteDispatchRate = -1L;
        @Parameter(names={"--dispatch-rate-period", "-dt"}, description="dispatch-rate-period in second type (default 1 second will be overwrite if not passed)", required=false)
        private int dispatchRatePeriodSec = 1;
        @Parameter(names={"--relative-to-publish-rate", "-rp"}, description="dispatch rate relative to publish-rate (if publish-relative flag is enabled then broker will apply throttling value to (publish-rate + dispatch rate))", required=false)
        private boolean relativeToPublishRate = false;

        private SetSubscriptionDispatchRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetSubscriptionDispatchRate.validateNamespace(this.params);
            CmdNamespaces.this.getAdmin().namespaces().setSubscriptionDispatchRate(namespace, DispatchRate.builder().dispatchThrottlingRateInMsg(this.msgDispatchRate).dispatchThrottlingRateInByte(this.byteDispatchRate).ratePeriodInSecond(this.dispatchRatePeriodSec).relativeToPublishRate(this.relativeToPublishRate).build());
        }
    }

    @Parameters(commandDescription="Remove configured subscribe-rate per consumer for all topics of the namespace")
    private class RemoveSubscribeRate
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private RemoveSubscribeRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = RemoveSubscribeRate.validateNamespace(this.params);
            CmdNamespaces.this.getAdmin().namespaces().removeSubscribeRate(namespace);
        }
    }

    @Parameters(commandDescription="Get configured subscribe-rate per consumer for all topics of the namespace")
    private class GetSubscribeRate
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private GetSubscribeRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetSubscribeRate.validateNamespace(this.params);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getSubscribeRate(namespace));
        }
    }

    @Parameters(commandDescription="Set subscribe-rate per consumer for all topics of the namespace")
    private class SetSubscribeRate
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;
        @Parameter(names={"--subscribe-rate", "-sr"}, description="subscribe-rate (default -1 will be overwrite if not passed)", required=false)
        private int subscribeRate = -1;
        @Parameter(names={"--subscribe-rate-period", "-st"}, description="subscribe-rate-period in second type (default 30 second will be overwrite if not passed)", required=false)
        private int subscribeRatePeriodSec = 30;

        private SetSubscribeRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetSubscribeRate.validateNamespace(this.params);
            CmdNamespaces.this.getAdmin().namespaces().setSubscribeRate(namespace, new SubscribeRate(this.subscribeRate, this.subscribeRatePeriodSec));
        }
    }

    @Parameters(commandDescription="Get configured message-dispatch-rate for all topics of the namespace (Disabled if value < 0)")
    private class GetDispatchRate
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private GetDispatchRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetDispatchRate.validateNamespace(this.params);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getDispatchRate(namespace));
        }
    }

    @Parameters(commandDescription="Remove configured message-dispatch-rate for all topics of the namespace")
    private class RemoveDispatchRate
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private RemoveDispatchRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = RemoveDispatchRate.validateNamespace(this.params);
            CmdNamespaces.this.getAdmin().namespaces().removeDispatchRate(namespace);
        }
    }

    @Parameters(commandDescription="Set message-dispatch-rate for all topics of the namespace")
    private class SetDispatchRate
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;
        @Parameter(names={"--msg-dispatch-rate", "-md"}, description="message-dispatch-rate (default -1 will be overwrite if not passed)", required=false)
        private int msgDispatchRate = -1;
        @Parameter(names={"--byte-dispatch-rate", "-bd"}, description="byte-dispatch-rate (default -1 will be overwrite if not passed)", required=false)
        private long byteDispatchRate = -1L;
        @Parameter(names={"--dispatch-rate-period", "-dt"}, description="dispatch-rate-period in second type (default 1 second will be overwrite if not passed)", required=false)
        private int dispatchRatePeriodSec = 1;
        @Parameter(names={"--relative-to-publish-rate", "-rp"}, description="dispatch rate relative to publish-rate (if publish-relative flag is enabled then broker will apply throttling value to (publish-rate + dispatch rate))", required=false)
        private boolean relativeToPublishRate = false;

        private SetDispatchRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetDispatchRate.validateNamespace(this.params);
            CmdNamespaces.this.getAdmin().namespaces().setDispatchRate(namespace, DispatchRate.builder().dispatchThrottlingRateInMsg(this.msgDispatchRate).dispatchThrottlingRateInByte(this.byteDispatchRate).ratePeriodInSecond(this.dispatchRatePeriodSec).relativeToPublishRate(this.relativeToPublishRate).build());
        }
    }

    @Parameters(commandDescription="Split a namespace-bundle from the current serving broker")
    private class SplitBundle
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;
        @Parameter(names={"--bundle", "-b"}, description="{start-boundary}_{end-boundary} (mutually exclusive with --bundle-type)", required=false)
        private String bundle;
        @Parameter(names={"--bundle-type", "-bt"}, description="bundle type (mutually exclusive with --bundle)", required=false)
        private Policies.BundleType bundleType;
        @Parameter(names={"--unload", "-u"}, description="Unload newly split bundles after splitting old bundle", required=false)
        private boolean unload;
        @Parameter(names={"--split-algorithm-name", "-san"}, description="Algorithm name for split namespace bundle. Valid options are: [range_equally_divide, topic_count_equally_divide]. Use broker side config if absent", required=false)
        private String splitAlgorithmName;

        private SplitBundle() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SplitBundle.validateNamespace(this.params);
            if (StringUtils.isBlank((CharSequence)this.bundle) && this.bundleType == null) {
                throw new ParameterException("Must pass one of the params: --bundle / --bundle-type");
            }
            if (StringUtils.isNotBlank((CharSequence)this.bundle) && this.bundleType != null) {
                throw new ParameterException("--bundle and --bundle-type are mutually exclusive");
            }
            this.bundle = this.bundleType != null ? this.bundleType.toString() : this.bundle;
            CmdNamespaces.this.getAdmin().namespaces().splitNamespaceBundle(namespace, this.bundle, this.unload, this.splitAlgorithmName);
        }
    }

    @Parameters(commandDescription="Unload a namespace from the current serving broker")
    private class Unload
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;
        @Parameter(names={"--bundle", "-b"}, description="{start-boundary}_{end-boundary}")
        private String bundle;

        private Unload() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = Unload.validateNamespace(this.params);
            if (this.bundle == null) {
                CmdNamespaces.this.getAdmin().namespaces().unload(namespace);
            } else {
                CmdNamespaces.this.getAdmin().namespaces().unloadNamespaceBundle(namespace, this.bundle);
            }
        }
    }

    @Parameters(commandDescription="Get subscription expiration time for a namespace")
    private class GetSubscriptionExpirationTime
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private GetSubscriptionExpirationTime() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetSubscriptionExpirationTime.validateNamespace(this.params);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getSubscriptionExpirationTime(namespace));
        }
    }

    @Parameters(commandDescription="Get message TTL for a namespace")
    private class GetMessageTTL
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private GetMessageTTL() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetMessageTTL.validateNamespace(this.params);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getNamespaceMessageTTL(namespace));
        }
    }

    @Parameters(commandDescription="Get the bookie-affinity group name")
    private class GetBookieAffinityGroup
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private GetBookieAffinityGroup() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetBookieAffinityGroup.validateNamespace(this.params);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getBookieAffinityGroup(namespace));
        }
    }

    @Parameters(commandDescription="Set the bookie-affinity group name")
    private class DeleteBookieAffinityGroup
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private DeleteBookieAffinityGroup() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = DeleteBookieAffinityGroup.validateNamespace(this.params);
            CmdNamespaces.this.getAdmin().namespaces().deleteBookieAffinityGroup(namespace);
        }
    }

    @Parameters(commandDescription="Set the bookie-affinity group name")
    private class SetBookieAffinityGroup
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;
        @Parameter(names={"--primary-group", "-pg"}, description="Bookie-affinity primary-groups (comma separated) name where namespace messages should be written", required=true)
        private String bookieAffinityGroupNamePrimary;
        @Parameter(names={"--secondary-group", "-sg"}, description="Bookie-affinity secondary-group (comma separated) name where namespace messages should be written. If you want to verify whether there are enough bookies in groups, use `--secondary-group` flag. Messages in this namespace are stored in secondary groups. If a group does not contain enough bookies, a topic cannot be created.", required=false)
        private String bookieAffinityGroupNameSecondary;

        private SetBookieAffinityGroup() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetBookieAffinityGroup.validateNamespace(this.params);
            CmdNamespaces.this.getAdmin().namespaces().setBookieAffinityGroup(namespace, BookieAffinityGroupData.builder().bookkeeperAffinityGroupPrimary(this.bookieAffinityGroupNamePrimary).bookkeeperAffinityGroupSecondary(this.bookieAffinityGroupNameSecondary).build());
        }
    }

    @Parameters(commandDescription="Get the retention policy for a namespace")
    private class GetRetention
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private GetRetention() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetRetention.validateNamespace(this.params);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getRetention(namespace));
        }
    }

    @Parameters(commandDescription="Set the retention policy for a namespace")
    private class SetRetention
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;
        @Parameter(names={"--time", "-t"}, description="Retention time in minutes (or minutes, hours,days,weeks eg: 100m, 3h, 2d, 5w). 0 means no retention and -1 means infinite time retention", required=true)
        private String retentionTimeStr;
        @Parameter(names={"--size", "-s"}, description="Retention size limit (eg: 10M, 16G, 3T). 0 or less than 1MB means no retention and -1 means infinite size retention", required=true)
        private String limitStr;

        private SetRetention() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetRetention.validateNamespace(this.params);
            long sizeLimit = SetRetention.validateSizeString(this.limitStr);
            long retentionTimeInSec = RelativeTimeUtil.parseRelativeTimeInSeconds((String)this.retentionTimeStr);
            int retentionTimeInMin = retentionTimeInSec != -1L ? (int)TimeUnit.SECONDS.toMinutes(retentionTimeInSec) : -1;
            int retentionSizeInMB = sizeLimit != -1L ? (int)(sizeLimit / 0x100000L) : -1;
            CmdNamespaces.this.getAdmin().namespaces().setRetention(namespace, new RetentionPolicies(retentionTimeInMin, retentionSizeInMB));
        }
    }

    @Parameters(commandDescription="Remove the retention policy for a namespace")
    private class RemoveRetention
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private RemoveRetention() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = RemoveRetention.validateNamespace(this.params);
            CmdNamespaces.this.getAdmin().namespaces().removeRetention(namespace);
        }
    }

    @Parameters(commandDescription="Remove override of autoSubscriptionCreation for a namespace")
    private class RemoveAutoSubscriptionCreation
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private RemoveAutoSubscriptionCreation() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = RemoveAutoSubscriptionCreation.validateNamespace(this.params);
            CmdNamespaces.this.getAdmin().namespaces().removeAutoSubscriptionCreation(namespace);
        }
    }

    @Parameters(commandDescription="Get the autoSubscriptionCreation for a namespace")
    private class GetAutoSubscriptionCreation
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private GetAutoSubscriptionCreation() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetAutoSubscriptionCreation.validateNamespace(this.params);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getAutoSubscriptionCreation(namespace));
        }
    }

    @Parameters(commandDescription="Enable autoSubscriptionCreation for a namespace, overriding broker settings")
    private class SetAutoSubscriptionCreation
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;
        @Parameter(names={"--enable", "-e"}, description="Enable allowAutoSubscriptionCreation on namespace")
        private boolean enable = false;

        private SetAutoSubscriptionCreation() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetAutoSubscriptionCreation.validateNamespace(this.params);
            CmdNamespaces.this.getAdmin().namespaces().setAutoSubscriptionCreation(namespace, AutoSubscriptionCreationOverride.builder().allowAutoSubscriptionCreation(this.enable).build());
        }
    }

    @Parameters(commandDescription="Remove override of autoTopicCreation for a namespace")
    private class RemoveAutoTopicCreation
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private RemoveAutoTopicCreation() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = RemoveAutoTopicCreation.validateNamespace(this.params);
            CmdNamespaces.this.getAdmin().namespaces().removeAutoTopicCreation(namespace);
        }
    }

    @Parameters(commandDescription="Get autoTopicCreation info for a namespace")
    private class GetAutoTopicCreation
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private GetAutoTopicCreation() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetAutoTopicCreation.validateNamespace(this.params);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getAutoTopicCreation(namespace));
        }
    }

    @Parameters(commandDescription="Enable or disable autoTopicCreation for a namespace, overriding broker settings")
    private class SetAutoTopicCreation
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;
        @Parameter(names={"--enable", "-e"}, description="Enable allowAutoTopicCreation on namespace")
        private boolean enable = false;
        @Parameter(names={"--disable", "-d"}, description="Disable allowAutoTopicCreation on namespace")
        private boolean disable = false;
        @Parameter(names={"--type", "-t"}, description="Type of topic to be auto-created. Possible values: (partitioned, non-partitioned). Default value: non-partitioned")
        private String type = "non-partitioned";
        @Parameter(names={"--num-partitions", "-n"}, description="Default number of partitions of topic to be auto-created, applicable to partitioned topics only", required=false)
        private Integer defaultNumPartitions = null;

        private SetAutoTopicCreation() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetAutoTopicCreation.validateNamespace(this.params);
            this.type = this.type.toLowerCase().trim();
            if (this.enable == this.disable) {
                throw new ParameterException("Need to specify either --enable or --disable");
            }
            if (this.enable) {
                if (!TopicType.isValidTopicType((String)this.type)) {
                    throw new ParameterException("Must specify type of topic to be created. Possible values: (partitioned, non-partitioned)");
                }
                if (TopicType.PARTITIONED.toString().equals(this.type) && (this.defaultNumPartitions == null || this.defaultNumPartitions <= 0)) {
                    throw new ParameterException("Must specify num-partitions or num-partitions > 0 for partitioned topic type.");
                }
            }
            CmdNamespaces.this.getAdmin().namespaces().setAutoTopicCreation(namespace, AutoTopicCreationOverride.builder().allowAutoTopicCreation(this.enable).topicType(this.type).defaultNumPartitions(this.defaultNumPartitions).build());
        }
    }

    @Parameters(commandDescription="Enable or disable deduplication for a namespace")
    private class SetDeduplication
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;
        @Parameter(names={"--enable", "-e"}, description="Enable deduplication")
        private boolean enable = false;
        @Parameter(names={"--disable", "-d"}, description="Disable deduplication")
        private boolean disable = false;

        private SetDeduplication() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetDeduplication.validateNamespace(this.params);
            if (this.enable == this.disable) {
                throw new ParameterException("Need to specify either --enable or --disable");
            }
            CmdNamespaces.this.getAdmin().namespaces().setDeduplicationStatus(namespace, this.enable);
        }
    }

    @Parameters(commandDescription="Remove Deduplication for a namespace")
    private class RemoveDeduplication
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private RemoveDeduplication() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = RemoveDeduplication.validateNamespace(this.params);
            CmdNamespaces.this.getAdmin().namespaces().removeDeduplicationStatus(namespace);
        }
    }

    @Parameters(commandDescription="Get Deduplication for a namespace")
    private class GetDeduplication
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private GetDeduplication() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetDeduplication.validateNamespace(this.params);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getDeduplicationStatus(namespace));
        }
    }

    @Parameters(commandDescription="Remove Anti-affinity group name for a namespace")
    private class DeleteAntiAffinityGroup
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private DeleteAntiAffinityGroup() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = DeleteAntiAffinityGroup.validateNamespace(this.params);
            CmdNamespaces.this.getAdmin().namespaces().deleteNamespaceAntiAffinityGroup(namespace);
        }
    }

    @Parameters(commandDescription="Get Anti-affinity namespaces grouped with the given anti-affinity group name")
    private class GetAntiAffinityNamespaces
    extends CliCommand {
        @Parameter(names={"--tenant", "-p"}, description="tenant is only used for authorization. Client has to be admin of any of the tenant to access this api", required=false)
        private String tenant;
        @Parameter(names={"--cluster", "-c"}, description="Cluster name", required=true)
        private String cluster;
        @Parameter(names={"--group", "-g"}, description="Anti-affinity group name", required=true)
        private String antiAffinityGroup;

        private GetAntiAffinityNamespaces() {
        }

        @Override
        void run() throws PulsarAdminException {
            this.print(CmdNamespaces.this.getAdmin().namespaces().getAntiAffinityNamespaces(this.tenant, this.cluster, this.antiAffinityGroup));
        }
    }

    @Parameters(commandDescription="Get Anti-affinity group name for a namespace")
    private class GetAntiAffinityGroup
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private GetAntiAffinityGroup() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetAntiAffinityGroup.validateNamespace(this.params);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getNamespaceAntiAffinityGroup(namespace));
        }
    }

    @Parameters(commandDescription="Set Anti-affinity group name for a namespace")
    private class SetAntiAffinityGroup
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;
        @Parameter(names={"--group", "-g"}, description="Anti-affinity group name", required=true)
        private String antiAffinityGroup;

        private SetAntiAffinityGroup() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetAntiAffinityGroup.validateNamespace(this.params);
            CmdNamespaces.this.getAdmin().namespaces().setNamespaceAntiAffinityGroup(namespace, this.antiAffinityGroup);
        }
    }

    @Parameters(commandDescription="Remove subscription expiration time for a namespace")
    private class RemoveSubscriptionExpirationTime
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private RemoveSubscriptionExpirationTime() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = RemoveSubscriptionExpirationTime.validateNamespace(this.params);
            CmdNamespaces.this.getAdmin().namespaces().removeSubscriptionExpirationTime(namespace);
        }
    }

    @Parameters(commandDescription="Set subscription expiration time for a namespace")
    private class SetSubscriptionExpirationTime
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;
        @Parameter(names={"-t", "--time"}, description="Subscription expiration time in minutes", required=true)
        private int expirationTime;

        private SetSubscriptionExpirationTime() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetSubscriptionExpirationTime.validateNamespace(this.params);
            CmdNamespaces.this.getAdmin().namespaces().setSubscriptionExpirationTime(namespace, this.expirationTime);
        }
    }

    @Parameters(commandDescription="Remove max subscriptions per topic for a namespace")
    private class RemoveMaxSubscriptionsPerTopic
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private RemoveMaxSubscriptionsPerTopic() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = RemoveMaxSubscriptionsPerTopic.validateNamespace(this.params);
            CmdNamespaces.this.getAdmin().namespaces().removeMaxSubscriptionsPerTopic(namespace);
        }
    }

    @Parameters(commandDescription="Set max subscriptions per topic for a namespace")
    private class SetMaxSubscriptionsPerTopic
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;
        @Parameter(names={"--max-subscriptions-per-topic", "-m"}, description="Max subscriptions per topic", required=true)
        private int maxSubscriptionsPerTopic;

        private SetMaxSubscriptionsPerTopic() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetMaxSubscriptionsPerTopic.validateNamespace(this.params);
            CmdNamespaces.this.getAdmin().namespaces().setMaxSubscriptionsPerTopic(namespace, this.maxSubscriptionsPerTopic);
        }
    }

    @Parameters(commandDescription="Get max subscriptions per topic for a namespace")
    private class GetMaxSubscriptionsPerTopic
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private GetMaxSubscriptionsPerTopic() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetMaxSubscriptionsPerTopic.validateNamespace(this.params);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getMaxSubscriptionsPerTopic(namespace));
        }
    }

    @Parameters(commandDescription="Remove Message TTL for a namespace")
    private class RemoveMessageTTL
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private RemoveMessageTTL() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = RemoveMessageTTL.validateNamespace(this.params);
            CmdNamespaces.this.getAdmin().namespaces().removeNamespaceMessageTTL(namespace);
        }
    }

    @Parameters(commandDescription="Set Message TTL for a namespace")
    private class SetMessageTTL
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;
        @Parameter(names={"--messageTTL", "-ttl"}, description="Message TTL in seconds. When the value is set to `0`, TTL is disabled.", required=true)
        private int messageTTL;

        private SetMessageTTL() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetMessageTTL.validateNamespace(this.params);
            CmdNamespaces.this.getAdmin().namespaces().setNamespaceMessageTTL(namespace, this.messageTTL);
        }
    }

    @Parameters(commandDescription="Remove subscription types enabled for a namespace")
    private class RemoveSubscriptionTypesEnabled
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private RemoveSubscriptionTypesEnabled() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = RemoveSubscriptionTypesEnabled.validateNamespace(this.params);
            CmdNamespaces.this.getAdmin().namespaces().removeSubscriptionTypesEnabled(namespace);
        }
    }

    @Parameters(commandDescription="Get subscription types enabled for a namespace")
    private class GetSubscriptionTypesEnabled
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private GetSubscriptionTypesEnabled() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetSubscriptionTypesEnabled.validateNamespace(this.params);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getSubscriptionTypesEnabled(namespace));
        }
    }

    @Parameters(commandDescription="Set subscription types enabled for a namespace")
    private class SetSubscriptionTypesEnabled
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;
        @Parameter(names={"--types", "-t"}, description="Subscription types enabled list (comma separated values). Possible values: (Exclusive, Shared, Failover, Key_Shared).", required=true)
        private List<String> subTypes;

        private SetSubscriptionTypesEnabled() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetSubscriptionTypesEnabled.validateNamespace(this.params);
            HashSet types = new HashSet();
            this.subTypes.forEach(s -> {
                SubscriptionType subType;
                try {
                    subType = SubscriptionType.valueOf((String)s);
                }
                catch (IllegalArgumentException exception) {
                    throw new ParameterException(String.format("Illegal subscription type %s. Possible values: %s.", s, Arrays.toString(SubscriptionType.values())));
                }
                types.add(subType);
            });
            CmdNamespaces.this.getAdmin().namespaces().setSubscriptionTypesEnabled(namespace, types);
        }
    }

    @Parameters(commandDescription="Get replication clusters for a namespace")
    private class GetReplicationClusters
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private GetReplicationClusters() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetReplicationClusters.validateNamespace(this.params);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getNamespaceReplicationClusters(namespace));
        }
    }

    @Parameters(commandDescription="Set replication clusters for a namespace")
    private class SetReplicationClusters
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;
        @Parameter(names={"--clusters", "-c"}, description="Replication Cluster Ids list (comma separated values)", required=true)
        private String clusterIds;

        private SetReplicationClusters() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SetReplicationClusters.validateNamespace(this.params);
            ArrayList clusters = Lists.newArrayList((Object[])this.clusterIds.split(","));
            CmdNamespaces.this.getAdmin().namespaces().setNamespaceReplicationClusters(namespace, (Set)Sets.newHashSet((Iterable)clusters));
        }
    }

    @Parameters(commandDescription="Get the permissions on a namespace")
    private class Permissions
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private Permissions() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = Permissions.validateNamespace(this.params);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getPermissions(namespace));
        }
    }

    @Parameters(commandDescription="Revoke permissions to access subscription admin-api")
    private class RevokeSubscriptionPermissions
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;
        @Parameter(names={"--subscription"}, description="Subscription name for which permission will be revoked to roles", required=true)
        private String subscription;
        @Parameter(names={"--role"}, description="Client role to which revoke permissions", required=true)
        private String role;

        private RevokeSubscriptionPermissions() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = RevokeSubscriptionPermissions.validateNamespace(this.params);
            CmdNamespaces.this.getAdmin().namespaces().revokePermissionOnSubscription(namespace, this.subscription, this.role);
        }
    }

    @Parameters(commandDescription="Grant permissions to access subscription admin-api")
    private class GrantSubscriptionPermissions
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;
        @Parameter(names={"--subscription"}, description="Subscription name for which permission will be granted to roles", required=true)
        private String subscription;
        @Parameter(names={"--roles"}, description="Client roles to which grant permissions (comma separated roles)", required=true, splitter=CommaParameterSplitter.class)
        private List<String> roles;

        private GrantSubscriptionPermissions() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GrantSubscriptionPermissions.validateNamespace(this.params);
            CmdNamespaces.this.getAdmin().namespaces().grantPermissionOnSubscription(namespace, this.subscription, (Set)Sets.newHashSet(this.roles));
        }
    }

    @Parameters(commandDescription="Get permissions to access subscription admin-api")
    private class SubscriptionPermissions
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private SubscriptionPermissions() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = SubscriptionPermissions.validateNamespace(this.params);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getPermissionOnSubscription(namespace));
        }
    }

    @Parameters(commandDescription="Revoke permissions on a namespace")
    private class RevokePermissions
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;
        @Parameter(names={"--role"}, description="Client role to which revoke permissions", required=true)
        private String role;

        private RevokePermissions() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = RevokePermissions.validateNamespace(this.params);
            CmdNamespaces.this.getAdmin().namespaces().revokePermissionsOnNamespace(namespace, this.role);
        }
    }

    @Parameters(commandDescription="Grant permissions on a namespace")
    private class GrantPermissions
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;
        @Parameter(names={"--role"}, description="Client role to which grant permissions", required=true)
        private String role;
        @Parameter(names={"--actions"}, description="Actions to be granted (produce,consume,sources,sinks,functions,packages)", required=true)
        private List<String> actions;

        private GrantPermissions() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GrantPermissions.validateNamespace(this.params);
            CmdNamespaces.this.getAdmin().namespaces().grantPermissionOnNamespace(namespace, this.role, GrantPermissions.getAuthActions(this.actions));
        }
    }

    @Parameters(commandDescription="Deletes a namespace.")
    private class Delete
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;
        @Parameter(names={"-f", "--force"}, description="Delete namespace forcefully by force deleting all topics under it")
        private boolean force = false;

        private Delete() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = Delete.validateNamespace(this.params);
            CmdNamespaces.this.getAdmin().namespaces().deleteNamespace(namespace, this.force);
        }
    }

    @Parameters(commandDescription="Creates a new namespace")
    private class Create
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;
        @Parameter(names={"--clusters", "-c"}, description="List of clusters this namespace will be assigned", required=false)
        private List<String> clusters;
        @Parameter(names={"--bundles", "-b"}, description="number of bundles to activate", required=false)
        private int numBundles = 0;
        private static final long MAX_BUNDLES = 0x100000000L;

        private Create() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = Create.validateNamespace(this.params);
            if (this.numBundles < 0 || (long)this.numBundles > 0x100000000L) {
                throw new ParameterException("Invalid number of bundles. Number of bundles has to be in the range of (0, 2^32].");
            }
            NamespaceName namespaceName = NamespaceName.get((String)namespace);
            if (namespaceName.isV2()) {
                Policies policies = new Policies();
                BundlesData bundlesData = policies.bundles = this.numBundles > 0 ? BundlesData.builder().numBundles(this.numBundles).build() : null;
                if (this.clusters != null) {
                    policies.replication_clusters = new HashSet<String>(this.clusters);
                }
                CmdNamespaces.this.getAdmin().namespaces().createNamespace(namespace, policies);
            } else {
                if (this.numBundles == 0) {
                    CmdNamespaces.this.getAdmin().namespaces().createNamespace(namespace);
                } else {
                    CmdNamespaces.this.getAdmin().namespaces().createNamespace(namespace, this.numBundles);
                }
                if (this.clusters != null && !this.clusters.isEmpty()) {
                    CmdNamespaces.this.getAdmin().namespaces().setNamespaceReplicationClusters(namespace, new HashSet<String>(this.clusters));
                }
            }
        }
    }

    @Parameters(commandDescription="Get the configuration policies of a namespace")
    private class GetPolicies
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private GetPolicies() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetPolicies.validateNamespace(this.params);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getPolicies(namespace));
        }
    }

    @Parameters(commandDescription="Get the list of destinations for a namespace", hidden=true)
    private class GetDestinations
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private GetDestinations() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetDestinations.validateNamespace(this.params);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getTopics(namespace));
        }
    }

    @Parameters(commandDescription="Get the list of bundles for a namespace")
    private class GetBundles
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private GetBundles() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetBundles.validateNamespace(this.params);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getBundles(namespace));
        }
    }

    @Parameters(commandDescription="Get the list of topics for a namespace")
    private class GetTopics
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private GetTopics() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetTopics.validateNamespace(this.params);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getTopics(namespace));
        }
    }

    @Parameters(commandDescription="Get the namespaces for a tenant in a cluster", hidden=true)
    private class GetNamespacesPerCluster
    extends CliCommand {
        @Parameter(description="tenant/cluster", required=true)
        private List<String> params;

        private GetNamespacesPerCluster() {
        }

        @Override
        void run() throws PulsarAdminException {
            String[] parts = GetNamespacesPerCluster.validatePropertyCluster(this.params);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getNamespaces(parts[0], parts[1]));
        }
    }

    @Parameters(commandDescription="Get the namespaces for a tenant")
    private class GetNamespacesPerProperty
    extends CliCommand {
        @Parameter(description="tenant-name", required=true)
        private List<String> params;

        private GetNamespacesPerProperty() {
        }

        @Override
        void run() throws PulsarAdminException {
            String tenant = GetNamespacesPerProperty.getOneArgument(this.params);
            this.print(CmdNamespaces.this.getAdmin().namespaces().getNamespaces(tenant));
        }
    }
}

