/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.admin.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.converters.StringConverter;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.annotations.VisibleForTesting;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.commons.lang.StringUtils;
import org.apache.pulsar.admin.cli.CliCommand;
import org.apache.pulsar.admin.cli.CmdBase;
import org.apache.pulsar.admin.cli.utils.CmdUtils;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.SubscriptionInitialPosition;
import org.apache.pulsar.common.functions.ConsumerConfig;
import org.apache.pulsar.common.functions.FunctionConfig;
import org.apache.pulsar.common.functions.FunctionState;
import org.apache.pulsar.common.functions.ProducerConfig;
import org.apache.pulsar.common.functions.Resources;
import org.apache.pulsar.common.functions.UpdateOptions;
import org.apache.pulsar.common.functions.UpdateOptionsImpl;
import org.apache.pulsar.common.functions.Utils;
import org.apache.pulsar.common.functions.WindowConfig;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Parameters(commandDescription="Interface for managing Pulsar Functions (lightweight, Lambda-style compute processes that work with Pulsar)")
public class CmdFunctions
extends CmdBase {
    private static final Logger log = LoggerFactory.getLogger(CmdFunctions.class);
    private final LocalRunner localRunner = new LocalRunner();
    private final CreateFunction creater = new CreateFunction();
    private final DeleteFunction deleter = new DeleteFunction();
    private final UpdateFunction updater = new UpdateFunction();
    private final GetFunction getter = new GetFunction();
    private final GetFunctionStatus functionStatus = new GetFunctionStatus();
    private final GetFunctionStats functionStats = new GetFunctionStats();
    private final RestartFunction restart;
    private final StopFunction stop;
    private final StartFunction start;
    private final ListFunctions lister = new ListFunctions();
    private final StateGetter stateGetter = new StateGetter();
    private final StatePutter statePutter = new StatePutter();
    private final TriggerFunction triggerer = new TriggerFunction();
    private final UploadFunction uploader = new UploadFunction();
    private final DownloadFunction downloader = new DownloadFunction();

    public CmdFunctions(Supplier<PulsarAdmin> admin) throws PulsarClientException {
        super("functions", admin);
        this.restart = new RestartFunction();
        this.stop = new StopFunction();
        this.start = new StartFunction();
        this.jcommander.addCommand("localrun", (Object)this.getLocalRunner());
        this.jcommander.addCommand("create", (Object)this.getCreater());
        this.jcommander.addCommand("delete", (Object)this.getDeleter());
        this.jcommander.addCommand("update", (Object)this.getUpdater());
        this.jcommander.addCommand("get", (Object)this.getGetter());
        this.jcommander.addCommand("restart", (Object)this.getRestarter());
        this.jcommander.addCommand("stop", (Object)this.getStopper());
        this.jcommander.addCommand("start", (Object)this.getStarter());
        this.jcommander.addCommand("status", (Object)this.getStatuser(), new String[]{"getstatus"});
        this.jcommander.addCommand("stats", (Object)this.getFunctionStats());
        this.jcommander.addCommand("list", (Object)this.getLister());
        this.jcommander.addCommand("querystate", (Object)this.getStateGetter());
        this.jcommander.addCommand("putstate", (Object)this.getStatePutter());
        this.jcommander.addCommand("trigger", (Object)this.getTriggerer());
        this.jcommander.addCommand("upload", (Object)this.getUploader());
        this.jcommander.addCommand("download", (Object)this.getDownloader());
    }

    @VisibleForTesting
    LocalRunner getLocalRunner() {
        return this.localRunner;
    }

    @VisibleForTesting
    CreateFunction getCreater() {
        return this.creater;
    }

    @VisibleForTesting
    DeleteFunction getDeleter() {
        return this.deleter;
    }

    @VisibleForTesting
    UpdateFunction getUpdater() {
        return this.updater;
    }

    @VisibleForTesting
    GetFunction getGetter() {
        return this.getter;
    }

    @VisibleForTesting
    GetFunctionStatus getStatuser() {
        return this.functionStatus;
    }

    @VisibleForTesting
    ListFunctions getLister() {
        return this.lister;
    }

    @VisibleForTesting
    StatePutter getStatePutter() {
        return this.statePutter;
    }

    @VisibleForTesting
    StateGetter getStateGetter() {
        return this.stateGetter;
    }

    @VisibleForTesting
    TriggerFunction getTriggerer() {
        return this.triggerer;
    }

    @VisibleForTesting
    UploadFunction getUploader() {
        return this.uploader;
    }

    @VisibleForTesting
    DownloadFunction getDownloader() {
        return this.downloader;
    }

    @VisibleForTesting
    RestartFunction getRestarter() {
        return this.restart;
    }

    @VisibleForTesting
    StopFunction getStopper() {
        return this.stop;
    }

    @VisibleForTesting
    StartFunction getStarter() {
        return this.start;
    }

    private void parseFullyQualifiedFunctionName(String fqfn, FunctionConfig functionConfig) {
        String[] args = fqfn.split("/");
        if (args.length != 3) {
            throw new ParameterException("Fully qualified function names (FQFNs) must be of the form tenant/namespace/name");
        }
        functionConfig.setTenant(args[0]);
        functionConfig.setNamespace(args[1]);
        functionConfig.setName(args[2]);
    }

    public GetFunctionStats getFunctionStats() {
        return this.functionStats;
    }

    @Parameters(commandDescription="Download File Data from Pulsar", hidden=true)
    class DownloadFunction
    extends FunctionCommand {
        @Parameter(names={"--destinationFile"}, description="The file to store downloaded content", listConverter=StringConverter.class, hidden=true)
        protected String DEPRECATED_destinationFile;
        @Parameter(names={"--destination-file"}, description="The file to store downloaded content", listConverter=StringConverter.class)
        protected String destinationFile;
        @Parameter(names={"--path"}, description="Path to store the content", listConverter=StringConverter.class, required=false, hidden=true)
        protected String path;

        DownloadFunction() {
        }

        private void mergeArgs() {
            if (StringUtils.isBlank((String)this.destinationFile) && !StringUtils.isBlank((String)this.DEPRECATED_destinationFile)) {
                this.destinationFile = this.DEPRECATED_destinationFile;
            }
        }

        @Override
        void processArguments() throws Exception {
            if (this.path == null) {
                super.processArguments();
            }
        }

        @Override
        void runCmd() throws Exception {
            this.mergeArgs();
            if (StringUtils.isBlank((String)this.destinationFile)) {
                throw new ParameterException("--destination-file needs to be specified");
            }
            if (this.path != null) {
                CmdFunctions.this.getAdmin().functions().downloadFunction(this.destinationFile, this.path);
            } else {
                CmdFunctions.this.getAdmin().functions().downloadFunction(this.destinationFile, this.tenant, this.namespace, this.functionName);
            }
            this.print("Downloaded successfully");
        }
    }

    @Parameters(commandDescription="Upload File Data to Pulsar", hidden=true)
    class UploadFunction
    extends BaseCommand {
        @Parameter(names={"--sourceFile"}, description="The file whose contents need to be uploaded", listConverter=StringConverter.class, hidden=true)
        protected String DEPRECATED_sourceFile;
        @Parameter(names={"--source-file"}, description="The file whose contents need to be uploaded", listConverter=StringConverter.class)
        protected String sourceFile;
        @Parameter(names={"--path"}, description="Path where the contents need to be stored", listConverter=StringConverter.class, required=true)
        protected String path;

        UploadFunction() {
        }

        private void mergeArgs() {
            if (StringUtils.isBlank((String)this.sourceFile) && !StringUtils.isBlank((String)this.DEPRECATED_sourceFile)) {
                this.sourceFile = this.DEPRECATED_sourceFile;
            }
        }

        @Override
        void runCmd() throws Exception {
            this.mergeArgs();
            if (StringUtils.isBlank((String)this.sourceFile)) {
                throw new ParameterException("--source-file needs to be specified");
            }
            CmdFunctions.this.getAdmin().functions().uploadFunction(this.sourceFile, this.path);
            this.print("Uploaded successfully");
        }
    }

    @Parameters(commandDescription="Trigger the specified Pulsar Function with a supplied value")
    class TriggerFunction
    extends FunctionCommand {
        @Parameter(names={"--triggerValue"}, description="The value with which you want to trigger the function", hidden=true)
        protected String DEPRECATED_triggerValue;
        @Parameter(names={"--trigger-value"}, description="The value with which you want to trigger the function")
        protected String triggerValue;
        @Parameter(names={"--triggerFile"}, description="The path to the file that contains the data with which you want to trigger the function", hidden=true)
        protected String DEPRECATED_triggerFile;
        @Parameter(names={"--trigger-file"}, description="The path to the file that contains the data with which you want to trigger the function")
        protected String triggerFile;
        @Parameter(names={"--topic"}, description="The specific topic name that the function consumes from that you want to inject the data to")
        protected String topic;

        TriggerFunction() {
        }

        public void mergeArgs() {
            if (StringUtils.isBlank((String)this.triggerValue) && !StringUtils.isBlank((String)this.DEPRECATED_triggerValue)) {
                this.triggerValue = this.DEPRECATED_triggerValue;
            }
            if (StringUtils.isBlank((String)this.triggerFile) && !StringUtils.isBlank((String)this.DEPRECATED_triggerFile)) {
                this.triggerFile = this.DEPRECATED_triggerFile;
            }
        }

        @Override
        void runCmd() throws Exception {
            this.mergeArgs();
            if (this.triggerFile == null && this.triggerValue == null) {
                throw new ParameterException("Either a trigger value or a trigger filepath needs to be specified");
            }
            String retval = CmdFunctions.this.getAdmin().functions().triggerFunction(this.tenant, this.namespace, this.functionName, this.topic, this.triggerValue, this.triggerFile);
            System.out.println(retval);
        }
    }

    @Parameters(commandDescription="Put the state associated with a Pulsar Function")
    class StatePutter
    extends FunctionCommand {
        @Parameter(names={"-s", "--state"}, description="The FunctionState that needs to be put", required=true)
        private String state;

        StatePutter() {
            this.state = null;
        }

        @Override
        void runCmd() throws Exception {
            TypeReference<FunctionState> typeRef = new TypeReference<FunctionState>(){};
            FunctionState stateRepr = (FunctionState)ObjectMapperFactory.getThreadLocal().readValue(this.state, (TypeReference)typeRef);
            CmdFunctions.this.getAdmin().functions().putFunctionState(this.tenant, this.namespace, this.functionName, stateRepr);
        }
    }

    @Parameters(commandDescription="Fetch the current state associated with a Pulsar Function")
    class StateGetter
    extends FunctionCommand {
        @Parameter(names={"-k", "--key"}, description="Key name of State")
        private String key;
        @Parameter(names={"-w", "--watch"}, description="Watch for changes in the value associated with a key for a Pulsar Function")
        private boolean watch;

        StateGetter() {
            this.key = null;
            this.watch = false;
        }

        @Override
        void runCmd() throws Exception {
            if (StringUtils.isBlank((String)this.key)) {
                throw new ParameterException("State key needs to be specified");
            }
            do {
                try {
                    FunctionState functionState = CmdFunctions.this.getAdmin().functions().getFunctionState(this.tenant, this.namespace, this.functionName, this.key);
                    Gson gson = new GsonBuilder().setPrettyPrinting().create();
                    System.out.println(gson.toJson((Object)functionState));
                }
                catch (PulsarAdminException pae) {
                    if (pae.getStatusCode() == 404 && this.watch) {
                        System.err.println(pae.getMessage());
                    }
                    throw pae;
                }
                if (!this.watch) continue;
                Thread.sleep(1000L);
            } while (this.watch);
        }
    }

    @Parameters(commandDescription="List all Pulsar Functions running under a specific tenant and namespace")
    class ListFunctions
    extends NamespaceCommand {
        ListFunctions() {
        }

        @Override
        void runCmd() throws Exception {
            this.print(CmdFunctions.this.getAdmin().functions().getFunctions(this.tenant, this.namespace));
        }
    }

    @Parameters(commandDescription="Update a Pulsar Function that has been deployed to a Pulsar cluster")
    class UpdateFunction
    extends FunctionDetailsCommand {
        @Parameter(names={"--update-auth-data"}, description="Whether or not to update the auth data")
        protected boolean updateAuthData;

        UpdateFunction() {
        }

        @Override
        protected void validateFunctionConfigs(FunctionConfig functionConfig) {
            if (StringUtils.isEmpty((String)functionConfig.getClassName())) {
                if (StringUtils.isEmpty((String)functionConfig.getName())) {
                    throw new IllegalArgumentException("Function Name not provided");
                }
            } else if (StringUtils.isEmpty((String)functionConfig.getName())) {
                Utils.inferMissingFunctionName((FunctionConfig)functionConfig);
            }
            if (StringUtils.isEmpty((String)functionConfig.getTenant())) {
                Utils.inferMissingTenant((FunctionConfig)functionConfig);
            }
            if (StringUtils.isEmpty((String)functionConfig.getNamespace())) {
                Utils.inferMissingNamespace((FunctionConfig)functionConfig);
            }
        }

        @Override
        void runCmd() throws Exception {
            UpdateOptionsImpl updateOptions = new UpdateOptionsImpl();
            updateOptions.setUpdateAuthData(this.updateAuthData);
            if (Utils.isFunctionPackageUrlSupported((String)this.functionConfig.getJar())) {
                CmdFunctions.this.getAdmin().functions().updateFunctionWithUrl(this.functionConfig, this.functionConfig.getJar(), (UpdateOptions)updateOptions);
            } else {
                CmdFunctions.this.getAdmin().functions().updateFunction(this.functionConfig, this.userCodeFile, (UpdateOptions)updateOptions);
            }
            this.print("Updated successfully");
        }
    }

    @Parameters(commandDescription="Delete a Pulsar Function that is running on a Pulsar cluster")
    class DeleteFunction
    extends FunctionCommand {
        DeleteFunction() {
        }

        @Override
        void runCmd() throws Exception {
            CmdFunctions.this.getAdmin().functions().deleteFunction(this.tenant, this.namespace, this.functionName);
            this.print("Deleted successfully");
        }
    }

    @Parameters(commandDescription="Starts a stopped function instance")
    class StartFunction
    extends FunctionCommand {
        @Parameter(names={"--instance-id"}, description="The function instanceId (start all instances if instance-id is not provided)")
        protected String instanceId;

        StartFunction() {
        }

        @Override
        void runCmd() throws Exception {
            if (StringUtils.isNotBlank((String)this.instanceId)) {
                try {
                    CmdFunctions.this.getAdmin().functions().startFunction(this.tenant, this.namespace, this.functionName, Integer.parseInt(this.instanceId));
                }
                catch (NumberFormatException e) {
                    System.err.println("instance-id must be a number");
                }
            } else {
                CmdFunctions.this.getAdmin().functions().startFunction(this.tenant, this.namespace, this.functionName);
            }
            System.out.println("Started successfully");
        }
    }

    @Parameters(commandDescription="Stops function instance")
    class StopFunction
    extends FunctionCommand {
        @Parameter(names={"--instance-id"}, description="The function instanceId (stop all instances if instance-id is not provided)")
        protected String instanceId;

        StopFunction() {
        }

        @Override
        void runCmd() throws Exception {
            if (StringUtils.isNotBlank((String)this.instanceId)) {
                try {
                    CmdFunctions.this.getAdmin().functions().stopFunction(this.tenant, this.namespace, this.functionName, Integer.parseInt(this.instanceId));
                }
                catch (NumberFormatException e) {
                    System.err.println("instance-id must be a number");
                }
            } else {
                CmdFunctions.this.getAdmin().functions().stopFunction(this.tenant, this.namespace, this.functionName);
            }
            System.out.println("Stopped successfully");
        }
    }

    @Parameters(commandDescription="Restart function instance")
    class RestartFunction
    extends FunctionCommand {
        @Parameter(names={"--instance-id"}, description="The function instanceId (restart all instances if instance-id is not provided)")
        protected String instanceId;

        RestartFunction() {
        }

        @Override
        void runCmd() throws Exception {
            if (StringUtils.isNotBlank((String)this.instanceId)) {
                try {
                    CmdFunctions.this.getAdmin().functions().restartFunction(this.tenant, this.namespace, this.functionName, Integer.parseInt(this.instanceId));
                }
                catch (NumberFormatException e) {
                    System.err.println("instance-id must be a number");
                }
            } else {
                CmdFunctions.this.getAdmin().functions().restartFunction(this.tenant, this.namespace, this.functionName);
            }
            System.out.println("Restarted successfully");
        }
    }

    @Parameters(commandDescription="Get the current stats of a Pulsar Function")
    class GetFunctionStats
    extends FunctionCommand {
        @Parameter(names={"--instance-id"}, description="The function instanceId (Get-stats of all instances if instance-id is not provided)")
        protected String instanceId;

        GetFunctionStats() {
        }

        @Override
        void runCmd() throws Exception {
            if (StringUtils.isBlank((String)this.instanceId)) {
                this.print(CmdFunctions.this.getAdmin().functions().getFunctionStats(this.tenant, this.namespace, this.functionName));
            } else {
                this.print(CmdFunctions.this.getAdmin().functions().getFunctionStats(this.tenant, this.namespace, this.functionName, Integer.parseInt(this.instanceId)));
            }
        }
    }

    @Parameters(commandDescription="Check the current status of a Pulsar Function")
    class GetFunctionStatus
    extends FunctionCommand {
        @Parameter(names={"--instance-id"}, description="The function instanceId (Get-status of all instances if instance-id is not provided)")
        protected String instanceId;

        GetFunctionStatus() {
        }

        @Override
        void runCmd() throws Exception {
            if (StringUtils.isBlank((String)this.instanceId)) {
                this.print(CmdFunctions.this.getAdmin().functions().getFunctionStatus(this.tenant, this.namespace, this.functionName));
            } else {
                this.print(CmdFunctions.this.getAdmin().functions().getFunctionStatus(this.tenant, this.namespace, this.functionName, Integer.parseInt(this.instanceId)));
            }
        }
    }

    @Parameters(commandDescription="Fetch information about a Pulsar Function")
    class GetFunction
    extends FunctionCommand {
        GetFunction() {
        }

        @Override
        void runCmd() throws Exception {
            FunctionConfig functionConfig = CmdFunctions.this.getAdmin().functions().getFunction(this.tenant, this.namespace, this.functionName);
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            System.out.println(gson.toJson((Object)functionConfig));
        }
    }

    @Parameters(commandDescription="Create a Pulsar Function in cluster mode (deploy it on a Pulsar cluster)")
    class CreateFunction
    extends FunctionDetailsCommand {
        CreateFunction() {
        }

        @Override
        void runCmd() throws Exception {
            if (Utils.isFunctionPackageUrlSupported((String)this.functionConfig.getJar())) {
                CmdFunctions.this.getAdmin().functions().createFunctionWithUrl(this.functionConfig, this.functionConfig.getJar());
            } else if (Utils.isFunctionPackageUrlSupported((String)this.functionConfig.getPy())) {
                CmdFunctions.this.getAdmin().functions().createFunctionWithUrl(this.functionConfig, this.functionConfig.getPy());
            } else if (Utils.isFunctionPackageUrlSupported((String)this.functionConfig.getGo())) {
                CmdFunctions.this.getAdmin().functions().createFunctionWithUrl(this.functionConfig, this.functionConfig.getGo());
            } else {
                CmdFunctions.this.getAdmin().functions().createFunction(this.functionConfig, this.userCodeFile);
            }
            this.print("Created successfully");
        }
    }

    @Parameters(commandDescription="Run a Pulsar Function locally, rather than deploy to a Pulsar cluster)")
    class LocalRunner
    extends FunctionDetailsCommand {
        @Parameter(names={"--stateStorageServiceUrl"}, description="The URL for the state storage service (the default is Apache BookKeeper)", hidden=true)
        protected String DEPRECATED_stateStorageServiceUrl;
        @Parameter(names={"--state-storage-service-url"}, description="The URL for the state storage service (the default is Apache BookKeeper)")
        protected String stateStorageServiceUrl;
        @Parameter(names={"--brokerServiceUrl"}, description="The URL for Pulsar broker", hidden=true)
        protected String DEPRECATED_brokerServiceUrl;
        @Parameter(names={"--broker-service-url"}, description="The URL for Pulsar broker")
        protected String brokerServiceUrl;
        @Parameter(names={"--web-service-url"}, description="The URL for Pulsar web service")
        protected String webServiceUrl;
        @Parameter(names={"--clientAuthPlugin"}, description="Client authentication plugin using which function-process can connect to broker", hidden=true)
        protected String DEPRECATED_clientAuthPlugin;
        @Parameter(names={"--client-auth-plugin"}, description="Client authentication plugin using which function-process can connect to broker")
        protected String clientAuthPlugin;
        @Parameter(names={"--clientAuthParams"}, description="Client authentication param", hidden=true)
        protected String DEPRECATED_clientAuthParams;
        @Parameter(names={"--client-auth-params"}, description="Client authentication param")
        protected String clientAuthParams;
        @Parameter(names={"--use_tls"}, description="Use tls connection", hidden=true)
        protected Boolean DEPRECATED_useTls;
        @Parameter(names={"--use-tls"}, description="Use tls connection")
        protected boolean useTls;
        @Parameter(names={"--tls_allow_insecure"}, description="Allow insecure tls connection", hidden=true)
        protected Boolean DEPRECATED_tlsAllowInsecureConnection;
        @Parameter(names={"--tls-allow-insecure"}, description="Allow insecure tls connection")
        protected boolean tlsAllowInsecureConnection;
        @Parameter(names={"--hostname_verification_enabled"}, description="Enable hostname verification", hidden=true)
        protected Boolean DEPRECATED_tlsHostNameVerificationEnabled;
        @Parameter(names={"--hostname-verification-enabled"}, description="Enable hostname verification")
        protected boolean tlsHostNameVerificationEnabled;
        @Parameter(names={"--tls_trust_cert_path"}, description="tls trust cert file path", hidden=true)
        protected String DEPRECATED_tlsTrustCertFilePath;
        @Parameter(names={"--tls-trust-cert-path"}, description="tls trust cert file path")
        protected String tlsTrustCertFilePath;
        @Parameter(names={"--instanceIdOffset"}, description="Start the instanceIds from this offset", hidden=true)
        protected Integer DEPRECATED_instanceIdOffset;
        @Parameter(names={"--instance-id-offset"}, description="Start the instanceIds from this offset")
        protected Integer instanceIdOffset;
        @Parameter(names={"--runtime"}, description="either THREAD or PROCESS. Only applies for Java functions")
        protected String runtime;
        @Parameter(names={"--secrets-provider-classname"}, description="Whats the classname for secrets provider")
        protected String secretsProviderClassName;
        @Parameter(names={"--secrets-provider-config"}, description="Config that needs to be passed to secrets provider")
        protected String secretsProviderConfig;
        @Parameter(names={"--metrics-port-start"}, description="The starting port range for metrics server")
        protected String metricsPortStart;

        LocalRunner() {
            this.webServiceUrl = null;
            this.DEPRECATED_useTls = null;
            this.DEPRECATED_tlsAllowInsecureConnection = null;
            this.DEPRECATED_tlsHostNameVerificationEnabled = null;
            this.DEPRECATED_instanceIdOffset = null;
            this.instanceIdOffset = 0;
        }

        private void mergeArgs() {
            if (StringUtils.isBlank((String)this.stateStorageServiceUrl) && !StringUtils.isBlank((String)this.DEPRECATED_stateStorageServiceUrl)) {
                this.stateStorageServiceUrl = this.DEPRECATED_stateStorageServiceUrl;
            }
            if (StringUtils.isBlank((String)this.brokerServiceUrl) && !StringUtils.isBlank((String)this.DEPRECATED_brokerServiceUrl)) {
                this.brokerServiceUrl = this.DEPRECATED_brokerServiceUrl;
            }
            if (StringUtils.isBlank((String)this.clientAuthPlugin) && !StringUtils.isBlank((String)this.DEPRECATED_clientAuthPlugin)) {
                this.clientAuthPlugin = this.DEPRECATED_clientAuthPlugin;
            }
            if (StringUtils.isBlank((String)this.clientAuthParams) && !StringUtils.isBlank((String)this.DEPRECATED_clientAuthParams)) {
                this.clientAuthParams = this.DEPRECATED_clientAuthParams;
            }
            if (!this.useTls && this.DEPRECATED_useTls != null) {
                this.useTls = this.DEPRECATED_useTls;
            }
            if (!this.tlsAllowInsecureConnection && this.DEPRECATED_tlsAllowInsecureConnection != null) {
                this.tlsAllowInsecureConnection = this.DEPRECATED_tlsAllowInsecureConnection;
            }
            if (!this.tlsHostNameVerificationEnabled && this.DEPRECATED_tlsHostNameVerificationEnabled != null) {
                this.tlsHostNameVerificationEnabled = this.DEPRECATED_tlsHostNameVerificationEnabled;
            }
            if (StringUtils.isBlank((String)this.tlsTrustCertFilePath) && !StringUtils.isBlank((String)this.DEPRECATED_tlsTrustCertFilePath)) {
                this.tlsTrustCertFilePath = this.DEPRECATED_tlsTrustCertFilePath;
            }
            if (this.instanceIdOffset == null && this.DEPRECATED_instanceIdOffset != null) {
                this.instanceIdOffset = this.DEPRECATED_instanceIdOffset;
            }
        }

        @Override
        void runCmd() throws Exception {
            this.mergeArgs();
            LinkedList<String> localRunArgs = new LinkedList<String>();
            localRunArgs.add(System.getenv("PULSAR_HOME") + "/bin/function-localrunner");
            localRunArgs.add("--functionConfig");
            localRunArgs.add(new Gson().toJson((Object)this.functionConfig));
            for (Field field : this.getClass().getDeclaredFields()) {
                Object value;
                if (field.getName().startsWith("DEPRECATED") || field.getName().contains("$") || (value = field.get(this)) == null) continue;
                localRunArgs.add("--" + field.getName());
                localRunArgs.add(value.toString());
            }
            ProcessBuilder processBuilder = new ProcessBuilder(localRunArgs).inheritIO();
            Process process = processBuilder.start();
            process.waitFor();
        }
    }

    abstract class FunctionDetailsCommand
    extends BaseCommand {
        @Parameter(names={"--fqfn"}, description="The Fully Qualified Function Name (FQFN) for the function")
        protected String fqfn;
        @Parameter(names={"--tenant"}, description="The tenant of a Pulsar Function")
        protected String tenant;
        @Parameter(names={"--namespace"}, description="The namespace of a Pulsar Function")
        protected String namespace;
        @Parameter(names={"--name"}, description="The name of a Pulsar Function")
        protected String functionName;
        @Parameter(names={"--className"}, description="The class name of a Pulsar Function", hidden=true)
        protected String DEPRECATED_className;
        @Parameter(names={"--classname"}, description="The class name of a Pulsar Function")
        protected String className;
        @Parameter(names={"--jar"}, description="Path to the JAR file for the function (if the function is written in Java). It also supports URL path [http/https/file (file protocol assumes that file already exists on worker host)/function (package URL from packages management service)] from which worker can download the package.", listConverter=StringConverter.class)
        protected String jarFile;
        @Parameter(names={"--py"}, description="Path to the main Python file/Python Wheel file for the function (if the function is written in Python). It also supports URL path [http/https/file (file protocol assumes that file already exists on worker host)/function (package URL from packages management service)] from which worker can download the package.", listConverter=StringConverter.class)
        protected String pyFile;
        @Parameter(names={"--go"}, description="Path to the main Go executable binary for the function (if the function is written in Go). It also supports URL path [http/https/file (file protocol assumes that file already exists on worker host)/function (package URL from packages management service)] from which worker can download the package.")
        protected String goFile;
        @Parameter(names={"-i", "--inputs"}, description="The input topic or topics (multiple topics can be specified as a comma-separated list) of a Pulsar Function")
        protected String inputs;
        @Parameter(names={"--topicsPattern"}, description="TopicsPattern to consume from list of topics under a namespace that match the pattern. [--input] and [--topic-pattern] are mutually exclusive. Add SerDe class name for a pattern in --custom-serde-inputs (supported for java fun only)", hidden=true)
        protected String DEPRECATED_topicsPattern;
        @Parameter(names={"--topics-pattern"}, description="The topic pattern to consume from list of topics under a namespace that match the pattern. [--input] and [--topic-pattern] are mutually exclusive. Add SerDe class name for a pattern in --custom-serde-inputs (supported for java fun only)")
        protected String topicsPattern;
        @Parameter(names={"-o", "--output"}, description="The output topic of a Pulsar Function (If none is specified, no output is written)")
        protected String output;
        @Parameter(names={"--producer-config"}, description="The custom producer configuration (as a JSON string)")
        protected String producerConfig;
        @Parameter(names={"--logTopic"}, description="The topic to which the logs of a Pulsar Function are produced", hidden=true)
        protected String DEPRECATED_logTopic;
        @Parameter(names={"--log-topic"}, description="The topic to which the logs of a Pulsar Function are produced")
        protected String logTopic;
        @Parameter(names={"-st", "--schema-type"}, description="The builtin schema type or custom schema class name to be used for messages output by the function")
        protected String schemaType;
        @Parameter(names={"--customSerdeInputs"}, description="The map of input topics to SerDe class names (as a JSON string)", hidden=true)
        protected String DEPRECATED_customSerdeInputString;
        @Parameter(names={"--custom-serde-inputs"}, description="The map of input topics to SerDe class names (as a JSON string)")
        protected String customSerdeInputString;
        @Parameter(names={"--custom-schema-inputs"}, description="The map of input topics to Schema properties (as a JSON string)")
        protected String customSchemaInputString;
        @Parameter(names={"--custom-schema-outputs"}, description="The map of input topics to Schema properties (as a JSON string)")
        protected String customSchemaOutputString;
        @Parameter(names={"--input-specs"}, description="The map of inputs to custom configuration (as a JSON string)")
        protected String inputSpecs;
        @Parameter(names={"--outputSerdeClassName"}, description="The SerDe class to be used for messages output by the function", hidden=true)
        protected String DEPRECATED_outputSerdeClassName;
        @Parameter(names={"--output-serde-classname"}, description="The SerDe class to be used for messages output by the function")
        protected String outputSerdeClassName;
        @Parameter(names={"--functionConfigFile"}, description="The path to a YAML config file that specifies the configuration of a Pulsar Function", hidden=true)
        protected String DEPRECATED_fnConfigFile;
        @Parameter(names={"--function-config-file"}, description="The path to a YAML config file that specifies the configuration of a Pulsar Function")
        protected String fnConfigFile;
        @Parameter(names={"--processingGuarantees"}, description="The processing guarantees (aka delivery semantics) applied to the function", hidden=true)
        protected FunctionConfig.ProcessingGuarantees DEPRECATED_processingGuarantees;
        @Parameter(names={"--processing-guarantees"}, description="The processing guarantees (aka delivery semantics) applied to the function")
        protected FunctionConfig.ProcessingGuarantees processingGuarantees;
        @Parameter(names={"--userConfig"}, description="User-defined config key/values", hidden=true)
        protected String DEPRECATED_userConfigString;
        @Parameter(names={"--user-config"}, description="User-defined config key/values")
        protected String userConfigString;
        @Parameter(names={"--retainOrdering"}, description="Function consumes and processes messages in order", hidden=true)
        protected Boolean DEPRECATED_retainOrdering;
        @Parameter(names={"--retain-ordering"}, description="Function consumes and processes messages in order")
        protected Boolean retainOrdering;
        @Parameter(names={"--retain-key-ordering"}, description="Function consumes and processes messages in key order")
        protected Boolean retainKeyOrdering;
        @Parameter(names={"--batch-builder"}, description="BatcherBuilder provides two types of batch construction methods, DEFAULT and KEY_BASED. The default value is: DEFAULT")
        protected String batchBuilder;
        @Parameter(names={"--forward-source-message-property"}, description="Forwarding input message's properties to output topic when processing (use false to disable it)", arity=1)
        protected Boolean forwardSourceMessageProperty;
        @Parameter(names={"--subs-name"}, description="Pulsar source subscription name if user wants a specific subscription-name for input-topic consumer")
        protected String subsName;
        @Parameter(names={"--subs-position"}, description="Pulsar source subscription position if user wants to consume messages from the specified location")
        protected SubscriptionInitialPosition subsPosition;
        @Parameter(names={"--parallelism"}, description="The parallelism factor of a Pulsar Function (i.e. the number of function instances to run)")
        protected Integer parallelism;
        @Parameter(names={"--cpu"}, description="The cpu in cores that need to be allocated per function instance(applicable only to docker runtime)")
        protected Double cpu;
        @Parameter(names={"--ram"}, description="The ram in bytes that need to be allocated per function instance(applicable only to process/docker runtime)")
        protected Long ram;
        @Parameter(names={"--disk"}, description="The disk in bytes that need to be allocated per function instance(applicable only to docker runtime)")
        protected Long disk;
        @Parameter(names={"--windowLengthCount"}, description="The number of messages per window", hidden=true)
        protected Integer DEPRECATED_windowLengthCount;
        @Parameter(names={"--window-length-count"}, description="The number of messages per window")
        protected Integer windowLengthCount;
        @Parameter(names={"--windowLengthDurationMs"}, description="The time duration of the window in milliseconds", hidden=true)
        protected Long DEPRECATED_windowLengthDurationMs;
        @Parameter(names={"--window-length-duration-ms"}, description="The time duration of the window in milliseconds")
        protected Long windowLengthDurationMs;
        @Parameter(names={"--slidingIntervalCount"}, description="The number of messages after which the window slides", hidden=true)
        protected Integer DEPRECATED_slidingIntervalCount;
        @Parameter(names={"--sliding-interval-count"}, description="The number of messages after which the window slides")
        protected Integer slidingIntervalCount;
        @Parameter(names={"--slidingIntervalDurationMs"}, description="The time duration after which the window slides", hidden=true)
        protected Long DEPRECATED_slidingIntervalDurationMs;
        @Parameter(names={"--sliding-interval-duration-ms"}, description="The time duration after which the window slides")
        protected Long slidingIntervalDurationMs;
        @Parameter(names={"--autoAck"}, description="Whether or not the framework acknowledges messages automatically", hidden=true)
        protected Boolean DEPRECATED_autoAck;
        @Parameter(names={"--auto-ack"}, description="Whether or not the framework acknowledges messages automatically", arity=1)
        protected Boolean autoAck;
        @Parameter(names={"--timeoutMs"}, description="The message timeout in milliseconds", hidden=true)
        protected Long DEPRECATED_timeoutMs;
        @Parameter(names={"--timeout-ms"}, description="The message timeout in milliseconds")
        protected Long timeoutMs;
        @Parameter(names={"--max-message-retries"}, description="How many times should we try to process a message before giving up")
        protected Integer maxMessageRetries;
        @Parameter(names={"--custom-runtime-options"}, description="A string that encodes options to customize the runtime, see docs for configured runtime for details")
        protected String customRuntimeOptions;
        @Parameter(names={"--dead-letter-topic"}, description="The topic where messages that are not processed successfully are sent to")
        protected String deadLetterTopic;
        protected FunctionConfig functionConfig;
        protected String userCodeFile;

        FunctionDetailsCommand() {
            this.schemaType = "";
            this.forwardSourceMessageProperty = true;
            this.DEPRECATED_autoAck = null;
        }

        private void mergeArgs() {
            if (StringUtils.isBlank((String)this.className) && !StringUtils.isBlank((String)this.DEPRECATED_className)) {
                this.className = this.DEPRECATED_className;
            }
            if (StringUtils.isBlank((String)this.topicsPattern) && !StringUtils.isBlank((String)this.DEPRECATED_topicsPattern)) {
                this.topicsPattern = this.DEPRECATED_topicsPattern;
            }
            if (StringUtils.isBlank((String)this.logTopic) && !StringUtils.isBlank((String)this.DEPRECATED_logTopic)) {
                this.logTopic = this.DEPRECATED_logTopic;
            }
            if (StringUtils.isBlank((String)this.outputSerdeClassName) && !StringUtils.isBlank((String)this.DEPRECATED_outputSerdeClassName)) {
                this.outputSerdeClassName = this.DEPRECATED_outputSerdeClassName;
            }
            if (StringUtils.isBlank((String)this.customSerdeInputString) && !StringUtils.isBlank((String)this.DEPRECATED_customSerdeInputString)) {
                this.customSerdeInputString = this.DEPRECATED_customSerdeInputString;
            }
            if (StringUtils.isBlank((String)this.fnConfigFile) && !StringUtils.isBlank((String)this.DEPRECATED_fnConfigFile)) {
                this.fnConfigFile = this.DEPRECATED_fnConfigFile;
            }
            if (this.processingGuarantees == null && this.DEPRECATED_processingGuarantees != null) {
                this.processingGuarantees = this.DEPRECATED_processingGuarantees;
            }
            if (StringUtils.isBlank((String)this.userConfigString) && !StringUtils.isBlank((String)this.DEPRECATED_userConfigString)) {
                this.userConfigString = this.DEPRECATED_userConfigString;
            }
            if (this.retainOrdering == null && this.DEPRECATED_retainOrdering != null) {
                this.retainOrdering = this.DEPRECATED_retainOrdering;
            }
            if (this.windowLengthCount == null && this.DEPRECATED_windowLengthCount != null) {
                this.windowLengthCount = this.DEPRECATED_windowLengthCount;
            }
            if (this.windowLengthDurationMs == null && this.DEPRECATED_windowLengthDurationMs != null) {
                this.windowLengthDurationMs = this.DEPRECATED_windowLengthDurationMs;
            }
            if (this.slidingIntervalCount == null && this.DEPRECATED_slidingIntervalCount != null) {
                this.slidingIntervalCount = this.DEPRECATED_slidingIntervalCount;
            }
            if (this.slidingIntervalDurationMs == null && this.DEPRECATED_slidingIntervalDurationMs != null) {
                this.slidingIntervalDurationMs = this.DEPRECATED_slidingIntervalDurationMs;
            }
            if (this.autoAck == null && this.DEPRECATED_autoAck != null) {
                this.autoAck = this.DEPRECATED_autoAck;
            }
            if (this.timeoutMs == null && this.DEPRECATED_timeoutMs != null) {
                this.timeoutMs = this.DEPRECATED_timeoutMs;
            }
        }

        @Override
        void processArguments() throws Exception {
            Type type;
            super.processArguments();
            this.mergeArgs();
            this.functionConfig = null != this.fnConfigFile ? CmdUtils.loadConfig(this.fnConfigFile, FunctionConfig.class) : new FunctionConfig();
            if (null != this.fqfn) {
                CmdFunctions.this.parseFullyQualifiedFunctionName(this.fqfn, this.functionConfig);
            } else {
                if (null != this.tenant) {
                    this.functionConfig.setTenant(this.tenant);
                }
                if (null != this.namespace) {
                    this.functionConfig.setNamespace(this.namespace);
                }
                if (null != this.functionName) {
                    this.functionConfig.setName(this.functionName);
                }
            }
            if (null != this.inputs) {
                List<String> inputTopics = Arrays.asList(this.inputs.split(","));
                this.functionConfig.setInputs(inputTopics);
            }
            if (null != this.customSerdeInputString) {
                type = new TypeToken<Map<String, String>>(){}.getType();
                Map customSerdeInputMap = (Map)new Gson().fromJson(this.customSerdeInputString, type);
                this.functionConfig.setCustomSerdeInputs(customSerdeInputMap);
            }
            if (null != this.customSchemaInputString) {
                type = new TypeToken<Map<String, String>>(){}.getType();
                Map customschemaInputMap = (Map)new Gson().fromJson(this.customSchemaInputString, type);
                this.functionConfig.setCustomSchemaInputs(customschemaInputMap);
            }
            if (null != this.customSchemaOutputString) {
                type = new TypeToken<Map<String, String>>(){}.getType();
                Map customSchemaOutputMap = (Map)new Gson().fromJson(this.customSchemaOutputString, type);
                this.functionConfig.setCustomSchemaOutputs(customSchemaOutputMap);
            }
            if (null != this.inputSpecs) {
                type = new TypeToken<Map<String, ConsumerConfig>>(){}.getType();
                this.functionConfig.setInputSpecs((Map)new Gson().fromJson(this.inputSpecs, type));
            }
            if (null != this.topicsPattern) {
                this.functionConfig.setTopicsPattern(this.topicsPattern);
            }
            if (null != this.output) {
                this.functionConfig.setOutput(this.output);
            }
            if (null != this.producerConfig) {
                type = new TypeToken<ProducerConfig>(){}.getType();
                this.functionConfig.setProducerConfig((ProducerConfig)new Gson().fromJson(this.producerConfig, type));
            }
            if (null != this.logTopic) {
                this.functionConfig.setLogTopic(this.logTopic);
            }
            if (null != this.className) {
                this.functionConfig.setClassName(this.className);
            }
            if (null != this.outputSerdeClassName) {
                this.functionConfig.setOutputSerdeClassName(this.outputSerdeClassName);
            }
            if (null != this.schemaType) {
                this.functionConfig.setOutputSchemaType(this.schemaType);
            }
            if (null != this.processingGuarantees) {
                this.functionConfig.setProcessingGuarantees(this.processingGuarantees);
            }
            if (null != this.retainOrdering) {
                this.functionConfig.setRetainOrdering(this.retainOrdering);
            }
            if (null != this.retainKeyOrdering) {
                this.functionConfig.setRetainKeyOrdering(this.retainKeyOrdering);
            }
            if (StringUtils.isNotBlank((String)this.batchBuilder)) {
                this.functionConfig.setBatchBuilder(this.batchBuilder);
            }
            if (null != this.forwardSourceMessageProperty) {
                this.functionConfig.setForwardSourceMessageProperty(this.forwardSourceMessageProperty);
            }
            if (StringUtils.isNotBlank((String)this.subsName)) {
                this.functionConfig.setSubName(this.subsName);
            }
            if (null != this.subsPosition) {
                this.functionConfig.setSubscriptionPosition(this.subsPosition);
            }
            if (null != this.userConfigString) {
                type = new TypeToken<Map<String, String>>(){}.getType();
                HashMap userConfigMap = (HashMap)new Gson().fromJson(this.userConfigString, type);
                if (userConfigMap == null) {
                    userConfigMap = new HashMap();
                }
                this.functionConfig.setUserConfig(userConfigMap);
            }
            if (this.parallelism != null) {
                this.functionConfig.setParallelism(this.parallelism);
            }
            Resources resources = this.functionConfig.getResources();
            if (this.cpu != null) {
                if (resources == null) {
                    resources = new Resources();
                }
                resources.setCpu(this.cpu);
            }
            if (this.ram != null) {
                if (resources == null) {
                    resources = new Resources();
                }
                resources.setRam(this.ram);
            }
            if (this.disk != null) {
                if (resources == null) {
                    resources = new Resources();
                }
                resources.setDisk(this.disk);
            }
            if (resources != null) {
                this.functionConfig.setResources(resources);
            }
            if (this.timeoutMs != null) {
                this.functionConfig.setTimeoutMs(this.timeoutMs);
            }
            if (this.customRuntimeOptions != null) {
                this.functionConfig.setCustomRuntimeOptions(this.customRuntimeOptions);
            }
            WindowConfig windowConfig = this.functionConfig.getWindowConfig();
            if (null != this.windowLengthCount) {
                if (windowConfig == null) {
                    windowConfig = new WindowConfig();
                }
                windowConfig.setWindowLengthCount(this.windowLengthCount);
            }
            if (null != this.windowLengthDurationMs) {
                if (windowConfig == null) {
                    windowConfig = new WindowConfig();
                }
                windowConfig.setWindowLengthDurationMs(this.windowLengthDurationMs);
            }
            if (null != this.slidingIntervalCount) {
                if (windowConfig == null) {
                    windowConfig = new WindowConfig();
                }
                windowConfig.setSlidingIntervalCount(this.slidingIntervalCount);
            }
            if (null != this.slidingIntervalDurationMs) {
                if (windowConfig == null) {
                    windowConfig = new WindowConfig();
                }
                windowConfig.setSlidingIntervalDurationMs(this.slidingIntervalDurationMs);
            }
            this.functionConfig.setWindowConfig(windowConfig);
            if (this.autoAck != null) {
                this.functionConfig.setAutoAck(this.autoAck);
            }
            if (null != this.maxMessageRetries) {
                this.functionConfig.setMaxMessageRetries(this.maxMessageRetries);
            }
            if (null != this.deadLetterTopic) {
                this.functionConfig.setDeadLetterTopic(this.deadLetterTopic);
            }
            if (null != this.jarFile) {
                this.functionConfig.setJar(this.jarFile);
            }
            if (null != this.pyFile) {
                this.functionConfig.setPy(this.pyFile);
            }
            if (null != this.goFile) {
                this.functionConfig.setGo(this.goFile);
            }
            if (this.functionConfig.getJar() != null) {
                this.userCodeFile = this.functionConfig.getJar();
            } else if (this.functionConfig.getPy() != null) {
                this.userCodeFile = this.functionConfig.getPy();
            } else if (this.functionConfig.getGo() != null) {
                this.userCodeFile = this.functionConfig.getGo();
            }
            this.validateFunctionConfigs(this.functionConfig);
        }

        protected void validateFunctionConfigs(FunctionConfig functionConfig) {
            if ((functionConfig.getRuntime() == FunctionConfig.Runtime.PYTHON || functionConfig.getRuntime() == FunctionConfig.Runtime.JAVA) && StringUtils.isEmpty((String)functionConfig.getClassName())) {
                throw new IllegalArgumentException("No Function Classname specified");
            }
            if (StringUtils.isEmpty((String)functionConfig.getName())) {
                Utils.inferMissingFunctionName((FunctionConfig)functionConfig);
            }
            if (StringUtils.isEmpty((String)functionConfig.getTenant())) {
                Utils.inferMissingTenant((FunctionConfig)functionConfig);
            }
            if (StringUtils.isEmpty((String)functionConfig.getNamespace())) {
                Utils.inferMissingNamespace((FunctionConfig)functionConfig);
            }
            if (StringUtils.isNotBlank((String)functionConfig.getJar()) && StringUtils.isNotBlank((String)functionConfig.getPy()) && StringUtils.isNotBlank((String)functionConfig.getGo())) {
                throw new ParameterException("Either a Java jar or a Python file or a Go executable binary needs to be specified for the function. Cannot specify both.");
            }
            if (StringUtils.isBlank((String)functionConfig.getJar()) && StringUtils.isBlank((String)functionConfig.getPy()) && StringUtils.isBlank((String)functionConfig.getGo())) {
                throw new ParameterException("Either a Java jar or a Python file or a Go executable binary needs to be specified for the function. Please specify one.");
            }
            if (!(StringUtils.isBlank((String)functionConfig.getJar()) || Utils.isFunctionPackageUrlSupported((String)functionConfig.getJar()) || new File(functionConfig.getJar()).exists())) {
                throw new ParameterException("The specified jar file does not exist");
            }
            if (!(StringUtils.isBlank((String)functionConfig.getPy()) || Utils.isFunctionPackageUrlSupported((String)functionConfig.getPy()) || new File(functionConfig.getPy()).exists())) {
                throw new ParameterException("The specified python file does not exist");
            }
            if (!(StringUtils.isBlank((String)functionConfig.getGo()) || Utils.isFunctionPackageUrlSupported((String)functionConfig.getGo()) || new File(functionConfig.getGo()).exists())) {
                throw new ParameterException("The specified go executable binary does not exist");
            }
        }

        public String getFqfn() {
            return this.fqfn;
        }

        public String getTenant() {
            return this.tenant;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getFunctionName() {
            return this.functionName;
        }

        public String getDEPRECATED_className() {
            return this.DEPRECATED_className;
        }

        public String getClassName() {
            return this.className;
        }

        public String getJarFile() {
            return this.jarFile;
        }

        public String getPyFile() {
            return this.pyFile;
        }

        public String getGoFile() {
            return this.goFile;
        }

        public String getInputs() {
            return this.inputs;
        }

        public String getDEPRECATED_topicsPattern() {
            return this.DEPRECATED_topicsPattern;
        }

        public String getTopicsPattern() {
            return this.topicsPattern;
        }

        public String getOutput() {
            return this.output;
        }

        public String getProducerConfig() {
            return this.producerConfig;
        }

        public String getDEPRECATED_logTopic() {
            return this.DEPRECATED_logTopic;
        }

        public String getLogTopic() {
            return this.logTopic;
        }

        public String getSchemaType() {
            return this.schemaType;
        }

        public String getDEPRECATED_customSerdeInputString() {
            return this.DEPRECATED_customSerdeInputString;
        }

        public String getCustomSerdeInputString() {
            return this.customSerdeInputString;
        }

        public String getCustomSchemaInputString() {
            return this.customSchemaInputString;
        }

        public String getCustomSchemaOutputString() {
            return this.customSchemaOutputString;
        }

        public String getInputSpecs() {
            return this.inputSpecs;
        }

        public String getDEPRECATED_outputSerdeClassName() {
            return this.DEPRECATED_outputSerdeClassName;
        }

        public String getOutputSerdeClassName() {
            return this.outputSerdeClassName;
        }

        public String getDEPRECATED_fnConfigFile() {
            return this.DEPRECATED_fnConfigFile;
        }

        public String getFnConfigFile() {
            return this.fnConfigFile;
        }

        public FunctionConfig.ProcessingGuarantees getDEPRECATED_processingGuarantees() {
            return this.DEPRECATED_processingGuarantees;
        }

        public FunctionConfig.ProcessingGuarantees getProcessingGuarantees() {
            return this.processingGuarantees;
        }

        public String getDEPRECATED_userConfigString() {
            return this.DEPRECATED_userConfigString;
        }

        public String getUserConfigString() {
            return this.userConfigString;
        }

        public Boolean getDEPRECATED_retainOrdering() {
            return this.DEPRECATED_retainOrdering;
        }

        public Boolean getRetainOrdering() {
            return this.retainOrdering;
        }

        public Boolean getRetainKeyOrdering() {
            return this.retainKeyOrdering;
        }

        public String getBatchBuilder() {
            return this.batchBuilder;
        }

        public Boolean getForwardSourceMessageProperty() {
            return this.forwardSourceMessageProperty;
        }

        public String getSubsName() {
            return this.subsName;
        }

        public SubscriptionInitialPosition getSubsPosition() {
            return this.subsPosition;
        }

        public Integer getParallelism() {
            return this.parallelism;
        }

        public Double getCpu() {
            return this.cpu;
        }

        public Long getRam() {
            return this.ram;
        }

        public Long getDisk() {
            return this.disk;
        }

        public Integer getDEPRECATED_windowLengthCount() {
            return this.DEPRECATED_windowLengthCount;
        }

        public Integer getWindowLengthCount() {
            return this.windowLengthCount;
        }

        public Long getDEPRECATED_windowLengthDurationMs() {
            return this.DEPRECATED_windowLengthDurationMs;
        }

        public Long getWindowLengthDurationMs() {
            return this.windowLengthDurationMs;
        }

        public Integer getDEPRECATED_slidingIntervalCount() {
            return this.DEPRECATED_slidingIntervalCount;
        }

        public Integer getSlidingIntervalCount() {
            return this.slidingIntervalCount;
        }

        public Long getDEPRECATED_slidingIntervalDurationMs() {
            return this.DEPRECATED_slidingIntervalDurationMs;
        }

        public Long getSlidingIntervalDurationMs() {
            return this.slidingIntervalDurationMs;
        }

        public Boolean getDEPRECATED_autoAck() {
            return this.DEPRECATED_autoAck;
        }

        public Boolean getAutoAck() {
            return this.autoAck;
        }

        public Long getDEPRECATED_timeoutMs() {
            return this.DEPRECATED_timeoutMs;
        }

        public Long getTimeoutMs() {
            return this.timeoutMs;
        }

        public Integer getMaxMessageRetries() {
            return this.maxMessageRetries;
        }

        public String getCustomRuntimeOptions() {
            return this.customRuntimeOptions;
        }

        public String getDeadLetterTopic() {
            return this.deadLetterTopic;
        }

        public FunctionConfig getFunctionConfig() {
            return this.functionConfig;
        }

        public String getUserCodeFile() {
            return this.userCodeFile;
        }
    }

    abstract class FunctionCommand
    extends BaseCommand {
        @Parameter(names={"--fqfn"}, description="The Fully Qualified Function Name (FQFN) for the function")
        protected String fqfn;
        @Parameter(names={"--tenant"}, description="The tenant of a Pulsar Function")
        protected String tenant;
        @Parameter(names={"--namespace"}, description="The namespace of a Pulsar Function")
        protected String namespace;
        @Parameter(names={"--name"}, description="The name of a Pulsar Function")
        protected String functionName;

        FunctionCommand() {
        }

        @Override
        void processArguments() throws Exception {
            boolean usesFqfn;
            super.processArguments();
            boolean usesSetters = null != this.tenant || null != this.namespace || null != this.functionName;
            boolean bl = usesFqfn = null != this.fqfn;
            if (usesFqfn && usesSetters) {
                throw new RuntimeException("You must specify either a Fully Qualified Function Name (FQFN) or tenant, namespace, and function name");
            }
            if (usesFqfn) {
                String[] fqfnParts = this.fqfn.split("/");
                if (fqfnParts.length != 3) {
                    throw new RuntimeException("Fully qualified function names (FQFNs) must be of the form tenant/namespace/name");
                }
                this.tenant = fqfnParts[0];
                this.namespace = fqfnParts[1];
                this.functionName = fqfnParts[2];
            } else {
                if (this.tenant == null) {
                    this.tenant = "public";
                }
                if (this.namespace == null) {
                    this.namespace = "default";
                }
                if (null == this.functionName) {
                    throw new RuntimeException("You must specify a name for the function or a Fully Qualified Function Name (FQFN)");
                }
            }
        }

        public String getFqfn() {
            return this.fqfn;
        }

        public String getTenant() {
            return this.tenant;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getFunctionName() {
            return this.functionName;
        }
    }

    abstract class NamespaceCommand
    extends BaseCommand {
        @Parameter(names={"--tenant"}, description="The tenant of a Pulsar Function")
        protected String tenant;
        @Parameter(names={"--namespace"}, description="The namespace of a Pulsar Function")
        protected String namespace;

        NamespaceCommand() {
        }

        @Override
        public void processArguments() {
            if (this.tenant == null) {
                this.tenant = "public";
            }
            if (this.namespace == null) {
                this.namespace = "default";
            }
        }

        public String getTenant() {
            return this.tenant;
        }

        public String getNamespace() {
            return this.namespace;
        }
    }

    abstract class BaseCommand
    extends CliCommand {
        BaseCommand() {
        }

        @Override
        void run() throws Exception {
            try {
                this.processArguments();
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                System.err.println();
                String chosenCommand = CmdFunctions.this.jcommander.getParsedCommand();
                CmdFunctions.this.getUsageFormatter().usage(chosenCommand);
                return;
            }
            this.runCmd();
        }

        void processArguments() throws Exception {
        }

        abstract void runCmd() throws Exception;
    }
}

