/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.auth;

import com.google.common.io.CharStreams;
import com.yahoo.athenz.auth.ServiceIdentityProvider;
import com.yahoo.athenz.auth.impl.SimpleServiceIdentityProvider;
import com.yahoo.athenz.auth.util.Crypto;
import com.yahoo.athenz.auth.util.CryptoException;
import com.yahoo.athenz.zts.RoleToken;
import com.yahoo.athenz.zts.ZTSClient;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.security.PrivateKey;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.AuthenticationDataProvider;
import org.apache.pulsar.client.api.EncodedAuthenticationParameterSupport;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.url.URL;
import org.apache.pulsar.client.impl.AuthenticationUtil;
import org.apache.pulsar.client.impl.auth.AuthenticationDataAthenz;

public class AuthenticationAthenz
implements Authentication,
EncodedAuthenticationParameterSupport {
    private static final long serialVersionUID = 1L;
    private static final String APPLICATION_X_PEM_FILE = "application/x-pem-file";
    private transient ZTSClient ztsClient = null;
    private String ztsUrl;
    private String tenantDomain;
    private String tenantService;
    private String providerDomain;
    private PrivateKey privateKey;
    private String keyId = "0";
    private String roleHeader = null;
    private boolean autoPrefetchEnabled = false;
    private long cachedRoleTokenTimestamp;
    private String roleToken;
    private final int minValidity = 7200;
    private final int maxValidity = 86400;
    private final int cacheDurationInHour = 1;

    public String getAuthMethodName() {
        return "athenz";
    }

    public synchronized AuthenticationDataProvider getAuthData() throws PulsarClientException {
        if (this.cachedRoleTokenIsValid()) {
            return new AuthenticationDataAthenz(this.roleToken, StringUtils.isNotBlank((CharSequence)this.roleHeader) ? this.roleHeader : ZTSClient.getHeader());
        }
        try {
            RoleToken token = this.getZtsClient().getRoleToken(this.providerDomain, null, Integer.valueOf(7200), Integer.valueOf(86400), false);
            this.roleToken = token.getToken();
            this.cachedRoleTokenTimestamp = System.nanoTime();
            return new AuthenticationDataAthenz(this.roleToken, StringUtils.isNotBlank((CharSequence)this.roleHeader) ? this.roleHeader : ZTSClient.getHeader());
        }
        catch (Throwable t) {
            throw new PulsarClientException.GettingAuthenticationDataException(t);
        }
    }

    private boolean cachedRoleTokenIsValid() {
        if (this.roleToken == null) {
            return false;
        }
        return System.nanoTime() - this.cachedRoleTokenTimestamp < TimeUnit.HOURS.toNanos(1L);
    }

    public void configure(String encodedAuthParamString) {
        if (StringUtils.isBlank((CharSequence)encodedAuthParamString)) {
            throw new IllegalArgumentException("authParams must not be empty");
        }
        try {
            this.setAuthParams(AuthenticationUtil.configureFromJsonString((String)encodedAuthParamString));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to parse authParams", e);
        }
    }

    @Deprecated
    public void configure(Map<String, String> authParams) {
        this.setAuthParams(authParams);
    }

    private void setAuthParams(Map<String, String> authParams) {
        this.tenantDomain = authParams.get("tenantDomain");
        this.tenantService = authParams.get("tenantService");
        this.providerDomain = authParams.get("providerDomain");
        this.privateKey = StringUtils.isBlank((CharSequence)authParams.get("privateKey")) && StringUtils.isNotBlank((CharSequence)authParams.get("privateKeyPath")) ? this.loadPrivateKey(authParams.get("privateKeyPath")) : this.loadPrivateKey(authParams.get("privateKey"));
        if (this.privateKey == null) {
            throw new IllegalArgumentException("Failed to load private key from privateKey or privateKeyPath field");
        }
        this.keyId = authParams.getOrDefault("keyId", "0");
        this.autoPrefetchEnabled = Boolean.valueOf(authParams.getOrDefault("autoPrefetchEnabled", "false"));
        if (StringUtils.isNotBlank((CharSequence)authParams.get("athenzConfPath"))) {
            System.setProperty("athenz.athenz_conf", authParams.get("athenzConfPath"));
        }
        if (StringUtils.isNotBlank((CharSequence)authParams.get("principalHeader"))) {
            System.setProperty("athenz.auth.principal.header", authParams.get("principalHeader"));
        }
        if (StringUtils.isNotBlank((CharSequence)authParams.get("roleHeader"))) {
            this.roleHeader = authParams.get("roleHeader");
            System.setProperty("athenz.auth.role.header", this.roleHeader);
        }
        if (StringUtils.isNotBlank((CharSequence)authParams.get("ztsUrl"))) {
            this.ztsUrl = authParams.get("ztsUrl");
        }
    }

    public void start() throws PulsarClientException {
    }

    public void close() throws IOException {
        if (this.ztsClient != null) {
            this.ztsClient.close();
        }
    }

    private ZTSClient getZtsClient() {
        if (this.ztsClient == null) {
            SimpleServiceIdentityProvider siaProvider = new SimpleServiceIdentityProvider(this.tenantDomain, this.tenantService, this.privateKey, this.keyId);
            this.ztsClient = new ZTSClient(this.ztsUrl, this.tenantDomain, this.tenantService, (ServiceIdentityProvider)siaProvider);
            ZTSClient.setPrefetchAutoEnable((boolean)this.autoPrefetchEnabled);
        }
        return this.ztsClient;
    }

    private PrivateKey loadPrivateKey(String privateKeyURL) {
        PrivateKey privateKey = null;
        try {
            URLConnection urlConnection = new URL(privateKeyURL).openConnection();
            String protocol = urlConnection.getURL().getProtocol();
            if ("data".equals(protocol) && !APPLICATION_X_PEM_FILE.equals(urlConnection.getContentType())) {
                throw new IllegalArgumentException("Unsupported media type or encoding format: " + urlConnection.getContentType());
            }
            String keyData = CharStreams.toString((Readable)new InputStreamReader((InputStream)urlConnection.getContent()));
            privateKey = Crypto.loadPrivateKey((String)keyData);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid privateKey format", e);
        }
        catch (CryptoException | IOException | IllegalAccessException | InstantiationException e) {
            privateKey = null;
        }
        return privateKey;
    }
}

