/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.util.netty;

import com.iterable.shade.io.netty.bootstrap.ServerBootstrap;
import com.iterable.shade.io.netty.channel.EventLoopGroup;
import com.iterable.shade.io.netty.channel.epoll.Epoll;
import com.iterable.shade.io.netty.channel.epoll.EpollChannelOption;
import com.iterable.shade.io.netty.channel.epoll.EpollDatagramChannel;
import com.iterable.shade.io.netty.channel.epoll.EpollEventLoopGroup;
import com.iterable.shade.io.netty.channel.epoll.EpollMode;
import com.iterable.shade.io.netty.channel.epoll.EpollServerSocketChannel;
import com.iterable.shade.io.netty.channel.epoll.EpollSocketChannel;
import com.iterable.shade.io.netty.channel.nio.NioEventLoopGroup;
import com.iterable.shade.io.netty.channel.socket.DatagramChannel;
import com.iterable.shade.io.netty.channel.socket.ServerSocketChannel;
import com.iterable.shade.io.netty.channel.socket.SocketChannel;
import com.iterable.shade.io.netty.channel.socket.nio.NioDatagramChannel;
import com.iterable.shade.io.netty.channel.socket.nio.NioServerSocketChannel;
import com.iterable.shade.io.netty.channel.socket.nio.NioSocketChannel;
import com.iterable.shade.io.netty.incubator.channel.uring.IOUring;
import com.iterable.shade.io.netty.incubator.channel.uring.IOUringDatagramChannel;
import com.iterable.shade.io.netty.incubator.channel.uring.IOUringEventLoopGroup;
import com.iterable.shade.io.netty.incubator.channel.uring.IOUringServerSocketChannel;
import com.iterable.shade.io.netty.incubator.channel.uring.IOUringSocketChannel;
import com.iterable.shade.org.apache.bookkeeper.common.util.affinity.CpuAffinity;
import com.iterable.shade.org.apache.commons.lang3.StringUtils;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadFactory;
import org.apache.pulsar.common.util.netty.NettyFutureUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventLoopUtil {
    private static final Logger log = LoggerFactory.getLogger(EventLoopUtil.class);
    private static final String ENABLE_IO_URING = "pulsar.enableUring";

    public static EventLoopGroup newEventLoopGroup(int nThreads, boolean enableBusyWait, ThreadFactory threadFactory) {
        if (Epoll.isAvailable()) {
            String enableIoUring = System.getProperty(ENABLE_IO_URING);
            if (StringUtils.equalsAnyIgnoreCase(enableIoUring, "1", "true")) {
                IOUring.ensureAvailability();
                return new IOUringEventLoopGroup(nThreads, threadFactory);
            }
            if (!enableBusyWait) {
                return new EpollEventLoopGroup(nThreads, threadFactory);
            }
            EpollEventLoopGroup eventLoopGroup = new EpollEventLoopGroup(nThreads, threadFactory, () -> (selectSupplier, hasTasks) -> -3);
            for (int i = 0; i < nThreads; ++i) {
                eventLoopGroup.next().submit(() -> {
                    try {
                        CpuAffinity.acquireCore();
                    }
                    catch (Throwable t2) {
                        log.warn("Failed to acquire CPU core for thread {} {}", new Object[]{Thread.currentThread().getName(), t2.getMessage(), t2});
                    }
                });
            }
            return eventLoopGroup;
        }
        return new NioEventLoopGroup(nThreads, threadFactory);
    }

    public static Class<? extends SocketChannel> getClientSocketChannelClass(EventLoopGroup eventLoopGroup) {
        if (eventLoopGroup instanceof IOUringEventLoopGroup) {
            return IOUringSocketChannel.class;
        }
        if (eventLoopGroup instanceof EpollEventLoopGroup) {
            return EpollSocketChannel.class;
        }
        return NioSocketChannel.class;
    }

    public static Class<? extends ServerSocketChannel> getServerSocketChannelClass(EventLoopGroup eventLoopGroup) {
        if (eventLoopGroup instanceof IOUringEventLoopGroup) {
            return IOUringServerSocketChannel.class;
        }
        if (eventLoopGroup instanceof EpollEventLoopGroup) {
            return EpollServerSocketChannel.class;
        }
        return NioServerSocketChannel.class;
    }

    public static Class<? extends DatagramChannel> getDatagramChannelClass(EventLoopGroup eventLoopGroup) {
        if (eventLoopGroup instanceof IOUringEventLoopGroup) {
            return IOUringDatagramChannel.class;
        }
        if (eventLoopGroup instanceof EpollEventLoopGroup) {
            return EpollDatagramChannel.class;
        }
        return NioDatagramChannel.class;
    }

    public static void enableTriggeredMode(ServerBootstrap bootstrap) {
        if (Epoll.isAvailable()) {
            bootstrap.childOption(EpollChannelOption.EPOLL_MODE, EpollMode.LEVEL_TRIGGERED);
        }
    }

    public static CompletableFuture<Void> shutdownGracefully(EventLoopGroup eventLoopGroup) {
        return NettyFutureUtil.toCompletableFutureVoid(eventLoopGroup.shutdownGracefully());
    }
}

