/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.util.collections;

import com.iterable.shade.org.apache.commons.lang.mutable.MutableInt;
import com.iterable.shade.org.apache.commons.lang.mutable.MutableLong;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.pulsar.common.util.collections.ConcurrentLongPairSet;
import org.apache.pulsar.common.util.collections.LongPairSet;

public class ConcurrentSortedLongPairSet
implements LongPairSet {
    protected final NavigableMap<Long, ConcurrentLongPairSet> longPairSets = new ConcurrentSkipListMap<Long, ConcurrentLongPairSet>();
    private final int expectedItems;
    private final int concurrencyLevel;
    private final int maxAllowedSetOnRemove;
    private final boolean autoShrink;
    private static final int DEFAULT_MAX_ALLOWED_SET_ON_REMOVE = 10;

    public ConcurrentSortedLongPairSet() {
        this(16, 1, 10);
    }

    public ConcurrentSortedLongPairSet(int expectedItems) {
        this(expectedItems, 1, 10);
    }

    public ConcurrentSortedLongPairSet(int expectedItems, int concurrencyLevel) {
        this(expectedItems, concurrencyLevel, 10);
    }

    public ConcurrentSortedLongPairSet(int expectedItems, int concurrencyLevel, boolean autoShrink) {
        this(expectedItems, concurrencyLevel, 10, autoShrink);
    }

    public ConcurrentSortedLongPairSet(int expectedItems, int concurrencyLevel, int maxAllowedSetOnRemove) {
        this(expectedItems, concurrencyLevel, maxAllowedSetOnRemove, false);
    }

    public ConcurrentSortedLongPairSet(int expectedItems, int concurrencyLevel, int maxAllowedSetOnRemove, boolean autoShrink) {
        this.expectedItems = expectedItems;
        this.concurrencyLevel = concurrencyLevel;
        this.maxAllowedSetOnRemove = maxAllowedSetOnRemove;
        this.autoShrink = autoShrink;
    }

    @Override
    public boolean add(long item1, long item2) {
        ConcurrentLongPairSet messagesToReplay = this.longPairSets.computeIfAbsent(item1, key -> ConcurrentLongPairSet.newBuilder().expectedItems(this.expectedItems).concurrencyLevel(this.concurrencyLevel).autoShrink(this.autoShrink).build());
        return messagesToReplay.add(item1, item2);
    }

    @Override
    public boolean remove(long item1, long item2) {
        ConcurrentLongPairSet messagesToReplay = (ConcurrentLongPairSet)this.longPairSets.get(item1);
        if (messagesToReplay != null) {
            boolean removed = messagesToReplay.remove(item1, item2);
            if (messagesToReplay.isEmpty() && this.longPairSets.size() > this.maxAllowedSetOnRemove) {
                this.longPairSets.remove(item1, messagesToReplay);
            }
            return removed;
        }
        return false;
    }

    @Override
    public int removeIf(LongPairSet.LongPairPredicate filter) {
        MutableInt removedValues = new MutableInt(0);
        this.longPairSets.forEach((? super K item1, ? super V longPairSet) -> {
            removedValues.add(longPairSet.removeIf(filter));
            if (longPairSet.isEmpty() && this.longPairSets.size() > this.maxAllowedSetOnRemove) {
                this.longPairSets.remove(item1, longPairSet);
            }
        });
        return removedValues.intValue();
    }

    @Override
    public Set<ConcurrentLongPairSet.LongPair> items() {
        return this.items((int)this.size());
    }

    @Override
    public void forEach(ConcurrentLongPairSet.LongPairConsumer processor) {
        this.longPairSets.forEach((? super K __, ? super V longPairSet) -> longPairSet.forEach(processor));
    }

    @Override
    public Set<ConcurrentLongPairSet.LongPair> items(int numberOfItems) {
        return this.items(numberOfItems, (item1, item2) -> new ConcurrentLongPairSet.LongPair(item1, item2));
    }

    @Override
    public <T> Set<T> items(int numberOfItems, LongPairSet.LongPairFunction<T> longPairConverter) {
        TreeSet items = new TreeSet();
        this.forEach((i1, i2) -> {
            items.add(longPairConverter.apply(i1, i2));
            if (items.size() > numberOfItems) {
                items.pollLast();
            }
        });
        return items;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        AtomicBoolean first = new AtomicBoolean(true);
        this.longPairSets.forEach((? super K key, ? super V longPairSet) -> longPairSet.forEach((item1, item2) -> {
            if (!first.getAndSet(false)) {
                sb.append(", ");
            }
            sb.append('[');
            sb.append(item1);
            sb.append(':');
            sb.append(item2);
            sb.append(']');
        }));
        sb.append('}');
        return sb.toString();
    }

    @Override
    public boolean isEmpty() {
        if (this.longPairSets.isEmpty()) {
            return true;
        }
        for (ConcurrentLongPairSet subSet : this.longPairSets.values()) {
            if (subSet.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void clear() {
        this.longPairSets.clear();
    }

    @Override
    public long size() {
        MutableLong size = new MutableLong(0L);
        this.longPairSets.forEach((? super K __, ? super V longPairSet) -> size.add(longPairSet.size()));
        return size.longValue();
    }

    @Override
    public long capacity() {
        MutableLong capacity = new MutableLong(0L);
        this.longPairSets.forEach((? super K __, ? super V longPairSet) -> capacity.add(longPairSet.capacity()));
        return capacity.longValue();
    }

    @Override
    public boolean contains(long item1, long item2) {
        ConcurrentLongPairSet longPairSet = (ConcurrentLongPairSet)this.longPairSets.get(item1);
        if (longPairSet != null) {
            return longPairSet.contains(item1, item2);
        }
        return false;
    }
}

