/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.stats;

import com.iterable.shade.com.google.common.base.Preconditions;
import java.util.concurrent.atomic.LongAdder;

public class Rate {
    private final LongAdder valueAdder = new LongAdder();
    private final LongAdder countAdder = new LongAdder();
    private final LongAdder totalCountAdder = new LongAdder();
    private long count = 0L;
    private double rate = 0.0;
    private double valueRate = 0.0;
    private double averageValue = 0.0;
    private long lastCalculatedTime = System.nanoTime();

    public void recordEvent() {
        this.countAdder.increment();
        this.totalCountAdder.increment();
    }

    public void recordEvent(long value) {
        this.valueAdder.add(value);
        this.countAdder.increment();
        this.totalCountAdder.increment();
    }

    public void recordMultipleEvents(long events, long totalValue) {
        this.valueAdder.add(totalValue);
        this.countAdder.add(events);
        this.totalCountAdder.add(events);
    }

    public void calculateRate() {
        double period = (double)(System.nanoTime() - this.lastCalculatedTime) / 1.0E9;
        this.calculateRate(period);
        this.lastCalculatedTime = System.nanoTime();
    }

    public void calculateRate(double period) {
        Preconditions.checkArgument(period > 0.0, "Invalid period %s to calculate rate", (Object)period);
        this.count = this.countAdder.sumThenReset();
        long sum = this.valueAdder.sumThenReset();
        this.averageValue = this.count != 0L ? Long.valueOf(sum).doubleValue() / Long.valueOf(this.count).doubleValue() : 0.0;
        this.rate = (double)this.count / period;
        this.valueRate = (double)sum / period;
    }

    public long getCount() {
        return this.count;
    }

    public double getAverageValue() {
        return this.averageValue;
    }

    public double getRate() {
        return this.rate;
    }

    public double getValueRate() {
        return this.valueRate;
    }

    public long getTotalCount() {
        return this.totalCountAdder.longValue();
    }
}

