/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.api.raw;

import com.iterable.shade.io.netty.buffer.ByteBuf;
import com.iterable.shade.io.netty.util.AbstractReferenceCounted;
import com.iterable.shade.io.netty.util.Recycler;
import com.iterable.shade.io.netty.util.ReferenceCounted;
import org.apache.pulsar.common.api.proto.MessageMetadata;

public class ReferenceCountedMessageMetadata
extends AbstractReferenceCounted {
    private static final Recycler<ReferenceCountedMessageMetadata> RECYCLER = new Recycler<ReferenceCountedMessageMetadata>(){

        @Override
        protected ReferenceCountedMessageMetadata newObject(Recycler.Handle<ReferenceCountedMessageMetadata> handle) {
            return new ReferenceCountedMessageMetadata(handle);
        }
    };
    private final MessageMetadata metadata = new MessageMetadata();
    private ByteBuf parsedBuf;
    private final Recycler.Handle<ReferenceCountedMessageMetadata> handle;

    private ReferenceCountedMessageMetadata(Recycler.Handle<ReferenceCountedMessageMetadata> handle) {
        this.handle = handle;
    }

    public static ReferenceCountedMessageMetadata get(ByteBuf parsedBuf) {
        ReferenceCountedMessageMetadata ref = RECYCLER.get();
        ref.parsedBuf = parsedBuf;
        ref.parsedBuf.retain();
        ref.setRefCnt(1);
        return ref;
    }

    public MessageMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public ReferenceCounted touch(Object hint) {
        return this;
    }

    @Override
    protected void deallocate() {
        if (this.parsedBuf != null) {
            this.parsedBuf.release();
        }
        this.metadata.clear();
        this.handle.recycle(this);
    }
}

