/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.api.proto;

import com.iterable.shade.io.netty.buffer.ByteBuf;
import com.iterable.shade.io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pulsar.common.api.proto.LightProtoCodec;

public final class CommandWatchTopicUpdate {
    private long watcherId;
    private static final int _WATCHER_ID_FIELD_NUMBER = 1;
    private static final int _WATCHER_ID_TAG = 8;
    private static final int _WATCHER_ID_TAG_SIZE = LightProtoCodec.computeVarIntSize(8);
    private static final int _WATCHER_ID_MASK = 1;
    private List<LightProtoCodec.StringHolder> newTopics = null;
    private int _newTopicsCount = 0;
    private static final int _NEW_TOPICS_FIELD_NUMBER = 2;
    private static final int _NEW_TOPICS_TAG = 18;
    private static final int _NEW_TOPICS_TAG_SIZE = LightProtoCodec.computeVarIntSize(18);
    private List<LightProtoCodec.StringHolder> deletedTopics = null;
    private int _deletedTopicsCount = 0;
    private static final int _DELETED_TOPICS_FIELD_NUMBER = 3;
    private static final int _DELETED_TOPICS_TAG = 26;
    private static final int _DELETED_TOPICS_TAG_SIZE = LightProtoCodec.computeVarIntSize(26);
    private String topicsHash;
    private int _topicsHashBufferIdx = -1;
    private int _topicsHashBufferLen = -1;
    private static final int _TOPICS_HASH_FIELD_NUMBER = 4;
    private static final int _TOPICS_HASH_TAG = 34;
    private static final int _TOPICS_HASH_TAG_SIZE = LightProtoCodec.computeVarIntSize(34);
    private static final int _TOPICS_HASH_MASK = 8;
    private int _bitField0;
    private static final int _REQUIRED_FIELDS_MASK0 = 9;
    private int _cachedSize;
    private ByteBuf _parsedBuffer;

    public boolean hasWatcherId() {
        return (this._bitField0 & 1) != 0;
    }

    public long getWatcherId() {
        if (!this.hasWatcherId()) {
            throw new IllegalStateException("Field 'watcher_id' is not set");
        }
        return this.watcherId;
    }

    public CommandWatchTopicUpdate setWatcherId(long watcherId) {
        this.watcherId = watcherId;
        this._bitField0 |= 1;
        this._cachedSize = -1;
        return this;
    }

    public CommandWatchTopicUpdate clearWatcherId() {
        this._bitField0 &= 0xFFFFFFFE;
        return this;
    }

    public int getNewTopicsCount() {
        return this._newTopicsCount;
    }

    public String getNewTopicAt(int idx) {
        if (idx < 0 || idx >= this._newTopicsCount) {
            throw new IndexOutOfBoundsException("Index " + idx + " is out of the list size (" + this._newTopicsCount + ") for field 'new_topics'");
        }
        LightProtoCodec.StringHolder _sh = this.newTopics.get(idx);
        if (_sh.s == null) {
            _sh.s = LightProtoCodec.readString(this._parsedBuffer, _sh.idx, _sh.len);
        }
        return _sh.s;
    }

    public List<String> getNewTopicsList() {
        if (this._newTopicsCount == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> _l = new ArrayList<String>();
        for (int i = 0; i < this._newTopicsCount; ++i) {
            _l.add(this.getNewTopicAt(i));
        }
        return _l;
    }

    public void addNewTopic(String newTopic) {
        if (this.newTopics == null) {
            this.newTopics = new ArrayList<LightProtoCodec.StringHolder>();
        }
        LightProtoCodec.StringHolder _sh = this._newNewTopicStringHolder();
        this._cachedSize = -1;
        _sh.s = newTopic;
        _sh.idx = -1;
        _sh.len = LightProtoCodec.computeStringUTF8Size(_sh.s);
    }

    public CommandWatchTopicUpdate addAllNewTopics(Iterable<String> newTopics) {
        for (String _s : newTopics) {
            this.addNewTopic(_s);
        }
        return this;
    }

    private LightProtoCodec.StringHolder _newNewTopicStringHolder() {
        LightProtoCodec.StringHolder _sh;
        if (this.newTopics == null) {
            this.newTopics = new ArrayList<LightProtoCodec.StringHolder>();
        }
        if (this.newTopics.size() == this._newTopicsCount) {
            _sh = new LightProtoCodec.StringHolder();
            this.newTopics.add(_sh);
        } else {
            _sh = this.newTopics.get(this._newTopicsCount);
        }
        ++this._newTopicsCount;
        return _sh;
    }

    public CommandWatchTopicUpdate clearNewTopics() {
        for (int i = 0; i < this._newTopicsCount; ++i) {
            LightProtoCodec.StringHolder _sh = this.newTopics.get(i);
            _sh.s = null;
            _sh.idx = -1;
            _sh.len = -1;
        }
        this._newTopicsCount = 0;
        return this;
    }

    public int getDeletedTopicsCount() {
        return this._deletedTopicsCount;
    }

    public String getDeletedTopicAt(int idx) {
        if (idx < 0 || idx >= this._deletedTopicsCount) {
            throw new IndexOutOfBoundsException("Index " + idx + " is out of the list size (" + this._deletedTopicsCount + ") for field 'deleted_topics'");
        }
        LightProtoCodec.StringHolder _sh = this.deletedTopics.get(idx);
        if (_sh.s == null) {
            _sh.s = LightProtoCodec.readString(this._parsedBuffer, _sh.idx, _sh.len);
        }
        return _sh.s;
    }

    public List<String> getDeletedTopicsList() {
        if (this._deletedTopicsCount == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> _l = new ArrayList<String>();
        for (int i = 0; i < this._deletedTopicsCount; ++i) {
            _l.add(this.getDeletedTopicAt(i));
        }
        return _l;
    }

    public void addDeletedTopic(String deletedTopic) {
        if (this.deletedTopics == null) {
            this.deletedTopics = new ArrayList<LightProtoCodec.StringHolder>();
        }
        LightProtoCodec.StringHolder _sh = this._newDeletedTopicStringHolder();
        this._cachedSize = -1;
        _sh.s = deletedTopic;
        _sh.idx = -1;
        _sh.len = LightProtoCodec.computeStringUTF8Size(_sh.s);
    }

    public CommandWatchTopicUpdate addAllDeletedTopics(Iterable<String> deletedTopics) {
        for (String _s : deletedTopics) {
            this.addDeletedTopic(_s);
        }
        return this;
    }

    private LightProtoCodec.StringHolder _newDeletedTopicStringHolder() {
        LightProtoCodec.StringHolder _sh;
        if (this.deletedTopics == null) {
            this.deletedTopics = new ArrayList<LightProtoCodec.StringHolder>();
        }
        if (this.deletedTopics.size() == this._deletedTopicsCount) {
            _sh = new LightProtoCodec.StringHolder();
            this.deletedTopics.add(_sh);
        } else {
            _sh = this.deletedTopics.get(this._deletedTopicsCount);
        }
        ++this._deletedTopicsCount;
        return _sh;
    }

    public CommandWatchTopicUpdate clearDeletedTopics() {
        for (int i = 0; i < this._deletedTopicsCount; ++i) {
            LightProtoCodec.StringHolder _sh = this.deletedTopics.get(i);
            _sh.s = null;
            _sh.idx = -1;
            _sh.len = -1;
        }
        this._deletedTopicsCount = 0;
        return this;
    }

    public boolean hasTopicsHash() {
        return (this._bitField0 & 8) != 0;
    }

    public String getTopicsHash() {
        if (!this.hasTopicsHash()) {
            throw new IllegalStateException("Field 'topics_hash' is not set");
        }
        if (this.topicsHash == null) {
            this.topicsHash = LightProtoCodec.readString(this._parsedBuffer, this._topicsHashBufferIdx, this._topicsHashBufferLen);
        }
        return this.topicsHash;
    }

    public CommandWatchTopicUpdate setTopicsHash(String topicsHash) {
        this.topicsHash = topicsHash;
        this._bitField0 |= 8;
        this._topicsHashBufferIdx = -1;
        this._topicsHashBufferLen = LightProtoCodec.computeStringUTF8Size(topicsHash);
        this._cachedSize = -1;
        return this;
    }

    public CommandWatchTopicUpdate clearTopicsHash() {
        this._bitField0 &= 0xFFFFFFF7;
        this.topicsHash = null;
        this._topicsHashBufferIdx = -1;
        this._topicsHashBufferLen = -1;
        return this;
    }

    public int writeTo(ByteBuf _b) {
        LightProtoCodec.StringHolder _sh;
        int i;
        this.checkRequiredFields();
        int _writeIdx = _b.writerIndex();
        LightProtoCodec.writeVarInt(_b, 8);
        LightProtoCodec.writeVarInt64(_b, this.watcherId);
        for (i = 0; i < this._newTopicsCount; ++i) {
            _sh = this.newTopics.get(i);
            LightProtoCodec.writeVarInt(_b, 18);
            LightProtoCodec.writeVarInt(_b, _sh.len);
            if (_sh.idx == -1) {
                LightProtoCodec.writeString(_b, _sh.s, _sh.len);
                continue;
            }
            this._parsedBuffer.getBytes(_sh.idx, _b, _sh.len);
        }
        for (i = 0; i < this._deletedTopicsCount; ++i) {
            _sh = this.deletedTopics.get(i);
            LightProtoCodec.writeVarInt(_b, 26);
            LightProtoCodec.writeVarInt(_b, _sh.len);
            if (_sh.idx == -1) {
                LightProtoCodec.writeString(_b, _sh.s, _sh.len);
                continue;
            }
            this._parsedBuffer.getBytes(_sh.idx, _b, _sh.len);
        }
        LightProtoCodec.writeVarInt(_b, 34);
        LightProtoCodec.writeVarInt(_b, this._topicsHashBufferLen);
        if (this._topicsHashBufferIdx == -1) {
            LightProtoCodec.writeString(_b, this.topicsHash, this._topicsHashBufferLen);
        } else {
            this._parsedBuffer.getBytes(this._topicsHashBufferIdx, _b, this._topicsHashBufferLen);
        }
        return _b.writerIndex() - _writeIdx;
    }

    public int getSerializedSize() {
        LightProtoCodec.StringHolder _sh;
        int i;
        if (this._cachedSize > -1) {
            return this._cachedSize;
        }
        int _size = 0;
        _size += _WATCHER_ID_TAG_SIZE;
        _size += LightProtoCodec.computeVarInt64Size(this.watcherId);
        for (i = 0; i < this._newTopicsCount; ++i) {
            _sh = this.newTopics.get(i);
            _size += _NEW_TOPICS_TAG_SIZE;
            _size += LightProtoCodec.computeVarIntSize(_sh.len) + _sh.len;
        }
        for (i = 0; i < this._deletedTopicsCount; ++i) {
            _sh = this.deletedTopics.get(i);
            _size += _DELETED_TOPICS_TAG_SIZE;
            _size += LightProtoCodec.computeVarIntSize(_sh.len) + _sh.len;
        }
        _size += _TOPICS_HASH_TAG_SIZE;
        _size += LightProtoCodec.computeVarIntSize(this._topicsHashBufferLen);
        this._cachedSize = _size += this._topicsHashBufferLen;
        return _size;
    }

    public void parseFrom(ByteBuf _buffer, int _size) {
        this.clear();
        int _endIdx = _buffer.readerIndex() + _size;
        block6: while (_buffer.readerIndex() < _endIdx) {
            int _tag = LightProtoCodec.readVarInt(_buffer);
            switch (_tag) {
                case 8: {
                    this._bitField0 |= 1;
                    this.watcherId = LightProtoCodec.readVarInt64(_buffer);
                    continue block6;
                }
                case 18: {
                    LightProtoCodec.StringHolder _newTopicsSh = this._newNewTopicStringHolder();
                    _newTopicsSh.len = LightProtoCodec.readVarInt(_buffer);
                    _newTopicsSh.idx = _buffer.readerIndex();
                    _buffer.skipBytes(_newTopicsSh.len);
                    continue block6;
                }
                case 26: {
                    LightProtoCodec.StringHolder _deletedTopicsSh = this._newDeletedTopicStringHolder();
                    _deletedTopicsSh.len = LightProtoCodec.readVarInt(_buffer);
                    _deletedTopicsSh.idx = _buffer.readerIndex();
                    _buffer.skipBytes(_deletedTopicsSh.len);
                    continue block6;
                }
                case 34: {
                    this._bitField0 |= 8;
                    this._topicsHashBufferLen = LightProtoCodec.readVarInt(_buffer);
                    this._topicsHashBufferIdx = _buffer.readerIndex();
                    _buffer.skipBytes(this._topicsHashBufferLen);
                    continue block6;
                }
            }
            LightProtoCodec.skipUnknownField(_tag, _buffer);
        }
        this.checkRequiredFields();
        this._parsedBuffer = _buffer;
    }

    private void checkRequiredFields() {
        if ((this._bitField0 & 9) != 9) {
            throw new IllegalStateException("Some required fields are missing");
        }
    }

    public CommandWatchTopicUpdate clear() {
        LightProtoCodec.StringHolder _sh;
        int i;
        for (i = 0; i < this._newTopicsCount; ++i) {
            _sh = this.newTopics.get(i);
            _sh.s = null;
            _sh.idx = -1;
            _sh.len = -1;
        }
        this._newTopicsCount = 0;
        for (i = 0; i < this._deletedTopicsCount; ++i) {
            _sh = this.deletedTopics.get(i);
            _sh.s = null;
            _sh.idx = -1;
            _sh.len = -1;
        }
        this._deletedTopicsCount = 0;
        this.topicsHash = null;
        this._topicsHashBufferIdx = -1;
        this._topicsHashBufferLen = -1;
        this._parsedBuffer = null;
        this._cachedSize = -1;
        this._bitField0 = 0;
        return this;
    }

    public CommandWatchTopicUpdate copyFrom(CommandWatchTopicUpdate _other) {
        int i;
        this._cachedSize = -1;
        if (_other.hasWatcherId()) {
            this.setWatcherId(_other.watcherId);
        }
        for (i = 0; i < _other.getNewTopicsCount(); ++i) {
            this.addNewTopic(_other.getNewTopicAt(i));
        }
        for (i = 0; i < _other.getDeletedTopicsCount(); ++i) {
            this.addDeletedTopic(_other.getDeletedTopicAt(i));
        }
        if (_other.hasTopicsHash()) {
            this.setTopicsHash(_other.getTopicsHash());
        }
        return this;
    }

    public byte[] toByteArray() {
        byte[] a = new byte[this.getSerializedSize()];
        ByteBuf b = Unpooled.wrappedBuffer(a).writerIndex(0);
        this.writeTo(b);
        return a;
    }

    public void parseFrom(byte[] a) {
        ByteBuf b = Unpooled.wrappedBuffer(a);
        this.parseFrom(b, b.readableBytes());
    }
}

