/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.api.proto;

import com.iterable.shade.io.netty.buffer.ByteBuf;
import com.iterable.shade.io.netty.buffer.Unpooled;
import org.apache.pulsar.common.api.proto.LightProtoCodec;
import org.apache.pulsar.common.api.proto.MessageIdData;

public final class CommandSendReceipt {
    private long producerId;
    private static final int _PRODUCER_ID_FIELD_NUMBER = 1;
    private static final int _PRODUCER_ID_TAG = 8;
    private static final int _PRODUCER_ID_TAG_SIZE = LightProtoCodec.computeVarIntSize(8);
    private static final int _PRODUCER_ID_MASK = 1;
    private long sequenceId;
    private static final int _SEQUENCE_ID_FIELD_NUMBER = 2;
    private static final int _SEQUENCE_ID_TAG = 16;
    private static final int _SEQUENCE_ID_TAG_SIZE = LightProtoCodec.computeVarIntSize(16);
    private static final int _SEQUENCE_ID_MASK = 2;
    private MessageIdData messageId;
    private static final int _MESSAGE_ID_FIELD_NUMBER = 3;
    private static final int _MESSAGE_ID_TAG = 26;
    private static final int _MESSAGE_ID_TAG_SIZE = LightProtoCodec.computeVarIntSize(26);
    private static final int _MESSAGE_ID_MASK = 4;
    private long highestSequenceId = 0L;
    private static final int _HIGHEST_SEQUENCE_ID_FIELD_NUMBER = 4;
    private static final int _HIGHEST_SEQUENCE_ID_TAG = 32;
    private static final int _HIGHEST_SEQUENCE_ID_TAG_SIZE = LightProtoCodec.computeVarIntSize(32);
    private static final int _HIGHEST_SEQUENCE_ID_MASK = 8;
    private int _bitField0;
    private static final int _REQUIRED_FIELDS_MASK0 = 3;
    private int _cachedSize;
    private ByteBuf _parsedBuffer;

    public boolean hasProducerId() {
        return (this._bitField0 & 1) != 0;
    }

    public long getProducerId() {
        if (!this.hasProducerId()) {
            throw new IllegalStateException("Field 'producer_id' is not set");
        }
        return this.producerId;
    }

    public CommandSendReceipt setProducerId(long producerId) {
        this.producerId = producerId;
        this._bitField0 |= 1;
        this._cachedSize = -1;
        return this;
    }

    public CommandSendReceipt clearProducerId() {
        this._bitField0 &= 0xFFFFFFFE;
        return this;
    }

    public boolean hasSequenceId() {
        return (this._bitField0 & 2) != 0;
    }

    public long getSequenceId() {
        if (!this.hasSequenceId()) {
            throw new IllegalStateException("Field 'sequence_id' is not set");
        }
        return this.sequenceId;
    }

    public CommandSendReceipt setSequenceId(long sequenceId) {
        this.sequenceId = sequenceId;
        this._bitField0 |= 2;
        this._cachedSize = -1;
        return this;
    }

    public CommandSendReceipt clearSequenceId() {
        this._bitField0 &= 0xFFFFFFFD;
        return this;
    }

    public boolean hasMessageId() {
        return (this._bitField0 & 4) != 0;
    }

    public MessageIdData getMessageId() {
        if (!this.hasMessageId()) {
            throw new IllegalStateException("Field 'message_id' is not set");
        }
        return this.messageId;
    }

    public MessageIdData setMessageId() {
        if (this.messageId == null) {
            this.messageId = new MessageIdData();
        }
        this._bitField0 |= 4;
        this._cachedSize = -1;
        return this.messageId;
    }

    public CommandSendReceipt clearMessageId() {
        this._bitField0 &= 0xFFFFFFFB;
        if (this.hasMessageId()) {
            this.messageId.clear();
        }
        return this;
    }

    public boolean hasHighestSequenceId() {
        return (this._bitField0 & 8) != 0;
    }

    public long getHighestSequenceId() {
        return this.highestSequenceId;
    }

    public CommandSendReceipt setHighestSequenceId(long highestSequenceId) {
        this.highestSequenceId = highestSequenceId;
        this._bitField0 |= 8;
        this._cachedSize = -1;
        return this;
    }

    public CommandSendReceipt clearHighestSequenceId() {
        this._bitField0 &= 0xFFFFFFF7;
        this.highestSequenceId = 0L;
        return this;
    }

    public int writeTo(ByteBuf _b) {
        this.checkRequiredFields();
        int _writeIdx = _b.writerIndex();
        LightProtoCodec.writeVarInt(_b, 8);
        LightProtoCodec.writeVarInt64(_b, this.producerId);
        LightProtoCodec.writeVarInt(_b, 16);
        LightProtoCodec.writeVarInt64(_b, this.sequenceId);
        if (this.hasMessageId()) {
            LightProtoCodec.writeVarInt(_b, 26);
            LightProtoCodec.writeVarInt(_b, this.messageId.getSerializedSize());
            this.messageId.writeTo(_b);
        }
        if (this.hasHighestSequenceId()) {
            LightProtoCodec.writeVarInt(_b, 32);
            LightProtoCodec.writeVarInt64(_b, this.highestSequenceId);
        }
        return _b.writerIndex() - _writeIdx;
    }

    public int getSerializedSize() {
        if (this._cachedSize > -1) {
            return this._cachedSize;
        }
        int _size = 0;
        _size += _PRODUCER_ID_TAG_SIZE;
        _size += LightProtoCodec.computeVarInt64Size(this.producerId);
        _size += _SEQUENCE_ID_TAG_SIZE;
        _size += LightProtoCodec.computeVarInt64Size(this.sequenceId);
        if (this.hasMessageId()) {
            _size += LightProtoCodec.computeVarIntSize(26);
            int MsgsizeMessageId = this.messageId.getSerializedSize();
            _size += LightProtoCodec.computeVarIntSize(MsgsizeMessageId) + MsgsizeMessageId;
        }
        if (this.hasHighestSequenceId()) {
            _size += _HIGHEST_SEQUENCE_ID_TAG_SIZE;
            _size += LightProtoCodec.computeVarInt64Size(this.highestSequenceId);
        }
        this._cachedSize = _size;
        return _size;
    }

    public void parseFrom(ByteBuf _buffer, int _size) {
        this.clear();
        int _endIdx = _buffer.readerIndex() + _size;
        block6: while (_buffer.readerIndex() < _endIdx) {
            int _tag = LightProtoCodec.readVarInt(_buffer);
            switch (_tag) {
                case 8: {
                    this._bitField0 |= 1;
                    this.producerId = LightProtoCodec.readVarInt64(_buffer);
                    continue block6;
                }
                case 16: {
                    this._bitField0 |= 2;
                    this.sequenceId = LightProtoCodec.readVarInt64(_buffer);
                    continue block6;
                }
                case 26: {
                    this._bitField0 |= 4;
                    int messageIdSize = LightProtoCodec.readVarInt(_buffer);
                    this.setMessageId().parseFrom(_buffer, messageIdSize);
                    continue block6;
                }
                case 32: {
                    this._bitField0 |= 8;
                    this.highestSequenceId = LightProtoCodec.readVarInt64(_buffer);
                    continue block6;
                }
            }
            LightProtoCodec.skipUnknownField(_tag, _buffer);
        }
        this.checkRequiredFields();
        this._parsedBuffer = _buffer;
    }

    private void checkRequiredFields() {
        if ((this._bitField0 & 3) != 3) {
            throw new IllegalStateException("Some required fields are missing");
        }
    }

    public CommandSendReceipt clear() {
        if (this.hasMessageId()) {
            this.messageId.clear();
        }
        this.highestSequenceId = 0L;
        this._parsedBuffer = null;
        this._cachedSize = -1;
        this._bitField0 = 0;
        return this;
    }

    public CommandSendReceipt copyFrom(CommandSendReceipt _other) {
        this._cachedSize = -1;
        if (_other.hasProducerId()) {
            this.setProducerId(_other.producerId);
        }
        if (_other.hasSequenceId()) {
            this.setSequenceId(_other.sequenceId);
        }
        if (_other.hasMessageId()) {
            this.setMessageId().copyFrom(_other.messageId);
        }
        if (_other.hasHighestSequenceId()) {
            this.setHighestSequenceId(_other.highestSequenceId);
        }
        return this;
    }

    public byte[] toByteArray() {
        byte[] a = new byte[this.getSerializedSize()];
        ByteBuf b = Unpooled.wrappedBuffer(a).writerIndex(0);
        this.writeTo(b);
        return a;
    }

    public void parseFrom(byte[] a) {
        ByteBuf b = Unpooled.wrappedBuffer(a);
        this.parseFrom(b, b.readableBytes());
    }
}

