/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.api.proto;

import com.iterable.shade.io.netty.buffer.ByteBuf;
import com.iterable.shade.io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pulsar.common.api.proto.KeyValue;
import org.apache.pulsar.common.api.proto.LightProtoCodec;
import org.apache.pulsar.common.api.proto.ProducerAccessMode;
import org.apache.pulsar.common.api.proto.Schema;

public final class CommandProducer {
    private String topic;
    private int _topicBufferIdx = -1;
    private int _topicBufferLen = -1;
    private static final int _TOPIC_FIELD_NUMBER = 1;
    private static final int _TOPIC_TAG = 10;
    private static final int _TOPIC_TAG_SIZE = LightProtoCodec.computeVarIntSize(10);
    private static final int _TOPIC_MASK = 1;
    private long producerId;
    private static final int _PRODUCER_ID_FIELD_NUMBER = 2;
    private static final int _PRODUCER_ID_TAG = 16;
    private static final int _PRODUCER_ID_TAG_SIZE = LightProtoCodec.computeVarIntSize(16);
    private static final int _PRODUCER_ID_MASK = 2;
    private long requestId;
    private static final int _REQUEST_ID_FIELD_NUMBER = 3;
    private static final int _REQUEST_ID_TAG = 24;
    private static final int _REQUEST_ID_TAG_SIZE = LightProtoCodec.computeVarIntSize(24);
    private static final int _REQUEST_ID_MASK = 4;
    private String producerName;
    private int _producerNameBufferIdx = -1;
    private int _producerNameBufferLen = -1;
    private static final int _PRODUCER_NAME_FIELD_NUMBER = 4;
    private static final int _PRODUCER_NAME_TAG = 34;
    private static final int _PRODUCER_NAME_TAG_SIZE = LightProtoCodec.computeVarIntSize(34);
    private static final int _PRODUCER_NAME_MASK = 8;
    private boolean encrypted = false;
    private static final int _ENCRYPTED_FIELD_NUMBER = 5;
    private static final int _ENCRYPTED_TAG = 40;
    private static final int _ENCRYPTED_TAG_SIZE = LightProtoCodec.computeVarIntSize(40);
    private static final int _ENCRYPTED_MASK = 16;
    private List<KeyValue> metadatas = null;
    private int _metadatasCount = 0;
    private static final int _METADATA_FIELD_NUMBER = 6;
    private static final int _METADATA_TAG = 50;
    private static final int _METADATA_TAG_SIZE = LightProtoCodec.computeVarIntSize(50);
    private Schema schema;
    private static final int _SCHEMA_FIELD_NUMBER = 7;
    private static final int _SCHEMA_TAG = 58;
    private static final int _SCHEMA_TAG_SIZE = LightProtoCodec.computeVarIntSize(58);
    private static final int _SCHEMA_MASK = 64;
    private long epoch = 0L;
    private static final int _EPOCH_FIELD_NUMBER = 8;
    private static final int _EPOCH_TAG = 64;
    private static final int _EPOCH_TAG_SIZE = LightProtoCodec.computeVarIntSize(64);
    private static final int _EPOCH_MASK = 128;
    private boolean userProvidedProducerName = true;
    private static final int _USER_PROVIDED_PRODUCER_NAME_FIELD_NUMBER = 9;
    private static final int _USER_PROVIDED_PRODUCER_NAME_TAG = 72;
    private static final int _USER_PROVIDED_PRODUCER_NAME_TAG_SIZE = LightProtoCodec.computeVarIntSize(72);
    private static final int _USER_PROVIDED_PRODUCER_NAME_MASK = 256;
    private ProducerAccessMode producerAccessMode = ProducerAccessMode.Shared;
    private static final int _PRODUCER_ACCESS_MODE_FIELD_NUMBER = 10;
    private static final int _PRODUCER_ACCESS_MODE_TAG = 80;
    private static final int _PRODUCER_ACCESS_MODE_TAG_SIZE = LightProtoCodec.computeVarIntSize(80);
    private static final int _PRODUCER_ACCESS_MODE_MASK = 512;
    private long topicEpoch;
    private static final int _TOPIC_EPOCH_FIELD_NUMBER = 11;
    private static final int _TOPIC_EPOCH_TAG = 88;
    private static final int _TOPIC_EPOCH_TAG_SIZE = LightProtoCodec.computeVarIntSize(88);
    private static final int _TOPIC_EPOCH_MASK = 1024;
    private boolean txnEnabled = false;
    private static final int _TXN_ENABLED_FIELD_NUMBER = 12;
    private static final int _TXN_ENABLED_TAG = 96;
    private static final int _TXN_ENABLED_TAG_SIZE = LightProtoCodec.computeVarIntSize(96);
    private static final int _TXN_ENABLED_MASK = 2048;
    private String initialSubscriptionName;
    private int _initialSubscriptionNameBufferIdx = -1;
    private int _initialSubscriptionNameBufferLen = -1;
    private static final int _INITIAL_SUBSCRIPTION_NAME_FIELD_NUMBER = 13;
    private static final int _INITIAL_SUBSCRIPTION_NAME_TAG = 106;
    private static final int _INITIAL_SUBSCRIPTION_NAME_TAG_SIZE = LightProtoCodec.computeVarIntSize(106);
    private static final int _INITIAL_SUBSCRIPTION_NAME_MASK = 4096;
    private int _bitField0;
    private static final int _REQUIRED_FIELDS_MASK0 = 7;
    private int _cachedSize;
    private ByteBuf _parsedBuffer;

    public boolean hasTopic() {
        return (this._bitField0 & 1) != 0;
    }

    public String getTopic() {
        if (!this.hasTopic()) {
            throw new IllegalStateException("Field 'topic' is not set");
        }
        if (this.topic == null) {
            this.topic = LightProtoCodec.readString(this._parsedBuffer, this._topicBufferIdx, this._topicBufferLen);
        }
        return this.topic;
    }

    public CommandProducer setTopic(String topic) {
        this.topic = topic;
        this._bitField0 |= 1;
        this._topicBufferIdx = -1;
        this._topicBufferLen = LightProtoCodec.computeStringUTF8Size(topic);
        this._cachedSize = -1;
        return this;
    }

    public CommandProducer clearTopic() {
        this._bitField0 &= 0xFFFFFFFE;
        this.topic = null;
        this._topicBufferIdx = -1;
        this._topicBufferLen = -1;
        return this;
    }

    public boolean hasProducerId() {
        return (this._bitField0 & 2) != 0;
    }

    public long getProducerId() {
        if (!this.hasProducerId()) {
            throw new IllegalStateException("Field 'producer_id' is not set");
        }
        return this.producerId;
    }

    public CommandProducer setProducerId(long producerId) {
        this.producerId = producerId;
        this._bitField0 |= 2;
        this._cachedSize = -1;
        return this;
    }

    public CommandProducer clearProducerId() {
        this._bitField0 &= 0xFFFFFFFD;
        return this;
    }

    public boolean hasRequestId() {
        return (this._bitField0 & 4) != 0;
    }

    public long getRequestId() {
        if (!this.hasRequestId()) {
            throw new IllegalStateException("Field 'request_id' is not set");
        }
        return this.requestId;
    }

    public CommandProducer setRequestId(long requestId) {
        this.requestId = requestId;
        this._bitField0 |= 4;
        this._cachedSize = -1;
        return this;
    }

    public CommandProducer clearRequestId() {
        this._bitField0 &= 0xFFFFFFFB;
        return this;
    }

    public boolean hasProducerName() {
        return (this._bitField0 & 8) != 0;
    }

    public String getProducerName() {
        if (!this.hasProducerName()) {
            throw new IllegalStateException("Field 'producer_name' is not set");
        }
        if (this.producerName == null) {
            this.producerName = LightProtoCodec.readString(this._parsedBuffer, this._producerNameBufferIdx, this._producerNameBufferLen);
        }
        return this.producerName;
    }

    public CommandProducer setProducerName(String producerName) {
        this.producerName = producerName;
        this._bitField0 |= 8;
        this._producerNameBufferIdx = -1;
        this._producerNameBufferLen = LightProtoCodec.computeStringUTF8Size(producerName);
        this._cachedSize = -1;
        return this;
    }

    public CommandProducer clearProducerName() {
        this._bitField0 &= 0xFFFFFFF7;
        this.producerName = null;
        this._producerNameBufferIdx = -1;
        this._producerNameBufferLen = -1;
        return this;
    }

    public boolean hasEncrypted() {
        return (this._bitField0 & 0x10) != 0;
    }

    public boolean isEncrypted() {
        return this.encrypted;
    }

    public CommandProducer setEncrypted(boolean encrypted) {
        this.encrypted = encrypted;
        this._bitField0 |= 0x10;
        this._cachedSize = -1;
        return this;
    }

    public CommandProducer clearEncrypted() {
        this._bitField0 &= 0xFFFFFFEF;
        this.encrypted = false;
        return this;
    }

    public int getMetadatasCount() {
        return this._metadatasCount;
    }

    public KeyValue getMetadataAt(int idx) {
        if (idx < 0 || idx >= this._metadatasCount) {
            throw new IndexOutOfBoundsException("Index " + idx + " is out of the list size (" + this._metadatasCount + ") for field 'metadata'");
        }
        return this.metadatas.get(idx);
    }

    public List<KeyValue> getMetadatasList() {
        if (this._metadatasCount == 0) {
            return Collections.emptyList();
        }
        return this.metadatas.subList(0, this._metadatasCount);
    }

    public KeyValue addMetadata() {
        if (this.metadatas == null) {
            this.metadatas = new ArrayList<KeyValue>();
        }
        if (this.metadatas.size() == this._metadatasCount) {
            this.metadatas.add(new KeyValue());
        }
        this._cachedSize = -1;
        return this.metadatas.get(this._metadatasCount++);
    }

    public CommandProducer addAllMetadatas(Iterable<KeyValue> metadatas) {
        for (KeyValue _o : metadatas) {
            this.addMetadata().copyFrom(_o);
        }
        return this;
    }

    public CommandProducer clearMetadata() {
        for (int i = 0; i < this._metadatasCount; ++i) {
            this.metadatas.get(i).clear();
        }
        this._metadatasCount = 0;
        return this;
    }

    public boolean hasSchema() {
        return (this._bitField0 & 0x40) != 0;
    }

    public Schema getSchema() {
        if (!this.hasSchema()) {
            throw new IllegalStateException("Field 'schema' is not set");
        }
        return this.schema;
    }

    public Schema setSchema() {
        if (this.schema == null) {
            this.schema = new Schema();
        }
        this._bitField0 |= 0x40;
        this._cachedSize = -1;
        return this.schema;
    }

    public CommandProducer clearSchema() {
        this._bitField0 &= 0xFFFFFFBF;
        if (this.hasSchema()) {
            this.schema.clear();
        }
        return this;
    }

    public boolean hasEpoch() {
        return (this._bitField0 & 0x80) != 0;
    }

    public long getEpoch() {
        return this.epoch;
    }

    public CommandProducer setEpoch(long epoch) {
        this.epoch = epoch;
        this._bitField0 |= 0x80;
        this._cachedSize = -1;
        return this;
    }

    public CommandProducer clearEpoch() {
        this._bitField0 &= 0xFFFFFF7F;
        this.epoch = 0L;
        return this;
    }

    public boolean hasUserProvidedProducerName() {
        return (this._bitField0 & 0x100) != 0;
    }

    public boolean isUserProvidedProducerName() {
        return this.userProvidedProducerName;
    }

    public CommandProducer setUserProvidedProducerName(boolean userProvidedProducerName) {
        this.userProvidedProducerName = userProvidedProducerName;
        this._bitField0 |= 0x100;
        this._cachedSize = -1;
        return this;
    }

    public CommandProducer clearUserProvidedProducerName() {
        this._bitField0 &= 0xFFFFFEFF;
        this.userProvidedProducerName = true;
        return this;
    }

    public boolean hasProducerAccessMode() {
        return (this._bitField0 & 0x200) != 0;
    }

    public ProducerAccessMode getProducerAccessMode() {
        return this.producerAccessMode;
    }

    public CommandProducer setProducerAccessMode(ProducerAccessMode producerAccessMode) {
        this.producerAccessMode = producerAccessMode;
        this._bitField0 |= 0x200;
        this._cachedSize = -1;
        return this;
    }

    public CommandProducer clearProducerAccessMode() {
        this._bitField0 &= 0xFFFFFDFF;
        this.producerAccessMode = ProducerAccessMode.Shared;
        return this;
    }

    public boolean hasTopicEpoch() {
        return (this._bitField0 & 0x400) != 0;
    }

    public long getTopicEpoch() {
        if (!this.hasTopicEpoch()) {
            throw new IllegalStateException("Field 'topic_epoch' is not set");
        }
        return this.topicEpoch;
    }

    public CommandProducer setTopicEpoch(long topicEpoch) {
        this.topicEpoch = topicEpoch;
        this._bitField0 |= 0x400;
        this._cachedSize = -1;
        return this;
    }

    public CommandProducer clearTopicEpoch() {
        this._bitField0 &= 0xFFFFFBFF;
        return this;
    }

    public boolean hasTxnEnabled() {
        return (this._bitField0 & 0x800) != 0;
    }

    public boolean isTxnEnabled() {
        return this.txnEnabled;
    }

    public CommandProducer setTxnEnabled(boolean txnEnabled) {
        this.txnEnabled = txnEnabled;
        this._bitField0 |= 0x800;
        this._cachedSize = -1;
        return this;
    }

    public CommandProducer clearTxnEnabled() {
        this._bitField0 &= 0xFFFFF7FF;
        this.txnEnabled = false;
        return this;
    }

    public boolean hasInitialSubscriptionName() {
        return (this._bitField0 & 0x1000) != 0;
    }

    public String getInitialSubscriptionName() {
        if (!this.hasInitialSubscriptionName()) {
            throw new IllegalStateException("Field 'initial_subscription_name' is not set");
        }
        if (this.initialSubscriptionName == null) {
            this.initialSubscriptionName = LightProtoCodec.readString(this._parsedBuffer, this._initialSubscriptionNameBufferIdx, this._initialSubscriptionNameBufferLen);
        }
        return this.initialSubscriptionName;
    }

    public CommandProducer setInitialSubscriptionName(String initialSubscriptionName) {
        this.initialSubscriptionName = initialSubscriptionName;
        this._bitField0 |= 0x1000;
        this._initialSubscriptionNameBufferIdx = -1;
        this._initialSubscriptionNameBufferLen = LightProtoCodec.computeStringUTF8Size(initialSubscriptionName);
        this._cachedSize = -1;
        return this;
    }

    public CommandProducer clearInitialSubscriptionName() {
        this._bitField0 &= 0xFFFFEFFF;
        this.initialSubscriptionName = null;
        this._initialSubscriptionNameBufferIdx = -1;
        this._initialSubscriptionNameBufferLen = -1;
        return this;
    }

    public int writeTo(ByteBuf _b) {
        this.checkRequiredFields();
        int _writeIdx = _b.writerIndex();
        LightProtoCodec.writeVarInt(_b, 10);
        LightProtoCodec.writeVarInt(_b, this._topicBufferLen);
        if (this._topicBufferIdx == -1) {
            LightProtoCodec.writeString(_b, this.topic, this._topicBufferLen);
        } else {
            this._parsedBuffer.getBytes(this._topicBufferIdx, _b, this._topicBufferLen);
        }
        LightProtoCodec.writeVarInt(_b, 16);
        LightProtoCodec.writeVarInt64(_b, this.producerId);
        LightProtoCodec.writeVarInt(_b, 24);
        LightProtoCodec.writeVarInt64(_b, this.requestId);
        if (this.hasProducerName()) {
            LightProtoCodec.writeVarInt(_b, 34);
            LightProtoCodec.writeVarInt(_b, this._producerNameBufferLen);
            if (this._producerNameBufferIdx == -1) {
                LightProtoCodec.writeString(_b, this.producerName, this._producerNameBufferLen);
            } else {
                this._parsedBuffer.getBytes(this._producerNameBufferIdx, _b, this._producerNameBufferLen);
            }
        }
        if (this.hasEncrypted()) {
            LightProtoCodec.writeVarInt(_b, 40);
            _b.writeBoolean(this.encrypted);
        }
        for (int i = 0; i < this._metadatasCount; ++i) {
            KeyValue _item = this.metadatas.get(i);
            LightProtoCodec.writeVarInt(_b, 50);
            LightProtoCodec.writeVarInt(_b, _item.getSerializedSize());
            _item.writeTo(_b);
        }
        if (this.hasSchema()) {
            LightProtoCodec.writeVarInt(_b, 58);
            LightProtoCodec.writeVarInt(_b, this.schema.getSerializedSize());
            this.schema.writeTo(_b);
        }
        if (this.hasEpoch()) {
            LightProtoCodec.writeVarInt(_b, 64);
            LightProtoCodec.writeVarInt64(_b, this.epoch);
        }
        if (this.hasUserProvidedProducerName()) {
            LightProtoCodec.writeVarInt(_b, 72);
            _b.writeBoolean(this.userProvidedProducerName);
        }
        if (this.hasProducerAccessMode()) {
            LightProtoCodec.writeVarInt(_b, 80);
            LightProtoCodec.writeVarInt(_b, this.producerAccessMode.getValue());
        }
        if (this.hasTopicEpoch()) {
            LightProtoCodec.writeVarInt(_b, 88);
            LightProtoCodec.writeVarInt64(_b, this.topicEpoch);
        }
        if (this.hasTxnEnabled()) {
            LightProtoCodec.writeVarInt(_b, 96);
            _b.writeBoolean(this.txnEnabled);
        }
        if (this.hasInitialSubscriptionName()) {
            LightProtoCodec.writeVarInt(_b, 106);
            LightProtoCodec.writeVarInt(_b, this._initialSubscriptionNameBufferLen);
            if (this._initialSubscriptionNameBufferIdx == -1) {
                LightProtoCodec.writeString(_b, this.initialSubscriptionName, this._initialSubscriptionNameBufferLen);
            } else {
                this._parsedBuffer.getBytes(this._initialSubscriptionNameBufferIdx, _b, this._initialSubscriptionNameBufferLen);
            }
        }
        return _b.writerIndex() - _writeIdx;
    }

    public int getSerializedSize() {
        if (this._cachedSize > -1) {
            return this._cachedSize;
        }
        int _size = 0;
        _size += _TOPIC_TAG_SIZE;
        _size += LightProtoCodec.computeVarIntSize(this._topicBufferLen);
        _size += this._topicBufferLen;
        _size += _PRODUCER_ID_TAG_SIZE;
        _size += LightProtoCodec.computeVarInt64Size(this.producerId);
        _size += _REQUEST_ID_TAG_SIZE;
        _size += LightProtoCodec.computeVarInt64Size(this.requestId);
        if (this.hasProducerName()) {
            _size += _PRODUCER_NAME_TAG_SIZE;
            _size += LightProtoCodec.computeVarIntSize(this._producerNameBufferLen);
            _size += this._producerNameBufferLen;
        }
        if (this.hasEncrypted()) {
            _size += _ENCRYPTED_TAG_SIZE;
            ++_size;
        }
        for (int i = 0; i < this._metadatasCount; ++i) {
            KeyValue _item = this.metadatas.get(i);
            _size += _METADATA_TAG_SIZE;
            int MsgsizeMetadata = _item.getSerializedSize();
            _size += LightProtoCodec.computeVarIntSize(MsgsizeMetadata) + MsgsizeMetadata;
        }
        if (this.hasSchema()) {
            _size += LightProtoCodec.computeVarIntSize(58);
            int MsgsizeSchema = this.schema.getSerializedSize();
            _size += LightProtoCodec.computeVarIntSize(MsgsizeSchema) + MsgsizeSchema;
        }
        if (this.hasEpoch()) {
            _size += _EPOCH_TAG_SIZE;
            _size += LightProtoCodec.computeVarInt64Size(this.epoch);
        }
        if (this.hasUserProvidedProducerName()) {
            _size += _USER_PROVIDED_PRODUCER_NAME_TAG_SIZE;
            ++_size;
        }
        if (this.hasProducerAccessMode()) {
            _size += _PRODUCER_ACCESS_MODE_TAG_SIZE;
            _size += LightProtoCodec.computeVarIntSize(this.producerAccessMode.getValue());
        }
        if (this.hasTopicEpoch()) {
            _size += _TOPIC_EPOCH_TAG_SIZE;
            _size += LightProtoCodec.computeVarInt64Size(this.topicEpoch);
        }
        if (this.hasTxnEnabled()) {
            _size += _TXN_ENABLED_TAG_SIZE;
            ++_size;
        }
        if (this.hasInitialSubscriptionName()) {
            _size += _INITIAL_SUBSCRIPTION_NAME_TAG_SIZE;
            _size += LightProtoCodec.computeVarIntSize(this._initialSubscriptionNameBufferLen);
            _size += this._initialSubscriptionNameBufferLen;
        }
        this._cachedSize = _size;
        return _size;
    }

    public void parseFrom(ByteBuf _buffer, int _size) {
        this.clear();
        int _endIdx = _buffer.readerIndex() + _size;
        block15: while (_buffer.readerIndex() < _endIdx) {
            int _tag = LightProtoCodec.readVarInt(_buffer);
            switch (_tag) {
                case 10: {
                    this._bitField0 |= 1;
                    this._topicBufferLen = LightProtoCodec.readVarInt(_buffer);
                    this._topicBufferIdx = _buffer.readerIndex();
                    _buffer.skipBytes(this._topicBufferLen);
                    continue block15;
                }
                case 16: {
                    this._bitField0 |= 2;
                    this.producerId = LightProtoCodec.readVarInt64(_buffer);
                    continue block15;
                }
                case 24: {
                    this._bitField0 |= 4;
                    this.requestId = LightProtoCodec.readVarInt64(_buffer);
                    continue block15;
                }
                case 34: {
                    this._bitField0 |= 8;
                    this._producerNameBufferLen = LightProtoCodec.readVarInt(_buffer);
                    this._producerNameBufferIdx = _buffer.readerIndex();
                    _buffer.skipBytes(this._producerNameBufferLen);
                    continue block15;
                }
                case 40: {
                    this._bitField0 |= 0x10;
                    this.encrypted = LightProtoCodec.readVarInt(_buffer) == 1;
                    continue block15;
                }
                case 50: {
                    int _metadataSize = LightProtoCodec.readVarInt(_buffer);
                    this.addMetadata().parseFrom(_buffer, _metadataSize);
                    continue block15;
                }
                case 58: {
                    this._bitField0 |= 0x40;
                    int schemaSize = LightProtoCodec.readVarInt(_buffer);
                    this.setSchema().parseFrom(_buffer, schemaSize);
                    continue block15;
                }
                case 64: {
                    this._bitField0 |= 0x80;
                    this.epoch = LightProtoCodec.readVarInt64(_buffer);
                    continue block15;
                }
                case 72: {
                    this._bitField0 |= 0x100;
                    this.userProvidedProducerName = LightProtoCodec.readVarInt(_buffer) == 1;
                    continue block15;
                }
                case 80: {
                    ProducerAccessMode _producerAccessMode = ProducerAccessMode.valueOf(LightProtoCodec.readVarInt(_buffer));
                    if (_producerAccessMode == null) continue block15;
                    this._bitField0 |= 0x200;
                    this.producerAccessMode = _producerAccessMode;
                    continue block15;
                }
                case 88: {
                    this._bitField0 |= 0x400;
                    this.topicEpoch = LightProtoCodec.readVarInt64(_buffer);
                    continue block15;
                }
                case 96: {
                    this._bitField0 |= 0x800;
                    this.txnEnabled = LightProtoCodec.readVarInt(_buffer) == 1;
                    continue block15;
                }
                case 106: {
                    this._bitField0 |= 0x1000;
                    this._initialSubscriptionNameBufferLen = LightProtoCodec.readVarInt(_buffer);
                    this._initialSubscriptionNameBufferIdx = _buffer.readerIndex();
                    _buffer.skipBytes(this._initialSubscriptionNameBufferLen);
                    continue block15;
                }
            }
            LightProtoCodec.skipUnknownField(_tag, _buffer);
        }
        this.checkRequiredFields();
        this._parsedBuffer = _buffer;
    }

    private void checkRequiredFields() {
        if ((this._bitField0 & 7) != 7) {
            throw new IllegalStateException("Some required fields are missing");
        }
    }

    public CommandProducer clear() {
        this.topic = null;
        this._topicBufferIdx = -1;
        this._topicBufferLen = -1;
        this.producerName = null;
        this._producerNameBufferIdx = -1;
        this._producerNameBufferLen = -1;
        this.encrypted = false;
        for (int i = 0; i < this._metadatasCount; ++i) {
            this.metadatas.get(i).clear();
        }
        this._metadatasCount = 0;
        if (this.hasSchema()) {
            this.schema.clear();
        }
        this.epoch = 0L;
        this.userProvidedProducerName = true;
        this.producerAccessMode = ProducerAccessMode.Shared;
        this.txnEnabled = false;
        this.initialSubscriptionName = null;
        this._initialSubscriptionNameBufferIdx = -1;
        this._initialSubscriptionNameBufferLen = -1;
        this._parsedBuffer = null;
        this._cachedSize = -1;
        this._bitField0 = 0;
        return this;
    }

    public CommandProducer copyFrom(CommandProducer _other) {
        this._cachedSize = -1;
        if (_other.hasTopic()) {
            this.setTopic(_other.getTopic());
        }
        if (_other.hasProducerId()) {
            this.setProducerId(_other.producerId);
        }
        if (_other.hasRequestId()) {
            this.setRequestId(_other.requestId);
        }
        if (_other.hasProducerName()) {
            this.setProducerName(_other.getProducerName());
        }
        if (_other.hasEncrypted()) {
            this.setEncrypted(_other.encrypted);
        }
        for (int i = 0; i < _other.getMetadatasCount(); ++i) {
            this.addMetadata().copyFrom(_other.getMetadataAt(i));
        }
        if (_other.hasSchema()) {
            this.setSchema().copyFrom(_other.schema);
        }
        if (_other.hasEpoch()) {
            this.setEpoch(_other.epoch);
        }
        if (_other.hasUserProvidedProducerName()) {
            this.setUserProvidedProducerName(_other.userProvidedProducerName);
        }
        if (_other.hasProducerAccessMode()) {
            this.setProducerAccessMode(_other.producerAccessMode);
        }
        if (_other.hasTopicEpoch()) {
            this.setTopicEpoch(_other.topicEpoch);
        }
        if (_other.hasTxnEnabled()) {
            this.setTxnEnabled(_other.txnEnabled);
        }
        if (_other.hasInitialSubscriptionName()) {
            this.setInitialSubscriptionName(_other.getInitialSubscriptionName());
        }
        return this;
    }

    public byte[] toByteArray() {
        byte[] a = new byte[this.getSerializedSize()];
        ByteBuf b = Unpooled.wrappedBuffer(a).writerIndex(0);
        this.writeTo(b);
        return a;
    }

    public void parseFrom(byte[] a) {
        ByteBuf b = Unpooled.wrappedBuffer(a);
        this.parseFrom(b, b.readableBytes());
    }
}

