/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.api.proto;

import com.iterable.shade.io.netty.buffer.ByteBuf;
import com.iterable.shade.io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pulsar.common.api.proto.LightProtoCodec;

public final class CommandGetTopicsOfNamespaceResponse {
    private long requestId;
    private static final int _REQUEST_ID_FIELD_NUMBER = 1;
    private static final int _REQUEST_ID_TAG = 8;
    private static final int _REQUEST_ID_TAG_SIZE = LightProtoCodec.computeVarIntSize(8);
    private static final int _REQUEST_ID_MASK = 1;
    private List<LightProtoCodec.StringHolder> topics = null;
    private int _topicsCount = 0;
    private static final int _TOPICS_FIELD_NUMBER = 2;
    private static final int _TOPICS_TAG = 18;
    private static final int _TOPICS_TAG_SIZE = LightProtoCodec.computeVarIntSize(18);
    private boolean filtered = false;
    private static final int _FILTERED_FIELD_NUMBER = 3;
    private static final int _FILTERED_TAG = 24;
    private static final int _FILTERED_TAG_SIZE = LightProtoCodec.computeVarIntSize(24);
    private static final int _FILTERED_MASK = 4;
    private String topicsHash;
    private int _topicsHashBufferIdx = -1;
    private int _topicsHashBufferLen = -1;
    private static final int _TOPICS_HASH_FIELD_NUMBER = 4;
    private static final int _TOPICS_HASH_TAG = 34;
    private static final int _TOPICS_HASH_TAG_SIZE = LightProtoCodec.computeVarIntSize(34);
    private static final int _TOPICS_HASH_MASK = 8;
    private boolean changed = true;
    private static final int _CHANGED_FIELD_NUMBER = 5;
    private static final int _CHANGED_TAG = 40;
    private static final int _CHANGED_TAG_SIZE = LightProtoCodec.computeVarIntSize(40);
    private static final int _CHANGED_MASK = 16;
    private int _bitField0;
    private static final int _REQUIRED_FIELDS_MASK0 = 1;
    private int _cachedSize;
    private ByteBuf _parsedBuffer;

    public boolean hasRequestId() {
        return (this._bitField0 & 1) != 0;
    }

    public long getRequestId() {
        if (!this.hasRequestId()) {
            throw new IllegalStateException("Field 'request_id' is not set");
        }
        return this.requestId;
    }

    public CommandGetTopicsOfNamespaceResponse setRequestId(long requestId) {
        this.requestId = requestId;
        this._bitField0 |= 1;
        this._cachedSize = -1;
        return this;
    }

    public CommandGetTopicsOfNamespaceResponse clearRequestId() {
        this._bitField0 &= 0xFFFFFFFE;
        return this;
    }

    public int getTopicsCount() {
        return this._topicsCount;
    }

    public String getTopicAt(int idx) {
        if (idx < 0 || idx >= this._topicsCount) {
            throw new IndexOutOfBoundsException("Index " + idx + " is out of the list size (" + this._topicsCount + ") for field 'topics'");
        }
        LightProtoCodec.StringHolder _sh = this.topics.get(idx);
        if (_sh.s == null) {
            _sh.s = LightProtoCodec.readString(this._parsedBuffer, _sh.idx, _sh.len);
        }
        return _sh.s;
    }

    public List<String> getTopicsList() {
        if (this._topicsCount == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> _l = new ArrayList<String>();
        for (int i = 0; i < this._topicsCount; ++i) {
            _l.add(this.getTopicAt(i));
        }
        return _l;
    }

    public void addTopic(String topic) {
        if (this.topics == null) {
            this.topics = new ArrayList<LightProtoCodec.StringHolder>();
        }
        LightProtoCodec.StringHolder _sh = this._newTopicStringHolder();
        this._cachedSize = -1;
        _sh.s = topic;
        _sh.idx = -1;
        _sh.len = LightProtoCodec.computeStringUTF8Size(_sh.s);
    }

    public CommandGetTopicsOfNamespaceResponse addAllTopics(Iterable<String> topics) {
        for (String _s : topics) {
            this.addTopic(_s);
        }
        return this;
    }

    private LightProtoCodec.StringHolder _newTopicStringHolder() {
        LightProtoCodec.StringHolder _sh;
        if (this.topics == null) {
            this.topics = new ArrayList<LightProtoCodec.StringHolder>();
        }
        if (this.topics.size() == this._topicsCount) {
            _sh = new LightProtoCodec.StringHolder();
            this.topics.add(_sh);
        } else {
            _sh = this.topics.get(this._topicsCount);
        }
        ++this._topicsCount;
        return _sh;
    }

    public CommandGetTopicsOfNamespaceResponse clearTopics() {
        for (int i = 0; i < this._topicsCount; ++i) {
            LightProtoCodec.StringHolder _sh = this.topics.get(i);
            _sh.s = null;
            _sh.idx = -1;
            _sh.len = -1;
        }
        this._topicsCount = 0;
        return this;
    }

    public boolean hasFiltered() {
        return (this._bitField0 & 4) != 0;
    }

    public boolean isFiltered() {
        return this.filtered;
    }

    public CommandGetTopicsOfNamespaceResponse setFiltered(boolean filtered) {
        this.filtered = filtered;
        this._bitField0 |= 4;
        this._cachedSize = -1;
        return this;
    }

    public CommandGetTopicsOfNamespaceResponse clearFiltered() {
        this._bitField0 &= 0xFFFFFFFB;
        this.filtered = false;
        return this;
    }

    public boolean hasTopicsHash() {
        return (this._bitField0 & 8) != 0;
    }

    public String getTopicsHash() {
        if (!this.hasTopicsHash()) {
            throw new IllegalStateException("Field 'topics_hash' is not set");
        }
        if (this.topicsHash == null) {
            this.topicsHash = LightProtoCodec.readString(this._parsedBuffer, this._topicsHashBufferIdx, this._topicsHashBufferLen);
        }
        return this.topicsHash;
    }

    public CommandGetTopicsOfNamespaceResponse setTopicsHash(String topicsHash) {
        this.topicsHash = topicsHash;
        this._bitField0 |= 8;
        this._topicsHashBufferIdx = -1;
        this._topicsHashBufferLen = LightProtoCodec.computeStringUTF8Size(topicsHash);
        this._cachedSize = -1;
        return this;
    }

    public CommandGetTopicsOfNamespaceResponse clearTopicsHash() {
        this._bitField0 &= 0xFFFFFFF7;
        this.topicsHash = null;
        this._topicsHashBufferIdx = -1;
        this._topicsHashBufferLen = -1;
        return this;
    }

    public boolean hasChanged() {
        return (this._bitField0 & 0x10) != 0;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public CommandGetTopicsOfNamespaceResponse setChanged(boolean changed) {
        this.changed = changed;
        this._bitField0 |= 0x10;
        this._cachedSize = -1;
        return this;
    }

    public CommandGetTopicsOfNamespaceResponse clearChanged() {
        this._bitField0 &= 0xFFFFFFEF;
        this.changed = true;
        return this;
    }

    public int writeTo(ByteBuf _b) {
        this.checkRequiredFields();
        int _writeIdx = _b.writerIndex();
        LightProtoCodec.writeVarInt(_b, 8);
        LightProtoCodec.writeVarInt64(_b, this.requestId);
        for (int i = 0; i < this._topicsCount; ++i) {
            LightProtoCodec.StringHolder _sh = this.topics.get(i);
            LightProtoCodec.writeVarInt(_b, 18);
            LightProtoCodec.writeVarInt(_b, _sh.len);
            if (_sh.idx == -1) {
                LightProtoCodec.writeString(_b, _sh.s, _sh.len);
                continue;
            }
            this._parsedBuffer.getBytes(_sh.idx, _b, _sh.len);
        }
        if (this.hasFiltered()) {
            LightProtoCodec.writeVarInt(_b, 24);
            _b.writeBoolean(this.filtered);
        }
        if (this.hasTopicsHash()) {
            LightProtoCodec.writeVarInt(_b, 34);
            LightProtoCodec.writeVarInt(_b, this._topicsHashBufferLen);
            if (this._topicsHashBufferIdx == -1) {
                LightProtoCodec.writeString(_b, this.topicsHash, this._topicsHashBufferLen);
            } else {
                this._parsedBuffer.getBytes(this._topicsHashBufferIdx, _b, this._topicsHashBufferLen);
            }
        }
        if (this.hasChanged()) {
            LightProtoCodec.writeVarInt(_b, 40);
            _b.writeBoolean(this.changed);
        }
        return _b.writerIndex() - _writeIdx;
    }

    public int getSerializedSize() {
        if (this._cachedSize > -1) {
            return this._cachedSize;
        }
        int _size = 0;
        _size += _REQUEST_ID_TAG_SIZE;
        _size += LightProtoCodec.computeVarInt64Size(this.requestId);
        for (int i = 0; i < this._topicsCount; ++i) {
            LightProtoCodec.StringHolder _sh = this.topics.get(i);
            _size += _TOPICS_TAG_SIZE;
            _size += LightProtoCodec.computeVarIntSize(_sh.len) + _sh.len;
        }
        if (this.hasFiltered()) {
            _size += _FILTERED_TAG_SIZE;
            ++_size;
        }
        if (this.hasTopicsHash()) {
            _size += _TOPICS_HASH_TAG_SIZE;
            _size += LightProtoCodec.computeVarIntSize(this._topicsHashBufferLen);
            _size += this._topicsHashBufferLen;
        }
        if (this.hasChanged()) {
            _size += _CHANGED_TAG_SIZE;
            ++_size;
        }
        this._cachedSize = _size;
        return _size;
    }

    public void parseFrom(ByteBuf _buffer, int _size) {
        this.clear();
        int _endIdx = _buffer.readerIndex() + _size;
        block7: while (_buffer.readerIndex() < _endIdx) {
            int _tag = LightProtoCodec.readVarInt(_buffer);
            switch (_tag) {
                case 8: {
                    this._bitField0 |= 1;
                    this.requestId = LightProtoCodec.readVarInt64(_buffer);
                    continue block7;
                }
                case 18: {
                    LightProtoCodec.StringHolder _topicsSh = this._newTopicStringHolder();
                    _topicsSh.len = LightProtoCodec.readVarInt(_buffer);
                    _topicsSh.idx = _buffer.readerIndex();
                    _buffer.skipBytes(_topicsSh.len);
                    continue block7;
                }
                case 24: {
                    this._bitField0 |= 4;
                    this.filtered = LightProtoCodec.readVarInt(_buffer) == 1;
                    continue block7;
                }
                case 34: {
                    this._bitField0 |= 8;
                    this._topicsHashBufferLen = LightProtoCodec.readVarInt(_buffer);
                    this._topicsHashBufferIdx = _buffer.readerIndex();
                    _buffer.skipBytes(this._topicsHashBufferLen);
                    continue block7;
                }
                case 40: {
                    this._bitField0 |= 0x10;
                    this.changed = LightProtoCodec.readVarInt(_buffer) == 1;
                    continue block7;
                }
            }
            LightProtoCodec.skipUnknownField(_tag, _buffer);
        }
        this.checkRequiredFields();
        this._parsedBuffer = _buffer;
    }

    private void checkRequiredFields() {
        if ((this._bitField0 & 1) != 1) {
            throw new IllegalStateException("Some required fields are missing");
        }
    }

    public CommandGetTopicsOfNamespaceResponse clear() {
        for (int i = 0; i < this._topicsCount; ++i) {
            LightProtoCodec.StringHolder _sh = this.topics.get(i);
            _sh.s = null;
            _sh.idx = -1;
            _sh.len = -1;
        }
        this._topicsCount = 0;
        this.filtered = false;
        this.topicsHash = null;
        this._topicsHashBufferIdx = -1;
        this._topicsHashBufferLen = -1;
        this.changed = true;
        this._parsedBuffer = null;
        this._cachedSize = -1;
        this._bitField0 = 0;
        return this;
    }

    public CommandGetTopicsOfNamespaceResponse copyFrom(CommandGetTopicsOfNamespaceResponse _other) {
        this._cachedSize = -1;
        if (_other.hasRequestId()) {
            this.setRequestId(_other.requestId);
        }
        for (int i = 0; i < _other.getTopicsCount(); ++i) {
            this.addTopic(_other.getTopicAt(i));
        }
        if (_other.hasFiltered()) {
            this.setFiltered(_other.filtered);
        }
        if (_other.hasTopicsHash()) {
            this.setTopicsHash(_other.getTopicsHash());
        }
        if (_other.hasChanged()) {
            this.setChanged(_other.changed);
        }
        return this;
    }

    public byte[] toByteArray() {
        byte[] a = new byte[this.getSerializedSize()];
        ByteBuf b = Unpooled.wrappedBuffer(a).writerIndex(0);
        this.writeTo(b);
        return a;
    }

    public void parseFrom(byte[] a) {
        ByteBuf b = Unpooled.wrappedBuffer(a);
        this.parseFrom(b, b.readableBytes());
    }
}

