/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.api.proto;

import com.iterable.shade.io.netty.buffer.ByteBuf;
import com.iterable.shade.io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pulsar.common.api.proto.KeyLongValue;
import org.apache.pulsar.common.api.proto.LightProtoCodec;
import org.apache.pulsar.common.api.proto.MessageIdData;

public final class CommandAck {
    private long consumerId;
    private static final int _CONSUMER_ID_FIELD_NUMBER = 1;
    private static final int _CONSUMER_ID_TAG = 8;
    private static final int _CONSUMER_ID_TAG_SIZE = LightProtoCodec.computeVarIntSize(8);
    private static final int _CONSUMER_ID_MASK = 1;
    private AckType ackType;
    private static final int _ACK_TYPE_FIELD_NUMBER = 2;
    private static final int _ACK_TYPE_TAG = 16;
    private static final int _ACK_TYPE_TAG_SIZE = LightProtoCodec.computeVarIntSize(16);
    private static final int _ACK_TYPE_MASK = 2;
    private List<MessageIdData> messageIds = null;
    private int _messageIdsCount = 0;
    private static final int _MESSAGE_ID_FIELD_NUMBER = 3;
    private static final int _MESSAGE_ID_TAG = 26;
    private static final int _MESSAGE_ID_TAG_SIZE = LightProtoCodec.computeVarIntSize(26);
    private ValidationError validationError;
    private static final int _VALIDATION_ERROR_FIELD_NUMBER = 4;
    private static final int _VALIDATION_ERROR_TAG = 32;
    private static final int _VALIDATION_ERROR_TAG_SIZE = LightProtoCodec.computeVarIntSize(32);
    private static final int _VALIDATION_ERROR_MASK = 8;
    private List<KeyLongValue> properties = null;
    private int _propertiesCount = 0;
    private static final int _PROPERTIES_FIELD_NUMBER = 5;
    private static final int _PROPERTIES_TAG = 42;
    private static final int _PROPERTIES_TAG_SIZE = LightProtoCodec.computeVarIntSize(42);
    private long txnidLeastBits = 0L;
    private static final int _TXNID_LEAST_BITS_FIELD_NUMBER = 6;
    private static final int _TXNID_LEAST_BITS_TAG = 48;
    private static final int _TXNID_LEAST_BITS_TAG_SIZE = LightProtoCodec.computeVarIntSize(48);
    private static final int _TXNID_LEAST_BITS_MASK = 32;
    private long txnidMostBits = 0L;
    private static final int _TXNID_MOST_BITS_FIELD_NUMBER = 7;
    private static final int _TXNID_MOST_BITS_TAG = 56;
    private static final int _TXNID_MOST_BITS_TAG_SIZE = LightProtoCodec.computeVarIntSize(56);
    private static final int _TXNID_MOST_BITS_MASK = 64;
    private long requestId;
    private static final int _REQUEST_ID_FIELD_NUMBER = 8;
    private static final int _REQUEST_ID_TAG = 64;
    private static final int _REQUEST_ID_TAG_SIZE = LightProtoCodec.computeVarIntSize(64);
    private static final int _REQUEST_ID_MASK = 128;
    private int _bitField0;
    private static final int _REQUIRED_FIELDS_MASK0 = 3;
    private int _cachedSize;
    private ByteBuf _parsedBuffer;

    public boolean hasConsumerId() {
        return (this._bitField0 & 1) != 0;
    }

    public long getConsumerId() {
        if (!this.hasConsumerId()) {
            throw new IllegalStateException("Field 'consumer_id' is not set");
        }
        return this.consumerId;
    }

    public CommandAck setConsumerId(long consumerId) {
        this.consumerId = consumerId;
        this._bitField0 |= 1;
        this._cachedSize = -1;
        return this;
    }

    public CommandAck clearConsumerId() {
        this._bitField0 &= 0xFFFFFFFE;
        return this;
    }

    public boolean hasAckType() {
        return (this._bitField0 & 2) != 0;
    }

    public AckType getAckType() {
        if (!this.hasAckType()) {
            throw new IllegalStateException("Field 'ack_type' is not set");
        }
        return this.ackType;
    }

    public CommandAck setAckType(AckType ackType) {
        this.ackType = ackType;
        this._bitField0 |= 2;
        this._cachedSize = -1;
        return this;
    }

    public CommandAck clearAckType() {
        this._bitField0 &= 0xFFFFFFFD;
        return this;
    }

    public int getMessageIdsCount() {
        return this._messageIdsCount;
    }

    public MessageIdData getMessageIdAt(int idx) {
        if (idx < 0 || idx >= this._messageIdsCount) {
            throw new IndexOutOfBoundsException("Index " + idx + " is out of the list size (" + this._messageIdsCount + ") for field 'message_id'");
        }
        return this.messageIds.get(idx);
    }

    public List<MessageIdData> getMessageIdsList() {
        if (this._messageIdsCount == 0) {
            return Collections.emptyList();
        }
        return this.messageIds.subList(0, this._messageIdsCount);
    }

    public MessageIdData addMessageId() {
        if (this.messageIds == null) {
            this.messageIds = new ArrayList<MessageIdData>();
        }
        if (this.messageIds.size() == this._messageIdsCount) {
            this.messageIds.add(new MessageIdData());
        }
        this._cachedSize = -1;
        return this.messageIds.get(this._messageIdsCount++);
    }

    public CommandAck addAllMessageIds(Iterable<MessageIdData> messageIds) {
        for (MessageIdData _o : messageIds) {
            this.addMessageId().copyFrom(_o);
        }
        return this;
    }

    public CommandAck clearMessageId() {
        for (int i = 0; i < this._messageIdsCount; ++i) {
            this.messageIds.get(i).clear();
        }
        this._messageIdsCount = 0;
        return this;
    }

    public boolean hasValidationError() {
        return (this._bitField0 & 8) != 0;
    }

    public ValidationError getValidationError() {
        if (!this.hasValidationError()) {
            throw new IllegalStateException("Field 'validation_error' is not set");
        }
        return this.validationError;
    }

    public CommandAck setValidationError(ValidationError validationError) {
        this.validationError = validationError;
        this._bitField0 |= 8;
        this._cachedSize = -1;
        return this;
    }

    public CommandAck clearValidationError() {
        this._bitField0 &= 0xFFFFFFF7;
        return this;
    }

    public int getPropertiesCount() {
        return this._propertiesCount;
    }

    public KeyLongValue getPropertyAt(int idx) {
        if (idx < 0 || idx >= this._propertiesCount) {
            throw new IndexOutOfBoundsException("Index " + idx + " is out of the list size (" + this._propertiesCount + ") for field 'properties'");
        }
        return this.properties.get(idx);
    }

    public List<KeyLongValue> getPropertiesList() {
        if (this._propertiesCount == 0) {
            return Collections.emptyList();
        }
        return this.properties.subList(0, this._propertiesCount);
    }

    public KeyLongValue addProperty() {
        if (this.properties == null) {
            this.properties = new ArrayList<KeyLongValue>();
        }
        if (this.properties.size() == this._propertiesCount) {
            this.properties.add(new KeyLongValue());
        }
        this._cachedSize = -1;
        return this.properties.get(this._propertiesCount++);
    }

    public CommandAck addAllProperties(Iterable<KeyLongValue> properties) {
        for (KeyLongValue _o : properties) {
            this.addProperty().copyFrom(_o);
        }
        return this;
    }

    public CommandAck clearProperties() {
        for (int i = 0; i < this._propertiesCount; ++i) {
            this.properties.get(i).clear();
        }
        this._propertiesCount = 0;
        return this;
    }

    public boolean hasTxnidLeastBits() {
        return (this._bitField0 & 0x20) != 0;
    }

    public long getTxnidLeastBits() {
        return this.txnidLeastBits;
    }

    public CommandAck setTxnidLeastBits(long txnidLeastBits) {
        this.txnidLeastBits = txnidLeastBits;
        this._bitField0 |= 0x20;
        this._cachedSize = -1;
        return this;
    }

    public CommandAck clearTxnidLeastBits() {
        this._bitField0 &= 0xFFFFFFDF;
        this.txnidLeastBits = 0L;
        return this;
    }

    public boolean hasTxnidMostBits() {
        return (this._bitField0 & 0x40) != 0;
    }

    public long getTxnidMostBits() {
        return this.txnidMostBits;
    }

    public CommandAck setTxnidMostBits(long txnidMostBits) {
        this.txnidMostBits = txnidMostBits;
        this._bitField0 |= 0x40;
        this._cachedSize = -1;
        return this;
    }

    public CommandAck clearTxnidMostBits() {
        this._bitField0 &= 0xFFFFFFBF;
        this.txnidMostBits = 0L;
        return this;
    }

    public boolean hasRequestId() {
        return (this._bitField0 & 0x80) != 0;
    }

    public long getRequestId() {
        if (!this.hasRequestId()) {
            throw new IllegalStateException("Field 'request_id' is not set");
        }
        return this.requestId;
    }

    public CommandAck setRequestId(long requestId) {
        this.requestId = requestId;
        this._bitField0 |= 0x80;
        this._cachedSize = -1;
        return this;
    }

    public CommandAck clearRequestId() {
        this._bitField0 &= 0xFFFFFF7F;
        return this;
    }

    public int writeTo(ByteBuf _b) {
        Object _item;
        int i;
        this.checkRequiredFields();
        int _writeIdx = _b.writerIndex();
        LightProtoCodec.writeVarInt(_b, 8);
        LightProtoCodec.writeVarInt64(_b, this.consumerId);
        LightProtoCodec.writeVarInt(_b, 16);
        LightProtoCodec.writeVarInt(_b, this.ackType.getValue());
        for (i = 0; i < this._messageIdsCount; ++i) {
            _item = this.messageIds.get(i);
            LightProtoCodec.writeVarInt(_b, 26);
            LightProtoCodec.writeVarInt(_b, ((MessageIdData)_item).getSerializedSize());
            ((MessageIdData)_item).writeTo(_b);
        }
        if (this.hasValidationError()) {
            LightProtoCodec.writeVarInt(_b, 32);
            LightProtoCodec.writeVarInt(_b, this.validationError.getValue());
        }
        for (i = 0; i < this._propertiesCount; ++i) {
            _item = this.properties.get(i);
            LightProtoCodec.writeVarInt(_b, 42);
            LightProtoCodec.writeVarInt(_b, ((KeyLongValue)_item).getSerializedSize());
            ((KeyLongValue)_item).writeTo(_b);
        }
        if (this.hasTxnidLeastBits()) {
            LightProtoCodec.writeVarInt(_b, 48);
            LightProtoCodec.writeVarInt64(_b, this.txnidLeastBits);
        }
        if (this.hasTxnidMostBits()) {
            LightProtoCodec.writeVarInt(_b, 56);
            LightProtoCodec.writeVarInt64(_b, this.txnidMostBits);
        }
        if (this.hasRequestId()) {
            LightProtoCodec.writeVarInt(_b, 64);
            LightProtoCodec.writeVarInt64(_b, this.requestId);
        }
        return _b.writerIndex() - _writeIdx;
    }

    public int getSerializedSize() {
        Object _item;
        int i;
        if (this._cachedSize > -1) {
            return this._cachedSize;
        }
        int _size = 0;
        _size += _CONSUMER_ID_TAG_SIZE;
        _size += LightProtoCodec.computeVarInt64Size(this.consumerId);
        _size += _ACK_TYPE_TAG_SIZE;
        _size += LightProtoCodec.computeVarIntSize(this.ackType.getValue());
        for (i = 0; i < this._messageIdsCount; ++i) {
            _item = this.messageIds.get(i);
            _size += _MESSAGE_ID_TAG_SIZE;
            int MsgsizeMessageId = ((MessageIdData)_item).getSerializedSize();
            _size += LightProtoCodec.computeVarIntSize(MsgsizeMessageId) + MsgsizeMessageId;
        }
        if (this.hasValidationError()) {
            _size += _VALIDATION_ERROR_TAG_SIZE;
            _size += LightProtoCodec.computeVarIntSize(this.validationError.getValue());
        }
        for (i = 0; i < this._propertiesCount; ++i) {
            _item = this.properties.get(i);
            _size += _PROPERTIES_TAG_SIZE;
            int MsgsizeProperties = ((KeyLongValue)_item).getSerializedSize();
            _size += LightProtoCodec.computeVarIntSize(MsgsizeProperties) + MsgsizeProperties;
        }
        if (this.hasTxnidLeastBits()) {
            _size += _TXNID_LEAST_BITS_TAG_SIZE;
            _size += LightProtoCodec.computeVarInt64Size(this.txnidLeastBits);
        }
        if (this.hasTxnidMostBits()) {
            _size += _TXNID_MOST_BITS_TAG_SIZE;
            _size += LightProtoCodec.computeVarInt64Size(this.txnidMostBits);
        }
        if (this.hasRequestId()) {
            _size += _REQUEST_ID_TAG_SIZE;
            _size += LightProtoCodec.computeVarInt64Size(this.requestId);
        }
        this._cachedSize = _size;
        return _size;
    }

    public void parseFrom(ByteBuf _buffer, int _size) {
        this.clear();
        int _endIdx = _buffer.readerIndex() + _size;
        block10: while (_buffer.readerIndex() < _endIdx) {
            int _tag = LightProtoCodec.readVarInt(_buffer);
            switch (_tag) {
                case 8: {
                    this._bitField0 |= 1;
                    this.consumerId = LightProtoCodec.readVarInt64(_buffer);
                    continue block10;
                }
                case 16: {
                    AckType _ackType = AckType.valueOf(LightProtoCodec.readVarInt(_buffer));
                    if (_ackType == null) continue block10;
                    this._bitField0 |= 2;
                    this.ackType = _ackType;
                    continue block10;
                }
                case 26: {
                    int _messageIdSize = LightProtoCodec.readVarInt(_buffer);
                    this.addMessageId().parseFrom(_buffer, _messageIdSize);
                    continue block10;
                }
                case 32: {
                    ValidationError _validationError = ValidationError.valueOf(LightProtoCodec.readVarInt(_buffer));
                    if (_validationError == null) continue block10;
                    this._bitField0 |= 8;
                    this.validationError = _validationError;
                    continue block10;
                }
                case 42: {
                    int _propertiesSize = LightProtoCodec.readVarInt(_buffer);
                    this.addProperty().parseFrom(_buffer, _propertiesSize);
                    continue block10;
                }
                case 48: {
                    this._bitField0 |= 0x20;
                    this.txnidLeastBits = LightProtoCodec.readVarInt64(_buffer);
                    continue block10;
                }
                case 56: {
                    this._bitField0 |= 0x40;
                    this.txnidMostBits = LightProtoCodec.readVarInt64(_buffer);
                    continue block10;
                }
                case 64: {
                    this._bitField0 |= 0x80;
                    this.requestId = LightProtoCodec.readVarInt64(_buffer);
                    continue block10;
                }
            }
            LightProtoCodec.skipUnknownField(_tag, _buffer);
        }
        this.checkRequiredFields();
        this._parsedBuffer = _buffer;
    }

    private void checkRequiredFields() {
        if ((this._bitField0 & 3) != 3) {
            throw new IllegalStateException("Some required fields are missing");
        }
    }

    public CommandAck clear() {
        int i;
        for (i = 0; i < this._messageIdsCount; ++i) {
            this.messageIds.get(i).clear();
        }
        this._messageIdsCount = 0;
        for (i = 0; i < this._propertiesCount; ++i) {
            this.properties.get(i).clear();
        }
        this._propertiesCount = 0;
        this.txnidLeastBits = 0L;
        this.txnidMostBits = 0L;
        this._parsedBuffer = null;
        this._cachedSize = -1;
        this._bitField0 = 0;
        return this;
    }

    public CommandAck copyFrom(CommandAck _other) {
        int i;
        this._cachedSize = -1;
        if (_other.hasConsumerId()) {
            this.setConsumerId(_other.consumerId);
        }
        if (_other.hasAckType()) {
            this.setAckType(_other.ackType);
        }
        for (i = 0; i < _other.getMessageIdsCount(); ++i) {
            this.addMessageId().copyFrom(_other.getMessageIdAt(i));
        }
        if (_other.hasValidationError()) {
            this.setValidationError(_other.validationError);
        }
        for (i = 0; i < _other.getPropertiesCount(); ++i) {
            this.addProperty().copyFrom(_other.getPropertyAt(i));
        }
        if (_other.hasTxnidLeastBits()) {
            this.setTxnidLeastBits(_other.txnidLeastBits);
        }
        if (_other.hasTxnidMostBits()) {
            this.setTxnidMostBits(_other.txnidMostBits);
        }
        if (_other.hasRequestId()) {
            this.setRequestId(_other.requestId);
        }
        return this;
    }

    public byte[] toByteArray() {
        byte[] a = new byte[this.getSerializedSize()];
        ByteBuf b = Unpooled.wrappedBuffer(a).writerIndex(0);
        this.writeTo(b);
        return a;
    }

    public void parseFrom(byte[] a) {
        ByteBuf b = Unpooled.wrappedBuffer(a);
        this.parseFrom(b, b.readableBytes());
    }

    public static enum AckType {
        Individual(0),
        Cumulative(1);

        private final int value;
        public static final int Individual_VALUE = 0;
        public static final int Cumulative_VALUE = 1;

        private AckType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static AckType valueOf(int n) {
            switch (n) {
                case 0: {
                    return Individual;
                }
                case 1: {
                    return Cumulative;
                }
            }
            return null;
        }
    }

    public static enum ValidationError {
        UncompressedSizeCorruption(0),
        DecompressionError(1),
        ChecksumMismatch(2),
        BatchDeSerializeError(3),
        DecryptionError(4);

        private final int value;
        public static final int UncompressedSizeCorruption_VALUE = 0;
        public static final int DecompressionError_VALUE = 1;
        public static final int ChecksumMismatch_VALUE = 2;
        public static final int BatchDeSerializeError_VALUE = 3;
        public static final int DecryptionError_VALUE = 4;

        private ValidationError(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static ValidationError valueOf(int n) {
            switch (n) {
                case 0: {
                    return UncompressedSizeCorruption;
                }
                case 1: {
                    return DecompressionError;
                }
                case 2: {
                    return ChecksumMismatch;
                }
                case 3: {
                    return BatchDeSerializeError;
                }
                case 4: {
                    return DecryptionError;
                }
            }
            return null;
        }
    }
}

