/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema.generic;

import com.iterable.shade.com.google.common.cache.CacheBuilder;
import com.iterable.shade.com.google.common.cache.CacheLoader;
import com.iterable.shade.com.google.common.cache.LoadingCache;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.api.schema.SchemaInfoProvider;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.protocol.schema.BytesSchemaVersion;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.util.FutureUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiVersionSchemaInfoProvider
implements SchemaInfoProvider {
    private static final Logger LOG = LoggerFactory.getLogger(MultiVersionSchemaInfoProvider.class);
    private final TopicName topicName;
    private final PulsarClientImpl pulsarClient;
    private final LoadingCache<BytesSchemaVersion, CompletableFuture<SchemaInfo>> cache = CacheBuilder.newBuilder().maximumSize(100000L).expireAfterAccess(30L, TimeUnit.MINUTES).build(new CacheLoader<BytesSchemaVersion, CompletableFuture<SchemaInfo>>(){

        @Override
        public CompletableFuture<SchemaInfo> load(BytesSchemaVersion schemaVersion) {
            CompletableFuture siFuture = MultiVersionSchemaInfoProvider.this.loadSchema(schemaVersion.get());
            siFuture.whenComplete((si, cause) -> {
                if (null != cause) {
                    MultiVersionSchemaInfoProvider.this.cache.asMap().remove(schemaVersion, siFuture);
                }
            });
            return siFuture;
        }
    });

    public MultiVersionSchemaInfoProvider(TopicName topicName, PulsarClientImpl pulsarClient) {
        this.topicName = topicName;
        this.pulsarClient = pulsarClient;
    }

    @Override
    public CompletableFuture<SchemaInfo> getSchemaByVersion(byte[] schemaVersion) {
        try {
            if (null == schemaVersion) {
                return CompletableFuture.completedFuture(null);
            }
            return this.cache.get(BytesSchemaVersion.of(schemaVersion));
        }
        catch (ExecutionException e) {
            LOG.error("Can't get schema for topic {} schema version {}", new Object[]{this.topicName.toString(), new String(schemaVersion, StandardCharsets.UTF_8), e});
            return FutureUtil.failedFuture(e.getCause());
        }
    }

    @Override
    public CompletableFuture<SchemaInfo> getLatestSchema() {
        return this.pulsarClient.getLookup().getSchema(this.topicName).thenApply(o -> o.orElse(null));
    }

    @Override
    public String getTopicName() {
        return this.topicName.getLocalName();
    }

    private CompletableFuture<SchemaInfo> loadSchema(byte[] schemaVersion) {
        return this.pulsarClient.getLookup().getSchema(this.topicName, schemaVersion).thenApply(o -> o.orElse(null));
    }

    public PulsarClientImpl getPulsarClient() {
        return this.pulsarClient;
    }
}

