/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema.generic;

import com.iterable.shade.org.apache.avro.Schema;
import com.iterable.shade.org.apache.avro.generic.GenericDatumReader;
import com.iterable.shade.org.apache.avro.io.BinaryDecoder;
import com.iterable.shade.org.apache.avro.io.BinaryEncoder;
import com.iterable.shade.org.apache.avro.io.DecoderFactory;
import com.iterable.shade.org.apache.avro.io.EncoderFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.pulsar.client.api.SchemaSerializationException;
import org.apache.pulsar.client.api.schema.Field;
import org.apache.pulsar.client.api.schema.GenericRecord;
import org.apache.pulsar.client.api.schema.SchemaReader;
import org.apache.pulsar.client.impl.schema.generic.GenericAvroRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericAvroReader
implements SchemaReader<GenericRecord> {
    private final GenericDatumReader<GenericAvroRecord> reader;
    private BinaryEncoder encoder;
    private final ByteArrayOutputStream byteArrayOutputStream;
    private final List<Field> fields;
    private final Schema schema;
    private final byte[] schemaVersion;
    private final int offset;
    private static final Logger log = LoggerFactory.getLogger(GenericAvroReader.class);

    public GenericAvroReader(Schema schema) {
        this(null, schema, null);
    }

    public GenericAvroReader(Schema writerSchema, Schema readerSchema, byte[] schemaVersion) {
        this.schema = readerSchema;
        this.fields = this.schema.getFields().stream().map(f -> new Field(f.name(), f.pos())).collect(Collectors.toList());
        this.schemaVersion = schemaVersion;
        this.reader = writerSchema == null ? new GenericDatumReader(readerSchema) : new GenericDatumReader(writerSchema, readerSchema);
        this.byteArrayOutputStream = new ByteArrayOutputStream();
        this.encoder = EncoderFactory.get().binaryEncoder(this.byteArrayOutputStream, null);
        this.offset = this.schema.getObjectProp("__AVRO_READ_OFFSET__") != null ? Integer.parseInt(this.schema.getObjectProp("__AVRO_READ_OFFSET__").toString()) : 0;
    }

    @Override
    public GenericAvroRecord read(byte[] bytes, int offset, int length) {
        try {
            if (offset == 0 && this.offset > 0) {
                offset = this.offset;
            }
            BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(bytes, offset, length - offset, null);
            com.iterable.shade.org.apache.avro.generic.GenericRecord avroRecord = this.reader.read(null, decoder);
            return new GenericAvroRecord(this.schemaVersion, this.schema, this.fields, avroRecord);
        }
        catch (IOException | IndexOutOfBoundsException e) {
            throw new SchemaSerializationException(e);
        }
    }

    @Override
    public GenericRecord read(InputStream inputStream) {
        try {
            BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(inputStream, null);
            com.iterable.shade.org.apache.avro.generic.GenericRecord avroRecord = this.reader.read(null, decoder);
            GenericAvroRecord genericAvroRecord = new GenericAvroRecord(this.schemaVersion, this.schema, this.fields, avroRecord);
            return genericAvroRecord;
        }
        catch (IOException | IndexOutOfBoundsException e) {
            throw new SchemaSerializationException(e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                log.error("GenericAvroReader close inputStream close error", (Throwable)e);
            }
        }
    }

    public int getOffset() {
        return this.offset;
    }

    @Override
    public Optional<Object> getNativeSchema() {
        return Optional.of(this.schema);
    }
}

