/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.auth.oauth2;

import com.iterable.shade.org.apache.commons.lang.NotImplementedException;
import com.iterable.shade.org.apache.commons.lang.StringUtils;
import java.io.IOException;
import java.time.Clock;
import java.time.Instant;
import java.util.Map;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.AuthenticationDataProvider;
import org.apache.pulsar.client.api.EncodedAuthenticationParameterSupport;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.AuthenticationUtil;
import org.apache.pulsar.client.impl.auth.oauth2.AuthenticationDataOAuth2;
import org.apache.pulsar.client.impl.auth.oauth2.ClientCredentialsFlow;
import org.apache.pulsar.client.impl.auth.oauth2.Flow;
import org.apache.pulsar.client.impl.auth.oauth2.protocol.TokenResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationOAuth2
implements Authentication,
EncodedAuthenticationParameterSupport {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationOAuth2.class);
    public static final String CONFIG_PARAM_TYPE = "type";
    public static final String TYPE_CLIENT_CREDENTIALS = "client_credentials";
    public static final String AUTH_METHOD_NAME = "token";
    public static final double EXPIRY_ADJUSTMENT = 0.9;
    private static final long serialVersionUID = 1L;
    final Clock clock;
    Flow flow;
    transient CachedToken cachedToken;

    public AuthenticationOAuth2() {
        this.clock = Clock.systemDefaultZone();
    }

    AuthenticationOAuth2(Flow flow, Clock clock) {
        this.flow = flow;
        this.clock = clock;
    }

    @Override
    public String getAuthMethodName() {
        return AUTH_METHOD_NAME;
    }

    @Override
    public void configure(String encodedAuthParamString) {
        String type;
        Map<String, String> params;
        if (StringUtils.isBlank(encodedAuthParamString)) {
            throw new IllegalArgumentException("No authentication parameters were provided");
        }
        try {
            params = AuthenticationUtil.configureFromJsonString(encodedAuthParamString);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Malformed authentication parameters", e);
        }
        switch (type = params.getOrDefault(CONFIG_PARAM_TYPE, TYPE_CLIENT_CREDENTIALS)) {
            case "client_credentials": {
                this.flow = ClientCredentialsFlow.fromParameters(params);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported authentication type: " + type);
            }
        }
    }

    @Override
    @Deprecated
    public void configure(Map<String, String> authParams) {
        throw new NotImplementedException("Deprecated; use EncodedAuthenticationParameterSupport");
    }

    @Override
    public void start() throws PulsarClientException {
        this.flow.initialize();
    }

    @Override
    public synchronized AuthenticationDataProvider getAuthData() throws PulsarClientException {
        if (this.cachedToken == null || this.cachedToken.isExpired()) {
            TokenResult tr = this.flow.authenticate();
            this.cachedToken = new CachedToken(tr);
        }
        return this.cachedToken.getAuthData();
    }

    @Override
    public void close() throws IOException {
        try {
            this.flow.close();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    class CachedToken {
        private final TokenResult latest;
        private final Instant expiresAt;
        private final AuthenticationDataOAuth2 authData;

        public CachedToken(TokenResult latest) {
            this.latest = latest;
            int adjustedExpiresIn = (int)((double)latest.getExpiresIn() * 0.9);
            this.expiresAt = AuthenticationOAuth2.this.clock.instant().plusSeconds(adjustedExpiresIn);
            this.authData = new AuthenticationDataOAuth2(latest.getAccessToken());
        }

        public boolean isExpired() {
            return AuthenticationOAuth2.this.clock.instant().isAfter(this.expiresAt);
        }

        public TokenResult getLatest() {
            return this.latest;
        }

        public Instant getExpiresAt() {
            return this.expiresAt;
        }

        public AuthenticationDataOAuth2 getAuthData() {
            return this.authData;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CachedToken)) {
                return false;
            }
            CachedToken other = (CachedToken)o;
            if (!other.canEqual(this)) {
                return false;
            }
            TokenResult this$latest = this.getLatest();
            TokenResult other$latest = other.getLatest();
            if (this$latest == null ? other$latest != null : !((Object)this$latest).equals(other$latest)) {
                return false;
            }
            Instant this$expiresAt = this.getExpiresAt();
            Instant other$expiresAt = other.getExpiresAt();
            if (this$expiresAt == null ? other$expiresAt != null : !((Object)this$expiresAt).equals(other$expiresAt)) {
                return false;
            }
            AuthenticationDataOAuth2 this$authData = this.getAuthData();
            AuthenticationDataOAuth2 other$authData = other.getAuthData();
            return !(this$authData == null ? other$authData != null : !this$authData.equals(other$authData));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CachedToken;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TokenResult $latest = this.getLatest();
            result = result * 59 + ($latest == null ? 43 : ((Object)$latest).hashCode());
            Instant $expiresAt = this.getExpiresAt();
            result = result * 59 + ($expiresAt == null ? 43 : ((Object)$expiresAt).hashCode());
            AuthenticationDataOAuth2 $authData = this.getAuthData();
            result = result * 59 + ($authData == null ? 43 : $authData.hashCode());
            return result;
        }

        public String toString() {
            return "AuthenticationOAuth2.CachedToken(latest=" + this.getLatest() + ", expiresAt=" + this.getExpiresAt() + ", authData=" + this.getAuthData() + ")";
        }
    }
}

