/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.auth;

import com.iterable.shade.com.google.gson.Gson;
import com.iterable.shade.com.google.gson.JsonObject;
import com.iterable.shade.com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.AuthenticationDataProvider;
import org.apache.pulsar.client.api.EncodedAuthenticationParameterSupport;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.auth.AuthenticationDataToken;

public class AuthenticationToken
implements Authentication,
EncodedAuthenticationParameterSupport {
    static final String AUTH_METHOD_NAME = "token";
    private static final long serialVersionUID = 1L;
    private Supplier<String> tokenSupplier = null;

    public AuthenticationToken() {
    }

    public AuthenticationToken(String token) {
        this(new SerializableTokenSupplier(token));
    }

    public AuthenticationToken(Supplier<String> tokenSupplier) {
        this.tokenSupplier = tokenSupplier;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public String getAuthMethodName() {
        return AUTH_METHOD_NAME;
    }

    @Override
    public AuthenticationDataProvider getAuthData() throws PulsarClientException {
        return new AuthenticationDataToken(this.tokenSupplier);
    }

    @Override
    public void configure(String encodedAuthParamString) {
        if (encodedAuthParamString.startsWith("token:")) {
            this.tokenSupplier = new SerializableTokenSupplier(encodedAuthParamString.substring("token:".length()));
        } else if (encodedAuthParamString.startsWith("file:")) {
            URI filePath = URI.create(encodedAuthParamString);
            this.tokenSupplier = new SerializableURITokenSupplier(filePath);
        } else {
            try {
                JsonObject authParams = new Gson().fromJson(encodedAuthParamString, JsonObject.class);
                this.tokenSupplier = new SerializableTokenSupplier(authParams.get(AUTH_METHOD_NAME).getAsString());
            }
            catch (JsonSyntaxException e) {
                this.tokenSupplier = new SerializableTokenSupplier(encodedAuthParamString);
            }
        }
    }

    @Override
    public void configure(Map<String, String> authParams) {
    }

    @Override
    public void start() throws PulsarClientException {
    }

    private static class SerializableTokenSupplier
    implements Supplier<String>,
    Serializable {
        private static final long serialVersionUID = 5095234161799506913L;
        private final String token;

        public SerializableTokenSupplier(String token) {
            this.token = token;
        }

        @Override
        public String get() {
            return this.token;
        }
    }

    private static class SerializableURITokenSupplier
    implements Supplier<String>,
    Serializable {
        private static final long serialVersionUID = 3160666668166028760L;
        private final URI uri;

        public SerializableURITokenSupplier(URI uri) {
            this.uri = uri;
        }

        @Override
        public String get() {
            try {
                return new String(Files.readAllBytes(Paths.get(this.uri)), StandardCharsets.UTF_8).trim();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read token from file", e);
            }
        }
    }
}

