/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import com.iterable.shade.com.google.common.base.Preconditions;
import com.iterable.shade.org.apache.commons.lang3.StringUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.pulsar.client.api.ConsumerCryptoFailureAction;
import org.apache.pulsar.client.api.CryptoKeyReader;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Range;
import org.apache.pulsar.client.api.Reader;
import org.apache.pulsar.client.api.ReaderBuilder;
import org.apache.pulsar.client.api.ReaderInterceptor;
import org.apache.pulsar.client.api.ReaderListener;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.impl.DefaultCryptoKeyReader;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.conf.ConfigurationDataUtils;
import org.apache.pulsar.client.impl.conf.ReaderConfigurationData;
import org.apache.pulsar.common.util.FutureUtil;

public class ReaderBuilderImpl<T>
implements ReaderBuilder<T> {
    private final PulsarClientImpl client;
    private ReaderConfigurationData<T> conf;
    private final Schema<T> schema;

    public ReaderBuilderImpl(PulsarClientImpl client, Schema<T> schema) {
        this(client, new ReaderConfigurationData(), schema);
    }

    private ReaderBuilderImpl(PulsarClientImpl client, ReaderConfigurationData<T> conf, Schema<T> schema) {
        this.client = client;
        this.conf = conf;
        this.schema = schema;
    }

    @Override
    public ReaderBuilder<T> clone() {
        return new ReaderBuilderImpl<T>(this.client, this.conf.clone(), this.schema);
    }

    @Override
    public Reader<T> create() throws PulsarClientException {
        try {
            return this.createAsync().get();
        }
        catch (Exception e) {
            throw PulsarClientException.unwrap(e);
        }
    }

    @Override
    public CompletableFuture<Reader<T>> createAsync() {
        boolean isStartMsgIdExist;
        if (this.conf.getTopicNames().isEmpty()) {
            return FutureUtil.failedFuture(new IllegalArgumentException("Topic name must be set on the reader builder"));
        }
        boolean bl = isStartMsgIdExist = this.conf.getStartMessageId() != null && this.conf.getStartMessageId() != MessageId.earliest;
        if (isStartMsgIdExist && this.conf.getStartMessageFromRollbackDurationInSec() > 0L || this.conf.getStartMessageId() == null && this.conf.getStartMessageFromRollbackDurationInSec() <= 0L) {
            return FutureUtil.failedFuture(new IllegalArgumentException("Start message id or start message from roll back must be specified but they cannot be specified at the same time"));
        }
        if (this.conf.getStartMessageFromRollbackDurationInSec() > 0L) {
            this.conf.setStartMessageId(MessageId.earliest);
        }
        return this.client.createReaderAsync(this.conf, this.schema);
    }

    @Override
    public ReaderBuilder<T> loadConf(Map<String, Object> config) {
        MessageId startMessageId = this.conf.getStartMessageId();
        this.conf = ConfigurationDataUtils.loadData(config, this.conf, ReaderConfigurationData.class);
        this.conf.setStartMessageId(startMessageId);
        return this;
    }

    @Override
    public ReaderBuilder<T> topic(String topicName) {
        this.conf.setTopicName(StringUtils.trim(topicName));
        return this;
    }

    @Override
    public ReaderBuilder<T> topics(List<String> topicNames) {
        Preconditions.checkArgument(topicNames != null && topicNames.size() > 0, "Passed in topicNames should not be null or empty.");
        topicNames.forEach(topicName -> Preconditions.checkArgument(StringUtils.isNotBlank(topicName), "topicNames cannot have blank topic"));
        this.conf.getTopicNames().addAll(topicNames.stream().map(StringUtils::trim).collect(Collectors.toList()));
        return this;
    }

    @Override
    public ReaderBuilder<T> startMessageId(MessageId startMessageId) {
        this.conf.setStartMessageId(startMessageId);
        return this;
    }

    @Override
    public ReaderBuilder<T> startMessageFromRollbackDuration(long rollbackDuration, TimeUnit timeunit) {
        this.conf.setStartMessageFromRollbackDurationInSec(timeunit.toSeconds(rollbackDuration));
        return this;
    }

    @Override
    public ReaderBuilder<T> startMessageIdInclusive() {
        this.conf.setResetIncludeHead(true);
        return this;
    }

    @Override
    public ReaderBuilder<T> readerListener(ReaderListener<T> readerListener) {
        this.conf.setReaderListener(readerListener);
        return this;
    }

    @Override
    public ReaderBuilder<T> cryptoKeyReader(CryptoKeyReader cryptoKeyReader) {
        this.conf.setCryptoKeyReader(cryptoKeyReader);
        return this;
    }

    @Override
    public ReaderBuilder<T> defaultCryptoKeyReader(String privateKey) {
        Preconditions.checkArgument(StringUtils.isNotBlank(privateKey), "privateKey cannot be blank");
        return this.cryptoKeyReader(DefaultCryptoKeyReader.builder().defaultPrivateKey(privateKey).build());
    }

    @Override
    public ReaderBuilder<T> defaultCryptoKeyReader(@NonNull Map<String, String> privateKeys) {
        if (privateKeys == null) {
            throw new NullPointerException("privateKeys is marked non-null but is null");
        }
        Preconditions.checkArgument(!privateKeys.isEmpty(), "privateKeys cannot be empty");
        return this.cryptoKeyReader(DefaultCryptoKeyReader.builder().privateKeys(privateKeys).build());
    }

    @Override
    public ReaderBuilder<T> cryptoFailureAction(ConsumerCryptoFailureAction action) {
        this.conf.setCryptoFailureAction(action);
        return this;
    }

    @Override
    public ReaderBuilder<T> receiverQueueSize(int receiverQueueSize) {
        Preconditions.checkArgument(receiverQueueSize >= 0, "receiverQueueSize needs to be >= 0");
        this.conf.setReceiverQueueSize(receiverQueueSize);
        return this;
    }

    @Override
    public ReaderBuilder<T> readerName(String readerName) {
        this.conf.setReaderName(readerName);
        return this;
    }

    @Override
    public ReaderBuilder<T> subscriptionRolePrefix(String subscriptionRolePrefix) {
        this.conf.setSubscriptionRolePrefix(subscriptionRolePrefix);
        return this;
    }

    @Override
    public ReaderBuilder<T> subscriptionName(String subscriptionName) {
        this.conf.setSubscriptionName(subscriptionName);
        return this;
    }

    @Override
    public ReaderBuilder<T> readCompacted(boolean readCompacted) {
        this.conf.setReadCompacted(readCompacted);
        return this;
    }

    @Override
    public ReaderBuilder<T> keyHashRange(Range ... ranges) {
        Preconditions.checkArgument(ranges != null && ranges.length > 0, "Cannot specify a null ofr an empty key hash ranges for a reader");
        for (int i = 0; i < ranges.length; ++i) {
            Range range1 = ranges[i];
            if (range1.getStart() < 0 || range1.getEnd() > 65536) {
                throw new IllegalArgumentException("Ranges must be [0, 65535] but provided range is " + range1);
            }
            for (int j = 0; j < ranges.length; ++j) {
                Range range2 = ranges[j];
                if (i == j || range1.intersect(range2) == null) continue;
                throw new IllegalArgumentException("Key hash ranges with overlap between " + range1 + " and " + range2);
            }
        }
        this.conf.setKeyHashRanges(Arrays.asList(ranges));
        return this;
    }

    @Override
    public ReaderBuilder<T> poolMessages(boolean poolMessages) {
        this.conf.setPoolMessages(poolMessages);
        return this;
    }

    @Override
    public ReaderBuilder<T> autoUpdatePartitions(boolean autoUpdate) {
        this.conf.setAutoUpdatePartitions(autoUpdate);
        return this;
    }

    @Override
    public ReaderBuilder<T> autoUpdatePartitionsInterval(int interval, TimeUnit unit) {
        long intervalSeconds = unit.toSeconds(interval);
        Preconditions.checkArgument(intervalSeconds >= 1L, "Auto update partition interval needs to be >= 1 second");
        this.conf.setAutoUpdatePartitionsIntervalSeconds(intervalSeconds);
        return this;
    }

    @Override
    public ReaderBuilder<T> intercept(ReaderInterceptor<T> ... interceptors) {
        if (interceptors != null) {
            this.conf.setReaderInterceptorList(Arrays.asList(interceptors));
        }
        return this;
    }

    @Override
    public ReaderBuilder<T> maxPendingChunkedMessage(int maxPendingChunkedMessage) {
        this.conf.setMaxPendingChunkedMessage(maxPendingChunkedMessage);
        return this;
    }

    @Override
    public ReaderBuilder<T> autoAckOldestChunkedMessageOnQueueFull(boolean autoAckOldestChunkedMessageOnQueueFull) {
        this.conf.setAutoAckOldestChunkedMessageOnQueueFull(autoAckOldestChunkedMessageOnQueueFull);
        return this;
    }

    @Override
    public ReaderBuilder<T> expireTimeOfIncompleteChunkedMessage(long duration, TimeUnit unit) {
        this.conf.setExpireTimeOfIncompleteChunkedMessageMillis(unit.toMillis(duration));
        return this;
    }

    public PulsarClientImpl getClient() {
        return this.client;
    }

    public ReaderConfigurationData<T> getConf() {
        return this.conf;
    }

    public Schema<T> getSchema() {
        return this.schema;
    }
}

