/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal.http;

import com.iterable.shade.javax.ws.rs.client.Client;
import com.iterable.shade.javax.ws.rs.core.Configuration;
import com.iterable.shade.org.glassfish.jersey.client.spi.Connector;
import com.iterable.shade.org.glassfish.jersey.client.spi.ConnectorProvider;
import org.apache.pulsar.client.admin.internal.http.AsyncHttpConnector;
import org.apache.pulsar.client.impl.conf.ClientConfigurationData;

public class AsyncHttpConnectorProvider
implements ConnectorProvider {
    private final ClientConfigurationData conf;
    private Connector connector;
    private final int autoCertRefreshTimeSeconds;

    public AsyncHttpConnectorProvider(ClientConfigurationData conf, int autoCertRefreshTimeSeconds) {
        this.conf = conf;
        this.autoCertRefreshTimeSeconds = autoCertRefreshTimeSeconds;
    }

    @Override
    public Connector getConnector(Client client, Configuration runtimeConfig) {
        if (this.connector == null) {
            this.connector = new AsyncHttpConnector(client, this.conf, this.autoCertRefreshTimeSeconds);
        }
        return this.connector;
    }

    public AsyncHttpConnector getConnector(int connectTimeoutMs, int readTimeoutMs, int requestTimeoutMs, int autoCertRefreshTimeSeconds) {
        return new AsyncHttpConnector(connectTimeoutMs, readTimeoutMs, requestTimeoutMs, autoCertRefreshTimeSeconds, this.conf);
    }
}

