/*
 * Decompiled with CFR 0.152.
 */
package com.scurrilous.circe.checksum;

import com.iterable.shade.io.netty.buffer.ByteBuf;
import com.scurrilous.circe.IncrementalIntHash;
import com.scurrilous.circe.checksum.Crc32cSse42Provider;
import com.scurrilous.circe.checksum.IntHash;
import com.scurrilous.circe.params.CrcParameters;

public class JniIntHash
implements IntHash {
    private final IncrementalIntHash hash = new Crc32cSse42Provider().getIncrementalInt(CrcParameters.CRC32C);

    @Override
    public int calculate(ByteBuf buffer) {
        return this.calculate(buffer, buffer.readerIndex(), buffer.readableBytes());
    }

    @Override
    public int resume(int current, ByteBuf buffer) {
        return this.resume(current, buffer, buffer.readerIndex(), buffer.readableBytes());
    }

    @Override
    public int calculate(ByteBuf buffer, int offset, int len) {
        return this.resume(0, buffer, offset, len);
    }

    @Override
    public int resume(int current, ByteBuf buffer, int offset, int len) {
        if (buffer.hasMemoryAddress()) {
            return this.hash.resume(current, buffer.memoryAddress() + (long)offset, len);
        }
        if (buffer.hasArray()) {
            return this.hash.resume(current, buffer.array(), buffer.arrayOffset() + offset, len);
        }
        return this.hash.resume(current, buffer.slice(offset, len).nioBuffer());
    }

    @Override
    public int resume(int current, byte[] buffer, int offset, int len) {
        return this.hash.resume(current, buffer, offset, len);
    }

    @Override
    public boolean acceptsMemoryAddressBuffer() {
        return true;
    }
}

