/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.shade.org.glassfish.jersey.uri;

import com.iterable.shade.org.glassfish.jersey.internal.guava.Preconditions;
import com.iterable.shade.org.glassfish.jersey.uri.PatternWithGroups;
import com.iterable.shade.org.glassfish.jersey.uri.UriComponent;
import com.iterable.shade.org.glassfish.jersey.uri.internal.UriPart;
import com.iterable.shade.org.glassfish.jersey.uri.internal.UriTemplateParser;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;

public class UriTemplate {
    private static final String[] EMPTY_VALUES = new String[0];
    public static final Comparator<UriTemplate> COMPARATOR = new Comparator<UriTemplate>(){

        @Override
        public int compare(UriTemplate o1, UriTemplate o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            if (o1 == EMPTY && o2 == EMPTY) {
                return 0;
            }
            if (o1 == EMPTY) {
                return 1;
            }
            if (o2 == EMPTY) {
                return -1;
            }
            int i = o2.getNumberOfExplicitCharacters() - o1.getNumberOfExplicitCharacters();
            if (i != 0) {
                return i;
            }
            i = o2.getNumberOfTemplateVariables() - o1.getNumberOfTemplateVariables();
            if (i != 0) {
                return i;
            }
            i = o2.getNumberOfExplicitRegexes() - o1.getNumberOfExplicitRegexes();
            if (i != 0) {
                return i;
            }
            return 0;
        }
    };
    private static final Pattern TEMPLATE_NAMES_PATTERN = Pattern.compile("\\{([\\w\\?;][-\\w\\.,]*)\\}");
    public static final UriTemplate EMPTY = new UriTemplate();
    private final String template;
    private final String normalizedTemplate;
    private final PatternWithGroups pattern;
    private final boolean endsWithSlash;
    private final List<UriPart> templateVariables;
    private final List<UriPart> uriParts;
    private final int numOfExplicitRegexes;
    private final int numOfRegexGroups;
    private final int numOfCharacters;

    private UriTemplate() {
        this.normalizedTemplate = "";
        this.template = "";
        this.pattern = PatternWithGroups.EMPTY;
        this.endsWithSlash = false;
        this.templateVariables = Collections.emptyList();
        this.uriParts = Collections.emptyList();
        this.numOfRegexGroups = 0;
        this.numOfCharacters = 0;
        this.numOfExplicitRegexes = 0;
    }

    public UriTemplate(String template) throws PatternSyntaxException, IllegalArgumentException {
        this(new UriTemplateParser(template));
    }

    protected UriTemplate(UriTemplateParser templateParser) throws PatternSyntaxException, IllegalArgumentException {
        this.template = templateParser.getTemplate();
        this.normalizedTemplate = templateParser.getNormalizedTemplate();
        this.pattern = UriTemplate.initUriPattern(templateParser);
        this.numOfExplicitRegexes = templateParser.getNumberOfExplicitRegexes();
        this.numOfRegexGroups = templateParser.getNumberOfRegexGroups();
        this.numOfCharacters = templateParser.getNumberOfLiteralCharacters();
        this.endsWithSlash = this.template.charAt(this.template.length() - 1) == '/';
        this.templateVariables = Collections.unmodifiableList(templateParser.getNames());
        this.uriParts = templateParser.getUriParts();
    }

    private static PatternWithGroups initUriPattern(UriTemplateParser templateParser) {
        return new PatternWithGroups(templateParser.getPattern(), templateParser.getGroupIndexes());
    }

    public static URI resolve(URI baseUri, String refUri) {
        return UriTemplate.resolve(baseUri, URI.create(refUri));
    }

    public static URI resolve(URI baseUri, URI refUri) {
        Preconditions.checkNotNull(baseUri, "Input base URI parameter must not be null.");
        Preconditions.checkNotNull(refUri, "Input reference URI parameter must not be null.");
        String refString = refUri.toString();
        if (refString.isEmpty()) {
            refUri = URI.create("#");
        } else if (refString.startsWith("?")) {
            String baseString = baseUri.toString();
            int qIndex = baseString.indexOf(63);
            baseString = qIndex > -1 ? baseString.substring(0, qIndex) : baseString;
            return URI.create(baseString + refString);
        }
        URI result = baseUri.resolve(refUri);
        if (refString.isEmpty()) {
            String resolvedString = result.toString();
            result = URI.create(resolvedString.substring(0, resolvedString.indexOf(35)));
        }
        return UriTemplate.normalize(result);
    }

    public static URI normalize(String uri) {
        return UriTemplate.normalize(URI.create(uri));
    }

    public static URI normalize(URI uri) {
        Preconditions.checkNotNull(uri, "Input reference URI parameter must not be null.");
        String path = uri.getPath();
        if (path == null || path.isEmpty() || !path.contains("/.")) {
            return uri;
        }
        String[] segments = path.split("/");
        ArrayDeque<String> resolvedSegments = new ArrayDeque<String>(segments.length);
        for (String segment : segments) {
            if (segment.isEmpty() || ".".equals(segment)) continue;
            if ("..".equals(segment)) {
                resolvedSegments.pollLast();
                continue;
            }
            resolvedSegments.offer(segment);
        }
        StringBuilder pathBuilder = new StringBuilder();
        for (String segment : resolvedSegments) {
            pathBuilder.append('/').append(UriComponent.encode(segment, UriComponent.Type.PATH));
        }
        String resultString = UriTemplate.createURIWithStringValues(uri.getScheme(), uri.getAuthority(), null, null, null, pathBuilder.toString(), uri.getQuery(), uri.getFragment(), EMPTY_VALUES, false, false);
        return URI.create(resultString);
    }

    public static URI relativize(URI baseUri, URI refUri) {
        Preconditions.checkNotNull(baseUri, "Input base URI parameter must not be null.");
        Preconditions.checkNotNull(refUri, "Input reference URI parameter must not be null.");
        return UriTemplate.normalize(baseUri.relativize(refUri));
    }

    public final String getTemplate() {
        return this.template;
    }

    public final PatternWithGroups getPattern() {
        return this.pattern;
    }

    public final boolean endsWithSlash() {
        return this.endsWithSlash;
    }

    public final List<String> getTemplateVariables() {
        return this.templateVariables.stream().map(UriPart::getPart).collect(Collectors.toList());
    }

    public final boolean isTemplateVariablePresent(String name) {
        for (UriPart tv : this.templateVariables) {
            if (!tv.getPart().equals(name)) continue;
            return true;
        }
        return false;
    }

    public final int getNumberOfExplicitRegexes() {
        return this.numOfExplicitRegexes;
    }

    public final int getNumberOfRegexGroups() {
        return this.numOfRegexGroups;
    }

    public final int getNumberOfExplicitCharacters() {
        return this.numOfCharacters;
    }

    public final int getNumberOfTemplateVariables() {
        return this.templateVariables.size();
    }

    public final boolean match(CharSequence uri, Map<String, String> templateVariableToValue) throws IllegalArgumentException {
        if (templateVariableToValue == null) {
            throw new IllegalArgumentException();
        }
        return this.pattern.match(uri, this.getTemplateVariables(), templateVariableToValue);
    }

    public final boolean match(CharSequence uri, List<String> groupValues) throws IllegalArgumentException {
        if (groupValues == null) {
            throw new IllegalArgumentException();
        }
        return this.pattern.match(uri, groupValues);
    }

    public final String createURI(final Map<String, String> values) {
        StringBuilder sb = new StringBuilder();
        this.resolveTemplate(sb, new TemplateValueStrategy(){

            @Override
            public String valueFor(UriPart templateVariable, String matchedGroup) {
                String value = (String)values.get(templateVariable.getPart());
                if (value == null) {
                    return "";
                }
                return templateVariable.resolve(value, null, false);
            }
        });
        return sb.toString();
    }

    public final String createURI(String ... values) {
        return this.createURI(values, 0, values.length);
    }

    public final String createURI(final String[] values, final int offset, final int length) {
        TemplateValueStrategy ns = new TemplateValueStrategy(){
            private final int lengthPlusOffset;
            private int v;
            private final Map<String, String> mapValues;
            {
                this.lengthPlusOffset = length + offset;
                this.v = offset;
                this.mapValues = new HashMap<String, String>();
            }

            @Override
            public String valueFor(UriPart templateVariable, String matchedGroup) {
                String tValue = this.mapValues.get(templateVariable.getPart());
                if (tValue == null && this.v < this.lengthPlusOffset && (tValue = values[this.v++]) != null) {
                    this.mapValues.put(templateVariable.getPart(), tValue);
                }
                return tValue;
            }
        };
        StringBuilder sb = new StringBuilder();
        this.resolveTemplate(sb, ns);
        return sb.toString();
    }

    private void resolveTemplate(StringBuilder builder, TemplateValueStrategy valueStrategy) {
        for (UriPart uriPart : this.uriParts) {
            if (uriPart.isTemplate()) {
                builder.append(valueStrategy.valueFor(uriPart, uriPart.getGroup()));
                continue;
            }
            builder.append(uriPart.getPart());
        }
    }

    public final String toString() {
        return this.pattern.toString();
    }

    public final int hashCode() {
        return this.pattern.hashCode();
    }

    public final boolean equals(Object o) {
        if (o instanceof UriTemplate) {
            UriTemplate that = (UriTemplate)o;
            return this.pattern.equals(that.pattern);
        }
        return false;
    }

    public static String createURI(String scheme, String authority, String userInfo, String host, String port, String path, String query, String fragment, Map<String, ?> values, boolean encode, boolean encodeSlashInPath) {
        return UriTemplate.createURI(scheme, authority, userInfo, host, port, path, query, fragment, new Object[0], encode, encodeSlashInPath, values);
    }

    public static String createURIWithStringValues(String scheme, String authority, String userInfo, String host, String port, String path, String query, String fragment, Map<String, ?> values, boolean encode, boolean encodeSlashInPath) {
        return UriTemplate.createURI(scheme, authority, userInfo, host, port, path, query, fragment, EMPTY_VALUES, encode, encodeSlashInPath, values);
    }

    public static String createURI(String scheme, String authority, String userInfo, String host, String port, String path, String query, String fragment, Object[] values, boolean encode, boolean encodeSlashInPath) {
        return UriTemplate.createURI(scheme, authority, userInfo, host, port, path, query, fragment, values, encode, encodeSlashInPath, new HashMap());
    }

    public static String createURIWithStringValues(String scheme, String authority, String userInfo, String host, String port, String path, String query, String fragment, String[] values, boolean encode, boolean encodeSlashInPath) {
        HashMap mapValues = new HashMap();
        return UriTemplate.createURI(scheme, authority, userInfo, host, port, path, query, fragment, values, encode, encodeSlashInPath, mapValues);
    }

    private static String createURI(String scheme, String authority, String userInfo, String host, String port, String path, String query, String fragment, Object[] values, boolean encode, boolean encodeSlashInPath, Map<String, ?> mapValues) {
        StringBuilder sb = new StringBuilder();
        int offset = 0;
        if (scheme != null) {
            offset = UriTemplate.createUriComponent(UriComponent.Type.SCHEME, scheme, values, offset, false, mapValues, sb);
            sb.append(':');
        }
        boolean hasAuthority = false;
        if (UriTemplate.notEmpty(userInfo) || UriTemplate.notEmpty(host) || UriTemplate.notEmpty(port)) {
            hasAuthority = true;
            sb.append("//");
            if (UriTemplate.notEmpty(userInfo)) {
                offset = UriTemplate.createUriComponent(UriComponent.Type.USER_INFO, userInfo, values, offset, encode, mapValues, sb);
                sb.append('@');
            }
            if (UriTemplate.notEmpty(host)) {
                offset = UriTemplate.createUriComponent(UriComponent.Type.HOST, host, values, offset, encode, mapValues, sb);
            }
            if (UriTemplate.notEmpty(port)) {
                sb.append(':');
                offset = UriTemplate.createUriComponent(UriComponent.Type.PORT, port, values, offset, false, mapValues, sb);
            }
        } else if (UriTemplate.notEmpty(authority)) {
            hasAuthority = true;
            sb.append("//");
            offset = UriTemplate.createUriComponent(UriComponent.Type.AUTHORITY, authority, values, offset, encode, mapValues, sb);
        }
        if (UriTemplate.notEmpty(path) || UriTemplate.notEmpty(query) || UriTemplate.notEmpty(fragment)) {
            if (hasAuthority && (path == null || path.isEmpty() || path.charAt(0) != '/')) {
                sb.append('/');
            }
            if (UriTemplate.notEmpty(path)) {
                UriComponent.Type t2 = encodeSlashInPath ? UriComponent.Type.PATH_SEGMENT : UriComponent.Type.PATH;
                offset = UriTemplate.createUriComponent(t2, path, values, offset, encode, mapValues, sb);
            }
            if (UriTemplate.notEmpty(query)) {
                char firstQuery;
                int sbLength = sb.length();
                offset = UriTemplate.createUriComponent(UriComponent.Type.QUERY_PARAM, query, values, offset, encode, mapValues, sb);
                if (sb.length() > sbLength && (firstQuery = sb.charAt(sbLength)) != '?' && (query.trim().charAt(0) != '{' || firstQuery != '&')) {
                    sb.insert(sbLength, '?');
                }
            }
            if (UriTemplate.notEmpty(fragment)) {
                sb.append('#');
                UriTemplate.createUriComponent(UriComponent.Type.FRAGMENT, fragment, values, offset, encode, mapValues, sb);
            }
        }
        return sb.toString();
    }

    private static boolean notEmpty(String string) {
        return string != null && !string.isEmpty();
    }

    private static int createUriComponent(final UriComponent.Type componentType, String template, final Object[] values, final int valueOffset, final boolean encode, Map<String, ?> _mapValues, StringBuilder b) {
        final Map<String, ?> mapValues = _mapValues;
        if (template.indexOf(123) == -1) {
            b.append(template);
            return valueOffset;
        }
        UriTemplateParser templateParser = new UriTemplateParser(template);
        class ValuesFromArrayStrategy
        implements TemplateValueStrategy {
            private int offset;

            ValuesFromArrayStrategy() {
                this.offset = valueOffset;
            }

            @Override
            public String valueFor(UriPart templateVariable, String matchedGroup) {
                Object value = mapValues.get(templateVariable.getPart());
                if (value == null && this.offset < values.length) {
                    value = values[this.offset++];
                    mapValues.put(templateVariable.getPart(), value);
                }
                if (value == null && templateVariable.throwWhenNoTemplateArg()) {
                    throw new IllegalArgumentException(String.format("The template variable '%s' has no value", templateVariable.getPart()));
                }
                return templateVariable.resolve(value, componentType, encode);
            }
        }
        ValuesFromArrayStrategy cs = new ValuesFromArrayStrategy();
        new UriTemplate(templateParser).resolveTemplate(b, cs);
        return cs.offset;
    }

    public static String resolveTemplateValues(final UriComponent.Type type, String template, final boolean encode, Map<String, ?> _mapValues) {
        if (template == null || template.isEmpty() || template.indexOf(123) == -1) {
            return template;
        }
        final Map<String, ?> mapValues = _mapValues;
        StringBuilder sb = new StringBuilder();
        new UriTemplate(new UriTemplateParser(template)).resolveTemplate(sb, new TemplateValueStrategy(){

            @Override
            public String valueFor(UriPart templateVariable, String matchedGroup) {
                Object value = mapValues.get(templateVariable.getPart());
                if (value != null) {
                    return templateVariable.resolve(value.toString(), type, encode);
                }
                if (mapValues.containsKey(templateVariable.getPart())) {
                    throw new IllegalArgumentException(String.format("The value associated of the template value map for key '%s' is 'null'.", templateVariable));
                }
                return matchedGroup;
            }
        });
        return sb.toString();
    }

    private static interface TemplateValueStrategy {
        public String valueFor(UriPart var1, String var2);
    }
}

