/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.shade.org.glassfish.jersey.model.internal;

import com.iterable.shade.javax.annotation.PreDestroy;
import com.iterable.shade.javax.inject.Singleton;
import com.iterable.shade.org.glassfish.jersey.internal.inject.InjectionManager;
import java.util.HashSet;
import java.util.Set;

@Singleton
public class ManagedObjectsFinalizer {
    private final InjectionManager injectionManager;
    private final Set<Object> managedObjects = new HashSet<Object>();

    public ManagedObjectsFinalizer(InjectionManager injectionManager) {
        this.injectionManager = injectionManager;
    }

    public void registerForPreDestroyCall(Object object) {
        this.managedObjects.add(object);
    }

    @PreDestroy
    public void preDestroy() {
        try {
            for (Object o : this.managedObjects) {
                this.injectionManager.preDestroy(o);
            }
        }
        finally {
            this.managedObjects.clear();
        }
    }
}

