/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.shade.org.glassfish.jersey.message.internal;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.atomic.AtomicReference;

public final class Utils {
    static void throwIllegalArgumentExceptionIfNull(Object toCheck, String errorMessage) {
        if (toCheck == null) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public static File createTempFile() throws IOException {
        final AtomicReference exceptionReference = new AtomicReference();
        File file = AccessController.doPrivileged(new PrivilegedAction<File>(){

            @Override
            public File run() {
                File tempFile = null;
                try {
                    tempFile = Files.createTempFile("rep", "tmp", new FileAttribute[0]).toFile();
                    tempFile.deleteOnExit();
                }
                catch (IOException e) {
                    exceptionReference.set(e);
                }
                return tempFile;
            }
        });
        if (exceptionReference.get() != null) {
            throw (IOException)exceptionReference.get();
        }
        return file;
    }

    private Utils() {
        throw new AssertionError((Object)"No instances allowed.");
    }
}

