/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.shade.org.glassfish.jersey.message.internal;

import com.iterable.shade.javax.inject.Singleton;
import com.iterable.shade.javax.ws.rs.Consumes;
import com.iterable.shade.javax.ws.rs.Produces;
import com.iterable.shade.javax.ws.rs.core.MediaType;
import com.iterable.shade.javax.ws.rs.core.MultivaluedMap;
import com.iterable.shade.org.glassfish.jersey.message.internal.AbstractMessageReaderWriterProvider;
import com.iterable.shade.org.glassfish.jersey.message.internal.Utils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

@Produces(value={"application/octet-stream", "*/*"})
@Consumes(value={"application/octet-stream", "*/*"})
@Singleton
public final class FileProvider
extends AbstractMessageReaderWriterProvider<File> {
    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return File.class == type;
    }

    @Override
    public File readFrom(Class<File> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        File file = Utils.createTempFile();
        Files.copy(entityStream, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        return file;
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return File.class.isAssignableFrom(type);
    }

    @Override
    public void writeTo(File t2, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        Files.copy(t2.toPath(), entityStream);
    }

    @Override
    public long getSize(File t2, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return t2.length();
    }
}

