/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.shade.org.glassfish.jersey.message.filtering;

import com.iterable.shade.javax.inject.Inject;
import com.iterable.shade.javax.inject.Singleton;
import com.iterable.shade.javax.ws.rs.ConstrainedTo;
import com.iterable.shade.javax.ws.rs.RuntimeType;
import com.iterable.shade.javax.ws.rs.core.Configuration;
import com.iterable.shade.javax.ws.rs.core.Context;
import com.iterable.shade.javax.ws.rs.core.SecurityContext;
import com.iterable.shade.org.glassfish.jersey.internal.inject.InjectionManager;
import com.iterable.shade.org.glassfish.jersey.message.filtering.SecurityHelper;
import com.iterable.shade.org.glassfish.jersey.message.filtering.ServerScopeProvider;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;

@Singleton
@ConstrainedTo(value=RuntimeType.SERVER)
final class SecurityServerScopeProvider
extends ServerScopeProvider {
    @Context
    private SecurityContext securityContext;

    @Inject
    public SecurityServerScopeProvider(Configuration config, InjectionManager injectionManager) {
        super(config, injectionManager);
    }

    @Override
    public Set<String> getFilteringScopes(Annotation[] entityAnnotations, boolean defaultIfNotFound) {
        Set<String> filteringScope = super.getFilteringScopes(entityAnnotations, false);
        if (filteringScope.isEmpty()) {
            filteringScope = new HashSet<String>();
            for (String role : SecurityHelper.getProcessedRoles()) {
                if (!this.securityContext.isUserInRole(role)) continue;
                filteringScope.add(SecurityHelper.getRolesAllowedScope(role));
            }
        }
        return this.returnFilteringScopes(filteringScope, defaultIfNotFound);
    }
}

