/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.shade.org.glassfish.jersey.logging;

import com.iterable.shade.javax.annotation.Priority;
import com.iterable.shade.javax.ws.rs.ConstrainedTo;
import com.iterable.shade.javax.ws.rs.RuntimeType;
import com.iterable.shade.javax.ws.rs.container.ContainerRequestContext;
import com.iterable.shade.javax.ws.rs.container.ContainerRequestFilter;
import com.iterable.shade.javax.ws.rs.container.ContainerResponseContext;
import com.iterable.shade.javax.ws.rs.container.ContainerResponseFilter;
import com.iterable.shade.javax.ws.rs.container.PreMatching;
import com.iterable.shade.org.glassfish.jersey.logging.LoggingFeature;
import com.iterable.shade.org.glassfish.jersey.logging.LoggingInterceptor;
import com.iterable.shade.org.glassfish.jersey.message.MessageUtils;
import java.io.IOException;

@ConstrainedTo(value=RuntimeType.SERVER)
@PreMatching
@Priority(value=-2147483648)
final class ServerLoggingFilter
extends LoggingInterceptor
implements ContainerRequestFilter,
ContainerResponseFilter {
    public ServerLoggingFilter(LoggingFeature.LoggingFeatureBuilder builder) {
        super(builder);
    }

    @Override
    public void filter(ContainerRequestContext context) throws IOException {
        if (!this.logger.isLoggable(this.level)) {
            return;
        }
        long id = this._id.incrementAndGet();
        context.setProperty(LOGGING_ID_PROPERTY, id);
        StringBuilder b = new StringBuilder();
        this.printRequestLine(b, "Server has received a request", id, context.getMethod(), context.getUriInfo().getRequestUri());
        this.printPrefixedHeaders(b, id, "> ", context.getHeaders());
        if (ServerLoggingFilter.printEntity(this.verbosity, context.getMediaType()) && context.hasEntity()) {
            context.setEntityStream(this.logInboundEntity(b, context.getEntityStream(), MessageUtils.getCharset(context.getMediaType())));
        }
        this.log(b);
    }

    @Override
    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        if (!this.logger.isLoggable(this.level)) {
            return;
        }
        Object requestId = requestContext.getProperty(LOGGING_ID_PROPERTY);
        long id = requestId != null ? ((Long)requestId).longValue() : this._id.incrementAndGet();
        StringBuilder b = new StringBuilder();
        this.printResponseLine(b, "Server responded with a response", id, responseContext.getStatus());
        this.printPrefixedHeaders(b, id, "< ", responseContext.getStringHeaders());
        if (ServerLoggingFilter.printEntity(this.verbosity, responseContext.getMediaType()) && responseContext.hasEntity()) {
            LoggingInterceptor.LoggingStream stream = new LoggingInterceptor.LoggingStream(b, responseContext.getEntityStream());
            responseContext.setEntityStream(stream);
            requestContext.setProperty(ENTITY_LOGGER_PROPERTY, stream);
        } else {
            this.log(b);
        }
    }
}

